/* $Id: ziphash.h,v 1.2 2003/01/16 00:31:15 rtakano Exp $
 * Copyright (c) 2002 TAKANO Ryousei
 */
#ifndef ZIP_HASH_H
#define ZIP_HASH_H
#include <assert.h>

struct zip_hash {
  struct zip_hash* next;
  struct ZipDirectory* zipd;
};

#define HASH_SIZE (256)
struct zip_hash* filehash[HASH_SIZE];

/*
 * this hash algoritm comes from sdbm database library.
 */
static inline unsigned long hashfn(const char* str)
{
  unsigned long hash = 0;
  int c;

  while (*str) {
    c = *str++;
    hash = c + (hash << 6) + (hash << 16) - hash;
  }
  return hash % HASH_SIZE;
}

static inline struct ZipDirectory* zip_find_file(const char* name)
{
  struct zip_hash* p;

  for (p = filehash[hashfn(name)]; p != NULL ;p = p->next) {
    if (strcmp(name, ZIPDIR_FILENAME(p->zipd)) == 0) {
      return p->zipd;
    }
  }
  return NULL;
}

static inline void zip_register_file(struct ZipDirectory* zipd)
{
  struct ZipDirectory *p;
  struct zip_hash* new;

  p = zip_find_file(ZIPDIR_FILENAME(zipd));
  if (p == NULL) {
    new = (struct zip_hash*)malloc(sizeof(struct zip_hash));
    assert(new != NULL);
    new->next = filehash[hashfn(ZIPDIR_FILENAME(zipd))];
    new->zipd = zipd;
    filehash[hashfn(ZIPDIR_FILENAME(zipd))] = new;
  }
}

#endif /* ZIP_HASH_H */
