// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5_PRE3 $
// $Id: platform_qpe.h,v 1.4 2002/11/04 22:39:47 yamaken Exp $

#ifndef IMKIT_PLATFORM_QPE_H
#define IMKIT_PLATFORM_QPE_H

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qwindowsystem_qws.h>
#include <qpe/inputmethodinterface.h>
#include "keyfilter.h"
#include "ui.h"

typedef InputMethodInterface *(*InputMethodCreator)(void);

#define IMKIT_EXPORT_INTERFACE(im_creator) \
  Q_EXPORT_INTERFACE() { \
    return imkit_export_interface(im_creator); \
  }

void imkit_setup_translator(QString &im_name);
QUnknownInterface *imkit_export_interface(InputMethodCreator creator);


class QWSKeyBypassIn
  : public QObject, public CascadeKeyFilter, public StdActivatable,
    public QWSServer::KeyboardFilter
{
  Q_OBJECT

protected:
  KeyEventConverter keyevent_converter;

protected:
  virtual void on_activate(void);
  virtual void on_deactivate(void);

public:
  virtual ~QWSKeyBypassIn(void);
  virtual bool filter(int unicode, int keycode, int modifiers,
                      bool is_press, bool autorepeat);

public slots:
  virtual void slot_activate(bool activity);
};


class QWSKeyBypassOut
  : public QObject, public CascadeKeyFilter, public StdActivatable
{
  Q_OBJECT

protected:
  KeyEventConverter keyevent_converter;

protected:
  virtual void on_input(QKeyEvent &e);
  void emit_as_signal(QKeyEvent &e);

protected slots:
  virtual void emit_key(int unicode, int scancode, int modifiers,
                        bool is_press, bool autorepeat);

public:
  QWSKeyBypassOut(void);
  virtual ~QWSKeyBypassOut(void);
  virtual void input(QKeyEvent *e);

signals:
  void key(ushort unicode, ushort scancode, ushort modifiers,
           bool is_press, bool autorepeat);

};


//TODO: ¸IM(եȥܡ)ϤǤ褦ˤ
//class IMAdapterKeyFilter : public CascadeKeyFilter {
//  Q_OBJECT
//
//public:
//  QWidget *adaptee;
//};


class IMKitImpl : public InputMethodInterface {
#ifndef QT_NO_COMPONENT
  Q_REFCOUNT
#endif

private:
  ulong ref;

protected:
  IMUserInterface *im_ui;
  QPixmap *_icon;
  QWSKeyBypassIn *bypass_in;
  QWSKeyBypassOut *bypass_out;

private:
  IMKitImpl(void);

protected:
  virtual void prepare_key_bypass(void);
  virtual void join_to_bypass(CascadeKeyFilter *im_keyfilter);

public:
  IMKitImpl(IMUserInterface *im_ui_init, QPixmap *icon_init = 0);
  virtual ~IMKitImpl(void);
  virtual QWidget *inputMethod(QWidget *parent, Qt::WFlags flags);
  virtual void resetState(void);
  virtual QPixmap *icon(void);
  virtual QString name(void);
  virtual void onKeyPress(QObject *receiver, const char *slot);
#ifndef QT_NO_COMPONENT
  QRESULT queryInterface(const QUuid &uuid, QUnknownInterface **interface);
#endif
};


#endif  // IMKIT_PLATFORM_QPE_H
