=begin
/****************************************************************************
** $Id: iconview.rb,v 1.1.1.1 2002/12/22 14:19:53 taka-hr Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include <qiconview.h>
#include <qapplication.h>
#include <qdragobject.h>
#include <qpixmap.h>
#include <qiconset.h>

#include <qmime.h>
#include <stdio.h>
require "qte"
include Qte
require "qpe"
include Qpe
#require "qt2iconview.so"
#include Qt2iconview

class ListenDND < QObject

#    Q_OBJECT

   def initialize( w )
        super
        @view = QWidget.new( w )
        @view.hide()
    catchEvent
    end

#public slots:
    def dropped( mime=Qnil )
        print( "Dropped Mimesource #{mime} into the view #{@view}\n" )
        print( "  Formats:\n" )
        i = 0
	if(!mime.nil?)
           str = mime.format( i )
           print( "    #{str}\n" )
           while ( str ) 
              printf( "    #{str}\n" )
              str = mime.format( i += 1 )
           end
	end
    end
    def moved()
        print( "All selected items were moved to another widget\n" )
    end

#protected:
#    QWidget *view

end

#int main( int argc, char **argv )

    a = QPEApplication.new( [$0]+ARGV )

    qiconview = QIconView.new
    qiconview.setSelectionMode( QIconView::Extended )

    for i in 0..100 #( unsigned int i = 0 i < 3000 i++ )
	item = QIconViewItem.new( qiconview, QString.new( "Item %1" ).arg( i + 1 ) )
	item.setRenameEnabled( TRUE )
    end

    qiconview.setCaption( "Iconview" )

    listen_dnd = ListenDND.new( qiconview )

    Qte::connect( qiconview, QSIGNAL( "dropped( QDropEvent * , const QValueList<QIconDragItem> & )" ),
		      listen_dnd,"dropped" )
    Qte::connect( qiconview, QSIGNAL( "moved()" ), listen_dnd, "moved()" )

    a.showMainWidget( qiconview )

    a.exec()


#include "main.moc"
