#!/usr/bin/env ruby
=begin
This script use compiled GUI part from ui file.  
BlackAddar has build-in uic (user interface compile) for Ruby.
After design GUI part, then File->compile all forms makes qtcalc_ui.rb
from qtcalc_ui.ui.
In this example, the function button_clicked in CalcForm (designed in 
BlackAdder GUI tool) in qtcalc.rb script.  Or you can derive sub class from
CalcForm and override functions you want.
=end
 
require "qte"
require "qpe"
require "qtcalc_ui.rb"
include Qte
include Qpe
include Math

class CalcForm
  def button_clicked( id )
    @radio_val = "RADIAN" if @radio_val.nil?
    @mem = 0 if @mem.nil?
    if @calc_str.nil? or @calc_str == "ERROR"
      @calc_str = "" 
    end
    begin    
    case id
    when 0..9
      if @last_key == "RETURN" or @last_key == "SIN" or @last_key == "COS" or @last_key == "TAN" or @last_key == "SQRT"
        clear_all
      end
      @calc_str += "#{id}"
      @last_key = "VALUE"
    when 11
      @calc_str += "."
      @last_key = "DOT"
    when 12
      @calc_str += " + "
      @last_key = "PLUS"
    when 13
      @calc_str += " - "
      @last_key = "MINUS"
    when 14
      @calc_str += " * "
      @last_key = "MUL"
    when 15
      @calc_str += " / "
      @last_key = "DIF"
    when 20
      @calc_str += "("
      @last_key = "PARR"
    when 21
      @calc_str += ")"
      @last_key = "PARL"
    when 16
      @calc_str = "#{sqrt(eval(@calc_str))}"
      @lsat_key = "SQRT"
    when 17
      val = to_radian(eval(@calc_str))
      @calc_str = "#{sin(val)}"
      @last_key = "SIN"
    when 18
      val = to_radian(eval(@calc_str))
      @calc_str = "#{cos(val)}"
      @last_key = "COS"
    when 19
      val = to_radian(eval(@calc_str))
      @calc_str = "#{tan(val)}"
      @last_key = "TAN"  
    when 23
      clear_all
      @last_key = "C"
    when 22
      clear_all
      @last_key = "AC"
    when 24
      @calc_str = "#{@mem}"
      @last_key = "MR"
    when 25
      @mem =0
      @last_key = "MC"
    when 26
      @calc_str = "#{eval(@calc_str)}"
      @mem += eval(@calc_str)
      @last_key = "RETURN"
    when 99
      @calc_str = "#{eval(@calc_str)}"
      @last_key = "RETURN"
    end
  rescue SyntaxError,ArgumentError,ZeroDivisionError
    @calc_str = "ERROR"
    @last_key = "ERROR"
  end
    @LineEdit1.setText(@calc_str)
  end

  def clear_all
    @calc_str = ""
    @LineEdit1.setText(@calc_str)
  end
 
  def radio_clicked id
    @radio_val = "RADIAN" if @radio_val.nil?
    case id
    when 0
      @radio_val = "RADION"
    when 1
      @radio_val = "GRADIAN"
    when 2
      @radio_val = "DEGREE"
    end
  end
  
  def to_radian( val )
    case @radio_val
    when "RADIAN"
      ret = val
    when "GRADIAN"
      ret = val/200.0*2.0*PI
    when "DEGREE"
      ret = val/360.0*2.0*PI
    end
    ret
  end
  
end


#main roop for displaying form

a = QPEApplication.new([$0]+ARGV)
codec = QTextCodec.codecForName("UTF-8")
a.setDefaultCodec(codec)
#for close to quit program
Qte::connect(QPEApplication::qApp,QSIGNAL("lastWindowClosed()"),
   QPEApplication::qApp,QSLOT("quit()"))
calc = CalcForm.new
a.showMainWidget(calc)
a.exec

