=begin
/****************************************************************************
** $Id: quoteparser.rb,v 1.1.1.1 2002/12/22 14:19:57 taka-hr Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include "quoteparser.h"
require "qte"
include Qte
require "qtexml"
include Qtexml

class QuoteHandler < QXmlRubyHandler

State = 0
StateInit = 1
StateDocument = 2
StateQuote = 3
StateLine = 4
StateHeading = 5
StateP= 6

def initialize()
   super
   @quoteList = []
   setSelf(self)

end

def quotes()
    return @quoteList
end

def errorProtocol()
    return @errorProt
end


def startDocument()
    #// at the beginning of parsing: do some initialization
    @quoteList.clear()
    @errorProt = ""
    @state = StateInit

    return TRUE
end

def startElement( namespaceURI,localName, qName,atts)
    #// do different actions depending on the name of the tag and the
    #// state you are in
    if        ( qName.to_str == "quotations" && @state == StateInit )
	@state = StateDocument
    elsif ( qName.to_str == "quote"      && @state == StateDocument )
	@state = StateQuote
	#// add a new quote to the end of the list
	@quoteList.push( "" )
	#// add some nice header
	#@quoteList.last() +=
              @quoteList[@quoteList.size - 1] += ("<b>Saying " + @quoteList.size.to_s +  "</b><br>" + "<hr><br><br>" +"<big>")
	    #QString::number( @quoteList.count() ) +
	    #"</b><br>"
	    #"<hr><br><br>"
	    #"<big>"
	#// a quote can have a author and a reference
	@author = atts.value( "author" )
	@reference = atts.value( "reference" )
    elsif ( qName.to_str == "line"       && @state == StateQuote )
	@state = StateLine
    elsif ( qName.to_str == "heading"    && @state == StateQuote )
	@state = StateHeading
	#// headings should be bold
	@quoteList[@quoteList.size - 1] += "<b>"
    elsif ( qName.to_str == "p"          && @state == StateQuote )
	@state = StateP
	#// start tag
	@quoteList[@quoteList.size - 1] += "</p>"
    else
	#// error
	return FALSE
    end
    return TRUE
end


def endElement( namespaceURI,localName, qName)
    #// "pop" the state and do some actions
    case ( @state )
	when StateQuote
	    @state = StateDocument
	    #// add closing tags and author and reference              QString tmp
	
	    @quoteList[@quoteList.size - 1] += "</big><br><br>"+"<center><i>-- "
	    if ( @author.isEmpty() )
		@quoteList[@quoteList.size - 1] += "Unknown"
	    else
		@quoteList[@quoteList.size - 1] += @author
                 end
	    if ( !@reference.isEmpty() )
		@quoteList[@quoteList.size - 1] += ", \"" + @reference + "\""
                 end
	    @quoteList[@quoteList.size - 1] += "</i></center><i>"
	
	when StateLine
	    @state = StateQuote
	    #// force line break
	    @quoteList[@quoteList.size - 1] += "<br>"
	
	when StateHeading
	    @state = StateQuote
	    #// closing tag
	    @quoteList[@quoteList.size - 1] += "</b><br>"
	
	when StateP
	    @state = StateQuote
	    #// closing tag
	    @quoteList[@quoteList.size - 1] += "</p>"

    end
    return TRUE
end


def characters( ch )
    #// we are not interested in whitespaces
    ch_simplified = ch.simplifyWhiteSpace()
    if ( ch_simplified.isEmpty() )
	return TRUE
    end
    case ( @state )
	when StateQuote,  StateLine,  StateHeading, StateP
	    @quoteList[@quoteList.size - 1] += ch_simplified	
	else
	    return FALSE
    end

    return TRUE
end


def errorString()
    return "the document is not in the quote file format"
end


def fatalErrorexception( exception )
    @errorProt += QString.new( "fatal parsing error: %1 in line %2, column %3\n" ).arg( exception.message() ).arg( exception.lineNumber() ).arg( exception.columnNumber() )

    return QXmlDefaultHandler::fatalError( exception )
end
end
