=begin
/****************************************************************
**
** Qt tutorial 8
**
****************************************************************/
=end
require "qte"
include Qte
require "qpe"
include Qpe

require "lcdrange.rb"
require "cannon.rb"

class MyWidget < QWidget

def initialize  parent=nil, name=""
    super( parent, name )
    @quit = QPushButton.new( "Quit", self, "quit" )
    @quit.setFont( QFont.new( "Times", 18, QFont::Bold ) )

    connect( @quit, QSIGNAL("clicked()"), QPEApplication::qApp, QSLOT("quit()") )

    @angle = LCDRange.new( self, "angle" )
    @angle.setRange( 5, 70 )

    @cannonField= CannonField.new( self, "cannonField" )

    connect( @angle.valueChanged, @cannonField, "setAngle" )
    connect( @cannonField.angleChanged,  @angle, "setValue" )

    grid = QGridLayout.new( self, 2, 2, 10 )
    #//2x2, 10 pixel border

    grid.addWidget( @quit, 0, 0 )
    grid.addWidget( @angle, 1, 0, Qt::AlignTop )
    grid.addWidget( @cannonField, 1, 1 )
    grid.setColStretch( 1, 10 )

    @angle.setValue( 60 )
    @angle.setFocus()
end
end


    $a = QPEApplication.new( [$0]+ARGV )

    $w = MyWidget.new
    $w.setGeometry( 100, 100, 500, 355 )
    $a.showMainWidget( $w )
    $a.exec()
