// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE8 $
// $Id: platform_qpe16.cpp,v 1.36 2004/03/07 07:07:43 yamaken Exp $

#include <stdlib.h>
#include <qlabel.h>
#include <qregexp.h>
#include <qapplication.h>
#include <qtopia/pluginloader.h>
#include <qtopia/qpeapplication.h>
#include "widgets/imkit_compactselector.h"
#include "widgets/imwidget_std.h"
#include "platform_qpe16.h"


static bool imkit_plugin_is_loading = false;


QUnknownInterface *
IMKitGlobal::create_instance(imkit_create_custom_ui_t ui_creator,
                             QPixmap *icon)
{
  ExtInputMethodInterface *instance;

  //Q_CREATE_INSTANCE(ExtIMKitImpl(ui_creator, elem_factory, icon))
  instance = new ExtIMKitImpl(ui_creator, icon);

  return instance;
}

QStringList *
IMKitGlobal::enabled_plugins(void) {
  PluginLoader *loader;

  if (!_enabled_plugins) {
    loader = new PluginLoader("inputmethods");
    qDebug("enabled_plugins(): methods = %s, last disabled = %s",
           loader->list().join(" ").latin1(),
           loader->disabledList().last().latin1());

    _enabled_plugins = new QStringList;
    *_enabled_plugins = loader->list().grep(QRegExp("^imkit-"));
    const QString &loading_plugin = loader->disabledList().last();
    _enabled_plugins->prepend(loading_plugin);

    delete loader;
    }

  return _enabled_plugins;
}

// IMKit-uim needs plugin name to specify inputmethod module to
// use. The symlink libimkit-uim-foo.so is exist to indicate
// inputmethod name to IMKit-uim. libimkit-uim.so.x.y.z, the
// implementation is shared by all inputmethods.
QString
IMKitGlobal::currently_loading_plugin_name(void) {
  PluginLoader *loader;
  static QString plugin;

  loader = new PluginLoader("inputmethods");

  if (imkit_plugin_is_loading) {
    // lib->queryInterface() is ongoing, so plugin name needs
    // updated.

    // Any plugin is temporarily disabled while loading, so we can
    // get my own plugin name from PluginLoader::disabledList().
    // see PluginLoader::queryInterface(), PluginLoader::setEnabled()
    plugin = loader->disabledList().last();
  }

  delete loader;

  return plugin;
}

void
Qpe16QWSKeyBypassIn::on_activate(void) {
}

void
Qpe16QWSKeyBypassIn::on_deactivate(void) {
}

Qpe16QWSKeyBypassIn::Qpe16QWSKeyBypassIn(void) {
}

void
Qpe16QWSKeyBypassOut::on_input(QKeyEvent &e) {
}

Qpe16QWSKeyBypassOut::Qpe16QWSKeyBypassOut(void) {
}

IMKitInputMethod::IMKitInputMethod(QWSKeyBypassIn *bypass_in_init,
                                   QWSKeyBypassOut *bypass_out_init)
  : bypass_in(bypass_in_init), bypass_out(bypass_out_init)
{
#ifndef IMKIT_BROKEN_QPE16_KEYFILTER
  connect(bypass_out, SIGNAL(key(ushort, ushort, ushort, bool, bool)),
          this, SLOT(sendback(int, int, int, bool, bool)));
#endif
}

IMKitInputMethod::~IMKitInputMethod(void) {
}

bool
IMKitInputMethod::filter(int unicode, int keycode, int modifiers, 
                         bool is_press, bool autorepeat)
{
  return bypass_in->filter(unicode, keycode, modifiers, is_press, autorepeat);
}

void
IMKitInputMethod::sendback(int unicode, int keycode, int modifiers,
                           bool is_press, bool autorepeat)
{
#ifndef IMKIT_BROKEN_QPE16_KEYFILTER
  //privateʤΤǸƤ٤ʤQWSServer::sendKeyEvent()Ǥ̵ºƵˤʤäƤޤ
  QWSServer::sendKeyEventUnfiltered(unicode, keycode, modifiers,
                                    is_press, autorepeat);
#endif
}

void
IMKitInputMethod::reset(void) {
#ifdef IMKIT_QPE16_EXPERIMENTAL_CONTEXT_RESET
  emit signal_reset();
#endif
}

extern QFrame *test_frame;
void
IMKitInputMethod::setMicroFocus(int x, int y) {
  //(x, y)ѴʸΥեbottomLeft + (0, 1)
#ifdef IMKIT_TEST_QWS_SETIMINFO_COMMAND
  qDebug("IMKitInputMethod::setMicroFocus(%d, %d)", x, y);
  {
    static int offset_x = 0;
    offset_x++;
    qDebug("IMKitInputMethod::setMicroFocus(): move(%d, 30) {", offset_x);
    test_frame->move(offset_x, 30);
    qDebug("IMKitInputMethod::setMicroFocus(): move(%d, 30) }", offset_x);
  }
#endif
#ifdef IMKIT_BROKEN_QPE16_PREEDIT_FOCUS
  int font_height, dummy_width;
  QFontMetrics metrics(font());

  font_height = metrics.height();
  dummy_width = font_height;  //TODO: Τwidth
  y -= metrics.height();  // y is not baseline

  QRect focus(x, y, dummy_width, font_height);
  emit focus_changed(focus);
#endif
}

void
IMKitInputMethod::mouseHandler(int x, int state) {
}

void
IMKitInputMethod::compose(const QString& str, int cursor_pos, int focus_len) {
  sendIMEvent(QWSServer::IMCompose, str, cursor_pos, focus_len);
}

void
IMKitInputMethod::commit(const QString& str) {
  sendIMEvent(QWSServer::IMEnd, str, 0, 0);
}

Qpe16Preedit::Qpe16Preedit(IMKitInputMethod *qws_im_init)
  : qws_im(NULL)
{
  set_qwsinputmethod(qws_im_init);
}

#ifdef IMKIT_BROKEN_QPE16_PREEDIT_FOCUS
void
Qpe16Preedit::notify_focus(const QRect &abs_focus) {
  emit focus_changed(abs_focus);
}
#endif

Qpe16Preedit::~Qpe16Preedit(void) {
}

void
Qpe16Preedit::set_qwsinputmethod(IMKitInputMethod *new_qws_im) {
  qws_im = new_qws_im;
  connect(qws_im, SIGNAL(focus_changed(const QRect &)),
          this, SLOT(notify_focus(const QRect &)));
}

QWidget *
Qpe16Preedit::widget(void) {
  return NULL;
}

void
Qpe16Preedit::set_widget(PreeditWidget *new_adaptee) {
}

void
Qpe16Preedit::update_state(PreeditState new_state) {
  _state = new_state;
}

void
Qpe16Preedit::update(Segments &segments) {
  Segments::const_iterator i;
  Segment::Type prev_segment_type;
  int cursor_pos = 0, focus_len = 0;
  QString str;

  prev_segment_type = Segment::IMKIT_SEG_NORMAL;
  for (i = segments.begin(); i != segments.end(); i++) {
    switch ((*i)->type()) {
    case Segment::IMKIT_SEG_CURSOR:
      cursor_pos = str.length();
      break;

    case Segment::IMKIT_SEG_SEPARATOR:
      if ((*i)->str() == "") {
        str += "|";
      }
      break;

    case Segment::IMKIT_SEG_FOCUS:
      // focus over multiple segments is supported
      if (prev_segment_type != Segment::IMKIT_SEG_FOCUS) {
        cursor_pos = str.length();
      }
      focus_len += (*i)->str().length();
      break;

    case Segment::IMKIT_SEG_NORMAL:
    case Segment::IMKIT_SEG_EDITING:
    case Segment::IMKIT_SEG_PENDING:
    default:
      break;
    }

    str += (*i)->str();
    prev_segment_type = (*i)->type();
  }

  if (str.isEmpty()) {
    qws_im->commit(str);
  } else {
    qws_im->compose(str, cursor_pos, focus_len);
  }
#ifndef IMKIT_BROKEN_QPE16_PREEDIT_FOCUS
  emit focus_changed(qws_im->inputRect());
#endif
}

void
Qpe16Preedit::commit(const QString& str) {
  qws_im->commit(str);
}

void
Qpe16IMElemFactory::initialize_inputmap_indicator(InputMapIndicator *indicator)
{
  StdIMWidgetFactory::initialize_inputmap_indicator(indicator);
  indicator->select(IMKIT_INPUT_MAP_ALPHA);
}

Qpe16IMElemFactory::Qpe16IMElemFactory(void)
  : qws_im(NULL), pixmaps(NULL)
{
  pixmaps = IMKitCompactSelectorPixmapRepository::instance();
}

Qpe16IMElemFactory::~Qpe16IMElemFactory(void) {
  IMKitCompactSelectorPixmapRepository::unref();
}

Preedit *
Qpe16IMElemFactory::create_preedit(QWidget *parent,
                                   Qt::WFlags flags,
                                   const char *name)
{
  return new Qpe16Preedit(qws_im);
}

InputMapIndicator *
Qpe16IMElemFactory::create_inputmap_indicator(QWidget *parent,
                                              Qt::WFlags flags,
                                              const char *name)
{
  InputMapIndicatorWidget *abstract_widget;
  StdInputMapIndicator *indicator;

  abstract_widget = create_inputmap_indicator_widget(parent, flags, name);
  indicator = new StdInputMapIndicator(abstract_widget, pixmaps);
  initialize_inputmap_indicator(indicator);

  return indicator;
}

InputMapIndicatorWidget *
Qpe16IMElemFactory::create_inputmap_indicator_widget(QWidget *parent,
                                                     Qt::WFlags flags,
                                                     const char *name)
{
  IMKitCompactSelector *widget;
  InputMapIndicatorWidget *abstract_widget;

  widget = new IMKitCompactSelector(parent, name, flags);
  abstract_widget = new InputMapIndicatorWidgetAbstractor<IMKitCompactSelector>(widget);

  return abstract_widget;
}

QWidget *
Qpe16IMElemFactory::build(QWidget *parent, Qt::WFlags flags) {
  _imwidget = create_imwidget(parent, flags);
  _preedit = create_preedit(NULL, flags);
  _indicator = create_inputmap_indicator(_imwidget, flags);
  _cand_win = create_candidate_window(NULL, flags);
  _committer = _preedit;

  return imwidget();
}

void
Qpe16IMElemFactory::set_qwsinputmethod(IMKitInputMethod *new_qws_im) {
  qws_im = new_qws_im;
}

void
ExtIMKitImpl::init(void) {
  if (!im_ui) {
    Qpe16IMElemFactory *elem_factory;

    elem_factory = new Qpe16IMElemFactory;
    im_ui = (*ui_creator)(elem_factory);
    prepare_key_bypass();
    join_to_bypass(im_ui->keyfilter_begin());
    QObject::connect(im_ui, SIGNAL(slot_activated(bool)),
                     bypass_in, SLOT(slot_activate(bool)));
    qws_im = new IMKitInputMethod(bypass_in, bypass_out);
#ifdef IMKIT_QPE16_EXPERIMENTAL_CONTEXT_RESET
    QObject::connect(qws_im, SIGNAL(signal_reset(void)),
                     im_ui, SLOT(reset_state(void)));
#endif
    elem_factory->set_qwsinputmethod(qws_im);
  }
}

void
ExtIMKitImpl::prepare_key_bypass(void) {
  bypass_in = new Qpe16QWSKeyBypassIn;
#ifdef IMKIT_BROKEN_QPE16_KEYFILTER
  bypass_out = new Qpe16QWSKeyBypassOut;
#else
  bypass_out = new QWSKeyBypassOut;
#endif
  bypass_in->insert_after(bypass_out);
  bypass_out->activate();
}

void
ExtIMKitImpl::join_to_bypass(CascadeKeyFilter *im_keyfilter) {
  if (!bypass_in) {
    prepare_key_bypass();
  }
  bypass_out->insert_before(im_keyfilter);
}

ExtIMKitImpl::ExtIMKitImpl(imkit_create_custom_ui_t ui_creator_init,
                           QPixmap *icon_init)
  : ref(0), qws_im(NULL), im_ui(NULL), ui_creator(ui_creator_init),
    _icon(icon_init), bypass_in(NULL), bypass_out(NULL)
{
  qDebug("ExtIMKitImpl::ExtIMKitImpl()");
  {
    // update plugin name
    imkit_plugin_is_loading = true;
    IMKitGlobal::currently_loading_plugin_name();
    imkit_plugin_is_loading = false;
  }
}

ExtIMKitImpl::~ExtIMKitImpl(void) {
  qDebug("ExtIMKitImpl::~ExtIMKitImpl()");
  delete bypass_out;
  delete bypass_in;
  if (im_ui) {
    delete qws_im;
    delete im_ui;
  }
  delete _icon;
  IMKitGlobal::unref();
}

void
ExtIMKitImpl::resetState(void) {
  im_ui->reset_state();
}

QPixmap *
ExtIMKitImpl::icon(void) {
  return _icon;
}

QString
ExtIMKitImpl::name(void) {
  return im_ui->name();
}

QStringList
ExtIMKitImpl::compatible(void) {
  return QStringList();
}

QWSInputMethod *
ExtIMKitImpl::inputMethod(void) {
  return qws_im;
}

QWidget *
ExtIMKitImpl::keyboardWidget(QWidget *parent, Qt::WFlags flags) {
  IMKitGlobal::loading_plugin_has_been_finished();

  return NULL;
}

QWidget *
ExtIMKitImpl::statusWidget(QWidget *parent, Qt::WFlags flags) {
  return im_ui->imwidget(parent, flags);
}

void
ExtIMKitImpl::qcopReceive(const QCString &msg, const QByteArray &data) {
  QDataStream stream(data, IO_ReadOnly);

  if (msg == "imkitSetMode(QString)") {
    QString map_name;
    InputMap map_val;

    stream >> map_name;
    map_val = imkit_str2sym_inputmap.ordinary_map.lookup(map_name);
    if (map_val == IMKIT_INPUT_MAP_TERM) return;

    im_ui->engine().select_map(map_val);
  }
}

QRESULT
ExtIMKitImpl::queryInterface(const QUuid &uuid, QUnknownInterface **interface)
{
  *interface = NULL;

  if (uuid == IID_QUnknown) {
    *interface = this;
    (*interface)->addRef();
    
    return QS_OK;
  } else if (uuid == IID_ExtInputMethod) {
    init();
    if (im_ui->engine().name()) {
      *interface = this;
      (*interface)->addRef();
      IMKitGlobal::loading_plugin_has_been_started();
      
      return QS_OK;
    } else {
      return QS_FALSE;
    }
  } else {
    return QS_FALSE;
  }
}
