// IMKit-uim: A Qtopia InputMethod interface for uim
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE9 $
// $Id: uim_keyevent.h,v 1.5 2004/03/07 07:07:43 yamaken Exp $

#ifndef IMKIT_UIM_KEYEVENT_H
#define IMKIT_UIM_KEYEVENT_H

#include <qnamespace.h>
#include <qevent.h>
#include <uim/uim.h>
#include "util.h"


class UIMKeyEvent {
protected:
  //q2u stands for Qt to UIM
  static BidirMap<Qt::Key, UKey> q2u_keycode;
  static BidirMap<Qt::Key, UKeyModifier> q2u_modifier_keycode;
  static BidirMap<Qt::ButtonState, UKeyModifier> q2u_modifier_state;

  bool accepted;

public:
  UKey keycode;
  UKeyModifier modifiers;
  bool is_press;

public:
  static Qt::ButtonState extract_modifier_state(QChar chr);
  static UKeyModifier q2u_convert_modifier_state(int modifier_state);

  UIMKeyEvent(void);
  UIMKeyEvent(UKey keycode_init, UKeyModifier modifiers_init,
                bool is_press_init);
  UIMKeyEvent(const QKeyEvent &e);
  virtual ~UIMKeyEvent(void);
  //operator QKeyEvent(void) const;
  virtual bool is_accepted(void) const;
  virtual void accept(void);
  virtual void ignore(void);
};

#endif  // IMKIT_UIM_KEYEVENT_H
