// IMKit-Raw: A Qtopia InputMethod (raw input)
// Copyright (C) 2003  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0 $
// $Id: engine_raw.cpp,v 1.6 2004/04/01 10:45:31 yamaken Exp $

#include <qobject.h>
#include <qstring.h>
#include <qtextcodec.h>
#include "engine_raw.h"


RawEngine::RawEngine(void) : _command_map(NULL) {
}

RawEngine::~RawEngine(void) {
  imkit_delete_command_map(_command_map);
}

void
RawEngine::reset(void) {
}

const char *
RawEngine::name(void) const {
  return QT_TR_NOOP("Raw");
}

const char *
RawEngine::language(void) const {
  return QTextCodec::locale();
}

InputMap
RawEngine::map_state(void) const {
  return IMKIT_INPUT_MAP_RAW;
}

CommandMap *
RawEngine::command_map(void) {
  typedef TemplateCommandWithKeyEvent<RawEngine> command_t;
  command_t *cmd;

  if (!_command_map) {
    cmd = new command_t(this,
                        &RawEngine::cmd_receive_keyevent,
                        "receive_keyevent");

    _command_map = new CommandMap;
    (*_command_map)["receive_keyevent"] = cmd;
  }

  return _command_map;
}

void
RawEngine::cmd_receive_keyevent(QKeyEvent &e) {
#if 0
  // input via QIMEvent (for testing)
  QChar chr;

  chr = e.ascii();
  if (e.type() == QEvent::KeyPress && chr.isPrint()) {
    e.accept();
    emit committed(QString(chr));
  }
#else
  // simply ignore
#endif
}

void
RawEngine::input_str(const QString &str) {
}

void
RawEngine::input_char(QChar chr) {
}

void
RawEngine::select_map(InputMap new_map) {
}

void
RawEngine::select_candidate(Candidates::size_type nth) {
}
