// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0 $
// $Id: ui_std.cpp,v 1.22 2004/03/16 15:46:36 yamaken Exp $

#include <qfont.h>
#include <qfontmetrics.h>
#include "ui_std.h"
#include "imwidget.h"
#include "keyfilter.h"
#include "widgets/imwidget_std.h"
#include "widgets/imkit_qlineedit.h"
#ifdef IMKIT_QPE15_USE_IMKITCOMPACTSELECTOR
#include "widgets/imkit_compactselector.h"
#endif
#include <qpe/config.h>

void
StdIMWidgetFactory::initialize_imwidget(QWidget *imwidget) {
  imwidget = imwidget;  //to supress warning
}

void
StdIMWidgetFactory::initialize_preedit(Preedit *preedit) {
  preedit = preedit;  //to supress warning
}

void
StdIMWidgetFactory::initialize_inputmap_indicator(InputMapIndicator *indicator)
{
  indicator->add_state(IMKIT_INPUT_MAP_HIRAGANA,
                       StdInputMapIndicator::tr("hira"));
  indicator->add_state(IMKIT_INPUT_MAP_KATAKANA,
                       StdInputMapIndicator::tr("kata"));
  indicator->add_state(IMKIT_INPUT_MAP_ALPHA,
                       StdInputMapIndicator::tr("alnm"));
  indicator->add_state(IMKIT_INPUT_MAP_WALPHA,
                       StdInputMapIndicator::tr("walnm"));
}

void
StdIMWidgetFactory::initialize_candidate_window(CandidateWindow *cand_win) {
  cand_win = cand_win;  //to supress warning
}

PreeditWidget *
StdIMWidgetFactory::create_preedit_widget(QWidget *parent,
                                          Qt::WFlags flags,
                                          const char *name)
{
  IMKitQLineEdit *widget;
  PreeditWidget *abstract_widget;

  widget = new IMKitQLineEdit(parent, name);
  abstract_widget = new PreeditWidgetAbstractor<IMKitQLineEdit>(widget);

  return abstract_widget;
}

InputMapIndicatorWidget *
StdIMWidgetFactory::create_inputmap_indicator_widget(QWidget *parent,
                                                     Qt::WFlags flags,
                                                     const char *name)
{
#ifdef IMKIT_QPE15_USE_IMKITCOMPACTSELECTOR
  IMKitCompactSelector *widget;
  InputMapIndicatorWidget *abstract_widget;

  widget = new IMKitCompactSelector(parent, name, flags);
  abstract_widget
    = new InputMapIndicatorWidgetAbstractor<IMKitCompactSelector>(widget);
#else
  QComboBox *widget;
  InputMapIndicatorWidget *abstract_widget;

  widget = new QComboBox(parent, name);
  abstract_widget = new InputMapIndicatorWidgetAbstractor<QComboBox>(widget);
  // TODO: indicator_widget->updateGeometry();  //add_state()˼¹
#endif

  return abstract_widget;
}

CandidateWindowWidget *
StdIMWidgetFactory::create_candidate_window_widget(QWidget *parent,
                                                   Qt::WFlags flags,
                                                   const char *name)
{
  QListBox *widget;
  CandidateWindowWidgetAbstractor<QListBox> *abstract_widget;
  Qt::WFlags overwrite_flags;

#ifdef IMKIT_QPE16_PLATFORM
  overwrite_flags = (Qt::WType_Popup  //ץΥեåʤ
#else
  //Qtopia 1.5ǤTopLevelˤʤȥץ΢˱
  overwrite_flags = (Qt::WType_TopLevel
#endif
                     | Qt::WStyle_Customize
                     | Qt::WStyle_NoBorderEx
                     | Qt::WStyle_StaysOnTop
                     );
  widget = new QListBox(parent, name, overwrite_flags);
  widget->setVScrollBarMode(QListBox::AlwaysOn);
  widget->setSelectionMode(QListBox::Single);
  widget->setColumnMode(1);

  //䥦ɥ򥿥åפƤIMEndEventȯʤ
  widget->setFocusPolicy(QWidget::NoFocus);

  abstract_widget = new CandidateWindowWidgetAbstractor<QListBox>(widget);
  {
    Config conf("IMKit");
    int n_candidates = -1, cell_spacing = -1;
    int decoration_height = -1, width = -1;

    conf.setGroup("Candidate Window");
    if (conf.hasKey("ItemsAtOnce")) {
      n_candidates = conf.readEntry("ItemsAtOnce").toInt();
    }
    if (conf.hasKey("_CellSpacing")) {
      cell_spacing = conf.readEntry("_CellSpacing").toInt();
    }
    if (conf.hasKey("_DecorationHeight")) {
      decoration_height = conf.readEntry("_DecorationHeight").toInt();
    }
    if (conf.hasKey("_Width")) {
      width = conf.readEntry("_Width").toInt();
    }
    
    abstract_widget->configure(n_candidates, cell_spacing,
                               decoration_height, width);
  }
  abstract_widget->resize();

  return abstract_widget;
}

StdIMWidgetFactory::StdIMWidgetFactory(void)
  : _committer(NULL), _preedit(NULL), _indicator(NULL), _cand_win(NULL),
    _imwidget(NULL)
{
}

StdIMWidgetFactory::~StdIMWidgetFactory(void) {
  if (_preedit) {
    if (_preedit->widget()) {
      delete _preedit->widget();
    }
    delete _preedit;
  }

  if (_indicator) {
    if (_indicator->widget()) {
      delete _indicator->widget();
    }
    delete _indicator;
  }

  if (_cand_win) {
    if (_cand_win->widget()) {
      delete _cand_win->widget();
    }
    delete _cand_win;
  }

  if (_imwidget) {
    delete _imwidget;
  }
}

QWidget *
StdIMWidgetFactory::create_imwidget(QWidget *parent,
                                    Qt::WFlags flags,
                                    const char *name)
{
  QWidget *imwidget;

  imwidget = new StdIMWidget(parent, name, flags);
  initialize_imwidget(imwidget);

  return imwidget;
}

Preedit *
StdIMWidgetFactory::create_preedit(QWidget *parent,
                                   Qt::WFlags flags,
                                   const char *name)
{
  PreeditWidget *abstract_widget;
  Preedit *preedit;

  abstract_widget = create_preedit_widget(parent, flags, name);
  preedit = new StdPreedit(abstract_widget, QChar(IMKIT_NON_UNICODE_CHAR));
  initialize_preedit(preedit);

  return preedit;
}

InputMapIndicator *
StdIMWidgetFactory::create_inputmap_indicator(QWidget *parent,
                                              Qt::WFlags flags,
                                              const char *name)
{
  InputMapIndicatorWidget *abstract_widget;
  StdInputMapIndicator *indicator;
#ifdef IMKIT_QPE15_USE_IMKITCOMPACTSELECTOR
  IMKitCompactSelectorPixmapRepository *pixmaps
    = IMKitCompactSelectorPixmapRepository::instance();
#endif

  abstract_widget = create_inputmap_indicator_widget(parent, flags, name);
#ifdef IMKIT_QPE15_USE_IMKITCOMPACTSELECTOR
  indicator = new StdInputMapIndicator(abstract_widget, pixmaps);
#else
  indicator = new StdInputMapIndicator(abstract_widget);
#endif
  initialize_inputmap_indicator(indicator);

  return indicator;
}

CandidateWindow *
StdIMWidgetFactory::create_candidate_window(QWidget *parent,
                                            Qt::WFlags flags,
                                            const char *name)
{
  CandidateWindowWidget *abstract_widget;
  CandidateWindow *cand_win;

  abstract_widget = create_candidate_window_widget(parent, flags, name);
  cand_win = new StdCandidateWindow(abstract_widget);
  initialize_candidate_window(cand_win);

  return cand_win;
}

QWidget *
StdIMWidgetFactory::build(QWidget *parent, Qt::WFlags flags) {
  _imwidget = create_imwidget(parent, flags);
  _preedit = create_preedit(_imwidget, flags);
  _indicator = create_inputmap_indicator(_imwidget, flags);
  _cand_win = create_candidate_window(_imwidget, flags);
  _committer = NULL;

  return imwidget();
}

QWidget *
StdIMWidgetFactory::imwidget(void) {
  return _imwidget;
}

Preedit *
StdIMWidgetFactory::preedit(void) {
  return _preedit;
}

InputMapIndicator *
StdIMWidgetFactory::inputmap_indicator(void) {
  return _indicator;
}

CandidateWindow *
StdIMWidgetFactory::candidate_window(void) {
  return _cand_win;
}

QObject *
StdIMWidgetFactory::committer(void) {
  return _committer;
}

void
StdIMUserInterface::delete_keyfilter(void) {
  CascadeKeyFilter *i, *next;
  
  for (i = keyfilter_begin()->next(); i != keyfilter_end(); i = next) {
    next = i->next();
    i->remove();
    delete i;
  }
}

void
StdIMUserInterface::connect_signals(void) {
  connect(_engine, SIGNAL(preedit_state_changed(PreeditState)),
          this, SLOT(update_preedit_state(PreeditState)));

  connect(_engine, SIGNAL(committed(const QString &)),
          committer, SLOT(commit(const QString &)));
  connect(_engine, SIGNAL(map_changed(InputMap)),
          indicator, SLOT(select(InputMap)));
  connect(_engine, SIGNAL(map_state_added(InputMap, const QString &)),
          indicator, SLOT(add_state(InputMap, const QString &)));
  connect(_engine, SIGNAL(map_states_cleared(void)),
          indicator, SLOT(clear(void)));
  
  connect(_engine, SIGNAL(preedit_state_changed(PreeditState)),
          preedit, SLOT(update_state(PreeditState)));
  connect(_engine, SIGNAL(segments_changed(Segments &)),
          preedit, SLOT(update(Segments &)));

  connect(_engine, SIGNAL(update_candidates(Candidates &)),
          cand_win, SLOT(update(Candidates &)));
  connect(_engine, SIGNAL(hilight_candidate(int, bool)),
          cand_win, SLOT(hilight(int, bool)));
  connect(_engine, SIGNAL(activation_hint_for_candidates(bool)),
          cand_win, SLOT(slot_activate(bool)));

  connect(indicator, SIGNAL(selected(InputMap)),
          _engine, SLOT(select_map(InputMap)));
  connect(cand_win, SIGNAL(selected(Candidates::size_type)),
          _engine, SLOT(select_candidate(Candidates::size_type)));
  connect(preedit, SIGNAL(focus_changed(const QRect &)),
          cand_win, SLOT(move_adjacent(const QRect &)));

  connect(_imwidget, SIGNAL(activated(bool)),
          this, SLOT(slot_activate(bool)));
}

TranslationEngine &
StdIMUserInterface::engine(void) {
  return *_engine;
}

#ifdef IMKIT_QPE16_EXPERIMENTAL_CONTEXT_RESET
TranslationEngine *
StdIMUserInterface::enginep(void) {
  return _engine;
}
#endif

CommandMap *
StdIMUserInterface::ui_command_map(void) {
  CommandMap *_ui_command_map;

  _ui_command_map = new CommandMap;
  (*_ui_command_map)["do_nothing"] = new DoNothingCommand("do_nothing");
  //"activate_candidate_window"
  //"deactivate_candidate_window"
  //"purge_engine"

  return _ui_command_map;
}

StdIMUserInterface::
StdIMUserInterface(TranslationEngine *engine_init,
                   StdIMWidgetFactory *imwidget_factory_init)
  : _engine(engine_init), _command_map(NULL),
    _keyfilter_begin(NULL), _keyfilter_end(NULL), committer(NULL),
    preedit(NULL), indicator(NULL), cand_win(NULL), _imwidget(NULL),
    imwidget_factory(imwidget_factory_init)
{
  _keyfilter_begin = new DumbPipe;
#ifdef IMKIT_QPE16_PLATFORM
  _keyfilter_end = new DumbPipe;
#else
  CharInjector *injector;

  injector = new CharInjector;
  committer = injector;
  _keyfilter_end = injector;
#endif
  _keyfilter_begin->insert_after(_keyfilter_end);
  //assemble_engine();
}

StdIMUserInterface::~StdIMUserInterface(void) {
  purge_engine();
  delete _keyfilter_begin;
  delete _keyfilter_end;
  delete imwidget_factory;
}

CascadeKeyFilter *
StdIMUserInterface::keyfilter_begin(void) {
  return _keyfilter_begin;
}

CascadeKeyFilter *
StdIMUserInterface::keyfilter_end(void) {
  return _keyfilter_end;
}

QWidget *
StdIMUserInterface::imwidget(void) {
  return _imwidget;
}

QWidget *
StdIMUserInterface::imwidget(QWidget *parent, Qt::WFlags flags) {
  if (!_imwidget) {
#ifdef IMKIT_QPE16_IMMODIFIER_NAME_INDICATOR
    QLabel *label;
#endif

    imwidget_factory->build(parent, flags);
    preedit = imwidget_factory->preedit();
    indicator = imwidget_factory->inputmap_indicator();
    cand_win = imwidget_factory->candidate_window();
    _imwidget = imwidget_factory->imwidget();

    if (!committer && imwidget_factory->committer()) {
      committer = imwidget_factory->committer();
    }

    //connect_signals();
    assemble_engine();
#ifdef IMKIT_QPE16_IMMODIFIER_NAME_INDICATOR
    label = new QLabel(engine().name(), _imwidget, "IMKitEngineName");
#endif
  }

  return _imwidget;
}

CommandMap *
StdIMUserInterface::command_map(void) {
  CommandMap *engine_commands;

  if (!_command_map) {
    _command_map = ui_command_map();
    engine_commands = engine().command_map();

    _command_map->insert(engine_commands->begin(), engine_commands->end());
  }

  return _command_map;
}

void
StdIMUserInterface::assemble_engine(void) {
  _keyfilter_begin->insert_after(create_keyfilter());
  //_engine = new AnthyEngine;  //TODO: create engine dynamically
  connect_signals();
  deactivate();
  engine().reset();  // to update inputmap indicator
  indicator->select(engine().map_state());
}

void
StdIMUserInterface::purge_engine(void) {
#if 0
  //~StdIMUserInterfaceƤФȡλset_activity()
  //̵ˤʤäƤ
  deactivate();
#endif
  disconnect(preedit, SIGNAL(focus_changed(const QRect &)),
             cand_win, SLOT(move_adjacent(const QRect &)));
  delete_keyfilter();

  if (_command_map) {
    CommandMap *engine_commands;
    CommandMap::iterator i;
    
    engine_commands = engine().command_map();
    for (i = engine_commands->begin(); i != engine_commands->end(); i++) {
      _command_map->erase(i->first);
    }
    imkit_delete_command_map(_command_map);
    _command_map = NULL;
  }

  delete _engine;
  _engine = NULL;
}
