// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0 $
// $Id: imkit_compactselector.h,v 1.9 2004/03/10 11:19:41 yamaken Exp $

#ifndef IMKIT_COMPACTSELECTOR_H
#define IMKIT_COMPACTSELECTOR_H

#include <qevent.h>
#include <qwidget.h>
#include <qwidgetstack.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include "imwidget.h"


class IMKitCompactSelectorPixmapRepository : public PixmapRepository {
protected:
  static IMKitCompactSelectorPixmapRepository *_instance;
  static int refcnt;

public:
  static IMKitCompactSelectorPixmapRepository *instance(void);

protected:
  IMKitCompactSelectorPixmapRepository(void);
  virtual ~IMKitCompactSelectorPixmapRepository(void);

public:
  static void unref(void);
  virtual QPixmap lookup(InputMap map_code);
};


class IMKitIndicator : public QLabel {
  Q_OBJECT

protected:
  QPopupMenu *chooser;

protected:
  virtual void mousePressEvent(QMouseEvent *event);
  virtual void choose(void);

public:
  IMKitIndicator(QWidget *parent, QPopupMenu *chooser_init);
  ~IMKitIndicator(void);
};

// QComboBoxΥ󥿥եΥ֥å
class IMKitCompactSelector : public QWidget {
  Q_OBJECT

protected:
  QLabel *indicator;
  QPopupMenu *chooser;
  int checked_item;

protected slots:
  virtual void activated_by_chooser(int index);

public:
  IMKitCompactSelector(QWidget *parent = NULL, const char *name = NULL,
                       WFlags flags = NULL);
  virtual ~IMKitCompactSelector(void);
  virtual void setFont(const QFont &new_font);
  virtual void setCurrentItem(int index);
  virtual void insertItem(const QPixmap &pixmap, const QString &label,
                          int index);
  virtual void insertItem(const QString &label, int index);
  virtual void clear(void);

signals:
  void activated(int index);
};

#endif  // IMKIT_COMPACTSELECTOR_H
