// IMKit-Raw: A Qtopia InputMethod (raw input)
// Copyright (C) 2003-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_4 $
// $Id: ui_raw.cpp,v 1.4 2004/04/01 10:45:31 yamaken Exp $

#include "ui_raw.h"


CascadeKeyFilter *
RawGUI::create_keyfilter(void) {
  forwarder = new RawMapper<>((*command_map())["receive_keyevent"]);
  
  return forwarder;
}

void
RawGUI::update_preedit_state(PreeditState new_state) {
}

RawGUI::RawGUI(RawEngine *engine_init,
               StdIMWidgetFactory *imwidget_factory_init)
  : StdIMUserInterface(engine_init, imwidget_factory_init),
    forwarder(NULL)
{
}

void
RawGUI::set_activity(bool activity) {
  //TODO: activate()engine̵äassemble
  forwarder->activate(activity);
}

bool
RawGUI::is_active(void) const {
  return forwarder->is_active();
}

QWidget *
RawGUI::imwidget(QWidget *parent, Qt::WFlags flags) {
  QWidget *widget;

  widget = StdIMUserInterface::imwidget(parent, flags);
  indicator->clear();
  indicator->add_state(IMKIT_INPUT_MAP_RAW, tr("raw input"));
  indicator->select(IMKIT_INPUT_MAP_RAW);

  return widget;
}
