// IMKit-Utena: A Qtopia InputMethod interface for Utena
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5_PRE_UTENA_902 $
// $Id: engine_utena.h,v 1.3 2002/09/02 22:57:01 yamaken Exp $

#ifndef IMKIT_ENGINE_UTENA_H
#define IMKIT_ENGINE_UTENA_H

extern "C" {
#include <utena.h>
}
#include "keyfilter.h"
#include "engine.h"

class QTextCodec;


class UtenaSegment : public Segment {
protected:
  QString unicode_str;

public:
  UtenaSegment(const char *raw_str = "");
  virtual ~UtenaSegment(void);
  virtual const QString &str(void);
  virtual const char *raw_str(void) const;
  virtual Type type(void) const;
  virtual void sync();
  virtual void sync(const char *raw_str);
};


class UtenaEngine : public TranslationEngine {
  Q_OBJECT

protected:
#if 0
  //n2a stands for Native to Abstract
  static BidirMap<int, PreeditState> n2a_preedit_state;
#endif

  utena_context utena_ctx;
  Segments *segments;
  CommandMap *_command_map;

protected:
  //callback interface to adapt to Utena API
  static void cb_commit(void *_this, char *str);
  static void cb_clear(void *_this);
  static void cb_pushback(void *_this, int attr, char *str);
  static void cb_update(void *_this);

protected slots:
  //internal slots that receives Utena callbacks
  virtual void slot_commit(char *str);
  virtual void slot_clear(void);
  virtual void slot_pushback(int attr, char *str);
  virtual void slot_update(void);
  
protected:
  virtual PreeditState preedit_state(void) const;
  virtual void init_state(void);
  virtual void free_state(void);
  virtual void init_segments(void);
  virtual void sync(void);

public:
  static const QTextCodec *codec(void);

  UtenaEngine(void);
  virtual ~UtenaEngine(void);
  virtual const char *name(void) const;
  virtual InputMap map_state(void) const;
  virtual CommandMap *command_map(void);

  //commands
  void cmd_receive_keyevent(QKeyEvent &e);

public slots:
  virtual void reset(void);
  virtual void input_str(const QString &str);
  virtual void input_char(QChar chr);
  virtual void select_map(InputMap new_map);
  virtual void select_candidate(Candidates::size_type which);
};

#endif  // IMKIT_ENGINE_UTENA_H
