// IMKit-Utena: A Qtopia InputMethod interface for Utena
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5_PRE_UTENA_902 $
// $Id: imkit_utena_qpe.cpp,v 1.1 2002/08/31 08:17:03 yamaken Exp $

#include <qwidget.h>
#include <qhbox.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qpe/inputmethodinterface.h>
#include "keyfilter.h"
#include "engine_utena.h"
#include "ui_utena.h"
#include "imkit_qlineedit.h"
#include "imwidget.h"
#include "imwidget_std.h"
#include "platform_qpe.h"


#ifdef IMKIT_USE_TEMPLATE_QOBJECT
typedef QWidgetWithActivationSignal<QHBox> UtenaWidget;
#else  //IMKIT_USE_TEMPLATE_QOBJECT
typedef StdIMWidget UtenaWidget;
#endif  //IMKIT_USE_TEMPLATE_QOBJECT

static IMUserInterface *create_custom_utena_ui(void);
static QPixmap *create_icon(void);
static InputMethodInterface *create_instance(void);

static const char *utena_icon_xpm[];


class UtenaWidgetFactory : public StdIMWidgetFactory {
public:
  UtenaWidgetFactory(void) {}
  virtual ~UtenaWidgetFactory(void) {}
  virtual QWidget *create_imwidget(QWidget *parent, Qt::WFlags flags,
                                   const char *name = "IMWidget");
  virtual Preedit *create_preedit(QWidget *parent, Qt::WFlags flags,
                                  const char *name = "Preedit");
  virtual InputMapIndicator *
    create_inputmap_indicator(QWidget *parent, Qt::WFlags flags,
                              const char *name = "InputMapIndicator");
  virtual CandidateWindow *
    create_candidate_window(QWidget *parent, Qt::WFlags flags,
                            const char *name = "CandidateWindow");
  virtual QListBox *create_candidate_window_widget(QWidget *parent,
                                                   const char *name);

};


//TODO: Utena򤵤Ƥǧ䤹Τѹ
static const char *utena_icon_xpm[] = {
"28 14 2 1",
"# c #000000",
". c None",
".........##..##.##..........",
"..........##.##.##..........",
"..........###########.......",
".......##....##.##..........",
"........##..########........",
"........##..##.##.##........",
"............########........",
".........##....##...........",
".........##.########........",
".........##....##...........",
"........##.##########.......",
"........##....##.#..........",
".......##....##..##.........",
".......##..###....###......."
};


QWidget *
UtenaWidgetFactory::create_imwidget(QWidget *parent,
                                    Qt::WFlags flags,
                                    const char *name = "IMWidget")
{
  QWidget *imwidget;

  imwidget = new UtenaWidget(parent, name, flags);

  return imwidget;
}

Preedit *
UtenaWidgetFactory::create_preedit(QWidget *parent,
                                   Qt::WFlags flags,
                                   const char *name = "Preedit")
{
  IMKitQLineEdit *preedit_widget;
  PreeditWidget *abstract_preedit_widget;
  Preedit *preedit;

  preedit_widget = new IMKitQLineEdit(parent, name);
  abstract_preedit_widget
    = new PreeditWidgetAbstractor<IMKitQLineEdit>(preedit_widget);
  preedit = new StdPreedit(abstract_preedit_widget,
                           QChar(IMKIT_NON_UNICODE_CHAR));

  return preedit;
}

InputMapIndicator *
UtenaWidgetFactory::
create_inputmap_indicator(QWidget *parent,
                          Qt::WFlags flags,
                          const char *name = "InputMapIndicator")
{
  QComboBox *indicator_widget;
  InputMapIndicatorWidget *abstract_indicator_widget;
  StdInputMapIndicator *indicator;

  indicator_widget = new QComboBox(parent, name);
  abstract_indicator_widget
    = new InputMapIndicatorWidgetAbstractor<QComboBox>(indicator_widget);
  indicator = new StdInputMapIndicator(abstract_indicator_widget);

  indicator->add_state(IMKIT_INPUT_MAP_HIRAGANA,
                       StdInputMapIndicator::tr("hira"));
  indicator->add_state(IMKIT_INPUT_MAP_KATAKANA,
                       StdInputMapIndicator::tr("kata"));
  indicator->add_state(IMKIT_INPUT_MAP_ALPHA,
                       StdInputMapIndicator::tr("alnm"));
  indicator->add_state(IMKIT_INPUT_MAP_WALPHA,
                       StdInputMapIndicator::tr("walnm"));
  indicator_widget->adjustSize();

  return indicator;
}

CandidateWindow *
UtenaWidgetFactory::
create_candidate_window(QWidget *parent,
                        Qt::WFlags flags,
                        const char *name = "CandidateWindow")
{
  QListBox *cand_win_widget;
  CandidateWindowWidget *abstract_cand_win_widget;
  CandidateWindow *cand_win;

  cand_win_widget = create_candidate_window_widget(parent, name);
  abstract_cand_win_widget
    = new CandidateWindowWidgetAbstractor<QListBox>(cand_win_widget);
  cand_win = new StdCandidateWindow(abstract_cand_win_widget);

  return cand_win;
}

QListBox *
UtenaWidgetFactory::create_candidate_window_widget(QWidget *parent,
                                                   const char *name)
{
  QListBox *widget;

  widget = new QListBox(parent, name,
                        Qt::WType_TopLevel
                        | Qt::WStyle_Customize
                        | Qt::WStyle_NoBorderEx
                        | Qt::WStyle_StaysOnTop
                        );
  widget->setVScrollBarMode(QListBox::AlwaysOn);
  widget->setSelectionMode(QListBox::Single);
  widget->setColumnMode(1);
  widget->setResizePolicy(QListBox::AutoOneFit);

  return NULL;
}

static IMUserInterface *
create_custom_utena_ui(void) {
  UtenaEngine *engine;
  IMUserInterface *utena_ui;
  StdIMWidgetFactory *imwidget_factory;

  engine = new UtenaEngine;
  imwidget_factory = new UtenaWidgetFactory;
  utena_ui = new UtenaGUI(engine, imwidget_factory);

  return utena_ui;
}

static QPixmap *
create_icon(void) {
  QPixmap *icon;

  icon = new QPixmap((const char **)utena_icon_xpm);

  return icon;
}

static InputMethodInterface *
create_instance(void) {
  IMUserInterface *ui;
  InputMethodInterface *instance;

  ui = create_custom_utena_ui();
  //Q_CREATE_INSTANCE(IMKitImpl(ui, icon))
  instance = new IMKitImpl(ui, create_icon());

  return instance;
}

IMKIT_EXPORT_INTERFACE(create_instance);
