// IMKit-Utena: A Qtopia InputMethod interface for Utena
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5_PRE_UTENA_902 $
// $Id: ui_utena.h,v 1.2 2002/09/02 18:38:52 yamaken Exp $

#ifndef IMKIT_UI_UTENA_H
#define IMKIT_UI_UTENA_H

#include "keyfilter.h"
#include "ui.h"
#include "ui_std.h"
#include "engine_utena.h"
#include "imwidget_std.h"


class UtenaGUI : public StdIMUserInterface {
  Q_OBJECT

protected:
  RawMapper<> *forwarder;

protected:
  virtual CascadeKeyFilter *create_keyfilter(void);
  virtual void set_activity(bool activity);

protected slots:
  virtual void update_preedit_state(PreeditState new_state);

public:
  UtenaGUI(UtenaEngine *engine_init,
           StdIMWidgetFactory *imwidget_factory_init);
  virtual bool is_active(void) const;
};

#endif  //IMKIT_UI_UTENA_H
