<?php
//
// +----------------------------------------------------------------------+
// |zen-cart Open Source E-commerce                                       |
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 The zen-cart developers                           |
// |                                                                      |
// | http://www.zen-cart.com/index.php                                    |
// |                                                                      |
// | Portions Copyright (c) 2003 osCommerce                               |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.0 of the GPL license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.zen-cart.com/license/2_0.txt.                             |
// | If you did not receive a copy of the zen-cart license and are unable |
// | to obtain it through the world-wide-web, please send a note to       |
// | license@zen-cart.com so we can mail you a copy immediately.          |
// +----------------------------------------------------------------------+
// $Id: checkout_process.php,v 1.3 2005/01/12 09:16:22 shida Exp $
//

if (!$full_ipn) {
  require(DIR_WS_MODULES . 'require_languages.php');


// if the customer is not logged on, redirect them to the time out page
  if (!$_SESSION['customer_id']) {
    zen_redirect(zen_href_link(FILENAME_TIME_OUT));
  }

// load selected payment module
  require(DIR_WS_CLASSES . 'payment.php');
  $payment_modules = new payment($_SESSION['payment']);

// load the selected shipping module
  require(DIR_WS_CLASSES . 'shipping.php');
  $shipping_modules = new shipping($_SESSION['shipping']);

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

//add for Japanese shipping module use
  if( isset( $_SESSION['shipping']['timespec'] ) ){
   	$order->info['comments'] = '['.TEXT_TIME_SPECIFY.$_SESSION['shipping']['timespec'].']'."\n".$order->info['comments'];
  }

  require(DIR_WS_CLASSES . 'order_total.php');
  $order_total_modules = new order_total;
  $order_totals = $order_total_modules->pre_confirmation_check();
  $order_totals = $order_total_modules->process();

if (!isset($_SESSION['payment']) && !$credit_covers) {
  zen_redirect(zen_href_link(FILENAME_DEFAULT));
}

// load the before_process function from the payment modules
  $payment_modules->before_process();
} else {

  include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_PROCESS);
  require(DIR_WS_CLASSES . 'payment.php');
  $payment_modules = new payment($payment);
  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;
  require(DIR_WS_CLASSES . 'order_total.php');
  $order_total_modules = new order_total;
  $order_totals = $order_total_modules->pre_confirmation_check();
  $order_totals = $order_total_modules->process();

}

  $sql_data_array = array('customers_id' => $_SESSION['customer_id'],
// update for jp style   'customers_name' => $order->customer['firstname'] . ' ' . $order->customer['lastname'],
                          'customers_name' => $order->customer['lastname'] . ' ' . $order->customer['firstname'],
                          'customers_company' => $order->customer['company'],
                          'customers_street_address' => $order->customer['street_address'],
                          'customers_suburb' => $order->customer['suburb'],
                          'customers_city' => $order->customer['city'],
                          'customers_postcode' => $order->customer['postcode'],
                          'customers_state' => $order->customer['state'],
                          'customers_country' => $order->customer['country']['title'],
                          'customers_telephone' => $order->customer['telephone'],
                          'customers_fax' => $order->customer['fax'],
                          'customers_email_address' => $order->customer['email_address'],
			 'customers_address_format_id' => $order->customer['format_id'],
// update for jp style    'delivery_name' => $order->delivery['firstname'] . ' ' . $order->delivery['lastname'],
                          'delivery_name' => $order->delivery['lastname'] . ' ' . $order->delivery['firstname'],
                          'delivery_company' => $order->delivery['company'],
                          'delivery_street_address' => $order->delivery['street_address'],
                          'delivery_suburb' => $order->delivery['suburb'],
                          'delivery_city' => $order->delivery['city'],
                          'delivery_postcode' => $order->delivery['postcode'],
                          'delivery_state' => $order->delivery['state'],
                          'delivery_country' => $order->delivery['country']['title'],
                          'delivery_telephone' => $order->delivery['telephone'],
                          'delivery_fax' => $order->delivery['fax'],
                          'delivery_address_format_id' => $order->delivery['format_id'],
// update for jp style    'billing_name' => $order->billing['firstname'] . ' ' . $order->billing['lastname'],
                          'billing_name' => $order->billing['lastname'] . ' ' . $order->billing['firstname'],
                          'billing_company' => $order->billing['company'],
                          'billing_street_address' => $order->billing['street_address'],
                          'billing_suburb' => $order->billing['suburb'],
                          'billing_city' => $order->billing['city'],
                          'billing_postcode' => $order->billing['postcode'],
                          'billing_state' => $order->billing['state'],
                          'billing_country' => $order->billing['country']['title'],
                          'billing_telephone' => $order->billing['telephone'],
                          'billing_fax' => $order->billing['fax'],
                          'billing_address_format_id' => $order->billing['format_id'],
                          'payment_method' => $order->info['payment_method'],
                          'cc_type' => $order->info['cc_type'],
                          'cc_owner' => $order->info['cc_owner'],
                          'cc_number' => $order->info['cc_number'],
                          'cc_expires' => $order->info['cc_expires'],
                          'date_purchased' => 'now()',
                          'orders_status' => $order->info['order_status'],
                          'order_total' => $order->info['total'],
                          'order_tax' => $order->info['tax'],
                          'currency' => $order->info['currency'],
                          'currency_value' => $order->info['currency_value']);
  if ($full_ipn) {
     $sql_data_array['paypal_ipn_id'] = $ipn->get_paypal_ipn_id();
  }

  zen_db_perform(TABLE_ORDERS, $sql_data_array);

  $insert_id = $db->Insert_ID();
  if (MODULE_PAYMENT_CC_COLLECT_CVV == 'True')  {
    $db->execute("update "  . TABLE_ORDERS . " set cc_cvv ='" . $order->info['cc_cvv'] . "' where orders_id = '" . $insert_id ."'");
  }
  for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
    $sql_data_array = array('orders_id' => $insert_id,
                            'title' => $order_totals[$i]['title'],
                            'text' => $order_totals[$i]['text'],
                            'value' => $order_totals[$i]['value'],
                            'class' => $order_totals[$i]['code'],
                            'sort_order' => $order_totals[$i]['sort_order']);

    zen_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
  }

  $customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
  $sql_data_array = array('orders_id' => $insert_id,
                          'orders_status_id' => $order->info['order_status'],
                          'date_added' => 'now()',
                          'customer_notified' => $customer_notification,
                          'comments' => $order->info['comments']);

  zen_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);

// initialized for the email confirmation
  $products_ordered = '';
  $subtotal = 0;
  $total_tax = 0;

// lowstock email report
  $email_low_stock='';

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
// Stock Update - Joao Correia
    if (STOCK_LIMITED == 'true') {
      if (DOWNLOAD_ENABLED == 'true') {
        $stock_query_raw = "SELECT products_quantity, pad.products_attributes_filename
                            FROM " . TABLE_PRODUCTS . " p
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                             ON p.products_id=pa.products_id
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                             ON pa.products_attributes_id=pad.products_attributes_id
                            WHERE p.products_id = '" . zen_get_prid($order->products[$i]['id']) . "'";

// Will work with only one option for downloadable products
// otherwise, we have to build the query dynamically with a loop
        $products_attributes = $order->products[$i]['attributes'];
        if (is_array($products_attributes)) {
          $stock_query_raw .= " AND pa.options_id = '" . $products_attributes[0]['option_id'] . "' AND pa.options_values_id = '" . $products_attributes[0]['value_id'] . "'";
        }
        $stock_values = $db->Execute($stock_query_raw);
      } else {
        $stock_values = $db->Execute("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . zen_get_prid($order->products[$i]['id']) . "'");
      }

      if ($stock_values->RecordCount() > 0) {
// do not decrement quantities if products_attributes_filename exists
        if ((DOWNLOAD_ENABLED != 'true') || (!$stock_values->fields['products_attributes_filename'])) {
          $stock_left = $stock_values->fields['products_quantity'] - $order->products[$i]['qty'];
        } else {
          $stock_left = $stock_values->fields['products_quantity'];
        }
        $db->Execute("update " . TABLE_PRODUCTS . " set products_quantity = '" . $stock_left . "' where products_id = '" . zen_get_prid($order->products[$i]['id']) . "'");
        if ( ($stock_left < 1) && (STOCK_ALLOW_CHECKOUT == 'false') ) {
// only set status to off when not displaying sold out
          if (SHOW_PRODUCTS_SOLD_OUT == '0') {
            $db->Execute("update " . TABLE_PRODUCTS . " set products_status = '0' where products_id = '" . zen_get_prid($order->products[$i]['id']) . "'");
          }
        }

// for low stock email
        if ( $stock_left <= STOCK_REORDER_LEVEL ) {
          // WebMakers.com Added: add to low stock email
          $email_low_stock .=  'ID# ' . zen_get_prid($order->products[$i]['id']) . "\t\t" . $order->products[$i]['model'] . "\t\t" . $order->products[$i]['name'] . "\t\t" . ' Qty Left: ' . $stock_left . "\n";
        }
      }
    }

// Update products_ordered (for bestsellers list)
    $db->Execute("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $order->products[$i]['qty']) . " where products_id = '" . zen_get_prid($order->products[$i]['id']) . "'");

    $sql_data_array = array('orders_id' => $insert_id,
                            'products_id' => zen_get_prid($order->products[$i]['id']),
                            'products_model' => $order->products[$i]['model'],
                            'products_name' => $order->products[$i]['name'],
                            'products_price' => $order->products[$i]['price'],
                            'final_price' => $order->products[$i]['final_price'],
                            'onetime_charges' => $order->products[$i]['onetime_charges'],
                            'products_tax' => $order->products[$i]['tax'],
                            'products_quantity' => $order->products[$i]['qty'],
                            'products_priced_by_attribute' => $order->products[$i]['products_priced_by_attribute'],
                            'product_is_free' => $order->products[$i]['product_is_free'],
                            'products_discount_type' => $order->products[$i]['products_discount_type'],
                            'products_discount_type_from' => $order->products[$i]['products_discount_type_from']);
    zen_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);

    $order_products_id = $db->Insert_ID();
    $order_total_modules->update_credit_account($i);//ICW ADDED FOR CREDIT CLASS SYSTEM

//------insert customer choosen option to order--------

    $attributes_exist = '0';
    $products_ordered_attributes = '';
    if (isset($order->products[$i]['attributes'])) {
      $attributes_exist = '1';
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        if (DOWNLOAD_ENABLED == 'true') {
          $attributes_query = "select popt.products_options_name, poval.products_options_values_name,
                               pa.options_values_price, pa.price_prefix,
                               pa.product_attribute_is_free, pa.products_attributes_weight, pa.products_attributes_weight_prefix,
                               pa.attributes_discounted, pa.attributes_price_base_included, pa.attributes_price_onetime,
                               pa.attributes_price_factor, pa.attributes_price_factor_offset,
                               pa.attributes_price_factor_onetime, pa.attributes_price_factor_onetime_offset,
                               pa.attributes_qty_prices, pa.attributes_qty_prices_onetime,
                               pa.attributes_price_words, pa.attributes_price_words_free,
                               pa.attributes_price_letters, pa.attributes_price_letters_free,
                               pad.products_attributes_maxdays, pad.products_attributes_maxcount, pad.products_attributes_filename,
                               pa.product_attribute_is_free, pa.attributes_discounted
                               from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                               left join " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                                on pa.products_attributes_id=pad.products_attributes_id
                               where pa.products_id = '" . zen_db_input($order->products[$i]['id']) . "'
                                and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "'
                                and pa.options_id = popt.products_options_id
                                and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "'
                                and pa.options_values_id = poval.products_options_values_id
                                and popt.language_id = '" . $_SESSION['languages_id'] . "'
                                and poval.language_id = '" . $_SESSION['languages_id'] . "'";
          $attributes_values = $db->Execute($attributes_query);
        } else {
          $attributes_values = $db->Execute("select popt.products_options_name, poval.products_options_values_name,
                               pa.options_values_price, pa.price_prefix,
                               pa.product_attribute_is_free, pa.products_attributes_weight, pa.products_attributes_weight_prefix,
                               pa.attributes_discounted, pa.attributes_price_base_included, pa.attributes_price_onetime,
                               pa.attributes_price_factor, pa.attributes_price_factor_offset,
                               pa.attributes_price_factor_onetime, pa.attributes_price_factor_onetime_offset,
                               pa.attributes_qty_prices, pa.attributes_qty_prices_onetime,
                               pa.attributes_price_words, pa.attributes_price_words_free,
                               pa.attributes_price_letters, pa.attributes_price_letters_free
                                from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                where pa.products_id = '" . $order->products[$i]['id'] . "' and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . $_SESSION['languages_id'] . "' and poval.language_id = '" . $_SESSION['languages_id'] . "'");
        }

//clr 030714 update insert query.  changing to use values form $order->products for products_options_values.
        $sql_data_array = array('orders_id' => $insert_id,
                                'orders_products_id' => $order_products_id,
                                'products_options' => $attributes_values->fields['products_options_name'],

//                                'products_options_values' => $attributes_values->fields['products_options_values_name'],
                                'products_options_values' => zen_output_string_protected($order->products[$i]['attributes'][$j]['value']),
                                'options_values_price' => $attributes_values->fields['options_values_price'],
                                'price_prefix' => $attributes_values->fields['price_prefix'],
                                'product_attribute_is_free' => $attributes_values->fields['product_attribute_is_free'],
                                'products_attributes_weight' => $attributes_values->fields['products_attributes_weight'],
                                'products_attributes_weight_prefix' => $attributes_values->fields['products_attributes_weight_prefix'],
                                'attributes_discounted' => $attributes_values->fields['attributes_discounted'],
                                'attributes_price_base_included' => $attributes_values->fields['attributes_price_base_included'],
                                'attributes_price_onetime' => $attributes_values->fields['attributes_price_onetime'],
                                'attributes_price_factor' => $attributes_values->fields['attributes_price_factor'],
                                'attributes_price_factor_offset' => $attributes_values->fields['attributes_price_factor_offset'],
                                'attributes_price_factor_onetime' => $attributes_values->fields['attributes_price_factor_onetime'],
                                'attributes_price_factor_onetime_offset' => $attributes_values->fields['attributes_price_factor_onetime_offset'],
                                'attributes_qty_prices' => $attributes_values->fields['attributes_qty_prices'],
                                'attributes_qty_prices_onetime' => $attributes_values->fields['attributes_qty_prices_onetime'],
                                'attributes_price_words' => $attributes_values->fields['attributes_price_words'],
                                'attributes_price_words_free' => $attributes_values->fields['attributes_price_words_free'],
                                'attributes_price_letters' => $attributes_values->fields['attributes_price_letters'],
                                'attributes_price_letters_free' => $attributes_values->fields['attributes_price_letters_free']
                                );


        zen_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);

        if ((DOWNLOAD_ENABLED == 'true') && isset($attributes_values->fields['products_attributes_filename']) && zen_not_null($attributes_values->fields['products_attributes_filename'])) {
          $sql_data_array = array('orders_id' => $insert_id,
                                  'orders_products_id' => $order_products_id,
                                  'orders_products_filename' => $attributes_values->fields['products_attributes_filename'],
                                  'download_maxdays' => $attributes_values->fields['products_attributes_maxdays'],
                                  'download_count' => $attributes_values->fields['products_attributes_maxcount']);

          zen_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
        }
//clr 030714 changing to use values from $orders->products and adding call to zen_decode_specialchars()
//        $products_ordered_attributes .= "\n\t" . $attributes_values->fields['products_options_name'] . ' ' . $attributes_values->fields['products_options_values_name'];
        $products_ordered_attributes .= "\n\t" . $attributes_values->fields['products_options_name'] . ' ' . zen_decode_specialchars(zen_output_string_protected($order->products[$i]['attributes'][$j]['value']));
      }
    }
//------insert customer choosen option eof ----
    $total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
    $total_tax += zen_calculate_tax($total_products_price, $products_tax) * $order->products[$i]['qty'];
    $total_cost += $total_products_price;

// include onetime charges
    $products_ordered .=  $order->products[$i]['qty'] . ' x ' . $order->products[$i]['name'] . ' (' . $order->products[$i]['model'] . ') = ' .
                          $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) .
                          ($order->products[$i]['onetime_charges'] !=0 ? "\n" . TEXT_ONETIME_CHARGES_EMAIL . $currencies->display_price($order->products[$i]['onetime_charges'], $order->products[$i]['tax'], 1) : '') .
                          $products_ordered_attributes . "\n";
    $products_ordered_html .=
	'<tr>' .
	'<td class="product-details" align="right" valign="top" width="30">' . $order->products[$i]['qty'] . '&nbsp;x</td>' .
	'<td class="product-details" valign="top">' . $order->products[$i]['name'] . ' (' . $order->products[$i]['model'] . ')' .
	'<nobr><small><em> '. $products_ordered_attributes .'</em></small></nobr></td>' .
	'<td class="product-details-num" valign="top" align="right">' .
	    $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) .
	    ($order->products[$i]['onetime_charges'] !=0 ?
                 '</td></tr><tr><td class="product-details">' . TEXT_ONETIME_CHARGES_EMAIL . '</td>' .
                 '<td>' . $currencies->display_price($order->products[$i]['onetime_charges'], $order->products[$i]['tax'], 1) : '') .
	'</td></tr>';
  }
  $order_total_modules->apply_credit();//ICW ADDED FOR CREDIT CLASS SYSTEM

if ($email_low_stock != '' and SEND_LOWSTOCK_EMAIL=='1') {
  // send an email
    $email_low_stock = SEND_EXTRA_LOW_STOCK_EMAIL_TITLE . "\n\n" . $email_low_stock;
    zen_mail('', SEND_EXTRA_LOW_STOCK_EMAILS_TO, EMAIL_TEXT_SUBJECT_LOWSTOCK, $email_low_stock, STORE_OWNER, EMAIL_FROM, array('EMAIL_MESSAGE_HTML' => nl2br($email_low_stock)),'low_stock');
}

// lets start with the email confirmation
// make an array to store the html version
  $html_msg=array();

//intro area
  $email_order = EMAIL_TEXT_HEADER . EMAIL_TEXT_FROM . STORE_NAME . "\n\n" .
//                 $order->customer['firstname'] . ' ' . $order->customer['lastname'] . "\n\n" .
                 $order->customer['lastname'] . ' ' . $order->customer['firstname'] . EMAIL_GREET  . "\n\n" .
                 EMAIL_THANKS_FOR_SHOPPING . "\n" . EMAIL_DETAILS_FOLLOW . "\n" .
                 EMAIL_SEPARATOR . "\n" .
                 EMAIL_TEXT_ORDER_NUMBER . ' ' . $insert_id . "\n" .
                 EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n" .
                 EMAIL_TEXT_INVOICE_URL . ' ' . zen_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $insert_id, 'SSL', false) . "\n\n";
  $html_msg['EMAIL_TEXT_HEADER']     = EMAIL_TEXT_HEADER;
  $html_msg['EMAIL_TEXT_FROM']       = EMAIL_TEXT_FROM;
  $html_msg['INTRO_STORE_NAME']      = STORE_NAME;
  $html_msg['EMAIL_THANKS_FOR_SHOPPING'] = EMAIL_THANKS_FOR_SHOPPING;
  $html_msg['EMAIL_DETAILS_FOLLOW']  = EMAIL_DETAILS_FOLLOW;
  $html_msg['INTRO_ORDER_NUM_TITLE'] = EMAIL_TEXT_ORDER_NUMBER;
  $html_msg['INTRO_ORDER_NUMBER']    = $insert_id;
  $html_msg['INTRO_DATE_TITLE']      = EMAIL_TEXT_DATE_ORDERED;
  $html_msg['INTRO_DATE_ORDERED']    = strftime(DATE_FORMAT_LONG);
  $html_msg['INTRO_URL_TEXT']        = EMAIL_TEXT_INVOICE_URL_CLICK;
  $html_msg['INTRO_URL_VALUE']       = zen_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $insert_id, 'SSL', false);

//comments area
  if ($order->info['comments']) {
    $email_order .= zen_db_output($order->info['comments']) . "\n\n";
    $html_msg['ORDER_COMMENTS'] = zen_db_output($order->info['comments']);
  } else {
    $html_msg['ORDER_COMMENTS'] = '';
  }

//products area
  $email_order .= EMAIL_TEXT_PRODUCTS . "\n" .
                  EMAIL_SEPARATOR . "\n" .
                  $products_ordered .
                  EMAIL_SEPARATOR . "\n";
  $html_msg['PRODUCTS_TITLE'] = EMAIL_TEXT_PRODUCTS;
  $html_msg['PRODUCTS_DETAIL']='<table class="product-details" border="0" width="100%" cellspacing="0" cellpadding="2">' . $products_ordered_html . '</table>';

//order totals area
  $html_ot .= '<td class="order-totals-text" align="right" width="100%">' . '&nbsp;' . '</td><td class="order-totals-num" align="right" nowrap="nowrap">' . '---------' .'</td></tr><tr>';
  for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
    $email_order .= strip_tags($order_totals[$i]['title']) . ' ' . strip_tags($order_totals[$i]['text']) . "\n";
	$html_ot .= '<td class="order-totals" align="right" width="100%">' . $order_totals[$i]['title'] . '</td><td class="order-totals" align="right" nowrap="nowrap">' .($order_totals[$i]['text']) .'</td></tr><tr>';
  }
	$html_msg['ORDER_TOTALS'] = '<table border="0" width="100%" cellspacing="0" cellpadding="2">' . $html_ot . '</table>';

//addresses area: Delivery
	$html_msg['HEADING_ADDRESS_INFORMATION']= HEADING_ADDRESS_INFORMATION;
	$html_msg['ADDRESS_DELIVERY_TITLE']     = EMAIL_TEXT_DELIVERY_ADDRESS;
	$html_msg['ADDRESS_DELIVERY_DETAIL']    = ($order->content_type != 'virtual') ? zen_address_label($_SESSION['customer_id'], $_SESSION['sendto'], true, '', "<br />") : 'n/a';
	$html_msg['SHIPPING_METHOD_TITLE']      = HEADING_SHIPPING_METHOD;
	$html_msg['SHIPPING_METHOD_DETAIL']     = (zen_not_null($order->info['shipping_method'])) ? $order->info['shipping_method'] : 'n/a';

  if ($order->content_type != 'virtual') {
    $email_order .= "\n" . EMAIL_TEXT_DELIVERY_ADDRESS . "\n" .
                    EMAIL_SEPARATOR . "\n" .
                    zen_address_label($_SESSION['customer_id'], $_SESSION['sendto'], 0, '', "\n") . "\n";
  }

//addresses area: Billing
  $email_order .= "\n" . EMAIL_TEXT_BILLING_ADDRESS . "\n" .
                  EMAIL_SEPARATOR . "\n" .
                  zen_address_label($_SESSION['customer_id'], $_SESSION['billto'], 0, '', "\n") . "\n\n";
	$html_msg['ADDRESS_BILLING_TITLE']   = EMAIL_TEXT_BILLING_ADDRESS;
	$html_msg['ADDRESS_BILLING_DETAIL']  = zen_address_label($_SESSION['customer_id'], $_SESSION['billto'], true, '', "<br />");

//payment area
  if (is_object($$_SESSION['payment'])) {
    $email_order .= EMAIL_TEXT_PAYMENT_METHOD . "\n" .
                    EMAIL_SEPARATOR . "\n";
    $payment_class = $$_SESSION['payment'];
    $email_order .= $payment_class->title . "\n\n";
    if ($payment_class->email_footer) {
      $email_order .= $payment_class->email_footer . "\n\n";
    }
  }
	$html_msg['PAYMENT_METHOD_TITLE']  = (is_object($$_SESSION['payment'])) ? EMAIL_TEXT_PAYMENT_METHOD : '' ;
	$html_msg['PAYMENT_METHOD_DETAIL'] = (is_object($$_SESSION['payment'])) ? $payment_class->title : '' ;
	$html_msg['PAYMENT_METHOD_FOOTER'] = (is_object($$_SESSION['payment'])) ? $payment_class->email_footer : '';

// include disclaimer
  $email_order .= "\n-----\n" . sprintf(EMAIL_DISCLAIMER, STORE_OWNER_EMAIL_ADDRESS) . "\n\n";

  while (strstr($email_order, '&nbsp;')) $email_order = str_replace('&nbsp;', ' ', $email_order);

  $html_msg['EMAIL_FIRST_NAME'] = $order->customer['firstname'];
  $html_msg['EMAIL_LAST_NAME'] = $order->customer['lastname'];
  $html_msg['EMAIL_GREET'] = EMAIL_GREET;
//  $html_msg['EMAIL_TEXT_HEADER'] = EMAIL_TEXT_HEADER;
  $html_msg['EXTRA_INFO'] = '';
// for japanese   zen_mail($order->customer['firstname'] . ' ' . $order->customer['lastname'], $order->customer['email_address'], EMAIL_TEXT_SUBJECT . EMAIL_ORDER_NUMBER_SUBJECT . $insert_id, $email_order, STORE_NAME, EMAIL_FROM, $html_msg, 'checkout');
  zen_mail($order->customer['lastname'] . ' ' . $order->customer['firstname'], $order->customer['email_address'], EMAIL_TEXT_SUBJECT . EMAIL_ORDER_NUMBER_SUBJECT . $insert_id, $email_order, STORE_NAME, EMAIL_FROM, $html_msg, 'checkout');

// send additional emails
  if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
	$extra_info=email_collect_extra_info('','', $order->customer['lastname'] . ' ' . $order->customer['firstname'] , $order->customer['email_address']);
    $html_msg['EXTRA_INFO'] = $extra_info['HTML'];
    zen_mail('', SEND_EXTRA_ORDER_EMAILS_TO, SEND_EXTRA_NEW_ORDERS_EMAILS_TO_SUBJECT . ' ' . EMAIL_TEXT_SUBJECT . EMAIL_ORDER_NUMBER_SUBJECT . $insert_id,
      $email_order . $extra_info['TEXT'], STORE_NAME, EMAIL_FROM, $html_msg, 'checkout_extra');
  }
?>
