import java.awt.geom.*;

import java.util.*;


/*
 * 作成日: 2004/01/10
 */

/**
 * 属性を基準にしてポリゴンを結合するクラスです。
 * @author Kumano Tatsuo
 */
class JoinTatemono {
    private boolean isChanged;

    /** 属性を基準にしてポリゴンを見かけ上結合します。
     * このメソッドを呼び出した直後に isChanged() を呼び出すと、
     * このメソッドによって地図の状態が変化したかどうかが取得できます。
     * @param maps 地図
     * @throws Exception 例外
     */
    void joinTatemono(Map maps) throws Exception {
        isChanged = false;

        Map attributePolygonMap = new HashMap(); // String -> Collection<Polygon> の Map

        // 属性をキー、ポリゴンの集合を値とする Map を初期化する
        for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
            MapData mapData = (MapData) iter.next();

            if (mapData.hasTatemono()) {
                for (Iterator iter2 = mapData.getTatemono().values().iterator();
                        iter2.hasNext();) {
                    PolygonData polygon = (PolygonData) iter2.next();

                    if (polygon.getAttribute() != null) {
                        if (polygon.getAttribute().length() > 0) {
                            if (!attributePolygonMap.containsKey(
                                        polygon.getAttribute())) {
                                attributePolygonMap.put(polygon.getAttribute(),
                                    new ArrayList());
                            }

                            ((Collection) attributePolygonMap.get(polygon
                                .getAttribute())).add(polygon);
                        }
                    }
                }
            }
        }

        for (Iterator iter = attributePolygonMap.values().iterator();
                iter.hasNext();) {
            Collection polygons = (Collection) iter.next();

            if (polygons.size() > 1) {
                Rectangle2D rect = null;

                for (Iterator iter2 = polygons.iterator(); iter2.hasNext();) {
                    PolygonData polygon = ((PolygonData) iter2.next());

                    if (rect == null) {
                        rect = polygon.getArea().getBounds();
                    } else {
                        rect.add(polygon.getArea().getBounds());
                    }
                }

                for (Iterator iter2 = polygons.iterator(); iter2.hasNext();) {
                    PolygonData polygon = ((PolygonData) iter2.next());
                    polygon.setX(rect.getCenterX());
                    polygon.setY(rect.getCenterY());
                }
            }
        }
    }

    /**
     * 直前の結合で、地図の状態が変化したかどうかを取得します。
     * @return 地図の状態が変化したかどうか
     */
    boolean isChanged() {
        return isChanged;
    }
}
