package map;

import java.awt.Color;
import java.awt.Font;

/**
 * デフォルトの地図の設定を扱うクラスです。
 * @author Kumano Tatsuo
 * 作成日：2004年1月7日
 */
class DefaultMapPreferences implements MapPreferences {
	/**
	 * 市区町村界の設定
	 */
	private Preferences cityPreferences = new Preferences(null, Color.BLACK, 0.1, Color.BLACK,
			new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 20));

	/**
	 * 都道府県界の設定
	 */
	private Preferences prefecturePreferences = new Preferences(null, Color.BLACK, 0.5,
			Color.BLACK, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 30));

	/**
	 * 文字の大きさを変更します。
	 * @param zoom 文字の大きさ
	 */
	public void setFontZoom(final double zoom) {
		this.normalRoadPreferences = new Preferences(Color.WHITE, Color.GRAY, 7, Color.BLUE,
				new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, (int) (15 * zoom)));
		this.railwayPreferences = new Preferences(Color.WHITE, Color.GRAY, 4, Color.BLUE, new Font(
				Const.FONT_FAMILY_GOTHIC, Font.PLAIN, (int) (16 * zoom)));
		this.mizuPreferences = new Preferences(new Color(200, 210, 250), new Color(200, 210, 250)
				.darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_MINCHO, Font.PLAIN,
				(int) (14 * zoom)));
		this.zyoutiPreferences = new Preferences(new Color(220, 220, 220), new Color(220, 220, 220)
				.darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN,
				(int) (15 * zoom)));
		this.parkPreferences = new Preferences(new Color(200, 250, 160), new Color(200, 250, 160)
				.darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN,
				(int) (15 * zoom)));
		this.tatemonoPreferences = new Preferences(new Color(180, 180, 180), new Color(180, 180,
				180).darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN,
				(int) (12 * zoom)));
		this.ekiPreferences = new Preferences(Color.RED, Color.BLACK, 8, Color.BLACK, new Font(
				Const.FONT_FAMILY_GOTHIC, Font.PLAIN, (int) (20 * zoom)));
		this.si_tyoPreferences = new Preferences(new Color(250, 250, 230), Color.BLACK, 4,
				new Color(0, 0, 160), new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN,
						(int) (40 * zoom)));
		this.cityPreferences = new Preferences(null, Color.BLACK, 0.1, Color.BLACK, new Font(
				Const.FONT_FAMILY_GOTHIC, Font.PLAIN, (int) (20 * zoom)));
		this.prefecturePreferences = new Preferences(null, Color.BLACK, 0.5, Color.BLACK, new Font(
				Const.FONT_FAMILY_GOTHIC, Font.PLAIN, (int) (30 * zoom)));
		this.isjPreferences = new Preferences(null, null, 0, new Color(180, 180, 180).darker(), new Font(
				Const.FONT_FAMILY_GOTHIC, Font.PLAIN, (int) (10 * zoom)));
	}

	/**
	 * 高速道路の設定
	 */
	private Preferences highwayPreferences = new Preferences(new Color(160, 220, 160), new Color(
			160, 220, 160).darker(), 17, null, null);

	/**
	 * 国道の設定
	 */
	private Preferences kokudoPreferences = new Preferences(new Color(250, 180, 180), new Color(
			250, 180, 180).darker(), 13, null, null);

	/**
	 * 県道の設定
	 */
	private Preferences kendoPreferences = new Preferences(new Color(255, 255, 180), new Color(255,
			255, 180).darker(), 7, null, null);

	/**
	 * 主要地方道の設定
	 */
	private Preferences chihodoPreferences = new Preferences(new Color(255, 255, 180), new Color(
			255, 255, 180).darker(), 13, null, null);

	/**
	 * 名前のある道路の設定
	 */
	private Preferences majorRoadPreferences = new Preferences(Color.WHITE, Color.GRAY, 13, null,
			null);

	/**
	 * 生活道路の設定
	 */
	private Preferences normalRoadPreferences = new Preferences(Color.WHITE, Color.GRAY, 7,
			Color.BLUE, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 15));

	/**
	 * JRの設定
	 */
	private Preferences jrPreferences = new Preferences(Color.WHITE, Color.GRAY, 6, null, null);

	/**
	 * JR新幹線の設定
	 */
	private Preferences jrShinkansenPreferences = new Preferences(Color.WHITE, Color.GRAY, 6, null,
			null);

	/**
	 * 私鉄の設定
	 */
	private Preferences railwayPreferences = new Preferences(Color.WHITE, Color.GRAY, 4,
			Color.BLUE, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 16));

	/**
	 * 内水面の設定
	 */
	private Preferences mizuPreferences = new Preferences(new Color(200, 210, 250), new Color(200,
			210, 250).darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_MINCHO, Font.PLAIN, 14));

	/**
	 * 城地の設定
	 */
	private Preferences zyoutiPreferences = new Preferences(new Color(220, 220, 220), new Color(
			220, 220, 220).darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN,
			15));

	/**
	 * 公園の設定
	 */
	private Preferences parkPreferences = new Preferences(new Color(200, 250, 160), new Color(200,
			250, 160).darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 15));

	/**
	 * 公共建物の設定
	 */
	private Preferences tatemonoPreferences = new Preferences(new Color(180, 180, 180), new Color(
			180, 180, 180).darker(), 1, Color.BLACK, new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN,
			12));

	/**
	 * 駅の設定
	 */
	private Preferences ekiPreferences = new Preferences(Color.RED, Color.BLACK, 8, Color.BLACK,
			new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 20));

	/**
	 * 丁目の設定
	 */
	private Preferences tyomePreferences = new Preferences(null, Color.BLACK, 1, new Color(0, 0,
			160), null);

	/**
	 * 市区町村の設定
	 */
	private Preferences si_tyoPreferences = new Preferences(new Color(250, 250, 230), Color.BLACK,
			4, new Color(0, 0, 160), new Font(Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 40));

	/**
	 * 街区レベル位置参照情報の設定
	 */
	private Preferences isjPreferences = new Preferences(null, null, 0, new Color(180, 180, 180).darker(), new Font(
			Const.FONT_FAMILY_GOTHIC, Font.PLAIN, 10));

	/**
	 * 丁目を塗り分ける色を取得します。
	 * @param index 何色目か
	 * @return 色
	 */
	public Color getTyomeFillColor(int index) {
		if (index == 0) {
			return Color.WHITE; // 白
		} else if (index == 1) {
			return new Color(250, 250, 230); // 黄色
		} else if (index == 2) {
			return new Color(230, 250, 250); // 水色
		} else if (index == 3) {
			return new Color(240, 250, 230); // 緑色
		} else if (index == 4) {
			return new Color(230, 230, 250); // 青色
		} else if (index == 5) {
			return new Color(250, 230, 255); // 赤紫色
		} else if (index == 6) {
			return new Color(250, 230, 230); // サーモンピンク色
		} else if (index == 7) {
			return new Color(255, (255 + 230) / 2, 230); // 橙色
		} else {
			return new Color(220, 240, 220); // 暗い緑色
		}
	}

	public Color getBackGroundColor() {
		return Color.WHITE;
	}

	public Color getMapBoundsColor() {
		return Color.BLACK;
	}

	public Preferences getChihodoPreferences() {
		return this.chihodoPreferences;
	}

	public Preferences getSi_tyoPreferences() {
		return this.si_tyoPreferences;
	}

	public Preferences getHighwayPreferences() {
		return this.highwayPreferences;
	}

	public Preferences getJRPreferences() {
		return this.jrPreferences;
	}

	public Preferences getJRShinkansenPreferences() {
		return this.jrShinkansenPreferences;
	}

	public Preferences getKendoPreferences() {
		return this.kendoPreferences;
	}

	public Preferences getKokudoPreferences() {
		return this.kokudoPreferences;
	}

	public Preferences getMajorRoadPreferences() {
		return this.majorRoadPreferences;
	}

	public Preferences getNormalRoadPreferences() {
		return this.normalRoadPreferences;
	}

	public Preferences getParkPreferences() {
		return this.parkPreferences;
	}

	public Preferences getRailwayPreferences() {
		return this.railwayPreferences;
	}

	public Preferences getTatemonoPreferences() {
		return this.tatemonoPreferences;
	}

	public Preferences getTyomePreferences() {
		return this.tyomePreferences;
	}

	public Preferences getMizuPreferences() {
		return this.mizuPreferences;
	}

	public Preferences getZyoutiPreferences() {
		return this.zyoutiPreferences;
	}

	public Preferences getEkiPreferences() {
		return this.ekiPreferences;
	}

	public Preferences getCityPreferences() {
		return this.cityPreferences;
	}

	public Preferences getPrefecturePreferences() {
		return this.prefecturePreferences;
	}

	public Preferences getIsjPreferences() {
		return this.isjPreferences;
	}
}
