// confset.c
// $Id: confset.c,v 1.3 2007/05/14 07:24:08 cvs Exp $
// masashi shimakura

#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<pthread.h>

#include"sitar.h"
#include"almemsys.h"

/* 
struct mail_data smtp;
struct set_conf conf;
extern struct file_path fi;
extern struct my_sock ip;
extern struct buff_set bf;
*/


extern global_data_t gd;
extern struct scan_buf sb;

/*
int conf_set(char *);
*/

int setup_check(void);
int path_check(char *);
int print_conf(void);
// int set_data(void);



/* ----------------- SET DATA ---------------- */
int set_data(void)
{

     gd.fi.bat_filename = safe_memcpy(gd.fi.bat_filename, "/tmp/sitar.bat", BUF_SLEN);
     gd.fi.bat_filename_2 = safe_memcpy(gd.fi.bat_filename_2, "/tmp/sitar.bat_2", BUF_SLEN);
     gd.fi.bat2_filename = safe_memcpy(gd.fi.bat2_filename, "/tmp/sitar.list", BUF_SLEN);
     gd.fi.bat2_filename_2 = safe_memcpy(gd.fi.bat2_filename_2, "/tmp/sitar.list_2", BUF_SLEN);
     gd.fi.command_path = safe_memcpy(gd.fi.command_path, "/usr/local/zither/sample_bin", BUF_SLEN);
     gd.fi.update_com = safe_memcpy(gd.fi.update_com, "/usr/local/zither/bin/get_sitar.sh", BUF_SLEN);
     gd.ip.ip_addr = safe_memcpy(gd.ip.ip_addr, "127.0.0.1", IP_LEN);
     gd.ip.ip2_addr = safe_memcpy(gd.ip.ip2_addr, "127.0.0.1", IP_LEN);
     gd.ip.port = 9999;
     gd.ip.port2 = 9999;
     gd.bf.c_info = safe_memcpy(gd.bf.c_info, "noname.localhost(127.0.0.1)", BUF_LEN);
     gd.bf.life_int = 10;
     gd.bf.life_los = 5;
     gd.bf.bat_int = 60;
     gd.bf.bat2_int = 60;
     gd.ld.onoff = 1;
     gd.bf.c_info = safe_memcpy(gd.bf.c_info, "noname", BUF_LEN);
     gd.smtp.ch_MailCc = safe_memcpy(gd.smtp.ch_MailCc, "NOT", BUF_LEN);
     gd.td.tcount = B_LEN;    // thread count max
     gd.td.tbufmax = B_MAX;   // thread buf count max

return 0;
}















/* ----------------- SETUP CHECK ---------------- */
int setup_check(void)
{

/*
  if(0 == strlen(gd.fi.bat_filename)){
     gd.fi.bat_filename = safe_memcpy(gd.fi.bat_filename, "/tmp/sitar.bat", BUF_SLEN);
     gd.fi.bat_filename_2 = safe_memcpy(gd.fi.bat_filename_2, "/tmp/sitar.bat_2", BUF_SLEN);
     }
  if(0 == strlen(gd.fi.bat2_filename)){
     gd.fi.bat2_filename = safe_memcpy(gd.fi.bat2_filename, "/tmp/sitar.list", BUF_SLEN);
     gd.fi.bat2_filename_2 = safe_memcpy(gd.fi.bat2_filename_2, "/tmp/sitar.list_2", BUF_SLEN);
     }
  if(0 == strlen(gd.fi.command_path)){
     gd.fi.command_path = safe_memcpy(gd.fi.command_path, "/usr/local/zither/sample_bin", BUF_SLEN);
     }
  if(0 == strlen(gd.fi.update_com)){
     gd.fi.update_com = safe_memcpy(gd.fi.update_com, "/usr/local/zither/bin/get_sitar.sh", BUF_SLEN);
     }
  if(0 == strlen(gd.ip.ip_addr)){
     gd.ip.ip_addr = safe_memcpy(gd.ip.ip_addr, "127.0.0.1", IP_LEN);
     }
  if(0 == strlen(gd.ip.ip2_addr)){
     gd.ip.ip2_addr = safe_memcpy(gd.ip.ip2_addr, "127.0.0.1", IP_LEN);
     }
  if(0 >= gd.ip.port){
     gd.ip.port = 9999;
     }
  if(0 >= gd.ip.port2){
     gd.ip.port2 = 9999;
     }
  if(0 == strlen(gd.bf.c_info)){
     gd.bf.c_info = safe_memcpy(gd.bf.c_info, "noname.localhost(127.0.0.1)", BUF_LEN);
     }
  if(0 >= gd.bf.life_int){
     gd.bf.life_int = 10;
     }
  if(0 >= gd.bf.life_los){
     gd.bf.life_los = 5;
     }
  if(0 >= gd.bf.bat_int){
     gd.bf.bat_int = 60;
     }
  if(0 >= gd.bf.bat2_int){
     gd.bf.bat2_int = 60;
     }
  if(0 == strlen(gd.bf.c_name)){
     gd.bf.c_info = safe_memcpy(gd.bf.c_info, "noname", BUF_LEN);
     }
  if(0 == strlen(gd.smtp.ch_MailCc)){
     gd.smtp.ch_MailCc = safe_memcpy(gd.smtp.ch_MailCc, "NOT", BUF_LEN);
//   gd.smtp.ch_MailCc[0] = (char)0x00;
     }
  if(0 >= gd.td.tcount){
     gd.td.tcount = B_LEN;
     }
  if(0 >= gd.td.tbufmax){
     gd.td.tbufmax = B_MAX;
     }
*/


   if(gd.bf.life_int < 10){
      gd.bf.life_int = 10;
      }
   if(gd.bf.life_int > 60){
      gd.bf.life_int = 60;
      }
   if(gd.bf.life_los < 1){
      gd.bf.life_los = 1;
      }
   if(gd.bf.life_los > 9){
      gd.bf.life_los = 9;
      }

#ifdef PRINT_CONF
print_conf();
#endif
return 0;
}



/* ----------- PRINT CONF ------------- */

int print_conf(void)
{
   fprintf(stdout,"-- SITAR CLIENT Configration setup list --\n");
   fprintf(stdout,"-- *Config File                           = %s\n", gd.fi.conf_path);
   fprintf(stdout,"-- *BAT Filename  (No used)               = %s\n", gd.fi.bat_filename);
   fprintf(stdout,"-- *BAT2 Filename (monitor list tmp file) = %s\n", gd.fi.bat2_filename);
   fprintf(stdout,"-- SOCK_IPADDR    (server ip1)            = %s\n",gd.ip.ip_addr);
   fprintf(stdout,"-- SOCK2_IPADDR   (server ip2)            = %s\n",gd.ip.ip2_addr);
   fprintf(stdout,"-- SOCK_PORT      (server port1)          = %d\n",gd.ip.port);
   fprintf(stdout,"-- SOCK2_PORT     (server port2)          = %d\n",gd.ip.port2);
   fprintf(stdout,"-- LIFE_ONOFF     (life on off)           = %d\n",gd.ld.onoff);
   fprintf(stdout,"-- LIFE_INT       (life interval sec)     = %d\n",gd.bf.life_int);
   fprintf(stdout,"-- LIFE_LOS       (life loss time sec)    = %d\n",gd.bf.life_los);
   fprintf(stdout,"-- C_NAME         (client name)           = %s\n",gd.bf.c_name);
   fprintf(stdout,"-- C_INFO         (client info)           = %s\n",gd.bf.c_info);
   fprintf(stdout,"-- MAIL_CC        (mail cc:)              = %s\n",gd.smtp.ch_MailCc);
   fprintf(stdout,"-- BAT_INT        (No used)               = %d\n", gd.bf.bat_int);
   fprintf(stdout,"-- BAT2_INT       (monitor interval)      = %d\n", gd.bf.bat2_int);
   fprintf(stdout,"-- COMMAND_PATH   (command path)          = %s\n", gd.fi.command_path);
   fprintf(stdout,"-- UPDATE_COM     (update command)        = %s\n", gd.fi.update_com);
   fprintf(stdout,"-- THREAD_MAX     (thread count max)      = %d\n", gd.td.tcount);
   fprintf(stdout,"-- TBUF_MAX       (thread buff count max) = %d\n", gd.td.tbufmax);
   fprintf(stdout,"Version %s\n", CL_VAR);

return 0;
}




/* ------------------ CONF SETC ----------------- */
int conf_set( char *conf_filename )
{
FILE * fp;
int inA=1;
int stat = 0;
char * tmp;

gd.sc.chA = (char *)calloc(IP_LEN, sizeof(char));
gd.sc.chB = (char *)calloc(IP_LEN, sizeof(char));
gd.sc.chC = (char *)calloc(IP_LEN, sizeof(char));

if((fp = fopen(conf_filename, "r"))!=NULL){
   while( 1 ){
      gd.sc.chA = safe_fpcat(fp, gd.sc.chA, &stat, BUF_LEN);
      if(stat == -1){
         fprintf(stderr,"conf_set(): Terminal of CONFIG FILE.\n");
         break;
         }
      else {
         if( NULL != strchr(gd.sc.chA,':') && 3 <= mem_count(gd.sc.chA,':') 
             && 5 <= strlen(gd.sc.chA) && gd.sc.chA[0] != '#'){ 
            gd.sc.chB = safe_memcpy(gd.sc.chB, strtok_r(gd.sc.chA, ":", &tmp), BUF_MAX);
            gd.sc.chC = safe_memcpy(gd.sc.chC, strtok_r(NULL, ":", &tmp), BUF_MAX);
	    if(BUF_LEN > strlen(gd.sc.chC) && IP_LEN > strlen(gd.sc.chB)){
               rm_crlf(gd.sc.chC, strlen(gd.sc.chC));
               inA = path_check(gd.sc.chB);
               switch(inA){
                  case 1 : gd.ip.ip_addr = safe_memcpy(gd.ip.ip_addr, gd.sc.chC, IP_LEN);
                           break;
                  case 2 : gd.ip.port = strtol(gd.sc.chC, (char **)NULL, 10);
                           break;
                  case 3 : gd.bf.life_int= strtol(gd.sc.chC, (char **)NULL, 10);
                           break;
                  case 4 : gd.bf.life_los= strtol(gd.sc.chC, (char **)NULL, 10);
                           break;
                  case 5 : gd.bf.c_info = safe_memcpy(gd.bf.c_info, gd.sc.chC, BUF_LEN);
                           swap_mem(gd.bf.c_info, ',', '*', (int)strlen(gd.bf.c_info));
                           break;
                  case 6 : gd.smtp.ch_MailCc = safe_memcpy(gd.smtp.ch_MailCc, gd.sc.chC, IP_LEN);
                           break;
                  case 7 : gd.bf.c_name = safe_memcpy(gd.bf.c_name, gd.sc.chC, BUF_LEN);
                           swap_mem(gd.bf.c_name, ',', '*', (int)strlen(gd.bf.c_name));
                           break;
                  case 8 : gd.fi.bat_filename = safe_memcpy(gd.fi.bat_filename, gd.sc.chC, BUF_LEN);
                           gd.fi.bat_filename_2 = safe_sprintf(gd.fi.bat_filename_2,BUF_LEN, "%s_2", gd.fi.bat_filename);
                           break;
                  case 9 : gd.fi.bat2_filename = safe_memcpy(gd.fi.bat2_filename, gd.sc.chC, BUF_LEN);
                           gd.fi.bat2_filename_2 = safe_sprintf(gd.fi.bat2_filename_2,BUF_LEN, "%s_2", gd.fi.bat2_filename);
                           break;

                  case 10 : gd.bf.bat_int= strtol(gd.sc.chC, (char **)NULL, 10);
                           break;

                  case 11 : gd.bf.bat2_int= strtol(gd.sc.chC, (char **)NULL, 10);
                           break;
                  case 12 : gd.fi.command_path = safe_memcpy(gd.fi.command_path, gd.sc.chC, BUF_LEN);
                           break;
                  case 13 : gd.ip.ip2_addr = safe_memcpy(gd.ip.ip2_addr, gd.sc.chC, IP_LEN);
                           break;
                  case 14 : gd.ip.port2 = strtol(gd.sc.chC, (char **)NULL, 10);
                           break;
                  case 15 : gd.fi.update_com = safe_memcpy(gd.fi.update_com, gd.sc.chC, BUF_LEN);
                           break;
                  case 16 : gd.td.tcount= strtol(gd.sc.chC, (char **)NULL, 10); // THREAD_MAX
                           break;
                  case 17 : gd.td.tbufmax= strtol(gd.sc.chC, (char **)NULL, 10); // TBUF_MAX
                           break;
                  case 18 : gd.ld.onoff= strtol(gd.sc.chC, (char **)NULL, 10); // TBUF_MAX
                           break;

                  default : break;
                  }
	       }
            }
         }
      }
   fclose( fp );
   }
else {
   fprintf(stderr,"-- CONF FILE NOT OPEN %s\n",conf_filename);
   }
setup_check();

free(gd.sc.chA);
free(gd.sc.chB);
free(gd.sc.chC);

return 0;
}




/* ------------------ PATH CHECK ----------------- */
int path_check(char *chA)
{
int bu;
char ch[20][BUF_COM];
int count = 0;
char * non = "NOT";
char * sock_ipaddr="SOCK_IPADDR";
char * sock_port="SOCK_PORT";
char * life_int="LIFE_INT";
char * life_los="LIFE_LOS";
char * c_name="C_NAME";
char * c_info="C_INFO";
char * mail_cc="MAIL_CC";
char * bat_file="BAT_FILE";
char * bat2_file="BAT2_FILE";
char * bat_int="BAT_INT";
char * bat2_int="BAT2_INT";
char * command_path="COMMAND_PATH";
char * sock2_ipaddr="SOCK2_IPADDR";
char * sock2_port="SOCK2_PORT";
char * update_com="UPDATE_COM";
char * thread_max="THREAD_MAX";
char * tbuf_max="TBUF_MAX";
char * life_onoff="LIFE_ONOFF";

self_memcpy(ch[0], non, BUF_COM);
self_memcpy(ch[1], sock_ipaddr, BUF_COM);
self_memcpy(ch[2], sock_port, BUF_COM);
self_memcpy(ch[3], life_int, BUF_COM);
self_memcpy(ch[4], life_los, BUF_COM);
self_memcpy(ch[5], c_info, BUF_COM);
self_memcpy(ch[6], mail_cc, BUF_COM);
self_memcpy(ch[7], c_name, BUF_COM);
self_memcpy(ch[8], bat_file, BUF_COM);
self_memcpy(ch[9], bat2_file, BUF_COM);
self_memcpy(ch[10], bat_int, BUF_COM);
self_memcpy(ch[11], bat2_int, BUF_COM);
self_memcpy(ch[12], command_path, BUF_COM);
self_memcpy(ch[13], sock2_ipaddr, BUF_COM);
self_memcpy(ch[14], sock2_port, BUF_COM);
self_memcpy(ch[15], update_com, BUF_COM);
self_memcpy(ch[16], thread_max, BUF_COM);
self_memcpy(ch[17], tbuf_max, BUF_COM);
self_memcpy(ch[18], life_onoff, BUF_COM);

bu = 0;
if(BUF_COM > strlen(chA)){
   for(count=1; count < 19; count++){
      if(0 == memcmp(chA, ch[count], (int)strlen(ch[count])+1)){
         bu=count;
         }
      }
   }
else{
   fprintf(stderr,"big size mess err. %s\n", chA);
   }
return(bu);
}




