// mail.c
// $Id: mail.c,v 1.3 2007/05/14 07:24:58 cvs Exp $
// masashi shimakura

#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<pthread.h>

#include"zither.h"
#include"almemsys.h"


/*
int mail_grsend( char *, char *, char *, char *, char *, char *, char *, char *);
*/


int mail_grsend_t(mail_data_t *);
int mail_malloc(mail_data_t *);
int mail_free(mail_data_t *);
char * swap_rn(char *, char);
int send_rcptto(mail_data_t *, int);
int send_rcpttodata(mail_data_t *, char *);
int msocket_connect(struct sockaddr_in *, int, char [], int *);
int msocket_send(char *, int);
int ujtoj(unsigned char *, unsigned char *);
int base64(char *, int, char *);
int outchar(int *, char **, char);




/* MAIL DATA ALOC */
int mail_malloc(mail_data_t *mdd)
{
if((mdd->swap = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->swap2 = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->server = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->rcptto = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->cp_time = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}

if((mdd->iserver = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->ifrom = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->ircptto = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->icc = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((mdd->iuser = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
/* if((mdd->ihost = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);} */
/* if((mdd->idata = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);} */
if((mdd->isubject = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}

return 0;
}



/* MAIL DATA FREE */
int mail_free(mail_data_t *mdd)
{

free(mdd->swap);
free(mdd->swap2);
free(mdd->server);
free(mdd->rcptto);
free(mdd->cp_time);

free(mdd->iserver);
free(mdd->ifrom);
free(mdd->ircptto);
free(mdd->icc);
free(mdd->iuser);
free(mdd->ihost);
free(mdd->idata);
free(mdd->isubject);

return 0;
}





/* --- MAIL GRSEND (user, host,data,subject)--- */
int mail_grsend( char * iserver,
                 char * ifrom,
                 char * ircptto,
                 char * icc,
                 char * iuser,
                 char * ihost,
                 char * idata,
                 char * isubject )
{
char * head = "=?ISO-2022-JP?B?";
char * tail = "?=";
char * subject_swap;
char * subject_swap2;

pthread_t pt_t;

mail_data_t * mdd;
if((mdd = (mail_data_t *)malloc(sizeof(mail_data_t)))==NULL){exit(1);}
mail_malloc(mdd);

mdd->iserver  = safe_memcpy(mdd->iserver, iserver, BUF_MAX);
mdd->ifrom    = safe_memcpy(mdd->ifrom, ifrom, BUF_MAX);
mdd->ircptto  = safe_memcpy(mdd->ircptto, ircptto, BUF_MAX);
mdd->icc      = safe_memcpy(mdd->icc, icc, BUF_MAX);
mdd->iuser    = safe_memcpy(mdd->iuser, iuser, BUF_MAX);

/* --- base64 encode --- */
subject_swap = (char *)calloc(2 * strlen(isubject), sizeof(char));
ujtoj((unsigned char *)subject_swap, (unsigned char *)isubject);
subject_swap2 = (char *)calloc(2 * strlen(subject_swap), sizeof(char));
base64(subject_swap, (int)strlen(subject_swap), subject_swap2);
subject_swap = safe_sprintf(subject_swap, BUF_MAX, "%s%s%s", head, subject_swap2, tail);
mdd->isubject = safe_sprintf(mdd->isubject, BUF_MAX, "ZITHER <%s> %s", mdd->iuser, subject_swap);
free(subject_swap);
free(subject_swap2);
//mdd->isubject = safe_memcpy(mdd->isubject, isubject, BUF_MAX);

/* --- EUC-JP -> JIS --- */
mdd->ihost = (char *)calloc(2 * strlen(ihost), sizeof(char));
ujtoj((unsigned char *)mdd->ihost, (unsigned char *)ihost);
mdd->idata = (char *)calloc(2 * strlen(idata), sizeof(char));
ujtoj((unsigned char *)mdd->idata, (unsigned char *)idata);

pthread_create( &pt_t, NULL, (void *)mail_grsend_t, mdd);

return 0;
}






/* --- MAIL GRSEND THREAD (user, host,data,subject)--- */
int mail_grsend_t(mail_data_t * mdd)
{
int stat;
int port;

char * charset = "X-Mailer: zither_server\r\n";
char * charenc = "X-Priority: 3\r\n";
char * charcontyp = "Content-Type: Text/Plain; charset=iso-2022-jp\r\n";
char * chartraenc = "Content-Transfer-Encoding: 7bit\r\n";

stat = 0;
port = 25;

pthread_detach(pthread_self());

mail_time_getr(mdd->cp_time, BUF_LEN, "+0900");

if((mdd->sk = msocket_connect(&mdd->my_maddr, port, mdd->iserver, &stat))< 0){
   fprintf(stderr,"mail_grsend_t():msocket_connect(): err\n");
   goto mailend;
   }
if(stat == -1){
   fprintf(stderr,"mail_grsend_t():msocket_connect(): stat err\n");
   goto mailend;
   }

mdd->swap = safe_fdcat(mdd->sk, mdd->swap, &stat, BUF_MAX, MAIL_INTERVAL);
#ifdef MAIL_DEBUG_IN
fprintf(stderr,"in0<%s>\n", mdd->swap);
#endif
if(stat < 0){
   fprintf(stderr,"mail_grsend_t():safe_fdcat(): err\n");
   goto mailend;
   }

mdd->swap = safe_memcpy(mdd->swap, "HELO localhost\r\n", BUF_MAX);
#ifdef MAIL_DEBUG_OUT
fprintf(stderr,"out1<%s>\n", mdd->swap);
#endif

if(1 > (msocket_send(mdd->swap, mdd->sk))){
   fprintf(stderr,"mail_grsend_t():msocket_send(): err\n");
   goto mailend;
   }
mdd->swap = safe_fdcat(mdd->sk, mdd->swap, &stat, BUF_MAX, MAIL_INTERVAL);
#ifdef MAIL_DEBUG_IN
fprintf(stderr,"in1<%s>\n", mdd->swap);
#endif
if(stat < 0){
   fprintf(stderr,"mail_grsend_t():safe_fdcat():2 err\n");
   goto mailend;
   }

mdd->swap = safe_sprintf(mdd->swap, BUF_MAX, "%s<%s>\r\n", "MAIL FROM: ", mdd->ifrom);
#ifdef MAIL_DEBUG_OUT
fprintf(stderr,"out2<%s>\n", mdd->swap);
#endif

if(1 > (msocket_send(mdd->swap, mdd->sk))){
   fprintf(stderr,"mail_grsend_t():msocket_send():2 err\n");
   goto mailend;
   }
mdd->swap = safe_fdcat(mdd->sk, mdd->swap, &stat, BUF_MAX, MAIL_INTERVAL);
#ifdef MAIL_DEBUG_IN
fprintf(stderr,"in2<%s>\n", mdd->swap);
#endif
if(stat < 0){
   fprintf(stderr,"mail_grsend_t():safe_fdcat():3 err\n");
   goto mailend;
   }

mdd->rcptto = safe_memcpy(mdd->rcptto, mdd->ircptto, BUF_MAX);
if(2 < (strlen(mdd->icc))){
   if(0 != memcmp(mdd->icc, "NOT", 3)){
      mdd->rcptto = safe_strncat(mdd->rcptto, ",", BUF_MAX);
      mdd->rcptto = safe_strncat(mdd->rcptto, mdd->icc, BUF_MAX);
      }
   }

if(0 > (send_rcptto(mdd, BUF_LEN))){
   fprintf(stderr,"mail_grsend_t():send_rcptto():stat err\n");
   goto mailend;
   }

mdd->swap = safe_memcpy(mdd->swap, "DATA\r\n", BUF_MAX);
#ifdef MAIL_DEBUG_OUT
fprintf(stderr,"out3<%s>\n", mdd->swap);
#endif

if(1 > (msocket_send(mdd->swap, mdd->sk))){
   fprintf(stderr,"mail_grsend_t():msocket_send():4 err\n");
   goto mailend;
   }

mdd->swap = safe_sprintf(mdd->swap, BUF_MAX,"%s%s%s%s",charset, charenc, charcontyp, chartraenc);

mdd->swap2 = safe_sprintf(mdd->swap2, BUF_MAX, "%s<%s>\r\n", "From: ", mdd->ifrom);
mdd->swap = safe_strncat(mdd->swap, mdd->swap2, BUF_MAX);

mdd->swap2 = safe_sprintf(mdd->swap2, BUF_MAX, "%s%s\r\n", "Date: ", mdd->cp_time);
mdd->swap = safe_strncat(mdd->swap, mdd->swap2, BUF_MAX);

mdd->swap2 = safe_sprintf(mdd->swap2, BUF_MAX, "%s%s\r\n", "To: ", mdd->ircptto);
mdd->swap = safe_strncat(mdd->swap, mdd->swap2, BUF_MAX);

if(2 < (strlen(mdd->icc))){
   if(0 != memcmp(mdd->icc, "NOT", 3)){
      mdd->swap2 = safe_sprintf(mdd->swap2, BUF_MAX, "Cc: %s\r\n", mdd->icc);
      mdd->swap = safe_strncat(mdd->swap, mdd->swap2, BUF_MAX);
      }
   }

mdd->swap2 = safe_sprintf(mdd->swap2, BUF_MAX, "%s %s\r\n\r\n%s\r\n\r\n%s\r\n", "Subject: ", mdd->isubject, mdd->ihost, mdd->idata);
mdd->swap2 = swap_rn(mdd->swap2, (char)0x01);
mdd->swap = safe_strncat(mdd->swap, mdd->swap2, BUF_MAX);
#ifdef MAIL_DEBUG_OUT
fprintf(stderr,"out4<%s>\n", mdd->swap);
#endif

if(1 > (msocket_send(mdd->swap, mdd->sk))){
   fprintf(stderr,"mail_sender():msocket_send():4 err\n");
   goto mailend;
   }
mdd->swap = safe_fdcat(mdd->sk, mdd->swap, &stat, BUF_MAX, MAIL_INTERVAL);
#ifdef MAIL_DEBUG_IN
fprintf(stderr,"in4<%s>\n", mdd->swap);
#endif
if(stat < 0){
   fprintf(stderr,"mail_sender():safe_fdcat():4 err\n");
   goto mailend;
   }

mdd->swap = safe_memcpy(mdd->swap, ".\r\n", BUF_MAX);
#ifdef MAIL_DEBUG_OUT
fprintf(stderr,"out5<%s>\n", mdd->swap);
#endif

if(1 > (msocket_send(mdd->swap, mdd->sk))){
   fprintf(stderr,"mail_sender():msocket_send():5 err\n");
   goto mailend;
   }
mdd->swap = safe_fdcat(mdd->sk, mdd->swap, &stat, BUF_MAX, MAIL_INTERVAL);
#ifdef MAIL_DEBUG_IN
fprintf(stderr,"in5<%s>\n", mdd->swap);
#endif
if(stat < 0){
   fprintf(stderr,"mail_sender():safe_fdcat():5 err\n");
   goto mailend;
   }

mdd->swap = safe_sprintf(mdd->swap, BUF_MAX, "QUIT\r\n\r\n");
#ifdef MAIL_DEBUG_OUT
fprintf(stderr,"out6<%s>\n", mdd->swap);
#endif

if(1 > (msocket_send(mdd->swap, mdd->sk))){
   fprintf(stderr,"mail_sender():msocket_send():6 err\n");
   goto mailend;
   }
mdd->swap = safe_fdcat(mdd->sk, mdd->swap, &stat, BUF_MAX, MAIL_INTERVAL);
#ifdef MAIL_DEBUG_IN
fprintf(stderr,"in6<%s>\n", mdd->swap);
#endif
if(stat < 0){
   fprintf(stderr,"mail_sender():safe_fdcat():7 err\n");
   goto mailend;
   }

mailend :;

close(mdd->sk);
mail_free(mdd);
free(mdd);

return 0;
}





/* ------------ SWAP FOR 0x01 -> \r\n ------------- */
char * swap_rn(char *data, char chS)
{
char * swap;
int max, count, count1, count2;
int nlen = 0;
count1 = 0;
max = strlen(data);

for(count2 = 0; count2 < max; count2++){
   if(data[count2] == chS){
      nlen++;
      }
   }

if((swap = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}

if(nlen > 0){
   if((swap = (char*)realloc(swap, sizeof(char) * (max + nlen + 1)))==NULL){
      fprintf(stderr,"swap_rn(): The memory cannot be newly secured. \n");
      exit(1);
      }

   for(count = 0; count < max; count++){
      if(data[count] == chS){
         swap[count1] = '\r';
         count1++;
         swap[count1] = '\n';
         count1++;
         }
      else {
         swap[count1] = data[count];
         count1++;
         }
      }
   swap[count1] = (char)0x00;
   clean_mem(data, '\0', (int)strlen(data));
   data = safe_memcpy(data, swap, BUF_MAX);

   }

free(swap);

return data;
}






int send_rcptto(mail_data_t * dt, int buf_len)
{
static int stat;
char * rcpadd;
int count, incount;
count = 0;
incount = 0;
stat = 0;

if((rcpadd = (char *)calloc(buf_len, sizeof(char)))==NULL){exit(1);}

incount = char_count(dt->rcptto, ','); 

for(count = 0; (count <= incount) && (count <= 20) && (stat != -1); count++){
   char_get(dt->rcptto, rcpadd, ',', count);
   stat = send_rcpttodata(dt, rcpadd);
   free(rcpadd);
   if((rcpadd = (char *)calloc(buf_len, sizeof(char)))==NULL){exit(1);}
   }

free(rcpadd);

return(stat);
}





int send_rcpttodata(mail_data_t * dt, char * rcpadd)
{
static int stat;
char * data = "RCPT TO: ";

stat = 0;

dt->swap2 = safe_sprintf(dt->swap2, BUF_MAX, "%s%s\r\n",data, rcpadd);

if(1 > (msocket_send(dt->swap2, dt->sk))){
   fprintf(stderr,"send_rcpttodata():msocket_send(): err\n");
   stat = -1;
   }
else{
   dt->swap2 = safe_fdcat(dt->sk, dt->swap2, &stat, BUF_MAX, MAIL_INTERVAL);
   }

return 0;
}
 



/*----------------------- CONNECT --------------------*/
int msocket_connect(struct sockaddr_in * my_maddr, int port, char ip_addr[], int * stat)
{
static int sk;

sk = 0;
if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"msocket_connect(): soket-err\n");
   }

my_maddr->sin_family = AF_INET;
my_maddr->sin_port = htons(port);
my_maddr->sin_addr.s_addr = inet_addr(ip_addr);

if(connect(sk, (struct sockaddr *) my_maddr, sizeof(* my_maddr)) == -1){
   fprintf(stderr,"msocket_send(): connect err\n");
   sleep(3);
   * stat = -1;
   close(sk);
   }

return(sk);
}



/*--------------------- SEND -------------------------*/
int msocket_send(char * buffs, int sk)
{
static int ret;
int len = strlen(buffs);

ret = 0;
if((ret = send(sk, buffs, len, 0)) == -1){
   fprintf(stderr,"msocket)send(): send err %s ---\n", buffs);
   }

#ifdef DEBUG
printf("msocket_send(): state %d\n", ret);
#endif

return(ret);
}







/* ujtoj komata mitsuyuki著　TCP_IP ネットワークプログラミング引用 */


#define iseuckanji(c) (0xa1<=(unsigned char)(c&0xff) && (unsigned char)(c&0xff)<=0xfe)
#define iseuckana(c) (0x8e==(unsigned char)(c&0xff))


/* ---- for test
int chcode(char * data)
{
int count, max;
count = 0;
max = strlen(data);
for(count = 0; count < max; count++){
   printf("0x0%x,", data[count]);
   }
return max;
}


int main(int argc, char ** argv)
{
char Out[1024];
char * out = Out;
char * in = "これこれしかじか";

ujtoj((unsigned char *)out, (unsigned char *)in);

printf("in data  <%s>\n", in);
chcode(in);
printf("out data <%s>\n", out);
chcode(out);

return 0;
}
*/


/* EUC -> JIS */
int ujtoj(unsigned char *to, unsigned char *from)
{
register int i, len, c;
int kanji_flag;

len = (int)strlen((char *)from);
c = 0;
kanji_flag = 0;

for(i = 0; i < len; i++){
   if(iseuckanji(from[i])){
      if(kanji_flag == 0){
         to[c] = 0x1b;
         c++;
         to[c] = 0x24;
         c++;
         to[c] = 0x42;
         c++;
         kanji_flag = 1;
         }
      to[c] = (from[i]&0x7f);
      c++; 
      to[c] = (from[i+1]&0x7f);
      c++;
      i++;
      }
   else{
      if(kanji_flag == 1){
         to[c] = 0x1b;
         c++; 
         to[c] = 0x28;
         c++; 
         to[c] = 0x4a;
         c++; 
         kanji_flag = 0;
         }
      to[c] = from[i];
      c++;
      }
   }

if(kanji_flag == 1){
   to[c] = 0x1b;
   c++; 
   to[c] = 0x28;
   c++; 
   to[c] = 0x4a;
   c++;
   kanji_flag = 0;
   }

to[c] = '\0';

return 0;
}





/* base64 encode */

int base64(char * data, int size, char * into)
{
char now[3];
char c;
int i, h, n;
char * ptr;
ptr = into;
n = 0;
for(i = 0; i < size; i += 3){
   if(i + 2 < size){
      now[0] = data[i];
      now[1] = data[i + 1];
      now[2] = data[i + 2];
      c=(now[0]>>2)&0x3f;
      outchar(&n, &ptr, c);
      c=((now[0]<<4)&0x30) + ((now[1]>>4)&0x0f);
      c&=0x3f;
      outchar(&n, &ptr, c);
      c=((now[1]<<2)&0x3c) + ((now[2]>>6)&0x03);
      c&=0x3f;
      outchar(&n, &ptr, c);
      c=now[2]&0x3f;
      c&=0x3f;
      outchar(&n, &ptr, c);
      }
   else if(i + 1 < size){
      now[0] = data[i];
      now[1] = data[i + 1];
      c=(now[0]>>2)&0x3f;
      outchar(&n, &ptr, c);
      c=((now[0]<<4)&0x30) + ((now[1]>>4)&0x0f);
      c&=0x3f;
      outchar(&n, &ptr, c);
      c=((now[1]<<2)&0x3c);
      c&=0x3f;
      outchar(&n, &ptr, c);
      }
   else{
      now[0] = data[i];
      c=(now[0]>>2)&0x3f;
      outchar(&n, &ptr, c);
      c=((now[0]<<4)&0x30);
      c&=0x3f;
      outchar(&n, &ptr, c);
      }
   }

h = 4 - (n%4);
if(h != 4){
   for(i = 0; i < h; i++){
      *ptr = '=';
      ptr++;
      }
   }

*ptr='\0';
return(0);
}





int outchar(int * n, char ** ptr, char c)
{

#ifdef BASE64_DEBUG
printf("%d ", c);
#endif

if(c <= 25){
   **ptr = c+'A';
   }
else if(c <= 51){
   **ptr = c-26+'a';
   }
else if(c <= 61){
   **ptr = c-52+'0';
   }

else if(c == 62){
   **ptr = '+';
   }

else if(c == 63){
   **ptr = '/';
   }
(*ptr)++;
(*n)++;

if((*n)%60 == 0){
   **ptr = '\n';
   (*ptr)++;
   }

#ifdef BASE64_DEBUG
printf("%d ", **ptr);
printf("%c\n", **ptr);
#endif
return 0;
}              















