// tcp.c
// $Id: tcp.c,v 1.3 2007/05/08 09:08:58 cvs Exp $
// masashi shimakura

#include<stdio.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>
#include <errno.h>

#include"zither.h"
#include"almemsys.h"

extern global_data_t gd;


/*
int socket_bind(struct sockaddr_in, int, char [], int *);
int socket_accept(struct sockaddr_in, int *, int *);
int socket_send(int, char *);
int socket_read(int sk, char *, int);
char * select_fdcat_2(int, char *, int, int *);
*/


/*------------------ BIND ----------------------*/
int socket_bind(struct sockaddr_in * my_addr, int port, char ip_addr[], int *ls)
{
if((*ls = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"socket_bind(1): Not cleate socket\n");
   exit(1);
   }

my_addr->sin_family = AF_INET;
my_addr->sin_port = htons(port);
/* my_addr->sin_addr.s_addr = inet_addr(ip_addr); */
if(0 == memcmp(ip_addr, "INADDR_ANY", 10)){
   my_addr->sin_addr.s_addr = INADDR_ANY;
   }
else{
   my_addr->sin_addr.s_addr = inet_addr(ip_addr);
   }

if(bind(*ls, (struct sockaddr *) my_addr, sizeof(* my_addr)) == -1){
   fprintf(stderr,"socket_bind(2): Not cleate bind\n");
   close(*ls);
   exit(1);
   }

if((listen(*ls,0))==-1){
   fprintf(stderr,"socket_bind(3): Not listen port\n");
   close(*ls);
   exit(1);
   }
return 0;
}




/*--------------------- ACCEPT -------------------*/
int socket_accept(struct sockaddr_in * my_addr, int *ls, int *sk)
{
static int ret;

unsigned int my_addrlen = sizeof(* my_addr);

ret = -1;
if((*sk = accept(*ls, (struct sockaddr *) my_addr, &my_addrlen)) == -1){
   fprintf(stderr,"socket_accept(): Not scception\n");
   close(*ls);
   ret = -1;
   return(ret);
   exit(1);
   }
else {
   ret = 0;
   return(ret);
   }
return(ret);
}






/*--------------------- SEND ------------------------- */
int socket_send(int sk, char * senddata, int interval){
int ret;

ret = 0;

ret = send(sk, senddata, (int)strlen(senddata), 0);

#ifdef SOCKET_SENDBUG
printf("SOCKET: socket_send(1): OK select <%d> <%d> ERRNO: %d %s\n",
  ret, interval, errno, strerror(errno));
#endif

return(ret);
}








/*--------------------- SEND ------------------------- */
int socket_send_client(int sk, char * senddata, int interval){
static int ret;
struct timeval tv;
int retval;
fd_set rfds;

fcntl(sk, F_SETFL, O_NONBLOCK);
tv.tv_sec = interval;
tv.tv_usec = 0;

#ifdef SOCKET_SENDBUG
printf("SOCKET: socket_send(1): interval time set %d \n", interval);
#endif


ret = 0;

ret = send(sk, senddata, (int)strlen(senddata), 0);
#ifdef SOCKET_SENDBUG
printf("SOCKET: socket_send(11): send data %d \n", ret);
#endif

while(1){
   FD_ZERO(&rfds);
   FD_SET(sk, &rfds);
   retval = select(sk + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      #ifdef SOCKET_SENDBUG
      printf("SOCKET: socket_send(2): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;      }
   if(retval == 0){
      #ifdef SOCKET_SENDBUG
      printf("SOCKET: socket_send(3): NG select <%d> ERRNO: %d %s ret=%d\n",
        retval, errno, strerror(errno), ret);
      #endif
      ret = -1;  // <--- server side default 0
      break;
      }
   if(retval >= 1){
      #ifdef SOCKET_SENDBUG
      printf("SOCKET: socket_send(4): NG select <%d> ERRNO: %d %s ret=%d\n",
        retval, errno, strerror(errno), ret);
      #endif
      break;
      }
   } /* while */

#ifdef SOCKET_SENDBUG
printf("SOCKET: socket_send(5) retval = %d: out of function \n", retval);
#endif

fcntl(sk, F_SETFL, 0);

return(ret);
}





char * select_fdcat_2(int sk, char * getdata, int interval, int * stat)
{
struct timeval tv;
int retval;
fd_set rfds;

fcntl(sk, F_SETFL, O_NONBLOCK);
tv.tv_sec = interval;
tv.tv_usec = 0;

* stat = 0;

while(1){
   FD_ZERO(&rfds);
   FD_SET(sk, &rfds);
   retval = select(sk + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      fcntl(sk, F_SETFL, 0);
      #ifdef SOCKET_BUG
      fprintf(stderr,"select_fdcat(1) retval=%d line=%d file=%s err=%s\n",
         retval, __LINE__, __FILE__, strerror(errno));
      #endif
      * stat = -1;
      break;
      }
   if(retval == 0){
      fcntl(sk, F_SETFL, 0);
      #ifdef SOCKET_BUG
      fprintf(stderr,"select_fdcat(2) retval=%d line=%d file=%s err=%s\n",
         retval, __LINE__, __FILE__, strerror(errno));
      #endif
      * stat = -1;
      break;
      }
   if(retval >= 1){
      fcntl(sk, F_SETFL, 0);
      getdata = safe_fdcat(sk, getdata, stat, BUF_MAX, interval);
      #ifdef SOCKET_BUG
      fprintf(stderr,"select_fdcat(3) retval=%d line=%d file=%s err=%s\n",
         retval, __LINE__, __FILE__, strerror(errno));
      #endif
      break;
      }
   } 

return getdata;
}






