/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVX_PARSECONTEXT_HXX
#define INCLUDED_SVX_PARSECONTEXT_HXX

#include <connectivity/IParseContext.hxx>
#include <rtl/ustring.hxx>
#include <svx/svxdllapi.h>
#include <unotools/localedatawrapper.hxx>
#include <vector>

namespace svxform
{

    //= OSystemParseContext

    class SVX_DLLPUBLIC OSystemParseContext : public ::connectivity::IParseContext
    {
    private:

        ::std::vector< OUString > m_aLocalizedKeywords;

    public:
        OSystemParseContext();

        virtual ~OSystemParseContext();
        // retrieves language specific error messages
        virtual OUString getErrorMessage(ErrorCode _eCodes) const SAL_OVERRIDE;

        // retrieves language specific keyword strings (only ASCII allowed)
        virtual OString getIntlKeywordAscii(InternationalKeyCode _eKey) const SAL_OVERRIDE;

        // finds out, if we have an international keyword (only ASCII allowed)
        virtual InternationalKeyCode getIntlKeyCode(const OString& rToken) const SAL_OVERRIDE;

        /** get's a locale instance which should be used when parsing in the context specified by this instance
            <p>if this is not overridden by derived classes, it returns the static default locale.</p>
        */
        virtual ::com::sun::star::lang::Locale getPreferredLocale( ) const SAL_OVERRIDE;

    };


    //= OParseContextClient

    /** helper class which needs access to a (shared and ref-counted) OSystemParseContext
        instance.
    */
    class SVX_DLLPUBLIC OParseContextClient
    {
    protected:
        OParseContextClient();
        virtual ~OParseContextClient();

        const OSystemParseContext* getParseContext() const;
    };
}
#endif // INCLUDED_SVX_PARSECONTEXT_HXX



/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
