/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptOrFnNode scriptOrFnNode) {
        this.transformCompilationUnit(scriptOrFnNode);
        for (int i = 0; i != scriptOrFnNode.getFunctionCount(); ++i) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
            this.transform(functionNode);
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode scriptOrFnNode) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        this.transformCompilationUnit_r(scriptOrFnNode, scriptOrFnNode);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode scriptOrFnNode, Node node) {
        Node node2 = null;
        block12: while (true) {
            Node node3 = null;
            if (node2 == null) {
                node2 = node.getFirstChild();
            } else {
                node3 = node2;
                node2 = node2.getNext();
            }
            if (node2 == null) break;
            int n = node2.getType();
            switch (n) {
                case 110: 
                case 126: 
                case 128: {
                    this.loops.push(node2);
                    this.loopEnds.push(((Node.Jump)node2).target);
                    break;
                }
                case 119: {
                    this.loops.push(node2);
                    Node node4 = node2.getNext();
                    if (node4.getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(node4);
                    break;
                }
                case 77: {
                    Node node4 = (Node.Jump)node2;
                    Object object = ((Node.Jump)node4).getFinally();
                    if (object == null) break;
                    this.hasFinally = true;
                    this.loops.push(node2);
                    this.loopEnds.push(object);
                    break;
                }
                case 3: 
                case 127: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node2) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 4: {
                    Node node5;
                    Node node6;
                    Node node7;
                    Node node8;
                    if (!this.hasFinally) break;
                    Node node4 = null;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        node8 = (Node)this.loops.get(i);
                        int n2 = node8.getType();
                        if (n2 != 77 && n2 != 119) continue;
                        if (n2 == 77) {
                            node7 = new Node.Jump(131);
                            ((Node.Jump)node7).target = node6 = ((Node.Jump)node8).getFinally();
                            node5 = node7;
                        } else {
                            node5 = new Node(3);
                        }
                        if (node4 == null) {
                            node4 = new Node(125, node2.getLineno());
                        }
                        node4.addChildToBack(node5);
                    }
                    if (node4 == null) break;
                    Node node9 = node2;
                    node8 = node9.getFirstChild();
                    node2 = NodeTransformer.replaceCurrent(node, node3, node2, node4);
                    if (node8 == null) {
                        node4.addChildToBack(node9);
                        continue block12;
                    }
                    Node node10 = new Node(130, node8);
                    node4.addChildToFront(node10);
                    node9 = new Node(62);
                    node4.addChildToBack(node9);
                    this.transformCompilationUnit_r(scriptOrFnNode, node10);
                    continue block12;
                }
                case 116: 
                case 117: {
                    Node node6;
                    Node node7;
                    Node node4 = (Node.Jump)node2;
                    Object object = ((Node.Jump)node4).getJumpStatement();
                    if (object == null) {
                        Kit.codeBug();
                    }
                    int n3 = this.loops.size();
                    while (true) {
                        Node node11;
                        if (n3 == 0) {
                            throw Kit.codeBug();
                        }
                        if ((node11 = (Node)this.loops.get(--n3)) == object) break;
                        int n4 = node11.getType();
                        if (n4 == 119) {
                            node7 = new Node(3);
                            node3 = NodeTransformer.addBeforeCurrent(node, node3, node2, node7);
                            continue;
                        }
                        if (n4 != 77) continue;
                        node7 = (Node.Jump)node11;
                        node6 = new Node.Jump(131);
                        ((Node.Jump)node6).target = ((Node.Jump)node7).getFinally();
                        node3 = NodeTransformer.addBeforeCurrent(node, node3, node2, node6);
                    }
                    ((Node.Jump)node4).target = n == 116 ? ((Node.Jump)object).target : ((Node.Jump)object).getContinue();
                    node4.setType(5);
                    break;
                }
                case 37: {
                    this.visitCall(node2, scriptOrFnNode);
                    break;
                }
                case 30: {
                    this.visitNew(node2, scriptOrFnNode);
                    break;
                }
                case 118: {
                    Node node5;
                    Object object;
                    Node node4 = new Node(125);
                    for (object = node2.getFirstChild(); object != null; object = ((Node)object).getNext()) {
                        Object object2 = object;
                        if (((Node)object2).getType() == 38) continue;
                        Kit.codeBug();
                        if (!((Node)object2).hasChildren()) continue;
                        Node node12 = ((Node)object2).getFirstChild();
                        ((Node)object2).removeChild(node12);
                        ((Node)object2).setType(48);
                        object2 = new Node(8, (Node)object2, node12);
                        node5 = new Node(129, (Node)object2, node2.getLineno());
                        node4.addChildToBack(node5);
                    }
                    node2 = NodeTransformer.replaceCurrent(node, node3, node2, node4);
                    break;
                }
                case 8: 
                case 31: 
                case 38: {
                    Node node4;
                    if (scriptOrFnNode.getType() != 105 || ((FunctionNode)scriptOrFnNode).requiresActivation()) break;
                    if (n == 38) {
                        node4 = node2;
                    } else {
                        node4 = node2.getFirstChild();
                        if (node4.getType() != 48) {
                            if (n == 31) break;
                            throw Kit.codeBug();
                        }
                    }
                    Object object = node4.getString();
                    if (!scriptOrFnNode.hasParamOrVar((String)object)) break;
                    if (n == 38) {
                        node2.setType(54);
                        break;
                    }
                    if (n == 8) {
                        node2.setType(55);
                        node4.setType(40);
                        break;
                    }
                    if (n == 31) {
                        Node node13 = new Node(43);
                        node2 = NodeTransformer.replaceCurrent(node, node3, node2, node13);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(scriptOrFnNode, node2);
        }
    }

    protected void visitNew(Node node, ScriptOrFnNode scriptOrFnNode) {
    }

    protected void visitCall(Node node, ScriptOrFnNode scriptOrFnNode) {
    }

    private static Node addBeforeCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.addChildToFront(node4);
        } else {
            if (node3 != node2.getNext()) {
                Kit.codeBug();
            }
            node.addChildAfter(node4, node2);
        }
        return node4;
    }

    private static Node replaceCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.replaceChild(node3, node4);
        } else if (node2.next == node3) {
            node.replaceChildAfter(node2, node4);
        } else {
            node.replaceChild(node3, node4);
        }
        return node4;
    }
}

