// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// To regenerate run the gen script in src/coreclr/tools/Common/JitInterface/ThunkGenerator
// and follow the instructions in docs/project/updating-jitinterface.md

#define API_ENTER(name) wrapComp->CLR_API_Enter(API_##name);
#define API_LEAVE(name) wrapComp->CLR_API_Leave(API_##name);

/**********************************************************************************/
// clang-format off
/**********************************************************************************/

bool WrapICorJitInfo::isJitIntrinsic(
          CORINFO_METHOD_HANDLE ftn)
{
    API_ENTER(isJitIntrinsic);
    bool temp = wrapHnd->isJitIntrinsic(ftn);
    API_LEAVE(isJitIntrinsic);
    return temp;
}

uint32_t WrapICorJitInfo::getMethodAttribs(
          CORINFO_METHOD_HANDLE ftn)
{
    API_ENTER(getMethodAttribs);
    uint32_t temp = wrapHnd->getMethodAttribs(ftn);
    API_LEAVE(getMethodAttribs);
    return temp;
}

void WrapICorJitInfo::setMethodAttribs(
          CORINFO_METHOD_HANDLE ftn,
          CorInfoMethodRuntimeFlags attribs)
{
    API_ENTER(setMethodAttribs);
    wrapHnd->setMethodAttribs(ftn, attribs);
    API_LEAVE(setMethodAttribs);
}

void WrapICorJitInfo::getMethodSig(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_SIG_INFO* sig,
          CORINFO_CLASS_HANDLE memberParent)
{
    API_ENTER(getMethodSig);
    wrapHnd->getMethodSig(ftn, sig, memberParent);
    API_LEAVE(getMethodSig);
}

bool WrapICorJitInfo::getMethodInfo(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_METHOD_INFO* info)
{
    API_ENTER(getMethodInfo);
    bool temp = wrapHnd->getMethodInfo(ftn, info);
    API_LEAVE(getMethodInfo);
    return temp;
}

CorInfoInline WrapICorJitInfo::canInline(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE calleeHnd,
          uint32_t* pRestrictions)
{
    API_ENTER(canInline);
    CorInfoInline temp = wrapHnd->canInline(callerHnd, calleeHnd, pRestrictions);
    API_LEAVE(canInline);
    return temp;
}

void WrapICorJitInfo::reportInliningDecision(
          CORINFO_METHOD_HANDLE inlinerHnd,
          CORINFO_METHOD_HANDLE inlineeHnd,
          CorInfoInline inlineResult,
          const char* reason)
{
    API_ENTER(reportInliningDecision);
    wrapHnd->reportInliningDecision(inlinerHnd, inlineeHnd, inlineResult, reason);
    API_LEAVE(reportInliningDecision);
}

bool WrapICorJitInfo::canTailCall(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE declaredCalleeHnd,
          CORINFO_METHOD_HANDLE exactCalleeHnd,
          bool fIsTailPrefix)
{
    API_ENTER(canTailCall);
    bool temp = wrapHnd->canTailCall(callerHnd, declaredCalleeHnd, exactCalleeHnd, fIsTailPrefix);
    API_LEAVE(canTailCall);
    return temp;
}

void WrapICorJitInfo::reportTailCallDecision(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE calleeHnd,
          bool fIsTailPrefix,
          CorInfoTailCall tailCallResult,
          const char* reason)
{
    API_ENTER(reportTailCallDecision);
    wrapHnd->reportTailCallDecision(callerHnd, calleeHnd, fIsTailPrefix, tailCallResult, reason);
    API_LEAVE(reportTailCallDecision);
}

void WrapICorJitInfo::getEHinfo(
          CORINFO_METHOD_HANDLE ftn,
          unsigned EHnumber,
          CORINFO_EH_CLAUSE* clause)
{
    API_ENTER(getEHinfo);
    wrapHnd->getEHinfo(ftn, EHnumber, clause);
    API_LEAVE(getEHinfo);
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getMethodClass(
          CORINFO_METHOD_HANDLE method)
{
    API_ENTER(getMethodClass);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getMethodClass(method);
    API_LEAVE(getMethodClass);
    return temp;
}

CORINFO_MODULE_HANDLE WrapICorJitInfo::getMethodModule(
          CORINFO_METHOD_HANDLE method)
{
    API_ENTER(getMethodModule);
    CORINFO_MODULE_HANDLE temp = wrapHnd->getMethodModule(method);
    API_LEAVE(getMethodModule);
    return temp;
}

void WrapICorJitInfo::getMethodVTableOffset(
          CORINFO_METHOD_HANDLE method,
          unsigned* offsetOfIndirection,
          unsigned* offsetAfterIndirection,
          bool* isRelative)
{
    API_ENTER(getMethodVTableOffset);
    wrapHnd->getMethodVTableOffset(method, offsetOfIndirection, offsetAfterIndirection, isRelative);
    API_LEAVE(getMethodVTableOffset);
}

bool WrapICorJitInfo::resolveVirtualMethod(
          CORINFO_DEVIRTUALIZATION_INFO* info)
{
    API_ENTER(resolveVirtualMethod);
    bool temp = wrapHnd->resolveVirtualMethod(info);
    API_LEAVE(resolveVirtualMethod);
    return temp;
}

CORINFO_METHOD_HANDLE WrapICorJitInfo::getUnboxedEntry(
          CORINFO_METHOD_HANDLE ftn,
          bool* requiresInstMethodTableArg)
{
    API_ENTER(getUnboxedEntry);
    CORINFO_METHOD_HANDLE temp = wrapHnd->getUnboxedEntry(ftn, requiresInstMethodTableArg);
    API_LEAVE(getUnboxedEntry);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getDefaultComparerClass(
          CORINFO_CLASS_HANDLE elemType)
{
    API_ENTER(getDefaultComparerClass);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getDefaultComparerClass(elemType);
    API_LEAVE(getDefaultComparerClass);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getDefaultEqualityComparerClass(
          CORINFO_CLASS_HANDLE elemType)
{
    API_ENTER(getDefaultEqualityComparerClass);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getDefaultEqualityComparerClass(elemType);
    API_LEAVE(getDefaultEqualityComparerClass);
    return temp;
}

void WrapICorJitInfo::expandRawHandleIntrinsic(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_GENERICHANDLE_RESULT* pResult)
{
    API_ENTER(expandRawHandleIntrinsic);
    wrapHnd->expandRawHandleIntrinsic(pResolvedToken, pResult);
    API_LEAVE(expandRawHandleIntrinsic);
}

CorInfoIntrinsics WrapICorJitInfo::getIntrinsicID(
          CORINFO_METHOD_HANDLE method,
          bool* pMustExpand)
{
    API_ENTER(getIntrinsicID);
    CorInfoIntrinsics temp = wrapHnd->getIntrinsicID(method, pMustExpand);
    API_LEAVE(getIntrinsicID);
    return temp;
}

bool WrapICorJitInfo::isIntrinsicType(
          CORINFO_CLASS_HANDLE classHnd)
{
    API_ENTER(isIntrinsicType);
    bool temp = wrapHnd->isIntrinsicType(classHnd);
    API_LEAVE(isIntrinsicType);
    return temp;
}

CorInfoCallConvExtension WrapICorJitInfo::getUnmanagedCallConv(
          CORINFO_METHOD_HANDLE method,
          CORINFO_SIG_INFO* callSiteSig,
          bool* pSuppressGCTransition)
{
    API_ENTER(getUnmanagedCallConv);
    CorInfoCallConvExtension temp = wrapHnd->getUnmanagedCallConv(method, callSiteSig, pSuppressGCTransition);
    API_LEAVE(getUnmanagedCallConv);
    return temp;
}

bool WrapICorJitInfo::pInvokeMarshalingRequired(
          CORINFO_METHOD_HANDLE method,
          CORINFO_SIG_INFO* callSiteSig)
{
    API_ENTER(pInvokeMarshalingRequired);
    bool temp = wrapHnd->pInvokeMarshalingRequired(method, callSiteSig);
    API_LEAVE(pInvokeMarshalingRequired);
    return temp;
}

bool WrapICorJitInfo::satisfiesMethodConstraints(
          CORINFO_CLASS_HANDLE parent,
          CORINFO_METHOD_HANDLE method)
{
    API_ENTER(satisfiesMethodConstraints);
    bool temp = wrapHnd->satisfiesMethodConstraints(parent, method);
    API_LEAVE(satisfiesMethodConstraints);
    return temp;
}

bool WrapICorJitInfo::isCompatibleDelegate(
          CORINFO_CLASS_HANDLE objCls,
          CORINFO_CLASS_HANDLE methodParentCls,
          CORINFO_METHOD_HANDLE method,
          CORINFO_CLASS_HANDLE delegateCls,
          bool* pfIsOpenDelegate)
{
    API_ENTER(isCompatibleDelegate);
    bool temp = wrapHnd->isCompatibleDelegate(objCls, methodParentCls, method, delegateCls, pfIsOpenDelegate);
    API_LEAVE(isCompatibleDelegate);
    return temp;
}

void WrapICorJitInfo::methodMustBeLoadedBeforeCodeIsRun(
          CORINFO_METHOD_HANDLE method)
{
    API_ENTER(methodMustBeLoadedBeforeCodeIsRun);
    wrapHnd->methodMustBeLoadedBeforeCodeIsRun(method);
    API_LEAVE(methodMustBeLoadedBeforeCodeIsRun);
}

CORINFO_METHOD_HANDLE WrapICorJitInfo::mapMethodDeclToMethodImpl(
          CORINFO_METHOD_HANDLE method)
{
    API_ENTER(mapMethodDeclToMethodImpl);
    CORINFO_METHOD_HANDLE temp = wrapHnd->mapMethodDeclToMethodImpl(method);
    API_LEAVE(mapMethodDeclToMethodImpl);
    return temp;
}

void WrapICorJitInfo::getGSCookie(
          GSCookie* pCookieVal,
          GSCookie** ppCookieVal)
{
    API_ENTER(getGSCookie);
    wrapHnd->getGSCookie(pCookieVal, ppCookieVal);
    API_LEAVE(getGSCookie);
}

void WrapICorJitInfo::setPatchpointInfo(
          PatchpointInfo* patchpointInfo)
{
    API_ENTER(setPatchpointInfo);
    wrapHnd->setPatchpointInfo(patchpointInfo);
    API_LEAVE(setPatchpointInfo);
}

PatchpointInfo* WrapICorJitInfo::getOSRInfo(
          unsigned* ilOffset)
{
    API_ENTER(getOSRInfo);
    PatchpointInfo* temp = wrapHnd->getOSRInfo(ilOffset);
    API_LEAVE(getOSRInfo);
    return temp;
}

void WrapICorJitInfo::resolveToken(
          CORINFO_RESOLVED_TOKEN* pResolvedToken)
{
    API_ENTER(resolveToken);
    wrapHnd->resolveToken(pResolvedToken);
    API_LEAVE(resolveToken);
}

bool WrapICorJitInfo::tryResolveToken(
          CORINFO_RESOLVED_TOKEN* pResolvedToken)
{
    API_ENTER(tryResolveToken);
    bool temp = wrapHnd->tryResolveToken(pResolvedToken);
    API_LEAVE(tryResolveToken);
    return temp;
}

void WrapICorJitInfo::findSig(
          CORINFO_MODULE_HANDLE module,
          unsigned sigTOK,
          CORINFO_CONTEXT_HANDLE context,
          CORINFO_SIG_INFO* sig)
{
    API_ENTER(findSig);
    wrapHnd->findSig(module, sigTOK, context, sig);
    API_LEAVE(findSig);
}

void WrapICorJitInfo::findCallSiteSig(
          CORINFO_MODULE_HANDLE module,
          unsigned methTOK,
          CORINFO_CONTEXT_HANDLE context,
          CORINFO_SIG_INFO* sig)
{
    API_ENTER(findCallSiteSig);
    wrapHnd->findCallSiteSig(module, methTOK, context, sig);
    API_LEAVE(findCallSiteSig);
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getTokenTypeAsHandle(
          CORINFO_RESOLVED_TOKEN* pResolvedToken)
{
    API_ENTER(getTokenTypeAsHandle);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getTokenTypeAsHandle(pResolvedToken);
    API_LEAVE(getTokenTypeAsHandle);
    return temp;
}

bool WrapICorJitInfo::isValidToken(
          CORINFO_MODULE_HANDLE module,
          unsigned metaTOK)
{
    API_ENTER(isValidToken);
    bool temp = wrapHnd->isValidToken(module, metaTOK);
    API_LEAVE(isValidToken);
    return temp;
}

bool WrapICorJitInfo::isValidStringRef(
          CORINFO_MODULE_HANDLE module,
          unsigned metaTOK)
{
    API_ENTER(isValidStringRef);
    bool temp = wrapHnd->isValidStringRef(module, metaTOK);
    API_LEAVE(isValidStringRef);
    return temp;
}

const char16_t* WrapICorJitInfo::getStringLiteral(
          CORINFO_MODULE_HANDLE module,
          unsigned metaTOK,
          int* length)
{
    API_ENTER(getStringLiteral);
    const char16_t* temp = wrapHnd->getStringLiteral(module, metaTOK, length);
    API_LEAVE(getStringLiteral);
    return temp;
}

CorInfoType WrapICorJitInfo::asCorInfoType(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(asCorInfoType);
    CorInfoType temp = wrapHnd->asCorInfoType(cls);
    API_LEAVE(asCorInfoType);
    return temp;
}

const char* WrapICorJitInfo::getClassName(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getClassName);
    const char* temp = wrapHnd->getClassName(cls);
    API_LEAVE(getClassName);
    return temp;
}

const char* WrapICorJitInfo::getClassNameFromMetadata(
          CORINFO_CLASS_HANDLE cls,
          const char** namespaceName)
{
    API_ENTER(getClassNameFromMetadata);
    const char* temp = wrapHnd->getClassNameFromMetadata(cls, namespaceName);
    API_LEAVE(getClassNameFromMetadata);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getTypeInstantiationArgument(
          CORINFO_CLASS_HANDLE cls,
          unsigned index)
{
    API_ENTER(getTypeInstantiationArgument);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getTypeInstantiationArgument(cls, index);
    API_LEAVE(getTypeInstantiationArgument);
    return temp;
}

int WrapICorJitInfo::appendClassName(
          char16_t** ppBuf,
          int* pnBufLen,
          CORINFO_CLASS_HANDLE cls,
          bool fNamespace,
          bool fFullInst,
          bool fAssembly)
{
    API_ENTER(appendClassName);
    int temp = wrapHnd->appendClassName(ppBuf, pnBufLen, cls, fNamespace, fFullInst, fAssembly);
    API_LEAVE(appendClassName);
    return temp;
}

bool WrapICorJitInfo::isValueClass(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(isValueClass);
    bool temp = wrapHnd->isValueClass(cls);
    API_LEAVE(isValueClass);
    return temp;
}

CorInfoInlineTypeCheck WrapICorJitInfo::canInlineTypeCheck(
          CORINFO_CLASS_HANDLE cls,
          CorInfoInlineTypeCheckSource source)
{
    API_ENTER(canInlineTypeCheck);
    CorInfoInlineTypeCheck temp = wrapHnd->canInlineTypeCheck(cls, source);
    API_LEAVE(canInlineTypeCheck);
    return temp;
}

uint32_t WrapICorJitInfo::getClassAttribs(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getClassAttribs);
    uint32_t temp = wrapHnd->getClassAttribs(cls);
    API_LEAVE(getClassAttribs);
    return temp;
}

bool WrapICorJitInfo::isStructRequiringStackAllocRetBuf(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(isStructRequiringStackAllocRetBuf);
    bool temp = wrapHnd->isStructRequiringStackAllocRetBuf(cls);
    API_LEAVE(isStructRequiringStackAllocRetBuf);
    return temp;
}

CORINFO_MODULE_HANDLE WrapICorJitInfo::getClassModule(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getClassModule);
    CORINFO_MODULE_HANDLE temp = wrapHnd->getClassModule(cls);
    API_LEAVE(getClassModule);
    return temp;
}

CORINFO_ASSEMBLY_HANDLE WrapICorJitInfo::getModuleAssembly(
          CORINFO_MODULE_HANDLE mod)
{
    API_ENTER(getModuleAssembly);
    CORINFO_ASSEMBLY_HANDLE temp = wrapHnd->getModuleAssembly(mod);
    API_LEAVE(getModuleAssembly);
    return temp;
}

const char* WrapICorJitInfo::getAssemblyName(
          CORINFO_ASSEMBLY_HANDLE assem)
{
    API_ENTER(getAssemblyName);
    const char* temp = wrapHnd->getAssemblyName(assem);
    API_LEAVE(getAssemblyName);
    return temp;
}

void* WrapICorJitInfo::LongLifetimeMalloc(
          size_t sz)
{
    API_ENTER(LongLifetimeMalloc);
    void* temp = wrapHnd->LongLifetimeMalloc(sz);
    API_LEAVE(LongLifetimeMalloc);
    return temp;
}

void WrapICorJitInfo::LongLifetimeFree(
          void* obj)
{
    API_ENTER(LongLifetimeFree);
    wrapHnd->LongLifetimeFree(obj);
    API_LEAVE(LongLifetimeFree);
}

size_t WrapICorJitInfo::getClassModuleIdForStatics(
          CORINFO_CLASS_HANDLE cls,
          CORINFO_MODULE_HANDLE* pModule,
          void** ppIndirection)
{
    API_ENTER(getClassModuleIdForStatics);
    size_t temp = wrapHnd->getClassModuleIdForStatics(cls, pModule, ppIndirection);
    API_LEAVE(getClassModuleIdForStatics);
    return temp;
}

unsigned WrapICorJitInfo::getClassSize(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getClassSize);
    unsigned temp = wrapHnd->getClassSize(cls);
    API_LEAVE(getClassSize);
    return temp;
}

unsigned WrapICorJitInfo::getHeapClassSize(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getHeapClassSize);
    unsigned temp = wrapHnd->getHeapClassSize(cls);
    API_LEAVE(getHeapClassSize);
    return temp;
}

bool WrapICorJitInfo::canAllocateOnStack(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(canAllocateOnStack);
    bool temp = wrapHnd->canAllocateOnStack(cls);
    API_LEAVE(canAllocateOnStack);
    return temp;
}

unsigned WrapICorJitInfo::getClassAlignmentRequirement(
          CORINFO_CLASS_HANDLE cls,
          bool fDoubleAlignHint)
{
    API_ENTER(getClassAlignmentRequirement);
    unsigned temp = wrapHnd->getClassAlignmentRequirement(cls, fDoubleAlignHint);
    API_LEAVE(getClassAlignmentRequirement);
    return temp;
}

unsigned WrapICorJitInfo::getClassGClayout(
          CORINFO_CLASS_HANDLE cls,
          uint8_t* gcPtrs)
{
    API_ENTER(getClassGClayout);
    unsigned temp = wrapHnd->getClassGClayout(cls, gcPtrs);
    API_LEAVE(getClassGClayout);
    return temp;
}

unsigned WrapICorJitInfo::getClassNumInstanceFields(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getClassNumInstanceFields);
    unsigned temp = wrapHnd->getClassNumInstanceFields(cls);
    API_LEAVE(getClassNumInstanceFields);
    return temp;
}

CORINFO_FIELD_HANDLE WrapICorJitInfo::getFieldInClass(
          CORINFO_CLASS_HANDLE clsHnd,
          int32_t num)
{
    API_ENTER(getFieldInClass);
    CORINFO_FIELD_HANDLE temp = wrapHnd->getFieldInClass(clsHnd, num);
    API_LEAVE(getFieldInClass);
    return temp;
}

bool WrapICorJitInfo::checkMethodModifier(
          CORINFO_METHOD_HANDLE hMethod,
          const char* modifier,
          bool fOptional)
{
    API_ENTER(checkMethodModifier);
    bool temp = wrapHnd->checkMethodModifier(hMethod, modifier, fOptional);
    API_LEAVE(checkMethodModifier);
    return temp;
}

CorInfoHelpFunc WrapICorJitInfo::getNewHelper(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          bool* pHasSideEffects)
{
    API_ENTER(getNewHelper);
    CorInfoHelpFunc temp = wrapHnd->getNewHelper(pResolvedToken, callerHandle, pHasSideEffects);
    API_LEAVE(getNewHelper);
    return temp;
}

CorInfoHelpFunc WrapICorJitInfo::getNewArrHelper(
          CORINFO_CLASS_HANDLE arrayCls)
{
    API_ENTER(getNewArrHelper);
    CorInfoHelpFunc temp = wrapHnd->getNewArrHelper(arrayCls);
    API_LEAVE(getNewArrHelper);
    return temp;
}

CorInfoHelpFunc WrapICorJitInfo::getCastingHelper(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool fThrowing)
{
    API_ENTER(getCastingHelper);
    CorInfoHelpFunc temp = wrapHnd->getCastingHelper(pResolvedToken, fThrowing);
    API_LEAVE(getCastingHelper);
    return temp;
}

CorInfoHelpFunc WrapICorJitInfo::getSharedCCtorHelper(
          CORINFO_CLASS_HANDLE clsHnd)
{
    API_ENTER(getSharedCCtorHelper);
    CorInfoHelpFunc temp = wrapHnd->getSharedCCtorHelper(clsHnd);
    API_LEAVE(getSharedCCtorHelper);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getTypeForBox(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getTypeForBox);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getTypeForBox(cls);
    API_LEAVE(getTypeForBox);
    return temp;
}

CorInfoHelpFunc WrapICorJitInfo::getBoxHelper(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getBoxHelper);
    CorInfoHelpFunc temp = wrapHnd->getBoxHelper(cls);
    API_LEAVE(getBoxHelper);
    return temp;
}

CorInfoHelpFunc WrapICorJitInfo::getUnBoxHelper(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getUnBoxHelper);
    CorInfoHelpFunc temp = wrapHnd->getUnBoxHelper(cls);
    API_LEAVE(getUnBoxHelper);
    return temp;
}

bool WrapICorJitInfo::getReadyToRunHelper(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_LOOKUP_KIND* pGenericLookupKind,
          CorInfoHelpFunc id,
          CORINFO_CONST_LOOKUP* pLookup)
{
    API_ENTER(getReadyToRunHelper);
    bool temp = wrapHnd->getReadyToRunHelper(pResolvedToken, pGenericLookupKind, id, pLookup);
    API_LEAVE(getReadyToRunHelper);
    return temp;
}

void WrapICorJitInfo::getReadyToRunDelegateCtorHelper(
          CORINFO_RESOLVED_TOKEN* pTargetMethod,
          CORINFO_CLASS_HANDLE delegateType,
          CORINFO_LOOKUP* pLookup)
{
    API_ENTER(getReadyToRunDelegateCtorHelper);
    wrapHnd->getReadyToRunDelegateCtorHelper(pTargetMethod, delegateType, pLookup);
    API_LEAVE(getReadyToRunDelegateCtorHelper);
}

const char* WrapICorJitInfo::getHelperName(
          CorInfoHelpFunc helpFunc)
{
    API_ENTER(getHelperName);
    const char* temp = wrapHnd->getHelperName(helpFunc);
    API_LEAVE(getHelperName);
    return temp;
}

CorInfoInitClassResult WrapICorJitInfo::initClass(
          CORINFO_FIELD_HANDLE field,
          CORINFO_METHOD_HANDLE method,
          CORINFO_CONTEXT_HANDLE context)
{
    API_ENTER(initClass);
    CorInfoInitClassResult temp = wrapHnd->initClass(field, method, context);
    API_LEAVE(initClass);
    return temp;
}

void WrapICorJitInfo::classMustBeLoadedBeforeCodeIsRun(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(classMustBeLoadedBeforeCodeIsRun);
    wrapHnd->classMustBeLoadedBeforeCodeIsRun(cls);
    API_LEAVE(classMustBeLoadedBeforeCodeIsRun);
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getBuiltinClass(
          CorInfoClassId classId)
{
    API_ENTER(getBuiltinClass);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getBuiltinClass(classId);
    API_LEAVE(getBuiltinClass);
    return temp;
}

CorInfoType WrapICorJitInfo::getTypeForPrimitiveValueClass(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getTypeForPrimitiveValueClass);
    CorInfoType temp = wrapHnd->getTypeForPrimitiveValueClass(cls);
    API_LEAVE(getTypeForPrimitiveValueClass);
    return temp;
}

CorInfoType WrapICorJitInfo::getTypeForPrimitiveNumericClass(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getTypeForPrimitiveNumericClass);
    CorInfoType temp = wrapHnd->getTypeForPrimitiveNumericClass(cls);
    API_LEAVE(getTypeForPrimitiveNumericClass);
    return temp;
}

bool WrapICorJitInfo::canCast(
          CORINFO_CLASS_HANDLE child,
          CORINFO_CLASS_HANDLE parent)
{
    API_ENTER(canCast);
    bool temp = wrapHnd->canCast(child, parent);
    API_LEAVE(canCast);
    return temp;
}

bool WrapICorJitInfo::areTypesEquivalent(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    API_ENTER(areTypesEquivalent);
    bool temp = wrapHnd->areTypesEquivalent(cls1, cls2);
    API_LEAVE(areTypesEquivalent);
    return temp;
}

TypeCompareState WrapICorJitInfo::compareTypesForCast(
          CORINFO_CLASS_HANDLE fromClass,
          CORINFO_CLASS_HANDLE toClass)
{
    API_ENTER(compareTypesForCast);
    TypeCompareState temp = wrapHnd->compareTypesForCast(fromClass, toClass);
    API_LEAVE(compareTypesForCast);
    return temp;
}

TypeCompareState WrapICorJitInfo::compareTypesForEquality(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    API_ENTER(compareTypesForEquality);
    TypeCompareState temp = wrapHnd->compareTypesForEquality(cls1, cls2);
    API_LEAVE(compareTypesForEquality);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::mergeClasses(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    API_ENTER(mergeClasses);
    CORINFO_CLASS_HANDLE temp = wrapHnd->mergeClasses(cls1, cls2);
    API_LEAVE(mergeClasses);
    return temp;
}

bool WrapICorJitInfo::isMoreSpecificType(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    API_ENTER(isMoreSpecificType);
    bool temp = wrapHnd->isMoreSpecificType(cls1, cls2);
    API_LEAVE(isMoreSpecificType);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getParentType(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getParentType);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getParentType(cls);
    API_LEAVE(getParentType);
    return temp;
}

CorInfoType WrapICorJitInfo::getChildType(
          CORINFO_CLASS_HANDLE clsHnd,
          CORINFO_CLASS_HANDLE* clsRet)
{
    API_ENTER(getChildType);
    CorInfoType temp = wrapHnd->getChildType(clsHnd, clsRet);
    API_LEAVE(getChildType);
    return temp;
}

bool WrapICorJitInfo::satisfiesClassConstraints(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(satisfiesClassConstraints);
    bool temp = wrapHnd->satisfiesClassConstraints(cls);
    API_LEAVE(satisfiesClassConstraints);
    return temp;
}

bool WrapICorJitInfo::isSDArray(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(isSDArray);
    bool temp = wrapHnd->isSDArray(cls);
    API_LEAVE(isSDArray);
    return temp;
}

unsigned WrapICorJitInfo::getArrayRank(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(getArrayRank);
    unsigned temp = wrapHnd->getArrayRank(cls);
    API_LEAVE(getArrayRank);
    return temp;
}

void* WrapICorJitInfo::getArrayInitializationData(
          CORINFO_FIELD_HANDLE field,
          uint32_t size)
{
    API_ENTER(getArrayInitializationData);
    void* temp = wrapHnd->getArrayInitializationData(field, size);
    API_LEAVE(getArrayInitializationData);
    return temp;
}

CorInfoIsAccessAllowedResult WrapICorJitInfo::canAccessClass(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_HELPER_DESC* pAccessHelper)
{
    API_ENTER(canAccessClass);
    CorInfoIsAccessAllowedResult temp = wrapHnd->canAccessClass(pResolvedToken, callerHandle, pAccessHelper);
    API_LEAVE(canAccessClass);
    return temp;
}

const char* WrapICorJitInfo::getFieldName(
          CORINFO_FIELD_HANDLE ftn,
          const char** moduleName)
{
    API_ENTER(getFieldName);
    const char* temp = wrapHnd->getFieldName(ftn, moduleName);
    API_LEAVE(getFieldName);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getFieldClass(
          CORINFO_FIELD_HANDLE field)
{
    API_ENTER(getFieldClass);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getFieldClass(field);
    API_LEAVE(getFieldClass);
    return temp;
}

CorInfoType WrapICorJitInfo::getFieldType(
          CORINFO_FIELD_HANDLE field,
          CORINFO_CLASS_HANDLE* structType,
          CORINFO_CLASS_HANDLE memberParent)
{
    API_ENTER(getFieldType);
    CorInfoType temp = wrapHnd->getFieldType(field, structType, memberParent);
    API_LEAVE(getFieldType);
    return temp;
}

unsigned WrapICorJitInfo::getFieldOffset(
          CORINFO_FIELD_HANDLE field)
{
    API_ENTER(getFieldOffset);
    unsigned temp = wrapHnd->getFieldOffset(field);
    API_LEAVE(getFieldOffset);
    return temp;
}

void WrapICorJitInfo::getFieldInfo(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_ACCESS_FLAGS flags,
          CORINFO_FIELD_INFO* pResult)
{
    API_ENTER(getFieldInfo);
    wrapHnd->getFieldInfo(pResolvedToken, callerHandle, flags, pResult);
    API_LEAVE(getFieldInfo);
}

bool WrapICorJitInfo::isFieldStatic(
          CORINFO_FIELD_HANDLE fldHnd)
{
    API_ENTER(isFieldStatic);
    bool temp = wrapHnd->isFieldStatic(fldHnd);
    API_LEAVE(isFieldStatic);
    return temp;
}

void WrapICorJitInfo::getBoundaries(
          CORINFO_METHOD_HANDLE ftn,
          unsigned int* cILOffsets,
          uint32_t** pILOffsets,
          ICorDebugInfo::BoundaryTypes* implicitBoundaries)
{
    API_ENTER(getBoundaries);
    wrapHnd->getBoundaries(ftn, cILOffsets, pILOffsets, implicitBoundaries);
    API_LEAVE(getBoundaries);
}

void WrapICorJitInfo::setBoundaries(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t cMap,
          ICorDebugInfo::OffsetMapping* pMap)
{
    API_ENTER(setBoundaries);
    wrapHnd->setBoundaries(ftn, cMap, pMap);
    API_LEAVE(setBoundaries);
}

void WrapICorJitInfo::getVars(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t* cVars,
          ICorDebugInfo::ILVarInfo** vars,
          bool* extendOthers)
{
    API_ENTER(getVars);
    wrapHnd->getVars(ftn, cVars, vars, extendOthers);
    API_LEAVE(getVars);
}

void WrapICorJitInfo::setVars(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t cVars,
          ICorDebugInfo::NativeVarInfo* vars)
{
    API_ENTER(setVars);
    wrapHnd->setVars(ftn, cVars, vars);
    API_LEAVE(setVars);
}

void* WrapICorJitInfo::allocateArray(
          size_t cBytes)
{
    API_ENTER(allocateArray);
    void* temp = wrapHnd->allocateArray(cBytes);
    API_LEAVE(allocateArray);
    return temp;
}

void WrapICorJitInfo::freeArray(
          void* array)
{
    API_ENTER(freeArray);
    wrapHnd->freeArray(array);
    API_LEAVE(freeArray);
}

CORINFO_ARG_LIST_HANDLE WrapICorJitInfo::getArgNext(
          CORINFO_ARG_LIST_HANDLE args)
{
    API_ENTER(getArgNext);
    CORINFO_ARG_LIST_HANDLE temp = wrapHnd->getArgNext(args);
    API_LEAVE(getArgNext);
    return temp;
}

CorInfoTypeWithMod WrapICorJitInfo::getArgType(
          CORINFO_SIG_INFO* sig,
          CORINFO_ARG_LIST_HANDLE args,
          CORINFO_CLASS_HANDLE* vcTypeRet)
{
    API_ENTER(getArgType);
    CorInfoTypeWithMod temp = wrapHnd->getArgType(sig, args, vcTypeRet);
    API_LEAVE(getArgType);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getArgClass(
          CORINFO_SIG_INFO* sig,
          CORINFO_ARG_LIST_HANDLE args)
{
    API_ENTER(getArgClass);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getArgClass(sig, args);
    API_LEAVE(getArgClass);
    return temp;
}

CorInfoHFAElemType WrapICorJitInfo::getHFAType(
          CORINFO_CLASS_HANDLE hClass)
{
    API_ENTER(getHFAType);
    CorInfoHFAElemType temp = wrapHnd->getHFAType(hClass);
    API_LEAVE(getHFAType);
    return temp;
}

JITINTERFACE_HRESULT WrapICorJitInfo::GetErrorHRESULT(
          struct _EXCEPTION_POINTERS* pExceptionPointers)
{
    API_ENTER(GetErrorHRESULT);
    JITINTERFACE_HRESULT temp = wrapHnd->GetErrorHRESULT(pExceptionPointers);
    API_LEAVE(GetErrorHRESULT);
    return temp;
}

uint32_t WrapICorJitInfo::GetErrorMessage(
          char16_t* buffer,
          uint32_t bufferLength)
{
    API_ENTER(GetErrorMessage);
    uint32_t temp = wrapHnd->GetErrorMessage(buffer, bufferLength);
    API_LEAVE(GetErrorMessage);
    return temp;
}

int WrapICorJitInfo::FilterException(
          struct _EXCEPTION_POINTERS* pExceptionPointers)
{
    API_ENTER(FilterException);
    int temp = wrapHnd->FilterException(pExceptionPointers);
    API_LEAVE(FilterException);
    return temp;
}

void WrapICorJitInfo::ThrowExceptionForJitResult(
          JITINTERFACE_HRESULT result)
{
    API_ENTER(ThrowExceptionForJitResult);
    wrapHnd->ThrowExceptionForJitResult(result);
    API_LEAVE(ThrowExceptionForJitResult);
}

void WrapICorJitInfo::ThrowExceptionForHelper(
          const CORINFO_HELPER_DESC* throwHelper)
{
    API_ENTER(ThrowExceptionForHelper);
    wrapHnd->ThrowExceptionForHelper(throwHelper);
    API_LEAVE(ThrowExceptionForHelper);
}

bool WrapICorJitInfo::runWithErrorTrap(
          ICorJitInfo::errorTrapFunction function,
          void* parameter)
{
    API_ENTER(runWithErrorTrap);
    bool temp = wrapHnd->runWithErrorTrap(function, parameter);
    API_LEAVE(runWithErrorTrap);
    return temp;
}

bool WrapICorJitInfo::runWithSPMIErrorTrap(
          ICorJitInfo::errorTrapFunction function,
          void* parameter)
{
    API_ENTER(runWithSPMIErrorTrap);
    bool temp = wrapHnd->runWithSPMIErrorTrap(function, parameter);
    API_LEAVE(runWithSPMIErrorTrap);
    return temp;
}

void WrapICorJitInfo::getEEInfo(
          CORINFO_EE_INFO* pEEInfoOut)
{
    API_ENTER(getEEInfo);
    wrapHnd->getEEInfo(pEEInfoOut);
    API_LEAVE(getEEInfo);
}

const char16_t* WrapICorJitInfo::getJitTimeLogFilename()
{
    API_ENTER(getJitTimeLogFilename);
    const char16_t* temp = wrapHnd->getJitTimeLogFilename();
    API_LEAVE(getJitTimeLogFilename);
    return temp;
}

mdMethodDef WrapICorJitInfo::getMethodDefFromMethod(
          CORINFO_METHOD_HANDLE hMethod)
{
    API_ENTER(getMethodDefFromMethod);
    mdMethodDef temp = wrapHnd->getMethodDefFromMethod(hMethod);
    API_LEAVE(getMethodDefFromMethod);
    return temp;
}

const char* WrapICorJitInfo::getMethodName(
          CORINFO_METHOD_HANDLE ftn,
          const char** moduleName)
{
    API_ENTER(getMethodName);
    const char* temp = wrapHnd->getMethodName(ftn, moduleName);
    API_LEAVE(getMethodName);
    return temp;
}

const char* WrapICorJitInfo::getMethodNameFromMetadata(
          CORINFO_METHOD_HANDLE ftn,
          const char** className,
          const char** namespaceName,
          const char** enclosingClassName)
{
    API_ENTER(getMethodNameFromMetadata);
    const char* temp = wrapHnd->getMethodNameFromMetadata(ftn, className, namespaceName, enclosingClassName);
    API_LEAVE(getMethodNameFromMetadata);
    return temp;
}

unsigned WrapICorJitInfo::getMethodHash(
          CORINFO_METHOD_HANDLE ftn)
{
    API_ENTER(getMethodHash);
    unsigned temp = wrapHnd->getMethodHash(ftn);
    API_LEAVE(getMethodHash);
    return temp;
}

size_t WrapICorJitInfo::findNameOfToken(
          CORINFO_MODULE_HANDLE moduleHandle,
          mdToken token,
          char* szFQName,
          size_t FQNameCapacity)
{
    API_ENTER(findNameOfToken);
    size_t temp = wrapHnd->findNameOfToken(moduleHandle, token, szFQName, FQNameCapacity);
    API_LEAVE(findNameOfToken);
    return temp;
}

bool WrapICorJitInfo::getSystemVAmd64PassStructInRegisterDescriptor(
          CORINFO_CLASS_HANDLE structHnd,
          SYSTEMV_AMD64_CORINFO_STRUCT_REG_PASSING_DESCRIPTOR* structPassInRegDescPtr)
{
    API_ENTER(getSystemVAmd64PassStructInRegisterDescriptor);
    bool temp = wrapHnd->getSystemVAmd64PassStructInRegisterDescriptor(structHnd, structPassInRegDescPtr);
    API_LEAVE(getSystemVAmd64PassStructInRegisterDescriptor);
    return temp;
}

uint32_t WrapICorJitInfo::getThreadTLSIndex(
          void** ppIndirection)
{
    API_ENTER(getThreadTLSIndex);
    uint32_t temp = wrapHnd->getThreadTLSIndex(ppIndirection);
    API_LEAVE(getThreadTLSIndex);
    return temp;
}

const void* WrapICorJitInfo::getInlinedCallFrameVptr(
          void** ppIndirection)
{
    API_ENTER(getInlinedCallFrameVptr);
    const void* temp = wrapHnd->getInlinedCallFrameVptr(ppIndirection);
    API_LEAVE(getInlinedCallFrameVptr);
    return temp;
}

int32_t* WrapICorJitInfo::getAddrOfCaptureThreadGlobal(
          void** ppIndirection)
{
    API_ENTER(getAddrOfCaptureThreadGlobal);
    int32_t* temp = wrapHnd->getAddrOfCaptureThreadGlobal(ppIndirection);
    API_LEAVE(getAddrOfCaptureThreadGlobal);
    return temp;
}

void* WrapICorJitInfo::getHelperFtn(
          CorInfoHelpFunc ftnNum,
          void** ppIndirection)
{
    API_ENTER(getHelperFtn);
    void* temp = wrapHnd->getHelperFtn(ftnNum, ppIndirection);
    API_LEAVE(getHelperFtn);
    return temp;
}

void WrapICorJitInfo::getFunctionEntryPoint(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_CONST_LOOKUP* pResult,
          CORINFO_ACCESS_FLAGS accessFlags)
{
    API_ENTER(getFunctionEntryPoint);
    wrapHnd->getFunctionEntryPoint(ftn, pResult, accessFlags);
    API_LEAVE(getFunctionEntryPoint);
}

void WrapICorJitInfo::getFunctionFixedEntryPoint(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_CONST_LOOKUP* pResult)
{
    API_ENTER(getFunctionFixedEntryPoint);
    wrapHnd->getFunctionFixedEntryPoint(ftn, pResult);
    API_LEAVE(getFunctionFixedEntryPoint);
}

void* WrapICorJitInfo::getMethodSync(
          CORINFO_METHOD_HANDLE ftn,
          void** ppIndirection)
{
    API_ENTER(getMethodSync);
    void* temp = wrapHnd->getMethodSync(ftn, ppIndirection);
    API_LEAVE(getMethodSync);
    return temp;
}

CorInfoHelpFunc WrapICorJitInfo::getLazyStringLiteralHelper(
          CORINFO_MODULE_HANDLE handle)
{
    API_ENTER(getLazyStringLiteralHelper);
    CorInfoHelpFunc temp = wrapHnd->getLazyStringLiteralHelper(handle);
    API_LEAVE(getLazyStringLiteralHelper);
    return temp;
}

CORINFO_MODULE_HANDLE WrapICorJitInfo::embedModuleHandle(
          CORINFO_MODULE_HANDLE handle,
          void** ppIndirection)
{
    API_ENTER(embedModuleHandle);
    CORINFO_MODULE_HANDLE temp = wrapHnd->embedModuleHandle(handle, ppIndirection);
    API_LEAVE(embedModuleHandle);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::embedClassHandle(
          CORINFO_CLASS_HANDLE handle,
          void** ppIndirection)
{
    API_ENTER(embedClassHandle);
    CORINFO_CLASS_HANDLE temp = wrapHnd->embedClassHandle(handle, ppIndirection);
    API_LEAVE(embedClassHandle);
    return temp;
}

CORINFO_METHOD_HANDLE WrapICorJitInfo::embedMethodHandle(
          CORINFO_METHOD_HANDLE handle,
          void** ppIndirection)
{
    API_ENTER(embedMethodHandle);
    CORINFO_METHOD_HANDLE temp = wrapHnd->embedMethodHandle(handle, ppIndirection);
    API_LEAVE(embedMethodHandle);
    return temp;
}

CORINFO_FIELD_HANDLE WrapICorJitInfo::embedFieldHandle(
          CORINFO_FIELD_HANDLE handle,
          void** ppIndirection)
{
    API_ENTER(embedFieldHandle);
    CORINFO_FIELD_HANDLE temp = wrapHnd->embedFieldHandle(handle, ppIndirection);
    API_LEAVE(embedFieldHandle);
    return temp;
}

void WrapICorJitInfo::embedGenericHandle(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool fEmbedParent,
          CORINFO_GENERICHANDLE_RESULT* pResult)
{
    API_ENTER(embedGenericHandle);
    wrapHnd->embedGenericHandle(pResolvedToken, fEmbedParent, pResult);
    API_LEAVE(embedGenericHandle);
}

void WrapICorJitInfo::getLocationOfThisType(
          CORINFO_METHOD_HANDLE context,
          CORINFO_LOOKUP_KIND* pLookupKind)
{
    API_ENTER(getLocationOfThisType);
    wrapHnd->getLocationOfThisType(context, pLookupKind);
    API_LEAVE(getLocationOfThisType);
}

void WrapICorJitInfo::getAddressOfPInvokeTarget(
          CORINFO_METHOD_HANDLE method,
          CORINFO_CONST_LOOKUP* pLookup)
{
    API_ENTER(getAddressOfPInvokeTarget);
    wrapHnd->getAddressOfPInvokeTarget(method, pLookup);
    API_LEAVE(getAddressOfPInvokeTarget);
}

void* WrapICorJitInfo::GetCookieForPInvokeCalliSig(
          CORINFO_SIG_INFO* szMetaSig,
          void** ppIndirection)
{
    API_ENTER(GetCookieForPInvokeCalliSig);
    void* temp = wrapHnd->GetCookieForPInvokeCalliSig(szMetaSig, ppIndirection);
    API_LEAVE(GetCookieForPInvokeCalliSig);
    return temp;
}

bool WrapICorJitInfo::canGetCookieForPInvokeCalliSig(
          CORINFO_SIG_INFO* szMetaSig)
{
    API_ENTER(canGetCookieForPInvokeCalliSig);
    bool temp = wrapHnd->canGetCookieForPInvokeCalliSig(szMetaSig);
    API_LEAVE(canGetCookieForPInvokeCalliSig);
    return temp;
}

CORINFO_JUST_MY_CODE_HANDLE WrapICorJitInfo::getJustMyCodeHandle(
          CORINFO_METHOD_HANDLE method,
          CORINFO_JUST_MY_CODE_HANDLE** ppIndirection)
{
    API_ENTER(getJustMyCodeHandle);
    CORINFO_JUST_MY_CODE_HANDLE temp = wrapHnd->getJustMyCodeHandle(method, ppIndirection);
    API_LEAVE(getJustMyCodeHandle);
    return temp;
}

void WrapICorJitInfo::GetProfilingHandle(
          bool* pbHookFunction,
          void** pProfilerHandle,
          bool* pbIndirectedHandles)
{
    API_ENTER(GetProfilingHandle);
    wrapHnd->GetProfilingHandle(pbHookFunction, pProfilerHandle, pbIndirectedHandles);
    API_LEAVE(GetProfilingHandle);
}

void WrapICorJitInfo::getCallInfo(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_RESOLVED_TOKEN* pConstrainedResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_CALLINFO_FLAGS flags,
          CORINFO_CALL_INFO* pResult)
{
    API_ENTER(getCallInfo);
    wrapHnd->getCallInfo(pResolvedToken, pConstrainedResolvedToken, callerHandle, flags, pResult);
    API_LEAVE(getCallInfo);
}

bool WrapICorJitInfo::canAccessFamily(
          CORINFO_METHOD_HANDLE hCaller,
          CORINFO_CLASS_HANDLE hInstanceType)
{
    API_ENTER(canAccessFamily);
    bool temp = wrapHnd->canAccessFamily(hCaller, hInstanceType);
    API_LEAVE(canAccessFamily);
    return temp;
}

bool WrapICorJitInfo::isRIDClassDomainID(
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(isRIDClassDomainID);
    bool temp = wrapHnd->isRIDClassDomainID(cls);
    API_LEAVE(isRIDClassDomainID);
    return temp;
}

unsigned WrapICorJitInfo::getClassDomainID(
          CORINFO_CLASS_HANDLE cls,
          void** ppIndirection)
{
    API_ENTER(getClassDomainID);
    unsigned temp = wrapHnd->getClassDomainID(cls, ppIndirection);
    API_LEAVE(getClassDomainID);
    return temp;
}

void* WrapICorJitInfo::getFieldAddress(
          CORINFO_FIELD_HANDLE field,
          void** ppIndirection)
{
    API_ENTER(getFieldAddress);
    void* temp = wrapHnd->getFieldAddress(field, ppIndirection);
    API_LEAVE(getFieldAddress);
    return temp;
}

CORINFO_CLASS_HANDLE WrapICorJitInfo::getStaticFieldCurrentClass(
          CORINFO_FIELD_HANDLE field,
          bool* pIsSpeculative)
{
    API_ENTER(getStaticFieldCurrentClass);
    CORINFO_CLASS_HANDLE temp = wrapHnd->getStaticFieldCurrentClass(field, pIsSpeculative);
    API_LEAVE(getStaticFieldCurrentClass);
    return temp;
}

CORINFO_VARARGS_HANDLE WrapICorJitInfo::getVarArgsHandle(
          CORINFO_SIG_INFO* pSig,
          void** ppIndirection)
{
    API_ENTER(getVarArgsHandle);
    CORINFO_VARARGS_HANDLE temp = wrapHnd->getVarArgsHandle(pSig, ppIndirection);
    API_LEAVE(getVarArgsHandle);
    return temp;
}

bool WrapICorJitInfo::canGetVarArgsHandle(
          CORINFO_SIG_INFO* pSig)
{
    API_ENTER(canGetVarArgsHandle);
    bool temp = wrapHnd->canGetVarArgsHandle(pSig);
    API_LEAVE(canGetVarArgsHandle);
    return temp;
}

InfoAccessType WrapICorJitInfo::constructStringLiteral(
          CORINFO_MODULE_HANDLE module,
          mdToken metaTok,
          void** ppValue)
{
    API_ENTER(constructStringLiteral);
    InfoAccessType temp = wrapHnd->constructStringLiteral(module, metaTok, ppValue);
    API_LEAVE(constructStringLiteral);
    return temp;
}

InfoAccessType WrapICorJitInfo::emptyStringLiteral(
          void** ppValue)
{
    API_ENTER(emptyStringLiteral);
    InfoAccessType temp = wrapHnd->emptyStringLiteral(ppValue);
    API_LEAVE(emptyStringLiteral);
    return temp;
}

uint32_t WrapICorJitInfo::getFieldThreadLocalStoreID(
          CORINFO_FIELD_HANDLE field,
          void** ppIndirection)
{
    API_ENTER(getFieldThreadLocalStoreID);
    uint32_t temp = wrapHnd->getFieldThreadLocalStoreID(field, ppIndirection);
    API_LEAVE(getFieldThreadLocalStoreID);
    return temp;
}

void WrapICorJitInfo::setOverride(
          ICorDynamicInfo* pOverride,
          CORINFO_METHOD_HANDLE currentMethod)
{
    API_ENTER(setOverride);
    wrapHnd->setOverride(pOverride, currentMethod);
    API_LEAVE(setOverride);
}

void WrapICorJitInfo::addActiveDependency(
          CORINFO_MODULE_HANDLE moduleFrom,
          CORINFO_MODULE_HANDLE moduleTo)
{
    API_ENTER(addActiveDependency);
    wrapHnd->addActiveDependency(moduleFrom, moduleTo);
    API_LEAVE(addActiveDependency);
}

CORINFO_METHOD_HANDLE WrapICorJitInfo::GetDelegateCtor(
          CORINFO_METHOD_HANDLE methHnd,
          CORINFO_CLASS_HANDLE clsHnd,
          CORINFO_METHOD_HANDLE targetMethodHnd,
          DelegateCtorArgs* pCtorData)
{
    API_ENTER(GetDelegateCtor);
    CORINFO_METHOD_HANDLE temp = wrapHnd->GetDelegateCtor(methHnd, clsHnd, targetMethodHnd, pCtorData);
    API_LEAVE(GetDelegateCtor);
    return temp;
}

void WrapICorJitInfo::MethodCompileComplete(
          CORINFO_METHOD_HANDLE methHnd)
{
    API_ENTER(MethodCompileComplete);
    wrapHnd->MethodCompileComplete(methHnd);
    API_LEAVE(MethodCompileComplete);
}

bool WrapICorJitInfo::getTailCallHelpers(
          CORINFO_RESOLVED_TOKEN* callToken,
          CORINFO_SIG_INFO* sig,
          CORINFO_GET_TAILCALL_HELPERS_FLAGS flags,
          CORINFO_TAILCALL_HELPERS* pResult)
{
    API_ENTER(getTailCallHelpers);
    bool temp = wrapHnd->getTailCallHelpers(callToken, sig, flags, pResult);
    API_LEAVE(getTailCallHelpers);
    return temp;
}

bool WrapICorJitInfo::convertPInvokeCalliToCall(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool mustConvert)
{
    API_ENTER(convertPInvokeCalliToCall);
    bool temp = wrapHnd->convertPInvokeCalliToCall(pResolvedToken, mustConvert);
    API_LEAVE(convertPInvokeCalliToCall);
    return temp;
}

bool WrapICorJitInfo::notifyInstructionSetUsage(
          CORINFO_InstructionSet instructionSet,
          bool supportEnabled)
{
    API_ENTER(notifyInstructionSetUsage);
    bool temp = wrapHnd->notifyInstructionSetUsage(instructionSet, supportEnabled);
    API_LEAVE(notifyInstructionSetUsage);
    return temp;
}

void WrapICorJitInfo::allocMem(
          AllocMemArgs* pArgs)
{
    API_ENTER(allocMem);
    wrapHnd->allocMem(pArgs);
    API_LEAVE(allocMem);
}

void WrapICorJitInfo::reserveUnwindInfo(
          bool isFunclet,
          bool isColdCode,
          uint32_t unwindSize)
{
    API_ENTER(reserveUnwindInfo);
    wrapHnd->reserveUnwindInfo(isFunclet, isColdCode, unwindSize);
    API_LEAVE(reserveUnwindInfo);
}

void WrapICorJitInfo::allocUnwindInfo(
          uint8_t* pHotCode,
          uint8_t* pColdCode,
          uint32_t startOffset,
          uint32_t endOffset,
          uint32_t unwindSize,
          uint8_t* pUnwindBlock,
          CorJitFuncKind funcKind)
{
    API_ENTER(allocUnwindInfo);
    wrapHnd->allocUnwindInfo(pHotCode, pColdCode, startOffset, endOffset, unwindSize, pUnwindBlock, funcKind);
    API_LEAVE(allocUnwindInfo);
}

void* WrapICorJitInfo::allocGCInfo(
          size_t size)
{
    API_ENTER(allocGCInfo);
    void* temp = wrapHnd->allocGCInfo(size);
    API_LEAVE(allocGCInfo);
    return temp;
}

void WrapICorJitInfo::setEHcount(
          unsigned cEH)
{
    API_ENTER(setEHcount);
    wrapHnd->setEHcount(cEH);
    API_LEAVE(setEHcount);
}

void WrapICorJitInfo::setEHinfo(
          unsigned EHnumber,
          const CORINFO_EH_CLAUSE* clause)
{
    API_ENTER(setEHinfo);
    wrapHnd->setEHinfo(EHnumber, clause);
    API_LEAVE(setEHinfo);
}

bool WrapICorJitInfo::logMsg(
          unsigned level,
          const char* fmt,
          va_list args)
{
    API_ENTER(logMsg);
    bool temp = wrapHnd->logMsg(level, fmt, args);
    API_LEAVE(logMsg);
    return temp;
}

int WrapICorJitInfo::doAssert(
          const char* szFile,
          int iLine,
          const char* szExpr)
{
    API_ENTER(doAssert);
    int temp = wrapHnd->doAssert(szFile, iLine, szExpr);
    API_LEAVE(doAssert);
    return temp;
}

void WrapICorJitInfo::reportFatalError(
          CorJitResult result)
{
    API_ENTER(reportFatalError);
    wrapHnd->reportFatalError(result);
    API_LEAVE(reportFatalError);
}

JITINTERFACE_HRESULT WrapICorJitInfo::getPgoInstrumentationResults(
          CORINFO_METHOD_HANDLE ftnHnd,
          ICorJitInfo::PgoInstrumentationSchema** pSchema,
          uint32_t* pCountSchemaItems,
          uint8_t** pInstrumentationData,
          ICorJitInfo::PgoSource* pgoSource)
{
    API_ENTER(getPgoInstrumentationResults);
    JITINTERFACE_HRESULT temp = wrapHnd->getPgoInstrumentationResults(ftnHnd, pSchema, pCountSchemaItems, pInstrumentationData, pgoSource);
    API_LEAVE(getPgoInstrumentationResults);
    return temp;
}

JITINTERFACE_HRESULT WrapICorJitInfo::allocPgoInstrumentationBySchema(
          CORINFO_METHOD_HANDLE ftnHnd,
          ICorJitInfo::PgoInstrumentationSchema* pSchema,
          uint32_t countSchemaItems,
          uint8_t** pInstrumentationData)
{
    API_ENTER(allocPgoInstrumentationBySchema);
    JITINTERFACE_HRESULT temp = wrapHnd->allocPgoInstrumentationBySchema(ftnHnd, pSchema, countSchemaItems, pInstrumentationData);
    API_LEAVE(allocPgoInstrumentationBySchema);
    return temp;
}

void WrapICorJitInfo::recordCallSite(
          uint32_t instrOffset,
          CORINFO_SIG_INFO* callSig,
          CORINFO_METHOD_HANDLE methodHandle)
{
    API_ENTER(recordCallSite);
    wrapHnd->recordCallSite(instrOffset, callSig, methodHandle);
    API_LEAVE(recordCallSite);
}

void WrapICorJitInfo::recordRelocation(
          void* location,
          void* locationRW,
          void* target,
          uint16_t fRelocType,
          uint16_t slotNum,
          int32_t addlDelta)
{
    API_ENTER(recordRelocation);
    wrapHnd->recordRelocation(location, locationRW, target, fRelocType, slotNum, addlDelta);
    API_LEAVE(recordRelocation);
}

uint16_t WrapICorJitInfo::getRelocTypeHint(
          void* target)
{
    API_ENTER(getRelocTypeHint);
    uint16_t temp = wrapHnd->getRelocTypeHint(target);
    API_LEAVE(getRelocTypeHint);
    return temp;
}

uint32_t WrapICorJitInfo::getExpectedTargetArchitecture()
{
    API_ENTER(getExpectedTargetArchitecture);
    uint32_t temp = wrapHnd->getExpectedTargetArchitecture();
    API_LEAVE(getExpectedTargetArchitecture);
    return temp;
}

uint32_t WrapICorJitInfo::getJitFlags(
          CORJIT_FLAGS* flags,
          uint32_t sizeInBytes)
{
    API_ENTER(getJitFlags);
    uint32_t temp = wrapHnd->getJitFlags(flags, sizeInBytes);
    API_LEAVE(getJitFlags);
    return temp;
}

bool WrapICorJitInfo::doesFieldBelongToClass(
          CORINFO_FIELD_HANDLE fldHnd,
          CORINFO_CLASS_HANDLE cls)
{
    API_ENTER(doesFieldBelongToClass);
    bool temp = wrapHnd->doesFieldBelongToClass(fldHnd, cls);
    API_LEAVE(doesFieldBelongToClass);
    return temp;
}

/**********************************************************************************/
// clang-format on
/**********************************************************************************/
