static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (pattern, _(\"Bayer pattern\"), 0)                               \n"
"   description (_(\"Bayer pattern used, 0 seems to work for some nikon files, 2 for some Fuji files.\"))\n"
"   value_range (0, 3)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE demosaic-simple.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"demosaic (GeglProperties          *op,                                        \n"
"          GeglBuffer          *src,                                           \n"
"          const GeglRectangle *src_rect,                                      \n"
"          GeglBuffer          *dst,                                           \n"
"          const GeglRectangle *dst_rect)                                      \n"
"{                                                                             \n"
"  gint x,y;                                                                   \n"
"  gint offset;                                                                \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, src_rect->width * src_rect->height * 1);          \n"
"  dst_buf = g_new0 (gfloat, dst_rect->width * dst_rect->height * 3);          \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0, babl_format (\"Y float\"), src_buf,    \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  offset=0;                                                                   \n"
"  for (y=src_rect->y; y < dst_rect->height + src_rect->y; y++)                \n"
"    {                                                                         \n"
"      gint src_offset = (y-src_rect->y) * src_rect->width;                    \n"
"      for (x=src_rect->x; x < dst_rect->width + src_rect->x; x++)             \n"
"        {                                                                     \n"
"          gfloat red=0.0;                                                     \n"
"          gfloat green=0.0;                                                   \n"
"          gfloat blue=0.0;                                                    \n"
"                                                                              \n"
"          if (y<dst_rect->height+dst_rect->y &&                               \n"
"              x<dst_rect->width+dst_rect->x)                                  \n"
"            {                                                                 \n"
"          if ((y + op->pattern%2)%2==0)                                       \n"
"            {                                                                 \n"
"              if ((x+op->pattern/2)%2==1)                                     \n"
"                {                                                             \n"
"                  blue=src_buf[src_offset+1];                                 \n"
"                  green=src_buf[src_offset];                                  \n"
"                  red=src_buf[src_offset + src_rect->width];                  \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  blue=src_buf[src_offset];                                   \n"
"                  green=src_buf[src_offset+1];                                \n"
"                  red=src_buf[src_offset+1+src_rect->width];                  \n"
"                }                                                             \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              if ((x+op->pattern/2)%2==1)                                     \n"
"                {                                                             \n"
"                  blue=src_buf[src_offset + src_rect->width + 1];             \n"
"                  green=src_buf[src_offset + 1];                              \n"
"                  red=src_buf[src_offset];                                    \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  blue=src_buf[src_offset + src_rect->width];                 \n"
"                  green=src_buf[src_offset];                                  \n"
"                  red=src_buf[src_offset + 1];                                \n"
"                }                                                             \n"
"            }                                                                 \n"
"          }                                                                   \n"
"                                                                              \n"
"          dst_buf [offset*3+0] = red;                                         \n"
"          dst_buf [offset*3+1] = green;                                       \n"
"          dst_buf [offset*3+2] = blue;                                        \n"
"                                                                              \n"
"          offset++;                                                           \n"
"          src_offset++;                                                       \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (dst, dst_rect, 0, babl_format (\"RGB float\"), dst_buf, GEGL_AUTO_ROWSTRIDE);\n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  area->right = area->bottom = 1;                                             \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGB float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle compute = gegl_operation_get_required_for_output (operation, \"input\", result);\n"
"                                                                              \n"
"  demosaic (o, input, &compute, output, result);                              \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\"        , \"gegl:demosaic-simple\",                                 \n"
"  \"categories\"  , \"blur\",                                                 \n"
"  \"description\" ,                                                           \n"
"        _(\"Performs a naive grayscale2color demosaicing of an image, no interpolation.\"),\n"
"        NULL);                                                                \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
