; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -attributor -enable-new-pm=0 -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=15 -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_CGSCC_NPM,NOT_CGSCC_OPM,NOT_TUNIT_NPM,IS__TUNIT____,IS________OPM,IS__TUNIT_OPM
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=15 -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_CGSCC_OPM,NOT_CGSCC_NPM,NOT_TUNIT_OPM,IS__TUNIT____,IS________NPM,IS__TUNIT_NPM
; RUN: opt -attributor-cgscc -enable-new-pm=0 -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_TUNIT_NPM,NOT_TUNIT_OPM,NOT_CGSCC_NPM,IS__CGSCC____,IS________OPM,IS__CGSCC_OPM
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_TUNIT_NPM,NOT_TUNIT_OPM,NOT_CGSCC_OPM,IS__CGSCC____,IS________NPM,IS__CGSCC_NPM


target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

declare nonnull i8* @ret_nonnull()
declare void @llvm.assume(i1)

; Return a pointer trivially nonnull (call return attribute)
define i8* @test1() {
; CHECK-LABEL: define {{[^@]+}}@test1() {
; CHECK-NEXT:    [[RET:%.*]] = call nonnull i8* @ret_nonnull()
; CHECK-NEXT:    ret i8* [[RET]]
;
  %ret = call i8* @ret_nonnull()
  ret i8* %ret
}

; Return a pointer trivially nonnull (argument attribute)
define i8* @test2(i8* nonnull %p) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@test2
; CHECK-SAME: (i8* nofree nonnull readnone returned "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    ret i8* [[P]]
;
  ret i8* %p
}

define i8* @test2A(i1 %c, i8* %ret) {
; CHECK: Function Attrs: inaccessiblememonly nofree norecurse nosync nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@test2A
; CHECK-SAME: (i1 [[C:%.*]], i8* nofree nonnull readnone returned "no-capture-maybe-returned" [[RET:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    br i1 [[C]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    call void @llvm.assume(i1 noundef true) #[[ATTR13:[0-9]+]] [ "nonnull"(i8* [[RET]]) ]
; CHECK-NEXT:    ret i8* [[RET]]
; CHECK:       B:
; CHECK-NEXT:    call void @llvm.assume(i1 noundef true) #[[ATTR13]] [ "nonnull"(i8* [[RET]]) ]
; CHECK-NEXT:    ret i8* [[RET]]
;
  br i1 %c, label %A, label %B
A:
  call void @llvm.assume(i1 true) [ "nonnull"(i8* %ret) ]
  ret i8* %ret
B:
  call void @llvm.assume(i1 true) [ "nonnull"(i8* %ret) ]
  ret i8* %ret
}

define i8* @test2B(i1 %c, i8* %ret) {
; CHECK: Function Attrs: inaccessiblememonly nofree norecurse nosync nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@test2B
; CHECK-SAME: (i1 [[C:%.*]], i8* nofree nonnull readnone returned dereferenceable(4) "no-capture-maybe-returned" [[RET:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    br i1 [[C]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    call void @llvm.assume(i1 noundef true) #[[ATTR13]] [ "dereferenceable"(i8* [[RET]], i32 4) ]
; CHECK-NEXT:    ret i8* [[RET]]
; CHECK:       B:
; CHECK-NEXT:    call void @llvm.assume(i1 noundef true) #[[ATTR13]] [ "dereferenceable"(i8* [[RET]], i32 4) ]
; CHECK-NEXT:    ret i8* [[RET]]
;
  br i1 %c, label %A, label %B
A:
  call void @llvm.assume(i1 true) [ "dereferenceable"(i8* %ret, i32 4) ]
  ret i8* %ret
B:
  call void @llvm.assume(i1 true) [ "dereferenceable"(i8* %ret, i32 4) ]
  ret i8* %ret
}

; Given an SCC where one of the functions can not be marked nonnull,
; can we still mark the other one which is trivially nonnull
define i8* @scc_binder(i1 %c) {
; IS________OPM-LABEL: define {{[^@]+}}@scc_binder
; IS________OPM-SAME: (i1 [[C:%.*]]) {
; IS________OPM-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; IS________OPM:       rec:
; IS________OPM-NEXT:    [[TMP1:%.*]] = call i8* @test3(i1 [[C]])
; IS________OPM-NEXT:    br label [[END]]
; IS________OPM:       end:
; IS________OPM-NEXT:    ret i8* null
;
; IS________NPM-LABEL: define {{[^@]+}}@scc_binder
; IS________NPM-SAME: (i1 [[C:%.*]]) {
; IS________NPM-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; IS________NPM:       rec:
; IS________NPM-NEXT:    [[TMP1:%.*]] = call i8* @test3(i1 noundef [[C]])
; IS________NPM-NEXT:    br label [[END]]
; IS________NPM:       end:
; IS________NPM-NEXT:    ret i8* null
;
  br i1 %c, label %rec, label %end
rec:
  call i8* @test3(i1 %c)
  br label %end
end:
  ret i8* null
}

define i8* @test3(i1 %c) {
; CHECK-LABEL: define {{[^@]+}}@test3
; CHECK-SAME: (i1 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8* @scc_binder(i1 [[C]])
; CHECK-NEXT:    [[RET:%.*]] = call nonnull i8* @ret_nonnull()
; CHECK-NEXT:    ret i8* [[RET]]
;
  call i8* @scc_binder(i1 %c)
  %ret = call i8* @ret_nonnull()
  ret i8* %ret
}

; Given a mutual recursive set of functions, we can mark them
; nonnull if neither can ever return null.  (In this case, they
; just never return period.)
define i8* @test4_helper() {
; NOT_CGSCC_NPM: Function Attrs: nofree nosync nounwind readnone willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@test4_helper
; NOT_CGSCC_NPM-SAME: () #[[ATTR3:[0-9]+]] {
; NOT_CGSCC_NPM-NEXT:    ret i8* undef
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@test4_helper
; IS__CGSCC_NPM-SAME: () #[[ATTR1]] {
; IS__CGSCC_NPM-NEXT:    ret i8* undef
;
  %ret = call i8* @test4()
  ret i8* %ret
}

define i8* @test4() {
; NOT_CGSCC_NPM: Function Attrs: nofree nosync nounwind readnone willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@test4
; NOT_CGSCC_NPM-SAME: () #[[ATTR3]] {
; NOT_CGSCC_NPM-NEXT:    ret i8* undef
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@test4
; IS__CGSCC_NPM-SAME: () #[[ATTR1]] {
; IS__CGSCC_NPM-NEXT:    ret i8* undef
;
  %ret = call i8* @test4_helper()
  ret i8* %ret
}

; Given a mutual recursive set of functions which *can* return null
; make sure we haven't marked them as nonnull.
define i8* @test5_helper(i1 %c) {
; NOT_CGSCC_NPM: Function Attrs: nofree nosync nounwind readnone willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@test5_helper
; NOT_CGSCC_NPM-SAME: (i1 [[C:%.*]]) #[[ATTR3]] {
; NOT_CGSCC_NPM-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; NOT_CGSCC_NPM:       rec:
; NOT_CGSCC_NPM-NEXT:    br label [[END]]
; NOT_CGSCC_NPM:       end:
; NOT_CGSCC_NPM-NEXT:    ret i8* null
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@test5_helper
; IS__CGSCC_NPM-SAME: (i1 [[C:%.*]]) #[[ATTR1]] {
; IS__CGSCC_NPM-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; IS__CGSCC_NPM:       rec:
; IS__CGSCC_NPM-NEXT:    br label [[END]]
; IS__CGSCC_NPM:       end:
; IS__CGSCC_NPM-NEXT:    ret i8* null
;
  br i1 %c, label %rec, label %end
rec:
  %ret = call i8* @test5(i1 %c)
  br label %end
end:
  ret i8* null
}

define i8* @test5(i1 %c) {
; NOT_CGSCC_NPM: Function Attrs: nofree nosync nounwind readnone willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@test5
; NOT_CGSCC_NPM-SAME: (i1 [[C:%.*]]) #[[ATTR3]] {
; NOT_CGSCC_NPM-NEXT:    ret i8* null
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@test5
; IS__CGSCC_NPM-SAME: (i1 [[C:%.*]]) #[[ATTR1]] {
; IS__CGSCC_NPM-NEXT:    ret i8* null
;
  %ret = call i8* @test5_helper(i1 %c)
  ret i8* %ret
}

; Local analysis, but going through a self recursive phi
define i8* @test6a() {
;
; NOT_CGSCC_NPM: Function Attrs: noreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@test6a
; NOT_CGSCC_NPM-SAME: () #[[ATTR4:[0-9]+]] {
; NOT_CGSCC_NPM-NEXT:  entry:
; NOT_CGSCC_NPM-NEXT:    [[RET:%.*]] = call i8* @ret_nonnull()
; NOT_CGSCC_NPM-NEXT:    br label [[LOOP:%.*]]
; NOT_CGSCC_NPM:       loop:
; NOT_CGSCC_NPM-NEXT:    unreachable
; NOT_CGSCC_NPM:       exit:
; NOT_CGSCC_NPM-NEXT:    unreachable
;
; IS__CGSCC_NPM: Function Attrs: noreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@test6a
; IS__CGSCC_NPM-SAME: () #[[ATTR3:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[RET:%.*]] = call i8* @ret_nonnull()
; IS__CGSCC_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_NPM:       loop:
; IS__CGSCC_NPM-NEXT:    unreachable
; IS__CGSCC_NPM:       exit:
; IS__CGSCC_NPM-NEXT:    unreachable
;
entry:
  %ret = call i8* @ret_nonnull()
  br label %loop
loop:
  %phi = phi i8* [%ret, %entry], [%phi, %loop]
  br i1 undef, label %loop, label %exit
exit:
  ret i8* %phi
}

define i8* @test6b(i1 %c) {
; IS________OPM-LABEL: define {{[^@]+}}@test6b
; IS________OPM-SAME: (i1 [[C:%.*]]) {
; IS________OPM-NEXT:  entry:
; IS________OPM-NEXT:    [[RET:%.*]] = call nonnull i8* @ret_nonnull()
; IS________OPM-NEXT:    br label [[LOOP:%.*]]
; IS________OPM:       loop:
; IS________OPM-NEXT:    [[PHI:%.*]] = phi i8* [ [[RET]], [[ENTRY:%.*]] ], [ [[PHI]], [[LOOP]] ]
; IS________OPM-NEXT:    br i1 [[C]], label [[LOOP]], label [[EXIT:%.*]]
; IS________OPM:       exit:
; IS________OPM-NEXT:    ret i8* [[PHI]]
;
; IS________NPM-LABEL: define {{[^@]+}}@test6b
; IS________NPM-SAME: (i1 [[C:%.*]]) {
; IS________NPM-NEXT:  entry:
; IS________NPM-NEXT:    [[RET:%.*]] = call nonnull i8* @ret_nonnull()
; IS________NPM-NEXT:    br label [[LOOP:%.*]]
; IS________NPM:       loop:
; IS________NPM-NEXT:    [[PHI:%.*]] = phi i8* [ [[RET]], [[ENTRY:%.*]] ], [ [[RET]], [[LOOP]] ]
; IS________NPM-NEXT:    br i1 [[C]], label [[LOOP]], label [[EXIT:%.*]]
; IS________NPM:       exit:
; IS________NPM-NEXT:    ret i8* [[RET]]
;
entry:
  %ret = call i8* @ret_nonnull()
  br label %loop
loop:
  %phi = phi i8* [%ret, %entry], [%phi, %loop]
  br i1 %c, label %loop, label %exit
exit:
  ret i8* %phi
}

define i8* @test7(i8* %a) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@test7
; CHECK-SAME: (i8* nofree readnone returned "no-capture-maybe-returned" [[A:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    ret i8* [[A]]
;
  %b = getelementptr inbounds i8, i8* %a, i64 0
  ret i8* %b
}

define i8* @test8(i8* %a) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@test8
; CHECK-SAME: (i8* nofree readnone "no-capture-maybe-returned" [[A:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds i8, i8* [[A]], i64 1
; CHECK-NEXT:    ret i8* [[B]]
;
  %b = getelementptr inbounds i8, i8* %a, i64 1
  ret i8* %b
}

define i8* @test9(i8* %a, i64 %n) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@test9
; CHECK-SAME: (i8* nofree readnone "no-capture-maybe-returned" [[A:%.*]], i64 [[N:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds i8, i8* [[A]], i64 [[N]]
; CHECK-NEXT:    ret i8* [[B]]
;
  %b = getelementptr inbounds i8, i8* %a, i64 %n
  ret i8* %b
}

; ATTRIBUTOR_OPM: define i8* @test10
; ATTRIBUTOR_NPM: define nonnull i8* @test10
define i8* @test10(i8* %a, i64 %n) {
; CHECK: Function Attrs: inaccessiblememonly nofree norecurse nosync nounwind willreturn
; CHECK-LABEL: define {{[^@]+}}@test10
; CHECK-SAME: (i8* nofree readnone "no-capture-maybe-returned" [[A:%.*]], i64 [[N:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[N]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 noundef [[CMP]]) #[[ATTR13]]
; CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds i8, i8* [[A]], i64 [[N]]
; CHECK-NEXT:    ret i8* [[B]]
;
  %cmp = icmp ne i64 %n, 0
  call void @llvm.assume(i1 %cmp)
  %b = getelementptr inbounds i8, i8* %a, i64 %n
  ret i8* %b
}

; TEST 11
; char* test11(char *p) {
;   return p? p: nonnull();
; }
; FIXME: missing nonnull
define i8* @test11(i8*) local_unnamed_addr {
; CHECK-LABEL: define {{[^@]+}}@test11
; CHECK-SAME: (i8* [[TMP0:%.*]]) local_unnamed_addr {
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8* [[TMP0]], null
; CHECK-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP5:%.*]]
; CHECK:       3:
; CHECK-NEXT:    [[TMP4:%.*]] = tail call i8* @ret_nonnull()
; CHECK-NEXT:    br label [[TMP5]]
; CHECK:       5:
; CHECK-NEXT:    [[TMP6:%.*]] = phi i8* [ [[TMP4]], [[TMP3]] ], [ [[TMP0]], [[TMP1:%.*]] ]
; CHECK-NEXT:    ret i8* [[TMP6]]
;
  %2 = icmp eq i8* %0, null
  br i1 %2, label %3, label %5

; <label>:3:                                      ; preds = %1
  %4 = tail call i8* @ret_nonnull()
  br label %5

; <label>:5:                                      ; preds = %3, %1
  %6 = phi i8* [ %4, %3 ], [ %0, %1 ]
  ret i8* %6
}

; TEST 12
; Simple CallSite Test
declare void @test12_helper(i8*)
define void @test12(i8* nonnull %a) {
; CHECK-LABEL: define {{[^@]+}}@test12
; CHECK-SAME: (i8* nonnull [[A:%.*]]) {
; CHECK-NEXT:    tail call void @test12_helper(i8* nonnull [[A]])
; CHECK-NEXT:    ret void
;
  tail call void @test12_helper(i8* %a)
  ret void
}

; TEST 13
; Simple Argument Tests
declare i8* @unknown()
define void @test13_helper() {
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@test13_helper() {
; NOT_CGSCC_NPM-NEXT:    [[NONNULLPTR:%.*]] = tail call nonnull i8* @ret_nonnull()
; NOT_CGSCC_NPM-NEXT:    [[MAYBENULLPTR:%.*]] = tail call i8* @unknown()
; NOT_CGSCC_NPM-NEXT:    tail call void @test13(i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]], i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]], i8* noalias nocapture nofree readnone [[MAYBENULLPTR]]) #[[ATTR5:[0-9]+]]
; NOT_CGSCC_NPM-NEXT:    tail call void @test13(i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]], i8* noalias nocapture nofree readnone [[MAYBENULLPTR]], i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@test13_helper() {
; IS__CGSCC_NPM-NEXT:    [[NONNULLPTR:%.*]] = tail call nonnull i8* @ret_nonnull()
; IS__CGSCC_NPM-NEXT:    [[MAYBENULLPTR:%.*]] = tail call i8* @unknown()
; IS__CGSCC_NPM-NEXT:    tail call void @test13(i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]], i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]], i8* noalias nocapture nofree readnone [[MAYBENULLPTR]]) #[[ATTR4:[0-9]+]]
; IS__CGSCC_NPM-NEXT:    tail call void @test13(i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]], i8* noalias nocapture nofree readnone [[MAYBENULLPTR]], i8* noalias nocapture nofree nonnull readnone [[NONNULLPTR]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  %nonnullptr = tail call i8* @ret_nonnull()
  %maybenullptr = tail call i8* @unknown()
  tail call void @test13(i8* %nonnullptr, i8* %nonnullptr, i8* %maybenullptr)
  tail call void @test13(i8* %nonnullptr, i8* %maybenullptr, i8* %nonnullptr)
  ret void
}
define internal void @test13(i8* %a, i8* %b, i8* %c) {
;
; NOT_CGSCC_NPM: Function Attrs: nounwind
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@test13
; NOT_CGSCC_NPM-SAME: (i8* noalias nocapture nofree nonnull readnone [[A:%.*]], i8* noalias nocapture nofree readnone [[B:%.*]], i8* noalias nocapture nofree readnone [[C:%.*]]) #[[ATTR5]] {
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree readnone [[B]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree readnone [[C]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nounwind
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@test13
; IS__CGSCC_NPM-SAME: (i8* noalias nocapture nofree nonnull readnone [[A:%.*]], i8* noalias nocapture nofree readnone [[B:%.*]], i8* noalias nocapture nofree readnone [[C:%.*]]) #[[ATTR4]] {
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree readnone [[B]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree readnone [[C]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  call void @use_i8_ptr(i8* %a)
  call void @use_i8_ptr(i8* %b)
  call void @use_i8_ptr(i8* %c)
  ret void
}

declare nonnull i8* @nonnull()

; TEST 14
; Complex propagation
; Argument of f1, f2, f3 can be marked with nonnull.

; * Argument
; 1. In f1:bb6, %arg can be marked with nonnull because of the comparison in bb1
; 2. Because f2 is internal function, f2(i32* %arg) -> @f2(i32* nonnull %arg)
; 3. In f1:bb4 %tmp5 is nonnull and f3 is internal function.
;    Then, f3(i32* %arg) -> @f3(i32* nonnull %arg)
; 4. We get nonnull in whole f1 call sites so f1(i32* %arg) -> @f1(i32* nonnull %arg)


define internal i32* @f1(i32* %arg) {
; FIXME: missing nonnull It should be nonnull @f1(i32* nonnull readonly %arg)
; NOT_CGSCC_NPM: Function Attrs: argmemonly nofree nosync nounwind readonly
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@f1
; NOT_CGSCC_NPM-SAME: (i32* nofree readonly [[ARG:%.*]]) #[[ATTR6:[0-9]+]] {
; NOT_CGSCC_NPM-NEXT:  bb:
; NOT_CGSCC_NPM-NEXT:    [[TMP:%.*]] = icmp eq i32* [[ARG]], null
; NOT_CGSCC_NPM-NEXT:    br i1 [[TMP]], label [[BB9:%.*]], label [[BB1:%.*]]
; NOT_CGSCC_NPM:       bb1:
; NOT_CGSCC_NPM-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARG]], align 4
; NOT_CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[TMP2]], 0
; NOT_CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[BB6:%.*]], label [[BB4:%.*]]
; NOT_CGSCC_NPM:       bb4:
; NOT_CGSCC_NPM-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i32, i32* [[ARG]], i64 1
; NOT_CGSCC_NPM-NEXT:    [[TMP5B:%.*]] = tail call i32* @f3(i32* nofree nonnull readonly [[TMP5]]) #[[ATTR14:[0-9]+]]
; NOT_CGSCC_NPM-NEXT:    [[TMP5C:%.*]] = getelementptr inbounds i32, i32* [[TMP5B]], i64 -1
; NOT_CGSCC_NPM-NEXT:    br label [[BB9]]
; NOT_CGSCC_NPM:       bb6:
; NOT_CGSCC_NPM-NEXT:    [[TMP7:%.*]] = tail call i32* @f2(i32* nofree nonnull readonly align 4 dereferenceable(4) [[ARG]]) #[[ATTR14]]
; NOT_CGSCC_NPM-NEXT:    ret i32* [[TMP7]]
; NOT_CGSCC_NPM:       bb9:
; NOT_CGSCC_NPM-NEXT:    [[TMP10:%.*]] = phi i32* [ [[TMP5C]], [[BB4]] ], [ inttoptr (i64 4 to i32*), [[BB:%.*]] ]
; NOT_CGSCC_NPM-NEXT:    ret i32* [[TMP10]]
;
; IS__CGSCC_NPM: Function Attrs: argmemonly nofree nosync nounwind readonly
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@f1
; IS__CGSCC_NPM-SAME: (i32* nofree readonly [[ARG:%.*]]) #[[ATTR5:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:  bb:
; IS__CGSCC_NPM-NEXT:    [[TMP:%.*]] = icmp eq i32* [[ARG]], null
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP]], label [[BB9:%.*]], label [[BB1:%.*]]
; IS__CGSCC_NPM:       bb1:
; IS__CGSCC_NPM-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARG]], align 4
; IS__CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[TMP2]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[BB6:%.*]], label [[BB4:%.*]]
; IS__CGSCC_NPM:       bb4:
; IS__CGSCC_NPM-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i32, i32* [[ARG]], i64 1
; IS__CGSCC_NPM-NEXT:    [[TMP5B:%.*]] = tail call i32* @f3(i32* nofree nonnull readonly [[TMP5]]) #[[ATTR14:[0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[TMP5C:%.*]] = getelementptr inbounds i32, i32* [[TMP5B]], i64 -1
; IS__CGSCC_NPM-NEXT:    br label [[BB9]]
; IS__CGSCC_NPM:       bb6:
; IS__CGSCC_NPM-NEXT:    [[TMP7:%.*]] = tail call i32* @f2(i32* nofree nonnull readonly align 4 dereferenceable(4) [[ARG]]) #[[ATTR14]]
; IS__CGSCC_NPM-NEXT:    ret i32* [[TMP7]]
; IS__CGSCC_NPM:       bb9:
; IS__CGSCC_NPM-NEXT:    [[TMP10:%.*]] = phi i32* [ [[TMP5C]], [[BB4]] ], [ inttoptr (i64 4 to i32*), [[BB:%.*]] ]
; IS__CGSCC_NPM-NEXT:    ret i32* [[TMP10]]
;

bb:
  %tmp = icmp eq i32* %arg, null
  br i1 %tmp, label %bb9, label %bb1

bb1:                                              ; preds = %bb
  %tmp2 = load i32, i32* %arg, align 4
  %tmp3 = icmp eq i32 %tmp2, 0
  br i1 %tmp3, label %bb6, label %bb4

bb4:                                              ; preds = %bb1
  %tmp5 = getelementptr inbounds i32, i32* %arg, i64 1
  %tmp5b = tail call i32* @f3(i32* %tmp5)
  %tmp5c = getelementptr inbounds i32, i32* %tmp5b, i64 -1
  br label %bb9

bb6:                                              ; preds = %bb1
  %tmp7 = tail call i32* @f2(i32* %arg)
  ret i32* %tmp7

bb9:                                              ; preds = %bb4, %bb
  %tmp10 = phi i32* [ %tmp5c, %bb4 ], [ inttoptr (i64 4 to i32*), %bb ]
  ret i32* %tmp10
}

define internal i32* @f2(i32* %arg) {
; NOT_CGSCC_NPM: Function Attrs: argmemonly nofree nosync nounwind readonly
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@f2
; NOT_CGSCC_NPM-SAME: (i32* nofree nonnull readonly align 4 dereferenceable(4) [[ARG:%.*]]) #[[ATTR6]] {
; NOT_CGSCC_NPM-NEXT:  bb:
; NOT_CGSCC_NPM-NEXT:    [[TMP:%.*]] = tail call i32* @f1(i32* nofree readonly [[ARG]]) #[[ATTR14]]
; NOT_CGSCC_NPM-NEXT:    ret i32* [[TMP]]
;
; IS__CGSCC_NPM: Function Attrs: argmemonly nofree nosync nounwind readonly
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@f2
; IS__CGSCC_NPM-SAME: (i32* nofree nonnull readonly align 4 dereferenceable(4) [[ARG:%.*]]) #[[ATTR5]] {
; IS__CGSCC_NPM-NEXT:  bb:
; IS__CGSCC_NPM-NEXT:    [[TMP:%.*]] = tail call i32* @f1(i32* nofree readonly [[ARG]]) #[[ATTR14]]
; IS__CGSCC_NPM-NEXT:    ret i32* [[TMP]]
;
bb:
  %tmp = tail call i32* @f1(i32* %arg)
  ret i32* %tmp
}

define dso_local noalias i32* @f3(i32* %arg) {
; FIXME: missing nonnull. It should be nonnull @f3(i32* nonnull readonly %arg)
; NOT_CGSCC_NPM: Function Attrs: argmemonly nofree nosync nounwind readonly
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@f3
; NOT_CGSCC_NPM-SAME: (i32* nofree readonly [[ARG:%.*]]) #[[ATTR6]] {
; NOT_CGSCC_NPM-NEXT:  bb:
; NOT_CGSCC_NPM-NEXT:    [[TMP:%.*]] = call i32* @f1(i32* nofree readonly [[ARG]]) #[[ATTR14]]
; NOT_CGSCC_NPM-NEXT:    ret i32* [[TMP]]
;
; IS__CGSCC_NPM: Function Attrs: argmemonly nofree nosync nounwind readonly
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@f3
; IS__CGSCC_NPM-SAME: (i32* nofree readonly [[ARG:%.*]]) #[[ATTR5]] {
; IS__CGSCC_NPM-NEXT:  bb:
; IS__CGSCC_NPM-NEXT:    [[TMP:%.*]] = call i32* @f1(i32* nofree readonly [[ARG]]) #[[ATTR14]]
; IS__CGSCC_NPM-NEXT:    ret i32* [[TMP]]
;
bb:
; FIXME: missing nonnull. It should be @f1(i32* nonnull readonly %arg)
  %tmp = call i32* @f1(i32* %arg)
  ret i32* %tmp
}

; TEST 15
define void @f15(i8* %arg) {
; CHECK-LABEL: define {{[^@]+}}@f15
; CHECK-SAME: (i8* noundef nonnull dereferenceable(4) [[ARG:%.*]]) {
; CHECK-NEXT:    tail call void @use1(i8* noundef nonnull dereferenceable(4) [[ARG]])
; CHECK-NEXT:    ret void
;

  tail call void @use1(i8* dereferenceable(4) %arg)
  ret void
}

declare void @fun0() #1
declare void @fun1(i8*) #1
declare void @fun2(i8*, i8*) #1
declare void @fun3(i8*, i8*, i8*) #1
; TEST 16 simple path test
; if(..)
;   fun2(nonnull %a, nonnull %b)
; else
;   fun2(nonnull %a, %b)
; We can say that %a is nonnull but %b is not.
define void @f16(i8* %a, i8 * %b, i8 %c) {
; NOT_CGSCC_NPM: Function Attrs: nounwind willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@f16
; NOT_CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8* [[B:%.*]], i8 [[C:%.*]]) #[[ATTR7:[0-9]+]] {
; NOT_CGSCC_NPM-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; NOT_CGSCC_NPM-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; NOT_CGSCC_NPM:       if.then:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun2(i8* nonnull [[A]], i8* nonnull [[B]]) #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    ret void
; NOT_CGSCC_NPM:       if.else:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun2(i8* nonnull [[A]], i8* [[B]]) #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@f16
; IS__CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8* [[B:%.*]], i8 [[C:%.*]]) #[[ATTR6:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; IS__CGSCC_NPM:       if.then:
; IS__CGSCC_NPM-NEXT:    tail call void @fun2(i8* nonnull [[A]], i8* nonnull [[B]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    ret void
; IS__CGSCC_NPM:       if.else:
; IS__CGSCC_NPM-NEXT:    tail call void @fun2(i8* nonnull [[A]], i8* [[B]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  %cmp = icmp eq i8 %c, 0
  br i1 %cmp, label %if.then, label %if.else
if.then:
  tail call void @fun2(i8* nonnull %a, i8* nonnull %b)
  ret void
if.else:
  tail call void @fun2(i8* nonnull %a, i8* %b)
  ret void
}
; TEST 17 explore child BB test
; if(..)
;    ... (willreturn & nounwind)
; else
;    ... (willreturn & nounwind)
; fun1(nonnull %a)
; We can say that %a is nonnull
define void @f17(i8* %a, i8 %c) {
;
; NOT_CGSCC_NPM: Function Attrs: nounwind willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@f17
; NOT_CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8 [[C:%.*]]) #[[ATTR7]] {
; NOT_CGSCC_NPM-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; NOT_CGSCC_NPM-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; NOT_CGSCC_NPM:       if.then:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    br label [[CONT:%.*]]
; NOT_CGSCC_NPM:       if.else:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    br label [[CONT]]
; NOT_CGSCC_NPM:       cont:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[A]]) #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@f17
; IS__CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8 [[C:%.*]]) #[[ATTR6]] {
; IS__CGSCC_NPM-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; IS__CGSCC_NPM:       if.then:
; IS__CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    br label [[CONT:%.*]]
; IS__CGSCC_NPM:       if.else:
; IS__CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    br label [[CONT]]
; IS__CGSCC_NPM:       cont:
; IS__CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[A]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  %cmp = icmp eq i8 %c, 0
  br i1 %cmp, label %if.then, label %if.else
if.then:
  tail call void @fun0()
  br label %cont
if.else:
  tail call void @fun0()
  br label %cont
cont:
  tail call void @fun1(i8* nonnull %a)
  ret void
}
; TEST 18 More complex test
; if(..)
;    ... (willreturn & nounwind)
; else
;    ... (willreturn & nounwind)
; if(..)
;    ... (willreturn & nounwind)
; else
;    ... (willreturn & nounwind)
; fun1(nonnull %a)

define void @f18(i8* %a, i8* %b, i8 %c) {
; NOT_CGSCC_NPM: Function Attrs: nounwind willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@f18
; NOT_CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8* [[B:%.*]], i8 [[C:%.*]]) #[[ATTR7]] {
; NOT_CGSCC_NPM-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[C]], 0
; NOT_CGSCC_NPM-NEXT:    br i1 [[CMP1]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; NOT_CGSCC_NPM:       if.then:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    br label [[CONT:%.*]]
; NOT_CGSCC_NPM:       if.else:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    br label [[CONT]]
; NOT_CGSCC_NPM:       cont:
; NOT_CGSCC_NPM-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 1
; NOT_CGSCC_NPM-NEXT:    br i1 [[CMP2]], label [[CONT_THEN:%.*]], label [[CONT_ELSE:%.*]]
; NOT_CGSCC_NPM:       cont.then:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[B]]) #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    br label [[CONT2:%.*]]
; NOT_CGSCC_NPM:       cont.else:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    br label [[CONT2]]
; NOT_CGSCC_NPM:       cont2:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[A]]) #[[ATTR7]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@f18
; IS__CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8* [[B:%.*]], i8 [[C:%.*]]) #[[ATTR6]] {
; IS__CGSCC_NPM-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[C]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[CMP1]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; IS__CGSCC_NPM:       if.then:
; IS__CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    br label [[CONT:%.*]]
; IS__CGSCC_NPM:       if.else:
; IS__CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    br label [[CONT]]
; IS__CGSCC_NPM:       cont:
; IS__CGSCC_NPM-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 1
; IS__CGSCC_NPM-NEXT:    br i1 [[CMP2]], label [[CONT_THEN:%.*]], label [[CONT_ELSE:%.*]]
; IS__CGSCC_NPM:       cont.then:
; IS__CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[B]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    br label [[CONT2:%.*]]
; IS__CGSCC_NPM:       cont.else:
; IS__CGSCC_NPM-NEXT:    tail call void @fun0() #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    br label [[CONT2]]
; IS__CGSCC_NPM:       cont2:
; IS__CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[A]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  %cmp1 = icmp eq i8 %c, 0
  br i1 %cmp1, label %if.then, label %if.else
if.then:
  tail call void @fun0()
  br label %cont
if.else:
  tail call void @fun0()
  br label %cont
cont:
  %cmp2 = icmp eq i8 %c, 1
  br i1 %cmp2, label %cont.then, label %cont.else
cont.then:
  tail call void @fun1(i8* nonnull %b)
  br label %cont2
cont.else:
  tail call void @fun0()
  br label %cont2
cont2:
  tail call void @fun1(i8* nonnull %a)
  ret void
}

; TEST 19: Loop

define void @f19(i8* %a, i8* %b, i8 %c) {
; NOT_CGSCC_NPM: Function Attrs: nounwind
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@f19
; NOT_CGSCC_NPM-SAME: (i8* [[A:%.*]], i8* nonnull [[B:%.*]], i8 [[C:%.*]]) #[[ATTR5]] {
; NOT_CGSCC_NPM-NEXT:    br label [[LOOP_HEADER:%.*]]
; NOT_CGSCC_NPM:       loop.header:
; NOT_CGSCC_NPM-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 0
; NOT_CGSCC_NPM-NEXT:    br i1 [[CMP2]], label [[LOOP_BODY:%.*]], label [[LOOP_EXIT:%.*]]
; NOT_CGSCC_NPM:       loop.body:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[B]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    br label [[LOOP_HEADER]]
; NOT_CGSCC_NPM:       loop.exit:
; NOT_CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[B]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nounwind
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@f19
; IS__CGSCC_NPM-SAME: (i8* [[A:%.*]], i8* nonnull [[B:%.*]], i8 [[C:%.*]]) #[[ATTR4]] {
; IS__CGSCC_NPM-NEXT:    br label [[LOOP_HEADER:%.*]]
; IS__CGSCC_NPM:       loop.header:
; IS__CGSCC_NPM-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[CMP2]], label [[LOOP_BODY:%.*]], label [[LOOP_EXIT:%.*]]
; IS__CGSCC_NPM:       loop.body:
; IS__CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[B]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    br label [[LOOP_HEADER]]
; IS__CGSCC_NPM:       loop.exit:
; IS__CGSCC_NPM-NEXT:    tail call void @fun1(i8* nonnull [[B]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  br label %loop.header
loop.header:
  %cmp2 = icmp eq i8 %c, 0
  br i1 %cmp2, label %loop.body, label %loop.exit
loop.body:
  tail call void @fun1(i8* nonnull %b)
  tail call void @fun1(i8* nonnull %a)
  br label %loop.header
loop.exit:
  tail call void @fun1(i8* nonnull %b)
  ret void
}

; Test propagation of nonnull callsite args back to caller.

declare void @use1(i8* %x)
declare void @use2(i8* %x, i8* %y);
declare void @use3(i8* %x, i8* %y, i8* %z);

declare void @use1nonnull(i8* nonnull %x);
declare void @use2nonnull(i8* nonnull %x, i8* nonnull %y);
declare void @use3nonnull(i8* nonnull %x, i8* nonnull %y, i8* nonnull %z);

declare i8 @use1safecall(i8* %x) readonly nounwind willreturn ; nounwind+willreturn guarantees that execution continues to successor

; Can't extend non-null to parent for any argument because the 2nd call is not guaranteed to execute.

define void @parent1(i8* %a, i8* %b, i8* %c) {
; CHECK-LABEL: define {{[^@]+}}@parent1
; CHECK-SAME: (i8* [[A:%.*]], i8* [[B:%.*]], i8* [[C:%.*]]) {
; CHECK-NEXT:    call void @use3(i8* [[C]], i8* [[A]], i8* [[B]])
; CHECK-NEXT:    call void @use3nonnull(i8* nonnull [[B]], i8* nonnull [[C]], i8* nonnull [[A]])
; CHECK-NEXT:    ret void
;
  call void @use3(i8* %c, i8* %a, i8* %b)
  call void @use3nonnull(i8* %b, i8* %c, i8* %a)
  ret void
}

; Extend non-null to parent for all arguments.

define void @parent2(i8* %a, i8* %b, i8* %c) {
; CHECK-LABEL: define {{[^@]+}}@parent2
; CHECK-SAME: (i8* nonnull [[A:%.*]], i8* nonnull [[B:%.*]], i8* nonnull [[C:%.*]]) {
; CHECK-NEXT:    call void @use3nonnull(i8* nonnull [[B]], i8* nonnull [[C]], i8* nonnull [[A]])
; CHECK-NEXT:    call void @use3(i8* nonnull [[C]], i8* nonnull [[A]], i8* nonnull [[B]])
; CHECK-NEXT:    ret void
;

  call void @use3nonnull(i8* %b, i8* %c, i8* %a)
  call void @use3(i8* %c, i8* %a, i8* %b)
  ret void
}

; Extend non-null to parent for 1st argument.

define void @parent3(i8* %a, i8* %b, i8* %c) {
; CHECK-LABEL: define {{[^@]+}}@parent3
; CHECK-SAME: (i8* nonnull [[A:%.*]], i8* [[B:%.*]], i8* [[C:%.*]]) {
; CHECK-NEXT:    call void @use1nonnull(i8* nonnull [[A]])
; CHECK-NEXT:    call void @use3(i8* [[C]], i8* [[B]], i8* nonnull [[A]])
; CHECK-NEXT:    ret void
;


  call void @use1nonnull(i8* %a)
  call void @use3(i8* %c, i8* %b, i8* %a)
  ret void
}

; Extend non-null to parent for last 2 arguments.

define void @parent4(i8* %a, i8* %b, i8* %c) {
; CHECK-LABEL: define {{[^@]+}}@parent4
; CHECK-SAME: (i8* [[A:%.*]], i8* nonnull [[B:%.*]], i8* nonnull [[C:%.*]]) {
; CHECK-NEXT:    call void @use2nonnull(i8* nonnull [[C]], i8* nonnull [[B]])
; CHECK-NEXT:    call void @use2(i8* [[A]], i8* nonnull [[C]])
; CHECK-NEXT:    call void @use1(i8* nonnull [[B]])
; CHECK-NEXT:    ret void
;



  call void @use2nonnull(i8* %c, i8* %b)
  call void @use2(i8* %a, i8* %c)
  call void @use1(i8* %b)
  ret void
}

; The callsite must execute in order for the attribute to transfer to the parent.
; It appears benign to extend non-null to the parent in this case, but we can't do that
; because it would incorrectly propagate the wrong information to its callers.

define void @parent5(i8* %a, i1 %a_is_notnull) {
; CHECK-LABEL: define {{[^@]+}}@parent5
; CHECK-SAME: (i8* [[A:%.*]], i1 [[A_IS_NOTNULL:%.*]]) {
; CHECK-NEXT:    br i1 [[A_IS_NOTNULL]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    call void @use1nonnull(i8* nonnull [[A]])
; CHECK-NEXT:    ret void
; CHECK:       f:
; CHECK-NEXT:    ret void
;

  br i1 %a_is_notnull, label %t, label %f
t:
  call void @use1nonnull(i8* %a)
  ret void
f:
  ret void
}

; The callsite must execute in order for the attribute to transfer to the parent.
; The volatile load can't trap, so we can guarantee that we'll get to the call.

define i8 @parent6(i8* %a, i8* %b) {
; CHECK-LABEL: define {{[^@]+}}@parent6
; CHECK-SAME: (i8* nonnull [[A:%.*]], i8* nofree noundef [[B:%.*]]) {
; CHECK-NEXT:    [[C:%.*]] = load volatile i8, i8* [[B]], align 1
; CHECK-NEXT:    call void @use1nonnull(i8* nonnull [[A]])
; CHECK-NEXT:    ret i8 [[C]]
;

  %c = load volatile i8, i8* %b
  call void @use1nonnull(i8* %a)
  ret i8 %c
}

; The nonnull callsite is guaranteed to execute, so the argument must be nonnull throughout the parent.

define i8 @parent7(i8* %a) {
; CHECK-LABEL: define {{[^@]+}}@parent7
; CHECK-SAME: (i8* nonnull [[A:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call i8 @use1safecall(i8* nonnull readonly [[A]]) #[[ATTR15:[0-9]+]]
; CHECK-NEXT:    call void @use1nonnull(i8* nonnull [[A]])
; CHECK-NEXT:    ret i8 [[RET]]
;


  %ret = call i8 @use1safecall(i8* %a)
  call void @use1nonnull(i8* %a)
  ret i8 %ret
}

; Make sure that an invoke works similarly to a call.

declare i32 @esfp(...)

define i1 @parent8(i8* %a, i8* %bogus1, i8* %b) personality i8* bitcast (i32 (...)* @esfp to i8*){
; NOT_CGSCC_NPM: Function Attrs: nounwind
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@parent8
; NOT_CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8* nocapture nofree readnone [[BOGUS1:%.*]], i8* nonnull [[B:%.*]]) #[[ATTR5]] personality i8* bitcast (i32 (...)* @esfp to i8*) {
; NOT_CGSCC_NPM-NEXT:  entry:
; NOT_CGSCC_NPM-NEXT:    invoke void @use2nonnull(i8* nonnull [[A]], i8* nonnull [[B]])
; NOT_CGSCC_NPM-NEXT:    to label [[CONT:%.*]] unwind label [[EXC:%.*]]
; NOT_CGSCC_NPM:       cont:
; NOT_CGSCC_NPM-NEXT:    ret i1 false
; NOT_CGSCC_NPM:       exc:
; NOT_CGSCC_NPM-NEXT:    [[LP:%.*]] = landingpad { i8*, i32 }
; NOT_CGSCC_NPM-NEXT:    filter [0 x i8*] zeroinitializer
; NOT_CGSCC_NPM-NEXT:    unreachable
;
; IS__CGSCC_NPM: Function Attrs: nounwind
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@parent8
; IS__CGSCC_NPM-SAME: (i8* nonnull [[A:%.*]], i8* nocapture nofree readnone [[BOGUS1:%.*]], i8* nonnull [[B:%.*]]) #[[ATTR4]] personality i8* bitcast (i32 (...)* @esfp to i8*) {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    invoke void @use2nonnull(i8* nonnull [[A]], i8* nonnull [[B]])
; IS__CGSCC_NPM-NEXT:    to label [[CONT:%.*]] unwind label [[EXC:%.*]]
; IS__CGSCC_NPM:       cont:
; IS__CGSCC_NPM-NEXT:    ret i1 false
; IS__CGSCC_NPM:       exc:
; IS__CGSCC_NPM-NEXT:    [[LP:%.*]] = landingpad { i8*, i32 }
; IS__CGSCC_NPM-NEXT:    filter [0 x i8*] zeroinitializer
; IS__CGSCC_NPM-NEXT:    unreachable
;

entry:
  invoke void @use2nonnull(i8* %a, i8* %b)
  to label %cont unwind label %exc

cont:
  %null_check = icmp eq i8* %b, null
  ret i1 %null_check

exc:
  %lp = landingpad { i8*, i32 }
  filter [0 x i8*] zeroinitializer
  unreachable
}

define i32* @gep1(i32* %p) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@gep1
; CHECK-SAME: (i32* nofree readnone "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, i32* [[P]], i32 1
; CHECK-NEXT:    ret i32* [[Q]]
;
  %q = getelementptr inbounds i32, i32* %p, i32 1
  ret i32* %q
}

define i32* @gep1_no_null_opt(i32* %p) #0 {
; Should't be able to derive nonnull based on gep.
; NOT_CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind null_pointer_is_valid readnone willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@gep1_no_null_opt
; NOT_CGSCC_NPM-SAME: (i32* nofree readnone "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR9:[0-9]+]] {
; NOT_CGSCC_NPM-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, i32* [[P]], i32 1
; NOT_CGSCC_NPM-NEXT:    ret i32* [[Q]]
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind null_pointer_is_valid readnone willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@gep1_no_null_opt
; IS__CGSCC_NPM-SAME: (i32* nofree readnone "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR8:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, i32* [[P]], i32 1
; IS__CGSCC_NPM-NEXT:    ret i32* [[Q]]
;
  %q = getelementptr inbounds i32, i32* %p, i32 1
  ret i32* %q
}

define i32 addrspace(3)* @gep2(i32 addrspace(3)* %p) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@gep2
; CHECK-SAME: (i32 addrspace(3)* nofree readnone "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, i32 addrspace(3)* [[P]], i32 1
; CHECK-NEXT:    ret i32 addrspace(3)* [[Q]]
;
  %q = getelementptr inbounds i32, i32 addrspace(3)* %p, i32 1
  ret i32 addrspace(3)* %q
}

; FIXME: We should propagate dereferenceable here but *not* nonnull
define i32 addrspace(3)* @as(i32 addrspace(3)* dereferenceable(4) %p) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@as
; CHECK-SAME: (i32 addrspace(3)* nofree nonnull readnone returned dereferenceable(4) "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    ret i32 addrspace(3)* [[P]]
;
  ret i32 addrspace(3)* %p
}

; CHECK-NOT: @g2()
define internal i32* @g2() {
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@g2
; IS__CGSCC____-SAME: () #[[ATTR1]] {
; IS__CGSCC____-NEXT:    ret i32* inttoptr (i64 4 to i32*)
;
  ret i32* inttoptr (i64 4 to i32*)
}

define i32* @g1() {
; IS__TUNIT____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__TUNIT____-LABEL: define {{[^@]+}}@g1
; IS__TUNIT____-SAME: () #[[ATTR1]] {
; IS__TUNIT____-NEXT:    ret i32* inttoptr (i64 4 to i32*)
;
; IS__CGSCC_OPM: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@g1
; IS__CGSCC_OPM-SAME: () #[[ATTR3]] {
; IS__CGSCC_OPM-NEXT:    [[C:%.*]] = call noundef nonnull align 4 i32* @g2() #[[ATTR16:[0-9]+]]
; IS__CGSCC_OPM-NEXT:    ret i32* [[C]]
;
; IS__CGSCC_NPM: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@g1
; IS__CGSCC_NPM-SAME: () #[[ATTR9:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:    [[C:%.*]] = call noundef nonnull align 4 i32* @g2() #[[ATTR16:[0-9]+]]
; IS__CGSCC_NPM-NEXT:    ret i32* [[C]]
;
  %c = call i32* @g2()
  ret i32* %c
}

declare void @use_i32_ptr(i32* readnone nocapture) nounwind
define internal void @called_by_weak(i32* %a) {
; NOT_CGSCC_NPM: Function Attrs: nounwind
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@called_by_weak
; NOT_CGSCC_NPM-SAME: (i32* noalias nocapture nonnull readnone [[A:%.*]]) #[[ATTR5]] {
; NOT_CGSCC_NPM-NEXT:    call void @use_i32_ptr(i32* noalias nocapture nonnull readnone [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nounwind
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@called_by_weak
; IS__CGSCC_NPM-SAME: (i32* noalias nocapture nonnull readnone [[A:%.*]]) #[[ATTR4]] {
; IS__CGSCC_NPM-NEXT:    call void @use_i32_ptr(i32* noalias nocapture nonnull readnone [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  call void @use_i32_ptr(i32* %a)
  ret void
}

; Check we do not annotate the function interface of this weak function.
define weak_odr void @weak_caller(i32* nonnull %a) {
;
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@weak_caller
; NOT_CGSCC_NPM-SAME: (i32* nonnull [[A:%.*]]) {
; NOT_CGSCC_NPM-NEXT:    call void @called_by_weak(i32* noalias nocapture nonnull readnone [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@weak_caller
; IS__CGSCC_NPM-SAME: (i32* nonnull [[A:%.*]]) {
; IS__CGSCC_NPM-NEXT:    call void @called_by_weak(i32* noalias nocapture nonnull readnone [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  call void @called_by_weak(i32* %a)
  ret void
}

; Expect nonnull
define internal void @control(i32* dereferenceable(4) %a) {
; NOT_CGSCC_NPM: Function Attrs: nounwind
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@control
; NOT_CGSCC_NPM-SAME: (i32* noalias nocapture noundef nonnull readnone align 16 dereferenceable(8) [[A:%.*]]) #[[ATTR5]] {
; NOT_CGSCC_NPM-NEXT:    call void @use_i32_ptr(i32* noalias nocapture noundef nonnull readnone align 16 dereferenceable(8) [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nounwind
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@control
; IS__CGSCC_NPM-SAME: (i32* noalias nocapture noundef nonnull readnone align 16 dereferenceable(8) [[A:%.*]]) #[[ATTR4]] {
; IS__CGSCC_NPM-NEXT:    call void @use_i32_ptr(i32* noalias nocapture noundef nonnull readnone align 16 dereferenceable(8) [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  call void @use_i32_ptr(i32* %a)
  ret void
}
; Avoid nonnull as we do not touch naked functions
define internal void @naked(i32* dereferenceable(4) %a) naked {
; CHECK: Function Attrs: naked
; CHECK-LABEL: define {{[^@]+}}@naked
; CHECK-SAME: (i32* dereferenceable(4) [[A:%.*]]) #[[ATTR10:[0-9]+]] {
; CHECK-NEXT:    call void @use_i32_ptr(i32* [[A]])
; CHECK-NEXT:    ret void
;
  call void @use_i32_ptr(i32* %a)
  ret void
}
; Avoid nonnull as we do not touch optnone
define internal void @optnone(i32* dereferenceable(4) %a) optnone noinline {
;
; CHECK: Function Attrs: noinline optnone
; CHECK-LABEL: define {{[^@]+}}@optnone
; CHECK-SAME: (i32* dereferenceable(4) [[A:%.*]]) #[[ATTR11:[0-9]+]] {
; CHECK-NEXT:    call void @use_i32_ptr(i32* [[A]])
; CHECK-NEXT:    ret void
;
  call void @use_i32_ptr(i32* %a)
  ret void
}
define void @make_live(i32* nonnull dereferenceable(8) %a) {
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@make_live
; NOT_CGSCC_NPM-SAME: (i32* noundef nonnull align 16 dereferenceable(8) [[A:%.*]]) {
; NOT_CGSCC_NPM-NEXT:    call void @naked(i32* noundef nonnull align 16 dereferenceable(8) [[A]])
; NOT_CGSCC_NPM-NEXT:    call void @control(i32* noalias nocapture noundef nonnull readnone align 16 dereferenceable(8) [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    call void @optnone(i32* noundef nonnull align 16 dereferenceable(8) [[A]])
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@make_live
; IS__CGSCC_NPM-SAME: (i32* noundef nonnull align 16 dereferenceable(8) [[A:%.*]]) {
; IS__CGSCC_NPM-NEXT:    call void @naked(i32* noundef nonnull align 16 dereferenceable(8) [[A]])
; IS__CGSCC_NPM-NEXT:    call void @control(i32* noalias nocapture noundef nonnull readnone align 16 dereferenceable(8) [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    call void @optnone(i32* noundef nonnull align 16 dereferenceable(8) [[A]])
; IS__CGSCC_NPM-NEXT:    ret void
;
  call void @naked(i32* nonnull dereferenceable(8) align 16 %a)
  call void @control(i32* nonnull dereferenceable(8) align 16 %a)
  call void @optnone(i32* nonnull dereferenceable(8) align 16 %a)
  ret void
}


;int f(int *u, int n){
;  for(int i = 0;i<n;i++){
;    h(u);
;  }
;  return g(nonnull u);
;}
declare void @h(i32*) willreturn nounwind
declare i32 @g(i32*) willreturn nounwind
define i32 @nonnull_exec_ctx_1(i32* %a, i32 %b) {
;
; IS________OPM: Function Attrs: nounwind
; IS________OPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_1
; IS________OPM-SAME: (i32* [[A:%.*]], i32 [[B:%.*]]) #[[ATTR5]] {
; IS________OPM-NEXT:  en:
; IS________OPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS________OPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS________OPM:       ex:
; IS________OPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR5]]
; IS________OPM-NEXT:    ret i32 [[TMP5]]
; IS________OPM:       hd:
; IS________OPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; IS________OPM-NEXT:    tail call void @h(i32* [[A]]) #[[ATTR5]]
; IS________OPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS________OPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS________OPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; IS__TUNIT_NPM: Function Attrs: nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_1
; IS__TUNIT_NPM-SAME: (i32* [[A:%.*]], i32 [[B:%.*]]) #[[ATTR7]] {
; IS__TUNIT_NPM-NEXT:  en:
; IS__TUNIT_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS__TUNIT_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS__TUNIT_NPM:       ex:
; IS__TUNIT_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR7]]
; IS__TUNIT_NPM-NEXT:    ret i32 [[TMP5]]
; IS__TUNIT_NPM:       hd:
; IS__TUNIT_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; IS__TUNIT_NPM-NEXT:    tail call void @h(i32* [[A]]) #[[ATTR7]]
; IS__TUNIT_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS__TUNIT_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS__TUNIT_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; IS__CGSCC_NPM: Function Attrs: nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_1
; IS__CGSCC_NPM-SAME: (i32* [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; IS__CGSCC_NPM-NEXT:  en:
; IS__CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS__CGSCC_NPM:       ex:
; IS__CGSCC_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    ret i32 [[TMP5]]
; IS__CGSCC_NPM:       hd:
; IS__CGSCC_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; IS__CGSCC_NPM-NEXT:    tail call void @h(i32* [[A]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS__CGSCC_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(i32* nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd ], [ 0, %en ]
  tail call void @h(i32* %a)
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

define i32 @nonnull_exec_ctx_1b(i32* %a, i32 %b) {
;
; IS________OPM: Function Attrs: nounwind
; IS________OPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_1b
; IS________OPM-SAME: (i32* [[A:%.*]], i32 [[B:%.*]]) #[[ATTR5]] {
; IS________OPM-NEXT:  en:
; IS________OPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS________OPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS________OPM:       ex:
; IS________OPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR5]]
; IS________OPM-NEXT:    ret i32 [[TMP5]]
; IS________OPM:       hd:
; IS________OPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; IS________OPM-NEXT:    tail call void @h(i32* [[A]]) #[[ATTR5]]
; IS________OPM-NEXT:    br label [[HD2]]
; IS________OPM:       hd2:
; IS________OPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS________OPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS________OPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; IS__TUNIT_NPM: Function Attrs: nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_1b
; IS__TUNIT_NPM-SAME: (i32* [[A:%.*]], i32 [[B:%.*]]) #[[ATTR7]] {
; IS__TUNIT_NPM-NEXT:  en:
; IS__TUNIT_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS__TUNIT_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS__TUNIT_NPM:       ex:
; IS__TUNIT_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR7]]
; IS__TUNIT_NPM-NEXT:    ret i32 [[TMP5]]
; IS__TUNIT_NPM:       hd:
; IS__TUNIT_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; IS__TUNIT_NPM-NEXT:    tail call void @h(i32* [[A]]) #[[ATTR7]]
; IS__TUNIT_NPM-NEXT:    br label [[HD2]]
; IS__TUNIT_NPM:       hd2:
; IS__TUNIT_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS__TUNIT_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS__TUNIT_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; IS__CGSCC_NPM: Function Attrs: nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_1b
; IS__CGSCC_NPM-SAME: (i32* [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; IS__CGSCC_NPM-NEXT:  en:
; IS__CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS__CGSCC_NPM:       ex:
; IS__CGSCC_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    ret i32 [[TMP5]]
; IS__CGSCC_NPM:       hd:
; IS__CGSCC_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; IS__CGSCC_NPM-NEXT:    tail call void @h(i32* [[A]]) #[[ATTR6]]
; IS__CGSCC_NPM-NEXT:    br label [[HD2]]
; IS__CGSCC_NPM:       hd2:
; IS__CGSCC_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS__CGSCC_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(i32* nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd2 ], [ 0, %en ]
  tail call void @h(i32* %a)
  br label %hd2

hd2:
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

define i32 @nonnull_exec_ctx_2(i32* %a, i32 %b) willreturn nounwind {
;
; NOT_CGSCC_NPM: Function Attrs: nounwind willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_2
; NOT_CGSCC_NPM-SAME: (i32* nonnull [[A:%.*]], i32 [[B:%.*]]) #[[ATTR7]] {
; NOT_CGSCC_NPM-NEXT:  en:
; NOT_CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; NOT_CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; NOT_CGSCC_NPM:       ex:
; NOT_CGSCC_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret i32 [[TMP5]]
; NOT_CGSCC_NPM:       hd:
; NOT_CGSCC_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; NOT_CGSCC_NPM-NEXT:    tail call void @h(i32* nonnull [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; NOT_CGSCC_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; NOT_CGSCC_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; IS__CGSCC_NPM: Function Attrs: nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_2
; IS__CGSCC_NPM-SAME: (i32* nonnull [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; IS__CGSCC_NPM-NEXT:  en:
; IS__CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS__CGSCC_NPM:       ex:
; IS__CGSCC_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret i32 [[TMP5]]
; IS__CGSCC_NPM:       hd:
; IS__CGSCC_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; IS__CGSCC_NPM-NEXT:    tail call void @h(i32* nonnull [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS__CGSCC_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(i32* nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd ], [ 0, %en ]
  tail call void @h(i32* %a)
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

define i32 @nonnull_exec_ctx_2b(i32* %a, i32 %b) willreturn nounwind {
;
; NOT_CGSCC_NPM: Function Attrs: nounwind willreturn
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_2b
; NOT_CGSCC_NPM-SAME: (i32* nonnull [[A:%.*]], i32 [[B:%.*]]) #[[ATTR7]] {
; NOT_CGSCC_NPM-NEXT:  en:
; NOT_CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; NOT_CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; NOT_CGSCC_NPM:       ex:
; NOT_CGSCC_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret i32 [[TMP5]]
; NOT_CGSCC_NPM:       hd:
; NOT_CGSCC_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; NOT_CGSCC_NPM-NEXT:    tail call void @h(i32* nonnull [[A]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    br label [[HD2]]
; NOT_CGSCC_NPM:       hd2:
; NOT_CGSCC_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; NOT_CGSCC_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; NOT_CGSCC_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; IS__CGSCC_NPM: Function Attrs: nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_exec_ctx_2b
; IS__CGSCC_NPM-SAME: (i32* nonnull [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; IS__CGSCC_NPM-NEXT:  en:
; IS__CGSCC_NPM-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; IS__CGSCC_NPM:       ex:
; IS__CGSCC_NPM-NEXT:    [[TMP5:%.*]] = tail call i32 @g(i32* nonnull [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret i32 [[TMP5]]
; IS__CGSCC_NPM:       hd:
; IS__CGSCC_NPM-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; IS__CGSCC_NPM-NEXT:    tail call void @h(i32* nonnull [[A]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    br label [[HD2]]
; IS__CGSCC_NPM:       hd2:
; IS__CGSCC_NPM-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; IS__CGSCC_NPM-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; IS__CGSCC_NPM-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(i32* nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd2 ], [ 0, %en ]
  tail call void @h(i32* %a)
  br label %hd2

hd2:
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

; Original from PR43833
declare void @sink(i32*)

define void @PR43833(i32* %0, i32 %1) {
; IS________OPM-LABEL: define {{[^@]+}}@PR43833
; IS________OPM-SAME: (i32* [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; IS________OPM-NEXT:    [[TMP3:%.*]] = icmp sgt i32 [[TMP1]], 1
; IS________OPM-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP7:%.*]]
; IS________OPM:       4:
; IS________OPM-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP1]] to i64
; IS________OPM-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i32, i32* [[TMP0]], i64 [[TMP5]]
; IS________OPM-NEXT:    br label [[TMP8:%.*]]
; IS________OPM:       7:
; IS________OPM-NEXT:    ret void
; IS________OPM:       8:
; IS________OPM-NEXT:    [[TMP9:%.*]] = phi i32 [ 1, [[TMP4]] ], [ [[TMP10:%.*]], [[TMP8]] ]
; IS________OPM-NEXT:    tail call void @sink(i32* [[TMP6]])
; IS________OPM-NEXT:    [[TMP10]] = add nuw nsw i32 [[TMP9]], 1
; IS________OPM-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], [[TMP1]]
; IS________OPM-NEXT:    br i1 [[TMP11]], label [[TMP7]], label [[TMP8]]
;
; IS________NPM-LABEL: define {{[^@]+}}@PR43833
; IS________NPM-SAME: (i32* [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; IS________NPM-NEXT:    [[TMP3:%.*]] = icmp sgt i32 [[TMP1]], 1
; IS________NPM-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP7:%.*]]
; IS________NPM:       4:
; IS________NPM-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP1]] to i64
; IS________NPM-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i32, i32* [[TMP0]], i64 [[TMP5]]
; IS________NPM-NEXT:    br label [[TMP8:%.*]]
; IS________NPM:       7:
; IS________NPM-NEXT:    ret void
; IS________NPM:       8:
; IS________NPM-NEXT:    [[TMP9:%.*]] = phi i32 [ 1, [[TMP4]] ], [ [[TMP10:%.*]], [[TMP8]] ]
; IS________NPM-NEXT:    tail call void @sink(i32* nonnull [[TMP6]])
; IS________NPM-NEXT:    [[TMP10]] = add nuw nsw i32 [[TMP9]], 1
; IS________NPM-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], [[TMP1]]
; IS________NPM-NEXT:    br i1 [[TMP11]], label [[TMP7]], label [[TMP8]]
;
  %3 = icmp sgt i32 %1, 1
  br i1 %3, label %4, label %7

4:                                                ; preds = %2
  %5 = zext i32 %1 to i64
  %6 = getelementptr inbounds i32, i32* %0, i64 %5
  br label %8

7:                                                ; preds = %8, %2
  ret void

8:                                                ; preds = %8, %4
  %9 = phi i32 [ 1, %4 ], [ %10, %8 ]
  tail call void @sink(i32* %6)
  %10 = add nuw nsw i32 %9, 1
  %11 = icmp eq i32 %10, %1
  br i1 %11, label %7, label %8
}

; Adjusted from PR43833
define void @PR43833_simple(i32* %0, i32 %1) {
; IS________OPM-LABEL: define {{[^@]+}}@PR43833_simple
; IS________OPM-SAME: (i32* [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; IS________OPM-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], 0
; IS________OPM-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP7:%.*]]
; IS________OPM:       4:
; IS________OPM-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP1]] to i64
; IS________OPM-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i32, i32* [[TMP0]], i64 [[TMP5]]
; IS________OPM-NEXT:    br label [[TMP8:%.*]]
; IS________OPM:       7:
; IS________OPM-NEXT:    ret void
; IS________OPM:       8:
; IS________OPM-NEXT:    [[TMP9:%.*]] = phi i32 [ 1, [[TMP4]] ], [ [[TMP10:%.*]], [[TMP8]] ]
; IS________OPM-NEXT:    tail call void @sink(i32* [[TMP6]])
; IS________OPM-NEXT:    [[TMP10]] = add nuw nsw i32 [[TMP9]], 1
; IS________OPM-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], [[TMP1]]
; IS________OPM-NEXT:    br i1 [[TMP11]], label [[TMP7]], label [[TMP8]]
;
; IS________NPM-LABEL: define {{[^@]+}}@PR43833_simple
; IS________NPM-SAME: (i32* [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; IS________NPM-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], 0
; IS________NPM-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP7:%.*]]
; IS________NPM:       4:
; IS________NPM-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP1]] to i64
; IS________NPM-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i32, i32* [[TMP0]], i64 [[TMP5]]
; IS________NPM-NEXT:    br label [[TMP8:%.*]]
; IS________NPM:       7:
; IS________NPM-NEXT:    ret void
; IS________NPM:       8:
; IS________NPM-NEXT:    [[TMP9:%.*]] = phi i32 [ 1, [[TMP4]] ], [ [[TMP10:%.*]], [[TMP8]] ]
; IS________NPM-NEXT:    tail call void @sink(i32* nonnull [[TMP6]])
; IS________NPM-NEXT:    [[TMP10]] = add nuw nsw i32 [[TMP9]], 1
; IS________NPM-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], [[TMP1]]
; IS________NPM-NEXT:    br i1 [[TMP11]], label [[TMP7]], label [[TMP8]]
;
  %3 = icmp ne i32 %1, 0
  br i1 %3, label %4, label %7

4:                                                ; preds = %2
  %5 = zext i32 %1 to i64
  %6 = getelementptr inbounds i32, i32* %0, i64 %5
  br label %8

7:                                                ; preds = %8, %2
  ret void

8:                                                ; preds = %8, %4
  %9 = phi i32 [ 1, %4 ], [ %10, %8 ]
  tail call void @sink(i32* %6)
  %10 = add nuw nsw i32 %9, 1
  %11 = icmp eq i32 %10, %1
  br i1 %11, label %7, label %8
}

declare i8* @strrchr(i8* %0, i32 %1) nofree nounwind readonly willreturn

; We should not mark the return of @strrchr as `nonnull`, it may well be NULL!
define i8* @mybasename(i8* nofree readonly %str) {
; CHECK: Function Attrs: nofree nounwind readonly willreturn
; CHECK-LABEL: define {{[^@]+}}@mybasename
; CHECK-SAME: (i8* nofree readonly [[STR:%.*]]) #[[ATTR12:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call i8* @strrchr(i8* nofree readonly [[STR]], i32 noundef 47) #[[ATTR15]]
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne i8* [[CALL]], null
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[CALL]], i64 1
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[TOBOOL]], i8* [[ADD_PTR]], i8* [[STR]]
; CHECK-NEXT:    ret i8* [[COND]]
;
  %call = call i8* @strrchr(i8* %str, i32 47)
  %tobool = icmp ne i8* %call, null
  %add.ptr = getelementptr inbounds i8, i8* %call, i64 1
  %cond = select i1 %tobool, i8* %add.ptr, i8* %str
  ret i8* %cond
}

define void @nonnull_assume_pos(i8* %arg) {
; ATTRIBUTOR-LABEL: define {{[^@]+}}@nonnull_assume_pos
; ATTRIBUTOR-SAME: (i8* nocapture nofree nonnull readnone [[ARG:%.*]])
; ATTRIBUTOR-NEXT:    call void @llvm.assume(i1 true) #11 [ "nonnull"(i8* [[ARG]]) ]
; ATTRIBUTOR-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[ARG]])
; ATTRIBUTOR-NEXT:    [[TMP1:%.*]] = call i8* @unknown()
; ATTRIBUTOR-NEXT:    ret void
;
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_assume_pos
; NOT_CGSCC_NPM-SAME: (i8* nocapture nofree nonnull readnone [[ARG:%.*]]) {
; NOT_CGSCC_NPM-NEXT:    call void @llvm.assume(i1 noundef true) #[[ATTR13]] [ "nonnull"(i8* [[ARG]]) ]
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    [[TMP1:%.*]] = call i8* @unknown()
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_assume_pos
; IS__CGSCC_NPM-SAME: (i8* nocapture nofree nonnull readnone [[ARG:%.*]]) {
; IS__CGSCC_NPM-NEXT:    call void @llvm.assume(i1 noundef true) #[[ATTR13]] [ "nonnull"(i8* [[ARG]]) ]
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    [[TMP1:%.*]] = call i8* @unknown()
; IS__CGSCC_NPM-NEXT:    ret void
;
  call void @llvm.assume(i1 true) ["nonnull"(i8* %arg)]
  call void @use_i8_ptr(i8* %arg)
  call i8* @unknown()
  ret void
}
define void @nonnull_assume_neg(i8* %arg) {
; ATTRIBUTOR-LABEL: define {{[^@]+}}@nonnull_assume_neg
; ATTRIBUTOR-SAME: (i8* nocapture nofree readnone [[ARG:%.*]])
; ATTRIBUTOR-NEXT:    [[TMP1:%.*]] = call i8* @unknown()
; ATTRIBUTOR-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree readnone [[ARG]])
; ATTRIBUTOR-NEXT:    call void @llvm.assume(i1 true) [ "nonnull"(i8* [[ARG]]) ]
; ATTRIBUTOR-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[ARG]])
; ATTRIBUTOR-NEXT:    [[TMP2:%.*]] = call i8* @unknown()
; ATTRIBUTOR-NEXT:    call void @use_i8_ptr_ret(i8* noalias nocapture nofree nonnull readnone [[ARG]])
; ATTRIBUTOR-NEXT:    call void @llvm.assume(i1 true) [ "nonnull"(i8* [[ARG]]) ]
; ATTRIBUTOR-NEXT:    call void @use_i8_ptr_ret(i8* noalias nocapture nofree nonnull readnone [[ARG]])
; ATTRIBUTOR-NEXT:    ret void
;
;
; NOT_CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_assume_neg
; NOT_CGSCC_NPM-SAME: (i8* nocapture nofree readnone [[ARG:%.*]]) {
; NOT_CGSCC_NPM-NEXT:    [[TMP1:%.*]] = call i8* @unknown()
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree readnone [[ARG]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    call void @llvm.assume(i1 noundef true) [ "nonnull"(i8* [[ARG]]) ]
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    [[TMP2:%.*]] = call i8* @unknown()
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr_ret(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    call void @llvm.assume(i1 noundef true) [ "nonnull"(i8* [[ARG]]) ]
; NOT_CGSCC_NPM-NEXT:    call void @use_i8_ptr_ret(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR5]]
; NOT_CGSCC_NPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@nonnull_assume_neg
; IS__CGSCC_NPM-SAME: (i8* nocapture nofree readnone [[ARG:%.*]]) {
; IS__CGSCC_NPM-NEXT:    [[TMP1:%.*]] = call i8* @unknown()
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree readnone [[ARG]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    call void @llvm.assume(i1 noundef true) [ "nonnull"(i8* [[ARG]]) ]
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    [[TMP2:%.*]] = call i8* @unknown()
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr_ret(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    call void @llvm.assume(i1 noundef true) [ "nonnull"(i8* [[ARG]]) ]
; IS__CGSCC_NPM-NEXT:    call void @use_i8_ptr_ret(i8* noalias nocapture nofree nonnull readnone [[ARG]]) #[[ATTR4]]
; IS__CGSCC_NPM-NEXT:    ret void
;
  call i8* @unknown()
  call void @use_i8_ptr(i8* %arg)
  call void @llvm.assume(i1 true) ["nonnull"(i8* %arg)]
  call void @use_i8_ptr(i8* %arg)
  call i8* @unknown()
  call void @use_i8_ptr_ret(i8* %arg)
  call void @llvm.assume(i1 true) ["nonnull"(i8* %arg)]
  call void @use_i8_ptr_ret(i8* %arg)
  ret void
}
declare void @use_i8_ptr(i8* nofree nocapture readnone) nounwind
declare void @use_i8_ptr_ret(i8* nofree nocapture readnone) nounwind willreturn

define i8* @nonnull_function_ptr_1() {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@nonnull_function_ptr_1
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    ret i8* bitcast (i8* ()* @nonnull_function_ptr_1 to i8*)
;
  %bc = bitcast i8*()* @nonnull_function_ptr_1 to i8*
  ret i8* %bc
}

declare i8* @function_decl()
define i8* @nonnull_function_ptr_2() {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@nonnull_function_ptr_2
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    ret i8* bitcast (i8* ()* @function_decl to i8*)
;
  %bc = bitcast i8*()* @function_decl to i8*
  ret i8* %bc
}

; FIXME: nonnull should not be propagated to the caller's p unless there is noundef
define void @nonnull_caller(i8* %p) {
; CHECK-LABEL: define {{[^@]+}}@nonnull_caller
; CHECK-SAME: (i8* nonnull [[P:%.*]]) {
; CHECK-NEXT:    call void @nonnull_callee(i8* nonnull [[P]])
; CHECK-NEXT:    ret void
;
  call void @nonnull_callee(i8* %p)
  ret void
}

declare void @nonnull_callee(i8* nonnull %p)

attributes #0 = { null_pointer_is_valid }
attributes #1 = { nounwind willreturn}
;.
; IS__TUNIT____: attributes #[[ATTR0:[0-9]+]] = { inaccessiblememonly nocallback nofree nosync nounwind willreturn }
; IS__TUNIT____: attributes #[[ATTR1]] = { nofree norecurse nosync nounwind readnone willreturn }
; IS__TUNIT____: attributes #[[ATTR2]] = { inaccessiblememonly nofree norecurse nosync nounwind willreturn }
; IS__TUNIT____: attributes #[[ATTR3]] = { nofree nosync nounwind readnone willreturn }
; IS__TUNIT____: attributes #[[ATTR4]] = { noreturn }
; IS__TUNIT____: attributes #[[ATTR5]] = { nounwind }
; IS__TUNIT____: attributes #[[ATTR6]] = { argmemonly nofree nosync nounwind readonly }
; IS__TUNIT____: attributes #[[ATTR7]] = { nounwind willreturn }
; IS__TUNIT____: attributes #[[ATTR8:[0-9]+]] = { nounwind readonly willreturn }
; IS__TUNIT____: attributes #[[ATTR9]] = { nofree norecurse nosync nounwind null_pointer_is_valid readnone willreturn }
; IS__TUNIT____: attributes #[[ATTR10]] = { naked }
; IS__TUNIT____: attributes #[[ATTR11]] = { noinline optnone }
; IS__TUNIT____: attributes #[[ATTR12]] = { nofree nounwind readonly willreturn }
; IS__TUNIT____: attributes #[[ATTR13]] = { willreturn }
; IS__TUNIT____: attributes #[[ATTR14]] = { nofree nosync nounwind readonly }
; IS__TUNIT____: attributes #[[ATTR15]] = { readonly willreturn }
;.
; IS__CGSCC_OPM: attributes #[[ATTR0:[0-9]+]] = { inaccessiblememonly nocallback nofree nosync nounwind willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR1]] = { nofree norecurse nosync nounwind readnone willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR2]] = { inaccessiblememonly nofree norecurse nosync nounwind willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR3]] = { nofree nosync nounwind readnone willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR4]] = { noreturn }
; IS__CGSCC_OPM: attributes #[[ATTR5]] = { nounwind }
; IS__CGSCC_OPM: attributes #[[ATTR6]] = { argmemonly nofree nosync nounwind readonly }
; IS__CGSCC_OPM: attributes #[[ATTR7]] = { nounwind willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR8:[0-9]+]] = { nounwind readonly willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR9]] = { nofree norecurse nosync nounwind null_pointer_is_valid readnone willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR10]] = { naked }
; IS__CGSCC_OPM: attributes #[[ATTR11]] = { noinline optnone }
; IS__CGSCC_OPM: attributes #[[ATTR12]] = { nofree nounwind readonly willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR13]] = { willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR14]] = { nofree nosync nounwind readonly }
; IS__CGSCC_OPM: attributes #[[ATTR15]] = { readonly willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR16]] = { readnone willreturn }
;.
; IS__CGSCC_NPM: attributes #[[ATTR0:[0-9]+]] = { inaccessiblememonly nocallback nofree nosync nounwind willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR1]] = { nofree norecurse nosync nounwind readnone willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR2]] = { inaccessiblememonly nofree norecurse nosync nounwind willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR3]] = { noreturn }
; IS__CGSCC_NPM: attributes #[[ATTR4]] = { nounwind }
; IS__CGSCC_NPM: attributes #[[ATTR5]] = { argmemonly nofree nosync nounwind readonly }
; IS__CGSCC_NPM: attributes #[[ATTR6]] = { nounwind willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR7:[0-9]+]] = { nounwind readonly willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR8]] = { nofree norecurse nosync nounwind null_pointer_is_valid readnone willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR9]] = { nofree nosync nounwind readnone willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR10]] = { naked }
; IS__CGSCC_NPM: attributes #[[ATTR11]] = { noinline optnone }
; IS__CGSCC_NPM: attributes #[[ATTR12]] = { nofree nounwind readonly willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR13]] = { willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR14]] = { nofree nosync nounwind readonly }
; IS__CGSCC_NPM: attributes #[[ATTR15]] = { readonly willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR16]] = { readnone willreturn }
;.
