/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.kawa.lispexpr.NamespaceUse;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;

public class LispPackage
extends Namespace {
    Namespace exported;
    LList shadowingSymbols = LList.Empty;
    NamespaceUse imported;
    NamespaceUse importing;

    public Symbol lookup(String name, int hash, boolean create) {
        Symbol sym = this.exported.lookup(name, hash, false);
        if (sym != null) {
            return sym;
        }
        sym = this.lookupInternal(name, hash);
        if (sym != null) {
            return sym;
        }
        NamespaceUse used = this.imported;
        while (used != null) {
            sym = this.lookup(name, hash, false);
            if (sym != null) {
                return sym;
            }
            used = used.nextImported;
        }
        if (create) {
            return this.add(new Symbol(this, name), hash);
        }
        return null;
    }

    public Symbol lookupPresent(String name, int hash, boolean intern) {
        Symbol sym = this.exported.lookup(name, hash, false);
        if (sym == null) {
            sym = super.lookup(name, hash, intern);
        }
        return sym;
    }

    public boolean isPresent(String name) {
        return this.lookupPresent(name, name.hashCode(), false) != null;
    }

    public boolean unintern(Symbol symbol) {
        int hash;
        String name = symbol.getName();
        if (this.exported.lookup(name, hash = name.hashCode(), false) == symbol) {
            this.exported.remove(symbol);
        } else if (super.lookup(name, hash, false) == symbol) {
            super.remove(symbol);
        } else {
            return false;
        }
        symbol.setNamespace(null);
        if (this.removeFromShadowingSymbols(symbol)) {
            // empty if block
        }
        return true;
    }

    private void addToShadowingSymbols(Symbol sym) {
        Object s = this.shadowingSymbols;
        while (s != LList.Empty) {
            Pair p = (Pair)s;
            if (p.car == sym) {
                return;
            }
            s = p.cdr;
        }
        this.shadowingSymbols = new Pair(sym, this.shadowingSymbols);
    }

    private boolean removeFromShadowingSymbols(Symbol sym) {
        Pair prev = null;
        Object s = this.shadowingSymbols;
        while (s != LList.Empty) {
            Pair p = (Pair)s;
            s = p.cdr;
            if (p.car == sym) {
                if (prev == null) {
                    this.shadowingSymbols = (LList)s;
                } else {
                    prev.cdr = s;
                }
                return true;
            }
            prev = p;
        }
        return false;
    }

    public void shadow(String name) {
        Symbol sym = this.lookupPresent(name, name.hashCode(), true);
        this.addToShadowingSymbols(sym);
    }

    public void shadowingImport(Symbol symbol) {
        String name = symbol.getName();
        int hash = name.hashCode();
        Symbol old = this.lookupPresent(name, name.hashCode(), false);
        if (old != null && old != symbol) {
            this.unintern(old);
        }
        this.addToShadowingSymbols(symbol);
    }
}

