/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.Platform;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

@GwtCompatible
public class ListAddAtIndexTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAtIndex_supportedPresent() {
        this.getList().add(0, this.samples.e0);
        this.expectAdded(0, this.samples.e0);
    }

    @ListFeature.Require(absent={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAtIndex_unsupportedPresent() {
        try {
            this.getList().add(0, this.samples.e0);
            ListAddAtIndexTester.fail((String)"add(n, present) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_supportedNotPresent() {
        this.getList().add(0, this.samples.e3);
        this.expectAdded(0, this.samples.e3);
    }

    @CollectionFeature.Require(value={CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndexConcurrentWithIteration() {
        try {
            Iterator iterator = this.collection.iterator();
            this.getList().add(0, this.samples.e3);
            iterator.next();
            ListAddAtIndexTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @ListFeature.Require(absent={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_unsupportedNotPresent() {
        try {
            this.getList().add(0, this.samples.e3);
            ListAddAtIndexTester.fail((String)"add(n, notPresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testAddAtIndex_middle() {
        this.getList().add(this.getNumElements() / 2, this.samples.e3);
        this.expectAdded(this.getNumElements() / 2, this.samples.e3);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAtIndex_end() {
        this.getList().add(this.getNumElements(), this.samples.e3);
        this.expectAdded(this.getNumElements(), this.samples.e3);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAddAtIndex_nullSupported() {
        this.getList().add(0, null);
        this.expectAdded(0, new Object[]{null});
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAddAtIndex_nullUnsupported() {
        try {
            this.getList().add(0, null);
            ListAddAtIndexTester.fail((String)"add(n, null) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullMissingWhenNullUnsupported("Should not contain null after unsupported add(n, null)");
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_negative() {
        try {
            this.getList().add(-1, this.samples.e3);
            ListAddAtIndexTester.fail((String)"add(-1, e) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAtIndex_tooLarge() {
        try {
            this.getList().add(this.getNumElements() + 1, this.samples.e3);
            ListAddAtIndexTester.fail((String)"add(size + 1, e) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }

    public static Method getAddNullSupportedMethod() {
        return Platform.getMethod(ListAddAtIndexTester.class, "testAddAtIndex_nullSupported");
    }
}

