/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractQueueTester;

@GwtCompatible
public class QueuePollTester<E>
extends AbstractQueueTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testPoll_empty() {
        QueuePollTester.assertNull((String)"emptyQueue.poll() should return null", this.getQueue().poll());
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testPoll_size1() {
        QueuePollTester.assertEquals((String)"size1Queue.poll() should return first element", this.samples.e0, this.getQueue().poll());
        this.expectMissing(this.samples.e0);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPoll_sizeMany() {
        QueuePollTester.assertEquals((String)"sizeManyQueue.poll() should return first element", this.samples.e0, this.getQueue().poll());
        this.expectMissing(this.samples.e0);
    }
}

