/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ArbitraryInstances;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

@Beta
public final class NullPointerTester {
    private final ClassToInstanceMap<Object> defaults = MutableClassToInstanceMap.create();
    private final List<Member> ignoredMembers = Lists.newArrayList();

    public <T> NullPointerTester setDefault(Class<T> type, T value) {
        this.defaults.put(type, value);
        return this;
    }

    @Deprecated
    public NullPointerTester ignore(Member member) {
        this.ignoredMembers.add(member);
        return this;
    }

    public NullPointerTester ignore(Method method) {
        this.ignoredMembers.add(method);
        return this;
    }

    public void testConstructors(Class<?> c, Visibility minimalVisibility) {
        for (Constructor<?> constructor : c.getDeclaredConstructors()) {
            if (!minimalVisibility.isVisible(constructor) || this.isIgnored(constructor)) continue;
            this.testConstructor(constructor);
        }
    }

    public void testAllPublicConstructors(Class<?> c) {
        this.testConstructors(c, Visibility.PUBLIC);
    }

    public void testStaticMethods(Class<?> c, Visibility minimalVisibility) {
        for (Method method : minimalVisibility.getStaticMethods(c)) {
            if (this.isIgnored(method)) continue;
            this.testMethod(null, method);
        }
    }

    public void testAllPublicStaticMethods(Class<?> c) {
        this.testStaticMethods(c, Visibility.PUBLIC);
    }

    public void testInstanceMethods(Object instance, Visibility minimalVisibility) {
        Class<?> c = instance.getClass();
        for (Method method : minimalVisibility.getInstanceMethods(c)) {
            if (this.isIgnored(method)) continue;
            this.testMethod(instance, method);
        }
    }

    public void testAllPublicInstanceMethods(Object instance) {
        this.testInstanceMethods(instance, Visibility.PUBLIC);
    }

    public void testMethod(Object instance, Method method) {
        Class<?>[] types = method.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testMethodParameter(instance, method, nullIndex);
        }
    }

    public void testConstructor(Constructor<?> ctor) {
        Class<?>[] types = ctor.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testConstructorParameter(ctor, nullIndex);
        }
    }

    public void testMethodParameter(final Object instance, final Method method, int paramIndex) {
        method.setAccessible(true);
        this.testFunctorParameter(instance, new Functor(){

            @Override
            public Type[] getParameterTypes() {
                Type[] unresolved = method.getGenericParameterTypes();
                if (NullPointerTester.isStatic(method)) {
                    return unresolved;
                }
                TypeToken type = TypeToken.of(instance.getClass());
                Type[] resolved = new Type[unresolved.length];
                for (int i = 0; i < unresolved.length; ++i) {
                    resolved[i] = type.resolveType(unresolved[i]).getType();
                }
                return resolved;
            }

            @Override
            public Annotation[][] getParameterAnnotations() {
                return method.getParameterAnnotations();
            }

            @Override
            public void invoke(Object object, Object[] params) throws InvocationTargetException, IllegalAccessException {
                method.invoke(object, params);
            }

            public String toString() {
                return method.toString();
            }
        }, paramIndex, method.getDeclaringClass());
    }

    public void testConstructorParameter(final Constructor<?> ctor, int paramIndex) {
        ctor.setAccessible(true);
        this.testFunctorParameter(null, new Functor(){

            @Override
            public Type[] getParameterTypes() {
                return ctor.getGenericParameterTypes();
            }

            @Override
            public Annotation[][] getParameterAnnotations() {
                return ctor.getParameterAnnotations();
            }

            @Override
            public void invoke(Object instance, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                ctor.newInstance(params);
            }
        }, paramIndex, ctor.getDeclaringClass());
    }

    private void testFunctorParameter(Object instance, Functor func, int paramIndex, Class<?> testedClass) {
        if (NullPointerTester.parameterIsPrimitiveOrNullable(func, paramIndex)) {
            return;
        }
        Object[] params = this.buildParamList(func, paramIndex);
        try {
            func.invoke(instance, params);
            Assert.fail((String)("No exception thrown from " + func + Arrays.toString(params) + " for " + testedClass));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NullPointerException || cause instanceof UnsupportedOperationException) {
                return;
            }
            AssertionFailedError error = new AssertionFailedError("wrong exception thrown from " + func + ": " + cause);
            error.initCause(cause);
            throw error;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean parameterIsPrimitiveOrNullable(Functor func, int paramIndex) {
        Annotation[] annotations;
        if (TypeToken.of((Type)func.getParameterTypes()[paramIndex]).getRawType().isPrimitive()) {
            return true;
        }
        for (Annotation annotation : annotations = func.getParameterAnnotations()[paramIndex]) {
            if (!(annotation instanceof Nullable)) continue;
            return true;
        }
        return false;
    }

    private Object[] buildParamList(Functor func, int indexOfParamToSetToNull) {
        Type[] types = func.getParameterTypes();
        Object[] params = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (i == indexOfParamToSetToNull) continue;
            TypeToken type = TypeToken.of((Type)types[i]);
            params[i] = this.getDefaultValue(type);
            if (NullPointerTester.parameterIsPrimitiveOrNullable(func, i)) continue;
            Assert.assertTrue((String)("No default value found for " + type.getRawType()), (params[i] != null ? 1 : 0) != 0);
        }
        return params;
    }

    private <T> T getDefaultValue(TypeToken<T> type) {
        Object defaultValue = this.defaults.getInstance(type.getRawType());
        if (defaultValue != null) {
            return (T)defaultValue;
        }
        Object nullValue = ArbitraryInstances.get(type.getRawType());
        if (nullValue != null) {
            return nullValue;
        }
        if (type.getRawType() == Class.class) {
            Class defaultClass = NullPointerTester.getFirstTypeParameter(type.getType()).getRawType();
            return (T)defaultClass;
        }
        if (type.getRawType() == TypeToken.class) {
            TypeToken<?> defaultType = NullPointerTester.getFirstTypeParameter(type.getType());
            return (T)defaultType;
        }
        if (type.getRawType().isInterface()) {
            return this.newDefaultReturningProxy(type);
        }
        return null;
    }

    private static TypeToken<?> getFirstTypeParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeToken.of((Type)((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        return TypeToken.of(Object.class);
    }

    private <T> T newDefaultReturningProxy(final TypeToken<T> type) {
        Set interfaceClasses = type.getTypes().interfaces().rawTypes();
        return (T)Proxy.newProxyInstance(((Class)interfaceClasses.iterator().next()).getClassLoader(), interfaceClasses.toArray(new Class[interfaceClasses.size()]), (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(Object proxy, Method method, Object[] args) {
                return NullPointerTester.this.getDefaultValue(type.resolveType(method.getGenericReturnType()));
            }

            public String toString() {
                return "NullPointerTester proxy for " + type;
            }
        });
    }

    private static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    private boolean isIgnored(Member member) {
        return member.isSynthetic() || this.ignoredMembers.contains(member);
    }

    private static interface Functor {
        public Type[] getParameterTypes();

        public Annotation[][] getParameterAnnotations();

        public void invoke(Object var1, Object[] var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }

    private static final class Signature {
        private final String name;
        private final ImmutableList<Class<?>> parameterTypes;

        Signature(Method method) {
            this(method.getName(), ImmutableList.copyOf((Object[])method.getParameterTypes()));
        }

        Signature(String name, ImmutableList<Class<?>> parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Signature) {
                Signature that = (Signature)obj;
                return this.name.equals(that.name) && this.parameterTypes.equals(that.parameterTypes);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.parameterTypes});
        }
    }

    public static enum Visibility {
        PACKAGE{

            @Override
            boolean isVisible(int modifiers) {
                return !Modifier.isPrivate(modifiers);
            }
        }
        ,
        PROTECTED{

            @Override
            boolean isVisible(int modifiers) {
                return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
            }
        }
        ,
        PUBLIC{

            @Override
            boolean isVisible(int modifiers) {
                return Modifier.isPublic(modifiers);
            }
        };


        abstract boolean isVisible(int var1);

        final boolean isVisible(Member member) {
            return this.isVisible(member.getModifiers());
        }

        final Iterable<Method> getStaticMethods(Class<?> cls) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Method method : this.getVisibleMethods(cls)) {
                if (!NullPointerTester.isStatic(method)) continue;
                builder.add((Object)method);
            }
            return builder.build();
        }

        final Iterable<Method> getInstanceMethods(Class<?> cls) {
            ConcurrentMap map = Maps.newConcurrentMap();
            for (Method method : this.getVisibleMethods(cls)) {
                if (NullPointerTester.isStatic(method)) continue;
                map.putIfAbsent(new Signature(method), method);
            }
            return map.values();
        }

        private ImmutableList<Method> getVisibleMethods(Class<?> cls) {
            Class type;
            String visiblePackage = Reflection.getPackageName(cls);
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator i$ = TypeToken.of(cls).getTypes().classes().rawTypes().iterator();
            while (i$.hasNext() && Reflection.getPackageName((Class)(type = (Class)i$.next())).equals(visiblePackage)) {
                for (Method method : type.getDeclaredMethods()) {
                    if (method.isSynthetic() || !this.isVisible(method)) continue;
                    builder.add((Object)method);
                }
            }
            return builder.build();
        }
    }
}

