/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_f64x2_cmp.wast

// ./test/core/simd/simd_f64x2_cmp.wast:4
let $0 = instantiate(`(module
  (func (export "f64x2.eq") (param v128 v128) (result v128) (f64x2.eq (local.get 0) (local.get 1)))
  (func (export "f64x2.ne") (param v128 v128) (result v128) (f64x2.ne (local.get 0) (local.get 1)))
  (func (export "f64x2.lt") (param v128 v128) (result v128) (f64x2.lt (local.get 0) (local.get 1)))
  (func (export "f64x2.le") (param v128 v128) (result v128) (f64x2.le (local.get 0) (local.get 1)))
  (func (export "f64x2.gt") (param v128 v128) (result v128) (f64x2.gt (local.get 0) (local.get 1)))
  (func (export "f64x2.ge") (param v128 v128) (result v128) (f64x2.ge (local.get 0) (local.get 1)))
)`);

// ./test/core/simd/simd_f64x2_cmp.wast:13
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:16
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:19
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:22
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:25
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:28
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:31
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:34
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:37
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:40
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:43
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:46
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:49
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:52
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:55
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:58
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:61
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:64
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:67
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:70
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:73
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:76
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:79
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:82
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:85
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:88
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:91
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:94
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:97
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:100
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:103
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:106
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:109
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:112
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:115
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:118
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:121
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:124
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:127
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:130
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:133
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:136
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:139
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:142
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:145
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:148
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:151
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:154
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:157
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:160
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:163
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:166
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:169
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:172
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:175
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:178
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:181
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:184
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:187
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:190
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:193
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:196
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:199
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:202
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:205
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:208
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([-0, -0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:211
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:214
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:217
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:220
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:223
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:226
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:229
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:232
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:235
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([1, 1]), f64x2([-1, -1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:238
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:241
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:244
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:247
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:250
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:253
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:256
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:259
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:262
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:265
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:268
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:271
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:274
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:277
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:280
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:283
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:286
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:289
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:292
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:295
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:298
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:301
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:304
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:307
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:310
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:313
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:316
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:319
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:322
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([1, 1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:325
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:328
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:331
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:334
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:337
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:340
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:343
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:346
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:349
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([0, 0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:352
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:355
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:358
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:361
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:364
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:367
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:370
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:373
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:376
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:379
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:382
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:385
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:388
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:391
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:394
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:397
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:400
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:403
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:406
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:409
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:412
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:415
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:418
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:421
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:424
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:427
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:430
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:433
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:436
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:439
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:442
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:445
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:448
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:451
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:454
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:457
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:460
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:463
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:466
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:469
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:472
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:475
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:478
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:481
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:484
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:487
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:490
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:493
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:496
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:499
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:502
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:505
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:508
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:511
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:514
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:517
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:520
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:523
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:526
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:529
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:532
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:535
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:538
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:541
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:544
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:547
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:550
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:553
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:556
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:559
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:562
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:565
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:568
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:571
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:574
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:577
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:580
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:583
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:586
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:589
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:592
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:595
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:598
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:601
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:604
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:607
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:610
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:613
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:616
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:619
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:622
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([1, 1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:625
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:628
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:631
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:634
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:637
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:640
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:643
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:646
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:649
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([0, 0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:652
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([Infinity, Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:655
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0.5, 0.5]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:658
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:661
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:664
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:667
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:670
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:673
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:676
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:679
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:682
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:685
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:688
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:691
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:694
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:697
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:700
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:703
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:706
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:709
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:712
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:715
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:718
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:721
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:724
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:727
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:730
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:733
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:736
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:739
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:742
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([1, 1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:745
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:748
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([-0, -0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:751
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:754
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:757
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:760
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:763
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:766
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:769
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([0, 0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:772
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([Infinity, Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:775
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([0, 0]), f64x2([-1, -1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:778
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:781
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:784
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:787
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:790
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:793
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:796
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:799
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:802
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([Infinity, Infinity]), f64x2([1, 1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:805
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:808
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([Infinity, Infinity]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:811
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([Infinity, Infinity]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:814
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:817
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:820
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:823
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([Infinity, Infinity]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:826
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:829
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([Infinity, Infinity]), f64x2([0, 0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:832
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:835
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([Infinity, Infinity]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:838
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:841
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:844
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:847
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:850
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:853
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:856
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:859
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:862
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([1, 1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:865
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:868
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:871
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:874
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:877
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:880
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:883
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:886
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:889
assert_return(() => invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:892
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([Infinity, Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:895
assert_return(
  () => invoke($0, `f64x2.eq`, [f64x2([-1, -1]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:898
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:901
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:904
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:907
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:910
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:913
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:916
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:919
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:922
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:925
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:928
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:931
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:934
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:937
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:940
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:943
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:946
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:949
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:952
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:955
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:958
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:961
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:964
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:967
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:970
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:973
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:976
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:979
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:982
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:985
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:988
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:991
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:994
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:997
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1000
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1003
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1006
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1009
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1012
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1015
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1018
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1021
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1024
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1027
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1030
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1033
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1036
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1039
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1042
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1045
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1048
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1051
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1054
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1057
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1060
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1063
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1066
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1069
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1072
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1075
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1078
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1081
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1084
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1087
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1090
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1093
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1096
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1099
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1102
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1105
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1108
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1111
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1114
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1117
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1120
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1123
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1126
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1129
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1132
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1135
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1138
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1141
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1144
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1147
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1150
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1153
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1156
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1159
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1162
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1165
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1168
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1171
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1174
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1177
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1180
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1183
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1186
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1189
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1192
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1195
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1198
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1201
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1204
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1207
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1210
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1213
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1216
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1219
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1222
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1225
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1228
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1231
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1234
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1237
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1240
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1243
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1246
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1249
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1252
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1255
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1258
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1261
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1264
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1267
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1270
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1273
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1276
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1279
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1282
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1285
assert_return(
  () =>
    invoke($0, `f64x2.eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1288
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1291
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1294
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1297
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1300
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1303
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1306
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1309
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1312
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1315
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1318
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1321
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1324
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1327
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1330
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1333
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1336
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1339
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1342
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1345
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1348
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1351
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1354
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1357
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1360
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1363
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1366
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1369
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1372
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1375
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1378
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1381
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1384
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1387
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1390
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1393
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1396
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1399
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1402
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1405
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1408
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1411
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1414
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1417
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1420
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1423
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1426
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1429
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1432
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1435
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1438
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1441
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1444
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1447
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1450
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1453
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1456
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1459
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1462
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1465
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1468
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1471
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1474
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1477
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([1, 1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:1480
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1483
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([-0, -0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:1486
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1489
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1492
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1495
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1498
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1501
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1504
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([0, 0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:1507
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1510
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([1, 1]), f64x2([-1, -1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:1513
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1516
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1519
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1522
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1525
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1528
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1531
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1534
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1537
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1540
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1543
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1546
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1549
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1552
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1555
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1558
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1561
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1564
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1567
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1570
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1573
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1576
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1579
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1582
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1585
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1588
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1591
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1594
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1597
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:1600
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1603
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1606
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1609
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1612
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1615
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1618
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1621
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1624
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:1627
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1630
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1633
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1636
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1639
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1642
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1645
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1648
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1651
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1654
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1657
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1660
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1663
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1666
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1669
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1672
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1675
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1678
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1681
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1684
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1687
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1690
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1693
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1696
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1699
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1702
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1705
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1708
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1711
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1714
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1717
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1720
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1723
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1726
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1729
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1732
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1735
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1738
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1741
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1744
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1747
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1750
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1753
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1756
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1759
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1762
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1765
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1768
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1771
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1774
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1777
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1780
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1783
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1786
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1789
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1792
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1795
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1798
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1801
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1804
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1807
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1810
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1813
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1816
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1819
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1822
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1825
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1828
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1831
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1834
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1837
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1840
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1843
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1846
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1849
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1852
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1855
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1858
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1861
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1864
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1867
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1870
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1873
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1876
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1879
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1882
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1885
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1888
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1891
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1894
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1897
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1900
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1903
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1906
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1909
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1912
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1915
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1918
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1921
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1924
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1927
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1930
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0.5, 0.5]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1933
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1936
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1939
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1942
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1945
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1948
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1951
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1954
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1957
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1960
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1963
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1966
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1969
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1972
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1975
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1978
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1981
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1984
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1987
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1990
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1993
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1996
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:1999
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2002
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2005
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2008
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2011
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2014
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2017
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2020
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2023
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([-0, -0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2026
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2029
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2032
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2035
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2038
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2041
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2044
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2047
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2050
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([0, 0]), f64x2([-1, -1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2053
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2056
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2059
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2062
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2065
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2068
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2071
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2074
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2077
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([Infinity, Infinity]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2080
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2083
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([Infinity, Infinity]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2086
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([Infinity, Infinity]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2089
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2092
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2095
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2098
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([Infinity, Infinity]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2101
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2104
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([Infinity, Infinity]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2107
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2110
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([Infinity, Infinity]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2113
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2116
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2119
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2122
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2125
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2128
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2131
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2134
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2137
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2140
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2143
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2146
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2149
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2152
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2155
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2158
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2161
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2164
assert_return(() => invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([0, 0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2167
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2170
assert_return(
  () => invoke($0, `f64x2.ne`, [f64x2([-1, -1]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2173
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2176
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2179
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2182
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2185
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2188
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2191
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2194
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2197
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2200
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2203
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2206
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2209
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2212
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2215
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2218
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2221
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2224
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2227
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2230
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2233
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2236
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2239
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2242
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2245
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2248
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2251
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2254
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2257
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2260
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2263
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2266
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2269
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2272
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2275
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2278
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2281
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2284
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2287
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2290
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2293
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2296
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2299
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2302
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2305
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2308
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2311
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2314
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2317
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2320
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2323
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2326
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2329
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2332
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2335
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2338
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2341
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2344
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2347
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2350
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2353
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2356
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2359
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2362
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2365
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2368
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2371
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2374
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2377
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2380
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2383
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2386
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2389
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2392
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2395
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2398
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2401
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2404
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2407
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2410
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2413
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2416
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2419
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2422
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2425
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2428
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2431
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2434
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2437
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2440
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2443
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2446
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2449
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2452
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2455
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2458
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2461
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2464
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2467
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2470
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2473
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2476
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2479
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2482
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2485
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2488
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2491
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2494
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2497
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2500
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2503
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2506
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2509
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2512
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2515
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2518
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2521
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2524
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2527
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2530
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2533
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2536
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2539
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2542
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2545
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2548
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2551
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2554
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2557
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2560
assert_return(
  () =>
    invoke($0, `f64x2.ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2563
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2566
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2569
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2572
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2575
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2578
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2581
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2584
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2587
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2590
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2593
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2596
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2599
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2602
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2605
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2608
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2611
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2614
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2617
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2620
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2623
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2626
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2629
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2632
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2635
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2638
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2641
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2644
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2647
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2650
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2653
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2656
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2659
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2662
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2665
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2668
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2671
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2674
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2677
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2680
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2683
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2686
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2689
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2692
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2695
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2698
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2701
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2704
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2707
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2710
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2713
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2716
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2719
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2722
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2725
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2728
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2731
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2734
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2737
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2740
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2743
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2746
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2749
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2752
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([1, 1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2755
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2758
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([-0, -0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2761
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2764
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2767
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2770
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2773
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2776
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2779
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2782
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2785
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([1, 1]), f64x2([-1, -1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2788
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2791
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2794
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2797
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2800
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2803
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2806
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2809
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2812
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2815
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2818
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2821
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2824
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2827
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2830
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2833
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2836
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2839
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2842
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2845
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2848
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2851
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2854
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2857
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2860
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2863
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2866
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2869
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2872
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2875
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2878
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2881
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2884
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2887
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2890
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2893
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2896
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2899
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:2902
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2905
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2908
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2911
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2914
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2917
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2920
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2923
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2926
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2929
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2932
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2935
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2938
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2941
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2944
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2947
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2950
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2953
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2956
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2959
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2962
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2965
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2968
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2971
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2974
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2977
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2980
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2983
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2986
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2989
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2992
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2995
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:2998
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3001
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3004
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3007
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3010
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3013
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3016
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3019
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3022
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3025
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3028
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3031
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3034
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3037
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3040
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3043
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3046
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3049
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3052
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3055
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3058
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3061
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3064
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3067
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3070
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3073
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3076
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3079
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3082
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3085
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3088
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3091
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3094
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3097
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3100
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3103
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3106
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3109
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3112
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3115
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3118
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3121
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3124
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3127
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3130
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3133
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3136
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3139
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3142
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3145
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3148
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3151
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3154
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3157
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3160
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3163
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3166
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3169
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3172
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3175
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3178
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3181
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3184
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3187
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3190
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3193
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3196
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3199
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([0, 0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3202
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3205
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0.5, 0.5]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3208
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3211
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3214
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3217
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3220
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3223
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3226
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3229
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3232
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3235
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3238
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3241
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3244
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3247
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3250
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3253
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3256
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3259
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3262
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3265
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3268
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3271
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3274
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3277
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3280
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3283
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3286
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3289
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3292
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:3295
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3298
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([-0, -0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:3301
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3304
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3307
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3310
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3313
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3316
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3319
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:3322
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3325
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([0, 0]), f64x2([-1, -1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:3328
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3331
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3334
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3337
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3340
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3343
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3346
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3349
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3352
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([Infinity, Infinity]), f64x2([1, 1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3355
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3358
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([Infinity, Infinity]), f64x2([-0, -0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3361
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([Infinity, Infinity]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3364
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3367
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3370
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3373
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([Infinity, Infinity]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3376
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3379
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([Infinity, Infinity]), f64x2([0, 0])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3382
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3385
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([Infinity, Infinity]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3388
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3391
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3394
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3397
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3400
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3403
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3406
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3409
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3412
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:3415
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3418
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3421
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3424
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3427
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3430
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3433
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3436
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3439
assert_return(() => invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([0, 0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:3442
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3445
assert_return(
  () => invoke($0, `f64x2.lt`, [f64x2([-1, -1]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3448
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3451
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3454
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3457
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3460
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3463
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3466
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3469
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3472
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3475
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3478
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3481
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3484
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3487
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3490
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3493
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3496
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3499
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3502
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3505
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3508
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3511
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3514
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3517
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3520
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3523
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3526
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3529
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3532
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3535
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3538
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3541
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3544
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3547
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3550
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3553
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3556
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3559
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3562
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3565
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3568
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3571
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3574
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3577
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3580
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3583
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        123456789012345690000000000000000000000000000000000000000,
        123456789012345690000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3586
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        0.000000000000000000012345678901234569,
        0.000000000000000000012345678901234569,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3589
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3592
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([
        12345678900000000000000000000000000000000000000,
        12345678900000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3595
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      f64x2([1234567890123456800, 1234567890123456800]),
      f64x2([1234567890123456800, 1234567890123456800]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3598
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3601
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3604
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3607
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3610
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3613
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3616
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3619
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3622
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3625
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3628
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3631
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3634
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3637
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3640
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3643
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3646
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3649
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3652
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3655
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3658
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3661
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3664
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3667
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3670
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3673
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3676
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3679
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3682
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3685
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3688
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3691
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3694
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3697
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3700
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3703
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3706
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3709
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3712
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3715
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3718
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3721
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3724
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3727
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3730
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3733
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3736
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3739
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3742
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3745
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3748
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3751
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3754
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3757
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3760
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3763
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3766
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3769
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3772
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3775
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3778
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3781
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3784
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3787
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3790
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3793
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3796
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3799
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3802
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3805
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3808
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3811
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3814
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3817
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3820
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3823
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3826
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3829
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3832
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3835
assert_return(
  () =>
    invoke($0, `f64x2.lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3838
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3841
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3844
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3847
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3850
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3853
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3856
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3859
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3862
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3865
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3868
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3871
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3874
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3877
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3880
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3883
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3886
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3889
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3892
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3895
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3898
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3901
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3904
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3907
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3910
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3913
assert_return(
  () =>
    invoke($0, `f64x2.le`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3916
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3919
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3922
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3925
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3928
assert_return(
  () =>
    invoke($0, `f64x2.le`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3931
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3934
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3937
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3940
assert_return(
  () =>
    invoke($0, `f64x2.le`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3943
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3946
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3949
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3952
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3955
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3958
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3961
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3964
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3967
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3970
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3973
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3976
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3979
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3982
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3985
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3988
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3991
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3994
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:3997
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4000
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4003
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4006
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4009
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4012
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4015
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4018
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4021
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4024
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4027
assert_return(() => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:4030
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4033
assert_return(() => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([-0, -0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:4036
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4039
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4042
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4045
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4048
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4051
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4054
assert_return(() => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([0, 0])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:4057
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4060
assert_return(() => invoke($0, `f64x2.le`, [f64x2([1, 1]), f64x2([-1, -1])]), [
  i64x2([0x0n, 0x0n]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:4063
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4066
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4069
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4072
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4075
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4078
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4081
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4084
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4087
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4090
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4093
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4096
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4099
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4102
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4105
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4108
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4111
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4114
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4117
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4120
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4123
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4126
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4129
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4132
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4135
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4138
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4141
assert_return(
  () =>
    invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4144
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4147
assert_return(() => invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([1, 1])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:4150
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4153
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4156
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4159
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4162
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4165
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4168
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4171
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4174
assert_return(() => invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([0, 0])]), [
  i64x2([0xffffffffffffffffn, 0xffffffffffffffffn]),
]);

// ./test/core/simd/simd_f64x2_cmp.wast:4177
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4180
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4183
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4186
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4189
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4192
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4195
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4198
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4201
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4204
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4207
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4210
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4213
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4216
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4219
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4222
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4225
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4228
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4231
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4234
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4237
assert_return(
  () =>
    invoke($0, `f64x2.le`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4240
assert_return(
  () => invoke($0, `f64x2.le`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4243
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4246
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4249
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4252
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4255
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4258
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4261
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4264
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4267
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4270
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4273
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4276
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4279
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4282
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4285
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4288
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4291
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4294
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4297
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4300
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4303
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4306
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4309
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4312
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4315
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4318
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4321
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4324
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4327
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4330
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4333
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4336
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4339
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4342
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4345
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4348
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4351
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4354
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4357
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4360
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4363
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4366
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4369
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4372
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4375
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4378
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4381
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4384
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4387
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4390
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4393
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4396
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4399
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4402
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4405
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4408
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4411
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [i64x2([0x0n, 0x0n])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4414
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4417
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [i64x2([0xffffffffffffffffn, 0xffffffffffffffffn])],
);

// ./test/core/simd/simd_f64x2_cmp.wast:4420
assert_return(
  () =>
    invoke($0, `f64x2.le`, [
      f64x2([
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000