/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef DELEGATE_H
#define DELEGATE_H

// Qt
#include <QStyledItemDelegate>

class Delegate : public QStyledItemDelegate
{
public:
    Delegate(QObject* parent = 0);

protected:
    virtual void paint(QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const;
    virtual QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;

private:
    void paintTime(QPainter* painter, const QStyleOptionViewItem& option, const QString& time) const;
    void paintCount(QPainter* painter, const QStyleOptionViewItem& option, int count) const;
};

#endif /* DELEGATE_H */
