/* MediaDataRepresentation.c generated by valac 0.36.6, the Vala compiler
 * generated from MediaDataRepresentation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;
typedef struct _BackingFileStatePrivate BackingFileStatePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef struct _ParamSpecBackingFileState ParamSpecBackingFileState;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_RATING (rating_get_type ())

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_EVENT_SOURCE_COLLECTION (event_source_collection_get_type ())
#define EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollection))
#define EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))
#define IS_EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE_COLLECTION))
#define IS_EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE_COLLECTION))
#define EVENT_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))

typedef struct _EventSourceCollection EventSourceCollection;
typedef struct _EventSourceCollectionClass EventSourceCollectionClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
enum  {
	MEDIA_SOURCE_MASTER_REPLACED_SIGNAL,
	MEDIA_SOURCE_LAST_SIGNAL
};
static guint media_source_signals[MEDIA_SOURCE_LAST_SIGNAL] = {0};
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;
typedef struct _DatabaseSourceHoldingTankPrivate DatabaseSourceHoldingTankPrivate;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;
typedef struct _MediaSourceHoldingTankPrivate MediaSourceHoldingTankPrivate;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef struct _TransactionControllerPrivate TransactionControllerPrivate;

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;
typedef struct _MediaSourceTransactionControllerPrivate MediaSourceTransactionControllerPrivate;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define _import_id_free0(var) ((var == NULL) ? NULL : (var = (import_id_free (var), NULL)))

#define TYPE_AGGREGATE_PROGRESS_MONITOR (aggregate_progress_monitor_get_type ())
#define AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitor))
#define AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))
#define IS_AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define IS_AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define AGGREGATE_PROGRESS_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))

typedef struct _AggregateProgressMonitor AggregateProgressMonitor;
typedef struct _AggregateProgressMonitorClass AggregateProgressMonitorClass;
#define _aggregate_progress_monitor_unref0(var) ((var == NULL) ? NULL : (var = (aggregate_progress_monitor_unref (var), NULL)))

#define TOMBSTONE_TYPE_REASON (tombstone_reason_get_type ())
enum  {
	MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_STARTING_SIGNAL,
	MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_COMPLETED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_MASTER_FILE_REPLACED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_TRASHCAN_CONTENTS_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_IMPORT_ROLL_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_OFFLINE_CONTENTS_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_FLAGGED_CONTENTS_ALTERED_SIGNAL,
	MEDIA_SOURCE_COLLECTION_LAST_SIGNAL
};
static guint media_source_collection_signals[MEDIA_SOURCE_COLLECTION_LAST_SIGNAL] = {0};

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
typedef struct _MediaCollectionRegistryPrivate MediaCollectionRegistryPrivate;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;

#define TYPE_LIBRARY_MONITOR (library_monitor_get_type ())
#define LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitor))
#define LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))
#define IS_LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR))
#define IS_LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR))
#define LIBRARY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))

typedef struct _LibraryMonitor LibraryMonitor;
typedef struct _LibraryMonitorClass LibraryMonitorClass;

#define TYPE_LIBRARY_MONITOR_POOL (library_monitor_pool_get_type ())
#define LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPool))
#define LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))
#define IS_LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR_POOL))
#define IS_LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR_POOL))
#define LIBRARY_MONITOR_POOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))

typedef struct _LibraryMonitorPool LibraryMonitorPool;
typedef struct _LibraryMonitorPoolClass LibraryMonitorPoolClass;
#define _library_monitor_pool_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_pool_unref (var), NULL)))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
typedef struct _ParamSpecMediaCollectionRegistry ParamSpecMediaCollectionRegistry;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BackingFileState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingFileStatePrivate * priv;
	gchar* filepath;
	gint64 filesize;
	time_t modification_time;
	gchar* md5;
};

struct _BackingFileStateClass {
	GTypeClass parent_class;
	void (*finalize) (BackingFileState *self);
};

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

struct _ParamSpecBackingFileState {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ImportID {
	gint64 id;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _MediaSourcePrivate {
	Event* event;
	gchar* indexable_keywords;
};

typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

struct _DatabaseSourceHoldingTank {
	SourceHoldingTank parent_instance;
	DatabaseSourceHoldingTankPrivate * priv;
};

struct _DatabaseSourceHoldingTankClass {
	SourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTank {
	DatabaseSourceHoldingTank parent_instance;
	MediaSourceHoldingTankPrivate * priv;
};

struct _MediaSourceHoldingTankClass {
	DatabaseSourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTankPrivate {
	GeeHashMap* master_file_map;
};

typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);
typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
struct _TransactionController {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TransactionControllerPrivate * priv;
};

struct _TransactionControllerClass {
	GTypeClass parent_class;
	void (*finalize) (TransactionController *self);
	void (*begin_impl) (TransactionController* self, GError** error);
	void (*commit_impl) (TransactionController* self, GError** error);
};

struct _MediaSourceTransactionController {
	TransactionController parent_instance;
	MediaSourceTransactionControllerPrivate * priv;
};

struct _MediaSourceTransactionControllerClass {
	TransactionControllerClass parent_class;
};

struct _MediaSourceTransactionControllerPrivate {
	MediaSourceCollection* sources;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _MediaSourceCollectionPrivate {
	MediaSourceHoldingTank* trashcan;
	MediaSourceHoldingTank* offline_bin;
	GeeHashMap* by_master_file;
	GeeMultiMap* import_rolls;
	GeeTreeSet* sorted_import_ids;
	GeeSet* flagged;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

typedef enum  {
	TOMBSTONE_REASON_REMOVED_BY_USER = 0,
	TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE = 1
} TombstoneReason;

struct _MediaCollectionRegistry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaCollectionRegistryPrivate * priv;
};

struct _MediaCollectionRegistryClass {
	GTypeClass parent_class;
	void (*finalize) (MediaCollectionRegistry *self);
};

struct _MediaCollectionRegistryPrivate {
	GeeArrayList* all;
	GeeHashMap* by_typename;
};

struct _ParamSpecMediaCollectionRegistry {
	GParamSpec parent_instance;
};


static gpointer backing_file_state_parent_class = NULL;
static gpointer media_source_parent_class = NULL;
extern EventSourceCollection* event_global;
static IndexableIface * media_source_indexable_parent_iface = NULL;
static gpointer media_source_holding_tank_parent_class = NULL;
static gpointer media_source_transaction_controller_parent_class = NULL;
static gpointer media_source_collection_parent_class = NULL;
static gpointer media_collection_registry_parent_class = NULL;
static MediaCollectionRegistry* media_collection_registry_instance;
static MediaCollectionRegistry* media_collection_registry_instance = NULL;
extern gboolean commandline_options_no_runtime_monitoring;

gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
enum  {
	BACKING_FILE_STATE_DUMMY_PROPERTY
};
BackingFileState* backing_file_state_new (const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5);
BackingFileState* backing_file_state_construct (GType object_type, const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5);
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
BackingFileState* backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row, const gchar* md5);
BackingFileState* backing_file_state_construct_from_photo_row (GType object_type, BackingPhotoRow* photo_row, const gchar* md5);
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType orientation_get_type (void) G_GNUC_CONST;
GFile* backing_file_state_get_file (BackingFileState* self);
static void backing_file_state_finalize (BackingFileState * obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType rating_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
#define MEDIA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_SOURCE, MediaSourcePrivate))
enum  {
	MEDIA_SOURCE_DUMMY_PROPERTY
};
MediaSource* media_source_construct (GType object_type, gint64 object_id);
ThumbnailSource* thumbnail_source_construct (GType object_type, gint64 object_id);
guint64 media_source_internal_add_flags (guint64 flags, guint64 selector);
guint64 media_source_internal_remove_flags (guint64 flags, guint64 selector);
gboolean media_source_internal_is_flag_set (guint64 flags, guint64 selector);
void media_source_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file);
static void media_source_real_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file);
static void media_source_real_notify_altered (DataObject* base, Alteration* alteration);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
static void media_source_update_indexable_keywords (MediaSource* self);
Alteration* alteration_compress (Alteration* self, Alteration* other);
Alteration* alteration_new (const gchar* subject, const gchar* detail);
Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
static void media_source_real_notify_membership_changed (DataObject* base, DataCollection* collection);
void data_object_notify_membership_changed (DataObject* self, DataCollection* collection);
gchar* media_source_get_title (MediaSource* self);
gchar* media_source_get_basename (MediaSource* self);
gchar* media_source_get_comment (MediaSource* self);
gchar* indexable_prepare_indexable_strings (gchar** strs, int strs_length1);
static const gchar* media_source_real_get_indexable_keywords (Indexable* base);
gboolean media_source_set_event_id (MediaSource* self, EventID* id);
static gboolean media_source_real_set_event_id (MediaSource* self, EventID* id);
gboolean media_source_delete_original_file (MediaSource* self);
GFile* media_source_get_master_file (MediaSource* self);
GFile* app_dirs_get_import_dir (void);
gboolean query_is_directory_empty (GFile* dir, GError** error);
static gchar* media_source_real_get_name (DataObject* base);
gboolean is_string_empty (const gchar* s);
static gchar* media_source_real_get_basename (MediaSource* self);
GFile* media_source_get_file (MediaSource* self);
static GFile* media_source_real_get_file (MediaSource* self);
static GFile* media_source_real_get_master_file (MediaSource* self);
guint64 media_source_get_master_filesize (MediaSource* self);
static guint64 media_source_real_get_master_filesize (MediaSource* self);
guint64 media_source_get_filesize (MediaSource* self);
static guint64 media_source_real_get_filesize (MediaSource* self);
time_t media_source_get_timestamp (MediaSource* self);
static time_t media_source_real_get_timestamp (MediaSource* self);
BackingFileState** media_source_get_backing_files_state (MediaSource* self, int* result_length1);
static BackingFileState** media_source_real_get_backing_files_state (MediaSource* self, int* result_length1);
static gchar* media_source_real_get_title (MediaSource* self);
static gchar* media_source_real_get_comment (MediaSource* self);
void media_source_set_title (MediaSource* self, const gchar* title);
static void media_source_real_set_title (MediaSource* self, const gchar* title);
gboolean media_source_set_comment (MediaSource* self, const gchar* comment);
static gboolean media_source_real_set_comment (MediaSource* self, const gchar* comment);
gchar* media_source_prep_title (const gchar* title);
GType prepare_input_text_options_get_type (void) G_GNUC_CONST;
gchar* prepare_input_text (const gchar* text, PrepareInputTextOptions options, gint dest_length);
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
gchar* media_source_prep_comment (const gchar* comment);
Rating media_source_get_rating (MediaSource* self);
static Rating media_source_real_get_rating (MediaSource* self);
void media_source_set_rating (MediaSource* self, Rating rating);
static void media_source_real_set_rating (MediaSource* self, Rating rating);
void media_source_increase_rating (MediaSource* self);
static void media_source_real_increase_rating (MediaSource* self);
void media_source_decrease_rating (MediaSource* self);
static void media_source_real_decrease_rating (MediaSource* self);
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
static void media_source_real_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self, Scaling* scaling, GError** error);
static GdkPixbuf* media_source_real_get_preview_pixbuf (MediaSource* self, Scaling* scaling, GError** error);
gboolean media_source_is_trashed (MediaSource* self);
static gboolean media_source_real_is_trashed (MediaSource* self);
void media_source_trash (MediaSource* self);
static void media_source_real_trash (MediaSource* self);
void media_source_untrash (MediaSource* self);
static void media_source_real_untrash (MediaSource* self);
gboolean media_source_is_offline (MediaSource* self);
static gboolean media_source_real_is_offline (MediaSource* self);
void media_source_mark_offline (MediaSource* self);
static void media_source_real_mark_offline (MediaSource* self);
void media_source_mark_online (MediaSource* self);
static void media_source_real_mark_online (MediaSource* self);
gchar* media_source_get_master_md5 (MediaSource* self);
static gchar* media_source_real_get_master_md5 (MediaSource* self);
void media_source_get_event_id (MediaSource* self, EventID* result);
static void media_source_real_get_event_id (MediaSource* self, EventID* result);
Event* media_source_get_event (MediaSource* self);
gboolean event_id_is_valid (EventID *self);
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType event_source_collection_get_type (void) G_GNUC_CONST;
Event* event_source_collection_fetch (EventSourceCollection* self, EventID* event_id);
gboolean media_source_set_event (MediaSource* self, Event* new_event);
void event_get_event_id (Event* self, EventID* result);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self, gint64 id);
void event_detach (Event* self, MediaSource* source);
void event_attach (Event* self, MediaSource* source);
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transaction_controller (GValue* value, gpointer v_object);
void value_take_transaction_controller (GValue* value, gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
void media_source_set_many_to_event (GeeCollection* media_sources, Event* event, TransactionController* controller, GError** error);
void transaction_controller_begin (TransactionController* self);
void event_attach_many (Event* self, GeeCollection* media);
void transaction_controller_commit (TransactionController* self);
time_t media_source_get_exposure_time (MediaSource* self);
static time_t media_source_real_get_exposure_time (MediaSource* self);
void media_source_get_import_id (MediaSource* self, ImportID* result);
static void media_source_real_get_import_id (MediaSource* self, ImportID* result);
static void media_source_real_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void media_source_finalize (GObject * obj);
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
#define MEDIA_SOURCE_HOLDING_TANK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankPrivate))
enum  {
	MEDIA_SOURCE_HOLDING_TANK_DUMMY_PROPERTY
};
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType media_source_collection_get_type (void) G_GNUC_CONST;
MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type, MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
DatabaseSourceHoldingTank* database_source_holding_tank_new (SourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
DatabaseSourceHoldingTank* database_source_holding_tank_construct (GType object_type, SourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self, GFile* file);
MediaSource* media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self, const gchar* md5);
static void media_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base, GeeCollection* added, GeeCollection* removed);
static void media_source_holding_tank_on_master_source_replaced (MediaSourceHoldingTank* self, MediaSource* media_source, GFile* old_file, GFile* new_file);
static void _media_source_holding_tank_on_master_source_replaced_media_source_master_replaced (MediaSource* _sender, GFile* old_file, GFile* new_file, gpointer self);
void source_holding_tank_notify_contents_altered (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
static void media_source_holding_tank_finalize (SourceHoldingTank * obj);
GType media_source_transaction_controller_get_type (void) G_GNUC_CONST;
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerPrivate))
enum  {
	MEDIA_SOURCE_TRANSACTION_CONTROLLER_DUMMY_PROPERTY
};
MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type, MediaSourceCollection* sources);
TransactionController* transaction_controller_construct (GType object_type);
static void media_source_transaction_controller_real_begin_impl (TransactionController* base, GError** error);
void database_table_begin_transaction (void);
void data_collection_freeze_notifications (DataCollection* self);
static void media_source_transaction_controller_real_commit_impl (TransactionController* base, GError** error);
void data_collection_thaw_notifications (DataCollection* self);
GQuark database_error_quark (void);
void database_table_commit_transaction (GError** error);
static void media_source_transaction_controller_finalize (TransactionController * obj);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
#define MEDIA_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionPrivate))
enum  {
	MEDIA_SOURCE_COLLECTION_DUMMY_PROPERTY
};
gint import_id_compare_func (ImportID* a, ImportID* b);
static gint _import_id_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
MediaSourceCollection* media_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
DatabaseSourceCollection* database_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
MediaSourceHoldingTank* media_source_collection_create_trashcan (MediaSourceCollection* self);
MediaSourceHoldingTank* media_source_collection_create_offline_bin (MediaSourceCollection* self);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
void media_source_collection_filter_media (GeeCollection* media, GeeCollection* photos, GeeCollection* videos);
gchar* data_object_to_string (DataObject* self);
void media_source_collection_count_media (GeeCollection* media, gint* photo_count, gint* video_count);
gboolean media_source_collection_has_photo (GeeCollection* media);
gboolean media_source_collection_has_video (GeeCollection* media);
static MediaSourceHoldingTank* media_source_collection_real_create_trashcan (MediaSourceCollection* self);
static MediaSourceHoldingTank* media_source_collection_real_create_offline_bin (MediaSourceCollection* self);
MediaMonitor* media_source_collection_create_media_monitor (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
static MediaMonitor* media_source_collection_real_create_media_monitor (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
gchar* media_source_collection_get_typename (MediaSourceCollection* self);
static gchar* media_source_collection_real_get_typename (MediaSourceCollection* self);
gboolean media_source_collection_is_file_recognized (MediaSourceCollection* self, GFile* file);
static gboolean media_source_collection_real_is_file_recognized (MediaSourceCollection* self, GFile* file);
MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self, gint64 numeric_id);
static MediaSource* media_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* self, gint64 numeric_id);
void media_source_collection_notify_import_roll_altered (MediaSourceCollection* self);
static void media_source_collection_real_notify_import_roll_altered (MediaSourceCollection* self);
void media_source_collection_notify_flagged_contents_altered (MediaSourceCollection* self);
static void media_source_collection_real_notify_flagged_contents_altered (MediaSourceCollection* self);
void media_source_collection_notify_media_import_starting (MediaSourceCollection* self, GeeCollection* media);
static void media_source_collection_real_notify_media_import_starting (MediaSourceCollection* self, GeeCollection* media);
void media_source_collection_notify_media_import_completed (MediaSourceCollection* self, GeeCollection* media);
static void media_source_collection_real_notify_media_import_completed (MediaSourceCollection* self, GeeCollection* media);
static void media_source_collection_real_items_altered (DataCollection* base, GeeMap* items);
gboolean alteration_has_subject (Alteration* self, const gchar* subject);
gboolean source_holding_tank_contains (SourceHoldingTank* self, DataSource* source);
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
void source_holding_tank_unlink_and_hold (SourceHoldingTank* self, GeeCollection* unlink);
static void media_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed);
static void media_source_collection_on_master_replaced (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
static void _media_source_collection_on_master_replaced_media_source_master_replaced (MediaSource* _sender, GFile* old_file, GFile* new_file, gpointer self);
gboolean import_id_is_valid (ImportID *self);
void data_collection_notify_contents_altered (DataCollection* self, GeeIterable* added, GeeIterable* removed);
MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self, GFile* file);
MediaSource* media_source_collection_fetch_by_source_id (MediaSourceCollection* self, const gchar* source_id);
static MediaSource* media_source_collection_real_fetch_by_source_id (MediaSourceCollection* self, const gchar* source_id);
gint64 parse_int64 (const gchar* str, gint num_base);
GeeCollection* media_source_collection_get_event_source_ids (MediaSourceCollection* self, EventID* event_id);
static GeeCollection* media_source_collection_real_get_event_source_ids (MediaSourceCollection* self, EventID* event_id);
GeeCollection* media_source_collection_get_trashcan_contents (MediaSourceCollection* self);
GeeCollection* source_holding_tank_get_all (SourceHoldingTank* self);
GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
GeeCollection* media_source_collection_get_flagged (MediaSourceCollection* self);
GeeSortedSet* media_source_collection_get_import_roll_ids (MediaSourceCollection* self);
ImportID* media_source_collection_get_last_import_id (MediaSourceCollection* self);
GeeCollection* media_source_collection_get_import_roll (MediaSourceCollection* self, ImportID* import_id);
void media_source_collection_add_many_to_trash (MediaSourceCollection* self, GeeCollection* sources);
void source_holding_tank_add_many (SourceHoldingTank* self, GeeCollection* many);
void media_source_collection_add_many_to_offline (MediaSourceCollection* self, GeeCollection* sources);
gint media_source_collection_get_trashcan_count (MediaSourceCollection* self);
gint source_holding_tank_get_count (SourceHoldingTank* self);
void media_source_collection_import_many (MediaSourceCollection* self, GeeCollection* media);
static void media_source_collection_real_import_many (MediaSourceCollection* self, GeeCollection* media);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
void media_source_collection_postprocess_imported_media (MediaSourceCollection* self, GeeCollection* media);
static void media_source_collection_real_postprocess_imported_media (MediaSourceCollection* self, GeeCollection* media);
void media_source_collection_remove_from_app (MediaSourceCollection* self, GeeCollection* sources, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed);
gpointer aggregate_progress_monitor_ref (gpointer instance);
void aggregate_progress_monitor_unref (gpointer instance);
GParamSpec* param_spec_aggregate_progress_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_aggregate_progress_monitor (GValue* value, gpointer v_object);
void value_take_aggregate_progress_monitor (GValue* value, gpointer v_object);
gpointer value_get_aggregate_progress_monitor (const GValue* value);
GType aggregate_progress_monitor_get_type (void) G_GNUC_CONST;
AggregateProgressMonitor* aggregate_progress_monitor_new (guint64 grand_total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target);
AggregateProgressMonitor* aggregate_progress_monitor_construct (GType object_type, guint64 grand_total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target);
gboolean aggregate_progress_monitor_monitor (AggregateProgressMonitor* self, guint64 count, guint64 total);
static gboolean _aggregate_progress_monitor_monitor_progress_monitor (guint64 current, guint64 total, gboolean do_event_loop, gpointer self);
void source_holding_tank_destroy_orphans (SourceHoldingTank* self, GeeList* destroy, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed);
gint source_collection_destroy_marked (SourceCollection* self, Marker* marker, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed);
Marker* data_collection_mark_many (DataCollection* self, GeeCollection* objects);
GType tombstone_reason_get_type (void) G_GNUC_CONST;
void tombstone_entomb_many_sources (GeeCollection* sources, TombstoneReason reason, GError** error);
void app_window_database_error (GError* err);
void media_source_collection_delete_backing_files (MediaSourceCollection* self, GeeCollection* sources, ProgressMonitor monitor, void* monitor_target, GeeList* not_deleted);
TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
static void media_source_collection_real_media_import_starting (MediaSourceCollection* self, GeeCollection* media);
static void media_source_collection_real_media_import_completed (MediaSourceCollection* self, GeeCollection* media);
static void media_source_collection_real_master_file_replaced (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void media_source_collection_real_trashcan_contents_altered (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void media_source_collection_real_import_roll_altered (MediaSourceCollection* self);
static void media_source_collection_real_offline_contents_altered (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void media_source_collection_real_flagged_contents_altered (MediaSourceCollection* self);
static void media_source_collection_finalize (DataCollection * obj);
gpointer media_collection_registry_ref (gpointer instance);
void media_collection_registry_unref (gpointer instance);
GParamSpec* param_spec_media_collection_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_collection_registry (GValue* value, gpointer v_object);
void value_take_media_collection_registry (GValue* value, gpointer v_object);
gpointer value_get_media_collection_registry (const GValue* value);
GType media_collection_registry_get_type (void) G_GNUC_CONST;
#define MEDIA_COLLECTION_REGISTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryPrivate))
enum  {
	MEDIA_COLLECTION_REGISTRY_DUMMY_PROPERTY
};
gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_application (GValue* value, gpointer v_object);
void value_take_application (GValue* value, gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_instance (void);
static void media_collection_registry_on_init_done (MediaCollectionRegistry* self);
static void _media_collection_registry_on_init_done_application_init_done (Application* _sender, gpointer self);
#define MEDIA_COLLECTION_REGISTRY_LIBRARY_MONITOR_START_DELAY_MSEC 1000
static MediaCollectionRegistry* media_collection_registry_new (void);
static MediaCollectionRegistry* media_collection_registry_construct (GType object_type);
GType directory_monitor_get_type (void) G_GNUC_CONST;
GType library_monitor_get_type (void) G_GNUC_CONST;
LibraryMonitor* library_monitor_new (GFile* root, gboolean recurse, gboolean monitoring);
LibraryMonitor* library_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring);
gpointer library_monitor_pool_ref (gpointer instance);
void library_monitor_pool_unref (gpointer instance);
GParamSpec* param_spec_library_monitor_pool (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_library_monitor_pool (GValue* value, gpointer v_object);
void value_take_library_monitor_pool (GValue* value, gpointer v_object);
gpointer value_get_library_monitor_pool (const GValue* value);
GType library_monitor_pool_get_type (void) G_GNUC_CONST;
LibraryMonitorPool* library_monitor_pool_get_instance (void);
void library_monitor_pool_replace (LibraryMonitorPool* self, LibraryMonitor* replacement, gint start_msec_delay);
void media_collection_registry_init (void);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
static void media_collection_registry_on_import_directory_changed (void);
static void _media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed (ConfigurationFacade* _sender, gpointer self);
void media_collection_registry_terminate (void);
LibraryMonitor* library_monitor_pool_get_monitor (LibraryMonitorPool* self);
GFile* directory_monitor_get_root (DirectoryMonitor* self);
void library_files_select_copy_function (void);
MediaCollectionRegistry* media_collection_registry_get_instance (void);
gchar* media_collection_registry_get_typename_from_source_id (const gchar* source_id);
#define PHOTO_TYPENAME "thumb"
void media_collection_registry_register_collection (MediaCollectionRegistry* self, MediaSourceCollection* collection);
MediaSourceCollection* media_collection_registry_get_collection (MediaCollectionRegistry* self, const gchar* typename);
GeeCollection* media_collection_registry_get_all (MediaCollectionRegistry* self);
void media_collection_registry_freeze_all (MediaCollectionRegistry* self);
void media_collection_registry_thaw_all (MediaCollectionRegistry* self);
void media_collection_registry_begin_transaction_on_all (MediaCollectionRegistry* self);
void media_collection_registry_commit_transaction_on_all (MediaCollectionRegistry* self);
MediaSource* media_collection_registry_fetch_media (MediaCollectionRegistry* self, const gchar* source_id);
ImportID* media_collection_registry_get_last_import_id (MediaCollectionRegistry* self);
#define IMPORT_ID_INVALID ((gint64) 0)
void import_id_init (ImportID *self, gint64 id);
GeeCollection* media_collection_registry_get_source_ids_for_event_id (MediaCollectionRegistry* self, EventID* event_id);
MediaSourceCollection* media_collection_registry_get_collection_for_file (MediaCollectionRegistry* self, GFile* file);
gboolean media_collection_registry_is_valid_source_id (MediaCollectionRegistry* self, const gchar* source_id);
#define VIDEO_TYPENAME "video"
static void media_collection_registry_finalize (MediaCollectionRegistry * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


BackingFileState* backing_file_state_construct (GType object_type, const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5) {
	BackingFileState* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint64 _tmp2_;
	time_t _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
#line 13 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 13 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = (BackingFileState*) g_type_create_instance (object_type);
#line 14 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = filepath;
#line 14 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 14 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->filepath);
#line 14 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->filepath = _tmp1_;
#line 15 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = filesize;
#line 15 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->filesize = _tmp2_;
#line 16 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = modification_time;
#line 16 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->modification_time = _tmp3_;
#line 17 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = md5;
#line 17 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 17 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->md5);
#line 17 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->md5 = _tmp5_;
#line 13 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self;
#line 1427 "MediaDataRepresentation.c"
}


BackingFileState* backing_file_state_new (const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5) {
#line 13 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return backing_file_state_construct (TYPE_BACKING_FILE_STATE, filepath, filesize, modification_time, md5);
#line 1434 "MediaDataRepresentation.c"
}


BackingFileState* backing_file_state_construct_from_photo_row (GType object_type, BackingPhotoRow* photo_row, const gchar* md5) {
	BackingFileState* self = NULL;
	BackingPhotoRow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	BackingPhotoRow* _tmp3_;
	gint64 _tmp4_;
	BackingPhotoRow* _tmp5_;
	time_t _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
#line 20 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (photo_row), NULL);
#line 20 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = (BackingFileState*) g_type_create_instance (object_type);
#line 21 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = photo_row;
#line 21 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_->filepath;
#line 21 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 21 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->filepath);
#line 21 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->filepath = _tmp2_;
#line 22 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = photo_row;
#line 22 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = _tmp3_->filesize;
#line 22 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->filesize = _tmp4_;
#line 23 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = photo_row;
#line 23 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = _tmp5_->timestamp;
#line 23 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->modification_time = _tmp6_;
#line 24 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp7_ = md5;
#line 24 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 24 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->md5);
#line 24 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->md5 = _tmp8_;
#line 20 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self;
#line 1485 "MediaDataRepresentation.c"
}


BackingFileState* backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row, const gchar* md5) {
#line 20 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return backing_file_state_construct_from_photo_row (TYPE_BACKING_FILE_STATE, photo_row, md5);
#line 1492 "MediaDataRepresentation.c"
}


GFile* backing_file_state_get_file (BackingFileState* self) {
	GFile* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
#line 27 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_BACKING_FILE_STATE (self), NULL);
#line 28 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->filepath;
#line 28 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 28 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 28 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 1510 "MediaDataRepresentation.c"
}


static void value_backing_file_state_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	value->data[0].v_pointer = NULL;
#line 1517 "MediaDataRepresentation.c"
}


static void value_backing_file_state_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		backing_file_state_unref (value->data[0].v_pointer);
#line 1526 "MediaDataRepresentation.c"
	}
}


static void value_backing_file_state_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		dest_value->data[0].v_pointer = backing_file_state_ref (src_value->data[0].v_pointer);
#line 1536 "MediaDataRepresentation.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1540 "MediaDataRepresentation.c"
	}
}


static gpointer value_backing_file_state_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return value->data[0].v_pointer;
#line 1548 "MediaDataRepresentation.c"
}


static gchar* value_backing_file_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (collect_values[0].v_pointer) {
#line 1555 "MediaDataRepresentation.c"
		BackingFileState * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1562 "MediaDataRepresentation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1566 "MediaDataRepresentation.c"
		}
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = backing_file_state_ref (object);
#line 1570 "MediaDataRepresentation.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = NULL;
#line 1574 "MediaDataRepresentation.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 1578 "MediaDataRepresentation.c"
}


static gchar* value_backing_file_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BackingFileState ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1589 "MediaDataRepresentation.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*object_p = NULL;
#line 1595 "MediaDataRepresentation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*object_p = value->data[0].v_pointer;
#line 1599 "MediaDataRepresentation.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*object_p = backing_file_state_ref (value->data[0].v_pointer);
#line 1603 "MediaDataRepresentation.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 1607 "MediaDataRepresentation.c"
}


GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBackingFileState* spec;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKING_FILE_STATE), NULL);
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return G_PARAM_SPEC (spec);
#line 1621 "MediaDataRepresentation.c"
}


gpointer value_get_backing_file_state (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_FILE_STATE), NULL);
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return value->data[0].v_pointer;
#line 1630 "MediaDataRepresentation.c"
}


void value_set_backing_file_state (GValue* value, gpointer v_object) {
	BackingFileState * old;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_FILE_STATE));
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_FILE_STATE));
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		backing_file_state_ref (value->data[0].v_pointer);
#line 1650 "MediaDataRepresentation.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = NULL;
#line 1654 "MediaDataRepresentation.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		backing_file_state_unref (old);
#line 1660 "MediaDataRepresentation.c"
	}
}


void value_take_backing_file_state (GValue* value, gpointer v_object) {
	BackingFileState * old;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_FILE_STATE));
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_FILE_STATE));
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = v_object;
#line 1679 "MediaDataRepresentation.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = NULL;
#line 1683 "MediaDataRepresentation.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		backing_file_state_unref (old);
#line 1689 "MediaDataRepresentation.c"
	}
}


static void backing_file_state_class_init (BackingFileStateClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	backing_file_state_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((BackingFileStateClass *) klass)->finalize = backing_file_state_finalize;
#line 1699 "MediaDataRepresentation.c"
}


static void backing_file_state_instance_init (BackingFileState * self) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->ref_count = 1;
#line 1706 "MediaDataRepresentation.c"
}


static void backing_file_state_finalize (BackingFileState * obj) {
	BackingFileState * self;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_FILE_STATE, BackingFileState);
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_handlers_destroy (self);
#line 8 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->filepath);
#line 11 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->md5);
#line 1720 "MediaDataRepresentation.c"
}


GType backing_file_state_get_type (void) {
	static volatile gsize backing_file_state_type_id__volatile = 0;
	if (g_once_init_enter (&backing_file_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_backing_file_state_init, value_backing_file_state_free_value, value_backing_file_state_copy_value, value_backing_file_state_peek_pointer, "p", value_backing_file_state_collect_value, "p", value_backing_file_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BackingFileStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_file_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingFileState), 0, (GInstanceInitFunc) backing_file_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType backing_file_state_type_id;
		backing_file_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackingFileState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&backing_file_state_type_id__volatile, backing_file_state_type_id);
	}
	return backing_file_state_type_id__volatile;
}


gpointer backing_file_state_ref (gpointer instance) {
	BackingFileState * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return instance;
#line 1745 "MediaDataRepresentation.c"
}


void backing_file_state_unref (gpointer instance) {
	BackingFileState * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		BACKING_FILE_STATE_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1758 "MediaDataRepresentation.c"
	}
}


MediaSource* media_source_construct (GType object_type, gint64 object_id) {
	MediaSource * self = NULL;
	gint64 _tmp0_;
#line 40 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = object_id;
#line 40 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = (MediaSource*) thumbnail_source_construct (object_type, _tmp0_);
#line 39 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self;
#line 1772 "MediaDataRepresentation.c"
}


inline guint64 media_source_internal_add_flags (guint64 flags, guint64 selector) {
	guint64 result = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = flags;
#line 44 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = selector;
#line 44 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp0_ | _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 1788 "MediaDataRepresentation.c"
}


inline guint64 media_source_internal_remove_flags (guint64 flags, guint64 selector) {
	guint64 result = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = flags;
#line 48 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = selector;
#line 48 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp0_ & (~_tmp1_);
#line 48 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 1804 "MediaDataRepresentation.c"
}


inline gboolean media_source_internal_is_flag_set (guint64 flags, guint64 selector) {
	gboolean result = FALSE;
	guint64 _tmp0_;
	guint64 _tmp1_;
#line 52 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = flags;
#line 52 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = selector;
#line 52 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = (_tmp0_ & _tmp1_) != ((guint64) 0);
#line 52 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 1820 "MediaDataRepresentation.c"
}


static void media_source_real_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file) {
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 55 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 55 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 56 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = old_file;
#line 56 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = new_file;
#line 56 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_emit (self, media_source_signals[MEDIA_SOURCE_MASTER_REPLACED_SIGNAL], 0, _tmp0_, _tmp1_);
#line 1837 "MediaDataRepresentation.c"
}


void media_source_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file) {
#line 55 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 55 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->notify_master_replaced (self, old_file, new_file);
#line 1846 "MediaDataRepresentation.c"
}


static gpointer _alteration_ref0 (gpointer self) {
#line 60 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self ? alteration_ref (self) : NULL;
#line 1853 "MediaDataRepresentation.c"
}


static void media_source_real_notify_altered (DataObject* base, Alteration* alteration) {
	MediaSource * self;
	Alteration* local = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Alteration* _tmp4_;
	gboolean _tmp5_;
	Alteration* _tmp14_;
#line 59 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
#line 59 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 60 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = alteration;
#line 60 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _alteration_ref0 (_tmp0_);
#line 60 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	local = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = local;
#line 62 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = alteration_has_detail (_tmp4_, "metadata", "name");
#line 62 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp5_) {
#line 62 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = TRUE;
#line 1885 "MediaDataRepresentation.c"
	} else {
		Alteration* _tmp6_;
		gboolean _tmp7_;
#line 63 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6_ = local;
#line 63 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp7_ = alteration_has_detail (_tmp6_, "metadata", "comment");
#line 63 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp7_;
#line 1895 "MediaDataRepresentation.c"
	}
#line 62 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp3_) {
#line 62 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = TRUE;
#line 1901 "MediaDataRepresentation.c"
	} else {
		Alteration* _tmp8_;
		gboolean _tmp9_;
#line 64 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp8_ = local;
#line 64 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp9_ = alteration_has_detail (_tmp8_, "backing", "master");
#line 64 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = _tmp9_;
#line 1911 "MediaDataRepresentation.c"
	}
#line 62 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp2_) {
#line 1915 "MediaDataRepresentation.c"
		Alteration* _tmp10_;
		Alteration* _tmp11_;
		Alteration* _tmp12_;
		Alteration* _tmp13_;
#line 65 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_source_update_indexable_keywords (self);
#line 66 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp10_ = local;
#line 66 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp11_ = alteration_new ("indexable", "keywords");
#line 66 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp12_ = _tmp11_;
#line 66 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp13_ = alteration_compress (_tmp10_, _tmp12_);
#line 66 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_alteration_unref0 (local);
#line 66 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		local = _tmp13_;
#line 66 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_alteration_unref0 (_tmp12_);
#line 1936 "MediaDataRepresentation.c"
	}
#line 69 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp14_ = local;
#line 69 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	DATA_OBJECT_CLASS (media_source_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), TYPE_DATA_OBJECT, DataObject), _tmp14_);
#line 59 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_alteration_unref0 (local);
#line 1944 "MediaDataRepresentation.c"
}


static void media_source_real_notify_membership_changed (DataObject* base, DataCollection* collection) {
	MediaSource * self;
	gboolean _tmp0_ = FALSE;
	DataCollection* _tmp1_;
	DataCollection* _tmp3_;
#line 74 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
#line 74 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 75 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = collection;
#line 75 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp1_ != NULL) {
#line 1961 "MediaDataRepresentation.c"
		const gchar* _tmp2_;
#line 75 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = self->priv->indexable_keywords;
#line 75 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 1967 "MediaDataRepresentation.c"
	} else {
#line 75 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = FALSE;
#line 1971 "MediaDataRepresentation.c"
	}
#line 75 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp0_) {
#line 78 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_source_update_indexable_keywords (self);
#line 1977 "MediaDataRepresentation.c"
	}
#line 81 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = collection;
#line 81 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	DATA_OBJECT_CLASS (media_source_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), TYPE_DATA_OBJECT, DataObject), _tmp3_);
#line 1983 "MediaDataRepresentation.c"
}


static void media_source_update_indexable_keywords (MediaSource* self) {
	gchar** indexables = NULL;
	gchar** _tmp0_;
	gint indexables_length1;
	gint _indexables_size_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 84 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 85 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = g_new0 (gchar*, 3 + 1);
#line 85 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	indexables = _tmp0_;
#line 85 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	indexables_length1 = 3;
#line 85 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_indexables_size_ = indexables_length1;
#line 86 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = media_source_get_title (self);
#line 86 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (indexables[0]);
#line 86 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	indexables[0] = _tmp1_;
#line 86 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = indexables[0];
#line 87 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = media_source_get_basename (self);
#line 87 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (indexables[1]);
#line 87 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	indexables[1] = _tmp3_;
#line 87 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = indexables[1];
#line 88 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = media_source_get_comment (self);
#line 88 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (indexables[2]);
#line 88 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	indexables[2] = _tmp5_;
#line 88 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = indexables[2];
#line 90 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp7_ = indexable_prepare_indexable_strings (indexables, indexables_length1);
#line 90 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->priv->indexable_keywords);
#line 90 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->indexable_keywords = _tmp7_;
#line 84 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	indexables = (_vala_array_free (indexables, indexables_length1, (GDestroyNotify) g_free), NULL);
#line 2041 "MediaDataRepresentation.c"
}


static const gchar* media_source_real_get_indexable_keywords (Indexable* base) {
	MediaSource * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
#line 94 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->indexable_keywords;
#line 94 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp0_;
#line 94 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 2057 "MediaDataRepresentation.c"
}


static gboolean media_source_real_set_event_id (MediaSource* self, EventID* id) {
	gboolean _tmp0_ = FALSE;
#line 97 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_set_event_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 97 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 2067 "MediaDataRepresentation.c"
}


gboolean media_source_set_event_id (MediaSource* self, EventID* id) {
#line 97 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
#line 97 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->set_event_id (self, id);
#line 2076 "MediaDataRepresentation.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 114 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self ? g_object_ref (self) : NULL;
#line 2083 "MediaDataRepresentation.c"
}


gboolean media_source_delete_original_file (MediaSource* self) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
#line 100 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	ret = FALSE;
#line 101 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_get_master_file (self);
#line 101 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	file = _tmp0_;
#line 2106 "MediaDataRepresentation.c"
	{
		gboolean _tmp1_ = FALSE;
		GFile* _tmp2_;
		gboolean _tmp3_;
#line 104 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = file;
#line 104 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = g_file_trash (_tmp2_, NULL, &_inner_error_);
#line 104 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp3_;
#line 104 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2119 "MediaDataRepresentation.c"
			goto __catch571_g_error;
		}
#line 104 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		ret = _tmp1_;
#line 2124 "MediaDataRepresentation.c"
	}
	goto __finally571;
	__catch571_g_error:
	{
		GError* err = NULL;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		err = _inner_error_;
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_inner_error_ = NULL;
#line 108 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp4_ = file;
#line 108 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 108 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6_ = _tmp5_;
#line 108 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp7_ = err;
#line 108 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp8_ = _tmp7_->message;
#line 108 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_message ("MediaDataRepresentation.vala:108: Unable to move original photo %s to " \
"trash: %s", _tmp6_, _tmp8_);
#line 108 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_free0 (_tmp6_);
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_error_free0 (err);
#line 2155 "MediaDataRepresentation.c"
	}
	__finally571:
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2160 "MediaDataRepresentation.c"
		gboolean _tmp9_ = FALSE;
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (file);
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_clear_error (&_inner_error_);
#line 103 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return _tmp9_;
#line 2170 "MediaDataRepresentation.c"
	}
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp10_ = file;
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp11_ = app_dirs_get_import_dir ();
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp12_ = _tmp11_;
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp13_ = g_file_has_prefix (_tmp10_, _tmp12_);
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp14_ = _tmp13_;
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (_tmp12_);
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp14_) {
#line 2186 "MediaDataRepresentation.c"
		GFile* parent = NULL;
		GFile* _tmp15_;
		GFile* _tmp16_;
#line 114 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp15_ = file;
#line 114 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp16_ = _g_object_ref0 (_tmp15_);
#line 114 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		parent = _tmp16_;
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 2198 "MediaDataRepresentation.c"
			GFile* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			gboolean _tmp24_ = FALSE;
			GFile* _tmp25_;
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp17_ = parent;
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp18_ = app_dirs_get_import_dir ();
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp19_ = _tmp18_;
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp20_ = g_file_equal (_tmp17_, _tmp19_);
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp21_ = !(!_tmp20_);
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_tmp19_);
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp21_) {
#line 115 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 2224 "MediaDataRepresentation.c"
			}
#line 116 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp22_ = parent;
#line 116 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp23_ = g_file_get_parent (_tmp22_);
#line 116 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (parent);
#line 116 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			parent = _tmp23_;
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp25_ = parent;
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp25_ == NULL) {
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp24_ = TRUE;
#line 2240 "MediaDataRepresentation.c"
			} else {
				GFile* _tmp26_;
				GFile* _tmp27_;
				GFile* _tmp28_;
				gboolean _tmp29_;
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp26_ = parent;
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp27_ = app_dirs_get_import_dir ();
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp28_ = _tmp27_;
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp29_ = g_file_equal (_tmp26_, _tmp28_);
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp24_ = _tmp29_;
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_tmp28_);
#line 2258 "MediaDataRepresentation.c"
			}
#line 117 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp24_) {
#line 118 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 2264 "MediaDataRepresentation.c"
			}
			{
				gboolean _tmp30_ = FALSE;
				GFile* _tmp31_;
				gboolean _tmp32_;
#line 121 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp31_ = parent;
#line 121 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp32_ = query_is_directory_empty (_tmp31_, &_inner_error_);
#line 121 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp30_ = _tmp32_;
#line 121 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2278 "MediaDataRepresentation.c"
					goto __catch572_g_error;
				}
#line 121 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (!_tmp30_) {
#line 122 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					break;
#line 2285 "MediaDataRepresentation.c"
				}
			}
			goto __finally572;
			__catch572_g_error:
			{
				GError* err = NULL;
				GFile* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				GError* _tmp36_;
				const gchar* _tmp37_;
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				err = _inner_error_;
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_inner_error_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp33_ = parent;
#line 124 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp34_ = g_file_get_path (_tmp33_);
#line 124 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp35_ = _tmp34_;
#line 124 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp36_ = err;
#line 124 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp37_ = _tmp36_->message;
#line 124 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_warning ("MediaDataRepresentation.vala:124: Unable to query file info for %s: %s", _tmp35_, _tmp37_);
#line 124 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_free0 (_tmp35_);
#line 126 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_error_free0 (err);
#line 126 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 2319 "MediaDataRepresentation.c"
			}
			__finally572:
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2324 "MediaDataRepresentation.c"
				gboolean _tmp38_ = FALSE;
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (parent);
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (file);
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_clear_error (&_inner_error_);
#line 120 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return _tmp38_;
#line 2336 "MediaDataRepresentation.c"
			}
			{
				GFile* _tmp39_;
				GFile* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
#line 130 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp39_ = parent;
#line 130 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_file_delete (_tmp39_, NULL, &_inner_error_);
#line 130 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2349 "MediaDataRepresentation.c"
					goto __catch573_g_error;
				}
#line 131 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp40_ = parent;
#line 131 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp41_ = g_file_get_path (_tmp40_);
#line 131 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp42_ = _tmp41_;
#line 131 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_debug ("MediaDataRepresentation.vala:131: Deleted empty directory %s", _tmp42_);
#line 131 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_free0 (_tmp42_);
#line 2362 "MediaDataRepresentation.c"
			}
			goto __finally573;
			__catch573_g_error:
			{
				GError* err = NULL;
				GFile* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				GError* _tmp46_;
				const gchar* _tmp47_;
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				err = _inner_error_;
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_inner_error_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp43_ = parent;
#line 134 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp44_ = g_file_get_path (_tmp43_);
#line 134 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp45_ = _tmp44_;
#line 134 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp46_ = err;
#line 134 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp47_ = _tmp46_->message;
#line 134 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_message ("MediaDataRepresentation.vala:134: Unable to delete empty directory %s:" \
" %s", _tmp45_, _tmp47_);
#line 134 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_free0 (_tmp45_);
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_error_free0 (err);
#line 2393 "MediaDataRepresentation.c"
			}
			__finally573:
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2398 "MediaDataRepresentation.c"
				gboolean _tmp48_ = FALSE;
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (parent);
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (file);
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_clear_error (&_inner_error_);
#line 129 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return _tmp48_;
#line 2410 "MediaDataRepresentation.c"
			}
		}
#line 113 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (parent);
#line 2415 "MediaDataRepresentation.c"
	}
#line 140 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = ret;
#line 140 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (file);
#line 140 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 2423 "MediaDataRepresentation.c"
}


static gchar* media_source_real_get_name (DataObject* base) {
	MediaSource * self;
	gchar* result = NULL;
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gboolean _tmp3_;
#line 143 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE, MediaSource);
#line 144 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_get_title (self);
#line 144 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	title = _tmp0_;
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = title;
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp3_) {
#line 2447 "MediaDataRepresentation.c"
		gchar* _tmp4_;
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp4_ = media_source_get_basename (self);
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_free0 (_tmp1_);
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp4_;
#line 2455 "MediaDataRepresentation.c"
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = title;
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_free0 (_tmp1_);
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp6_;
#line 2467 "MediaDataRepresentation.c"
	}
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (title);
#line 146 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 2475 "MediaDataRepresentation.c"
}


static gchar* media_source_real_get_basename (MediaSource* self) {
	gchar* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 150 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_get_file (self);
#line 150 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 150 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = g_file_get_basename (_tmp1_);
#line 150 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = _tmp2_;
#line 150 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (_tmp1_);
#line 150 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp3_;
#line 150 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 2499 "MediaDataRepresentation.c"
}


gchar* media_source_get_basename (MediaSource* self) {
#line 149 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 149 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_basename (self);
#line 2508 "MediaDataRepresentation.c"
}


static GFile* media_source_real_get_file (MediaSource* self) {
#line 153 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 153 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 2517 "MediaDataRepresentation.c"
}


GFile* media_source_get_file (MediaSource* self) {
#line 153 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 153 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_file (self);
#line 2526 "MediaDataRepresentation.c"
}


static GFile* media_source_real_get_master_file (MediaSource* self) {
#line 154 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_master_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 154 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 2535 "MediaDataRepresentation.c"
}


GFile* media_source_get_master_file (MediaSource* self) {
#line 154 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 154 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_master_file (self);
#line 2544 "MediaDataRepresentation.c"
}


static guint64 media_source_real_get_master_filesize (MediaSource* self) {
	guint64 _tmp0_ = 0ULL;
#line 155 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_master_filesize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 155 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 2554 "MediaDataRepresentation.c"
}


guint64 media_source_get_master_filesize (MediaSource* self) {
#line 155 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0ULL);
#line 155 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_master_filesize (self);
#line 2563 "MediaDataRepresentation.c"
}


static guint64 media_source_real_get_filesize (MediaSource* self) {
	guint64 _tmp0_ = 0ULL;
#line 156 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_filesize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 156 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 2573 "MediaDataRepresentation.c"
}


guint64 media_source_get_filesize (MediaSource* self) {
#line 156 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0ULL);
#line 156 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_filesize (self);
#line 2582 "MediaDataRepresentation.c"
}


static time_t media_source_real_get_timestamp (MediaSource* self) {
	time_t _tmp0_ = 0;
#line 157 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_timestamp'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 157 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 2592 "MediaDataRepresentation.c"
}


time_t media_source_get_timestamp (MediaSource* self) {
#line 157 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0);
#line 157 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_timestamp (self);
#line 2601 "MediaDataRepresentation.c"
}


static BackingFileState** media_source_real_get_backing_files_state (MediaSource* self, int* result_length1) {
#line 160 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_backing_files_state'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 160 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 2610 "MediaDataRepresentation.c"
}


BackingFileState** media_source_get_backing_files_state (MediaSource* self, int* result_length1) {
#line 160 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 160 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_backing_files_state (self, result_length1);
#line 2619 "MediaDataRepresentation.c"
}


static gchar* media_source_real_get_title (MediaSource* self) {
#line 162 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 162 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 2628 "MediaDataRepresentation.c"
}


gchar* media_source_get_title (MediaSource* self) {
#line 162 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 162 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_title (self);
#line 2637 "MediaDataRepresentation.c"
}


static gchar* media_source_real_get_comment (MediaSource* self) {
#line 163 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 163 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 2646 "MediaDataRepresentation.c"
}


gchar* media_source_get_comment (MediaSource* self) {
#line 163 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 163 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_comment (self);
#line 2655 "MediaDataRepresentation.c"
}


static void media_source_real_set_title (MediaSource* self, const gchar* title) {
#line 164 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_set_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 164 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2664 "MediaDataRepresentation.c"
}


void media_source_set_title (MediaSource* self, const gchar* title) {
#line 164 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 164 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->set_title (self, title);
#line 2673 "MediaDataRepresentation.c"
}


static gboolean media_source_real_set_comment (MediaSource* self, const gchar* comment) {
	gboolean _tmp0_ = FALSE;
#line 165 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_set_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 165 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 2683 "MediaDataRepresentation.c"
}


gboolean media_source_set_comment (MediaSource* self, const gchar* comment) {
#line 165 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
#line 165 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->set_comment (self, comment);
#line 2692 "MediaDataRepresentation.c"
}


gchar* media_source_prep_title (const gchar* title) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = title;
#line 168 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = prepare_input_text (_tmp0_, PREPARE_INPUT_TEXT_OPTIONS_DEFAULT & (~PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL), DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 168 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 2708 "MediaDataRepresentation.c"
}


gchar* media_source_prep_comment (const gchar* comment) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 173 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = comment;
#line 173 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = prepare_input_text (_tmp0_, (PREPARE_INPUT_TEXT_OPTIONS_DEFAULT & (~PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF)) & (~PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL), -1);
#line 173 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 173 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 2724 "MediaDataRepresentation.c"
}


static Rating media_source_real_get_rating (MediaSource* self) {
#line 177 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 177 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return 0;
#line 2733 "MediaDataRepresentation.c"
}


Rating media_source_get_rating (MediaSource* self) {
#line 177 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0);
#line 177 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_rating (self);
#line 2742 "MediaDataRepresentation.c"
}


static void media_source_real_set_rating (MediaSource* self, Rating rating) {
#line 178 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_set_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 178 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2751 "MediaDataRepresentation.c"
}


void media_source_set_rating (MediaSource* self, Rating rating) {
#line 178 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 178 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->set_rating (self, rating);
#line 2760 "MediaDataRepresentation.c"
}


static void media_source_real_increase_rating (MediaSource* self) {
#line 179 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_increase_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 179 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2769 "MediaDataRepresentation.c"
}


void media_source_increase_rating (MediaSource* self) {
#line 179 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 179 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->increase_rating (self);
#line 2778 "MediaDataRepresentation.c"
}


static void media_source_real_decrease_rating (MediaSource* self) {
#line 180 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_decrease_rating'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 180 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2787 "MediaDataRepresentation.c"
}


void media_source_decrease_rating (MediaSource* self) {
#line 180 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 180 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->decrease_rating (self);
#line 2796 "MediaDataRepresentation.c"
}


static void media_source_real_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result) {
#line 182 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_dimensions'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 182 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2805 "MediaDataRepresentation.c"
}


void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result) {
#line 182 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 182 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->get_dimensions (self, disallowed_steps, result);
#line 2814 "MediaDataRepresentation.c"
}


static GdkPixbuf* media_source_real_get_preview_pixbuf (MediaSource* self, Scaling* scaling, GError** error) {
#line 190 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_preview_pixbuf'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 190 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 2823 "MediaDataRepresentation.c"
}


GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self, Scaling* scaling, GError** error) {
#line 190 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 190 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_preview_pixbuf (self, scaling, error);
#line 2832 "MediaDataRepresentation.c"
}


static gboolean media_source_real_is_trashed (MediaSource* self) {
	gboolean _tmp0_ = FALSE;
#line 192 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_is_trashed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 192 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 2842 "MediaDataRepresentation.c"
}


gboolean media_source_is_trashed (MediaSource* self) {
#line 192 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
#line 192 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->is_trashed (self);
#line 2851 "MediaDataRepresentation.c"
}


static void media_source_real_trash (MediaSource* self) {
#line 193 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_trash'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 193 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2860 "MediaDataRepresentation.c"
}


void media_source_trash (MediaSource* self) {
#line 193 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 193 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->trash (self);
#line 2869 "MediaDataRepresentation.c"
}


static void media_source_real_untrash (MediaSource* self) {
#line 194 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_untrash'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 194 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2878 "MediaDataRepresentation.c"
}


void media_source_untrash (MediaSource* self) {
#line 194 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 194 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->untrash (self);
#line 2887 "MediaDataRepresentation.c"
}


static gboolean media_source_real_is_offline (MediaSource* self) {
	gboolean _tmp0_ = FALSE;
#line 196 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_is_offline'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 196 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 2897 "MediaDataRepresentation.c"
}


gboolean media_source_is_offline (MediaSource* self) {
#line 196 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
#line 196 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->is_offline (self);
#line 2906 "MediaDataRepresentation.c"
}


static void media_source_real_mark_offline (MediaSource* self) {
#line 197 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_mark_offline'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 197 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2915 "MediaDataRepresentation.c"
}


void media_source_mark_offline (MediaSource* self) {
#line 197 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 197 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->mark_offline (self);
#line 2924 "MediaDataRepresentation.c"
}


static void media_source_real_mark_online (MediaSource* self) {
#line 198 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_mark_online'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 198 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2933 "MediaDataRepresentation.c"
}


void media_source_mark_online (MediaSource* self) {
#line 198 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 198 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->mark_online (self);
#line 2942 "MediaDataRepresentation.c"
}


static gchar* media_source_real_get_master_md5 (MediaSource* self) {
#line 200 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_master_md5'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 200 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 2951 "MediaDataRepresentation.c"
}


gchar* media_source_get_master_md5 (MediaSource* self) {
#line 200 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 200 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_master_md5 (self);
#line 2960 "MediaDataRepresentation.c"
}


static void media_source_real_get_event_id (MediaSource* self, EventID* result) {
#line 204 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_event_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 204 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 2969 "MediaDataRepresentation.c"
}


void media_source_get_event_id (MediaSource* self, EventID* result) {
#line 204 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 204 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->get_event_id (self, result);
#line 2978 "MediaDataRepresentation.c"
}


Event* media_source_get_event (MediaSource* self) {
	Event* result = NULL;
	Event* _tmp0_;
	EventID event_id = {0};
	EventID _tmp3_ = {0};
	gboolean _tmp4_;
	EventSourceCollection* _tmp5_;
	EventID _tmp6_;
	Event* _tmp7_;
	Event* _tmp8_;
	Event* _tmp9_;
#line 206 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), NULL);
#line 207 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->event;
#line 207 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp0_ != NULL) {
#line 2999 "MediaDataRepresentation.c"
		Event* _tmp1_;
		Event* _tmp2_;
#line 208 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = self->priv->event;
#line 208 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 208 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = _tmp2_;
#line 208 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 3010 "MediaDataRepresentation.c"
	}
#line 210 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_get_event_id (self, &_tmp3_);
#line 210 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	event_id = _tmp3_;
#line 211 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = event_id_is_valid (&event_id);
#line 211 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (!_tmp4_) {
#line 212 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = NULL;
#line 212 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 3024 "MediaDataRepresentation.c"
	}
#line 214 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = event_global;
#line 214 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = event_id;
#line 214 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp7_ = event_source_collection_fetch (_tmp5_, &_tmp6_);
#line 214 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->event);
#line 214 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->event = _tmp7_;
#line 216 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp8_ = self->priv->event;
#line 216 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 216 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp9_;
#line 216 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 3044 "MediaDataRepresentation.c"
}


gboolean media_source_set_event (MediaSource* self, Event* new_event) {
	gboolean result = FALSE;
	EventID _tmp0_ = {0};
	Event* _tmp1_;
	EventID event_id = {0};
	EventID _tmp4_ = {0};
	gint64 _tmp5_;
	EventID _tmp6_;
	gint64 _tmp7_;
	gboolean committed = FALSE;
	EventID _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
#line 219 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), FALSE);
#line 219 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail ((new_event == NULL) || IS_EVENT (new_event), FALSE);
#line 220 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = new_event;
#line 220 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp1_ != NULL) {
#line 3069 "MediaDataRepresentation.c"
		Event* _tmp2_;
		EventID _tmp3_ = {0};
#line 220 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = new_event;
#line 220 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		event_get_event_id (_tmp2_, &_tmp3_);
#line 220 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = _tmp3_;
#line 3078 "MediaDataRepresentation.c"
	} else {
#line 220 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		event_id_init (&_tmp0_, EVENT_ID_INVALID);
#line 3082 "MediaDataRepresentation.c"
	}
#line 220 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	event_id = _tmp0_;
#line 221 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_get_event_id (self, &_tmp4_);
#line 221 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = _tmp4_.id;
#line 221 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = event_id;
#line 221 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp7_ = _tmp6_.id;
#line 221 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp5_ == _tmp7_) {
#line 222 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = TRUE;
#line 222 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 3100 "MediaDataRepresentation.c"
	}
#line 224 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp8_ = event_id;
#line 224 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp9_ = media_source_set_event_id (self, &_tmp8_);
#line 224 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	committed = _tmp9_;
#line 225 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp10_ = committed;
#line 225 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp10_) {
#line 3112 "MediaDataRepresentation.c"
		Event* _tmp11_;
		Event* _tmp13_;
		Event* _tmp15_;
		Event* _tmp16_;
		Alteration* _tmp17_;
		Alteration* _tmp18_;
#line 226 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp11_ = self->priv->event;
#line 226 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		if (_tmp11_ != NULL) {
#line 3123 "MediaDataRepresentation.c"
			Event* _tmp12_;
#line 227 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp12_ = self->priv->event;
#line 227 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			event_detach (_tmp12_, self);
#line 3129 "MediaDataRepresentation.c"
		}
#line 229 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp13_ = new_event;
#line 229 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		if (_tmp13_ != NULL) {
#line 3135 "MediaDataRepresentation.c"
			Event* _tmp14_;
#line 230 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp14_ = new_event;
#line 230 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			event_attach (_tmp14_, self);
#line 3141 "MediaDataRepresentation.c"
		}
#line 232 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp15_ = new_event;
#line 232 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp16_ = _g_object_ref0 (_tmp15_);
#line 232 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (self->priv->event);
#line 232 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		self->priv->event = _tmp16_;
#line 234 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp17_ = alteration_new ("metadata", "event");
#line 234 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp18_ = _tmp17_;
#line 234 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp18_);
#line 234 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_alteration_unref0 (_tmp18_);
#line 3159 "MediaDataRepresentation.c"
	}
#line 237 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = committed;
#line 237 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 3165 "MediaDataRepresentation.c"
}


void media_source_set_many_to_event (GeeCollection* media_sources, Event* event, TransactionController* controller, GError** error) {
	EventID _tmp0_ = {0};
	Event* _tmp1_;
	EventID event_id = {0};
	TransactionController* _tmp4_;
	Event* _tmp21_;
	Alteration* alteration = NULL;
	Alteration* _tmp24_;
	TransactionController* _tmp33_;
#line 240 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media_sources));
#line 240 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((event == NULL) || IS_EVENT (event));
#line 240 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 242 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = event;
#line 242 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp1_ != NULL) {
#line 3188 "MediaDataRepresentation.c"
		Event* _tmp2_;
		EventID _tmp3_ = {0};
#line 242 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = event;
#line 242 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		event_get_event_id (_tmp2_, &_tmp3_);
#line 242 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = _tmp3_;
#line 3197 "MediaDataRepresentation.c"
	} else {
#line 242 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		event_id_init (&_tmp0_, EVENT_ID_INVALID);
#line 3201 "MediaDataRepresentation.c"
	}
#line 242 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	event_id = _tmp0_;
#line 244 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = controller;
#line 244 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	transaction_controller_begin (_tmp4_);
#line 3209 "MediaDataRepresentation.c"
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = media_sources;
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_media_it = _tmp6_;
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 3222 "MediaDataRepresentation.c"
			GeeIterator* _tmp7_;
			gboolean _tmp8_;
			MediaSource* media = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			Event* old_event = NULL;
			MediaSource* _tmp11_;
			Event* _tmp12_;
			Event* _tmp13_;
			MediaSource* _tmp16_;
			EventID _tmp17_;
			MediaSource* _tmp18_;
			Event* _tmp19_;
			Event* _tmp20_;
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = _media_it;
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp8_) {
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 3245 "MediaDataRepresentation.c"
			}
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = _media_it;
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			media = (MediaSource*) _tmp10_;
#line 247 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp11_ = media;
#line 247 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp12_ = media_source_get_event (_tmp11_);
#line 247 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			old_event = _tmp12_;
#line 248 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp13_ = old_event;
#line 248 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp13_ != NULL) {
#line 3263 "MediaDataRepresentation.c"
				Event* _tmp14_;
				MediaSource* _tmp15_;
#line 249 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp14_ = old_event;
#line 249 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp15_ = media;
#line 249 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				event_detach (_tmp14_, _tmp15_);
#line 3272 "MediaDataRepresentation.c"
			}
#line 251 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp16_ = media;
#line 251 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp17_ = event_id;
#line 251 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			media_source_set_event_id (_tmp16_, &_tmp17_);
#line 252 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp18_ = media;
#line 252 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp19_ = event;
#line 252 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 252 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_tmp18_->priv->event);
#line 252 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp18_->priv->event = _tmp20_;
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (old_event);
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (media);
#line 3294 "MediaDataRepresentation.c"
		}
#line 246 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_media_it);
#line 3298 "MediaDataRepresentation.c"
	}
#line 255 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp21_ = event;
#line 255 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp21_ != NULL) {
#line 3304 "MediaDataRepresentation.c"
		Event* _tmp22_;
		GeeCollection* _tmp23_;
#line 256 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp22_ = event;
#line 256 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp23_ = media_sources;
#line 256 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		event_attach_many (_tmp22_, _tmp23_);
#line 3313 "MediaDataRepresentation.c"
	}
#line 258 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp24_ = alteration_new ("metadata", "event");
#line 258 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	alteration = _tmp24_;
#line 3319 "MediaDataRepresentation.c"
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp25_;
		GeeIterator* _tmp26_;
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp25_ = media_sources;
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp26_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ITERABLE, GeeIterable));
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_media_it = _tmp26_;
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 3332 "MediaDataRepresentation.c"
			GeeIterator* _tmp27_;
			gboolean _tmp28_;
			MediaSource* media = NULL;
			GeeIterator* _tmp29_;
			gpointer _tmp30_;
			MediaSource* _tmp31_;
			Alteration* _tmp32_;
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp27_ = _media_it;
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp28_ = gee_iterator_next (_tmp27_);
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp28_) {
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 3348 "MediaDataRepresentation.c"
			}
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp29_ = _media_it;
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp30_ = gee_iterator_get (_tmp29_);
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			media = (MediaSource*) _tmp30_;
#line 260 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp31_ = media;
#line 260 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp32_ = alteration;
#line 260 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_DATA_OBJECT, DataObject), _tmp32_);
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (media);
#line 3364 "MediaDataRepresentation.c"
		}
#line 259 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_media_it);
#line 3368 "MediaDataRepresentation.c"
	}
#line 262 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp33_ = controller;
#line 262 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	transaction_controller_commit (_tmp33_);
#line 240 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_alteration_unref0 (alteration);
#line 3376 "MediaDataRepresentation.c"
}


static time_t media_source_real_get_exposure_time (MediaSource* self) {
	time_t _tmp0_ = 0;
#line 265 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_exposure_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 265 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 3386 "MediaDataRepresentation.c"
}


time_t media_source_get_exposure_time (MediaSource* self) {
#line 265 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (self), 0);
#line 265 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_GET_CLASS (self)->get_exposure_time (self);
#line 3395 "MediaDataRepresentation.c"
}


static void media_source_real_get_import_id (MediaSource* self, ImportID* result) {
#line 267 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_get_import_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 267 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return;
#line 3404 "MediaDataRepresentation.c"
}


void media_source_get_import_id (MediaSource* self, ImportID* result) {
#line 267 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (self));
#line 267 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_GET_CLASS (self)->get_import_id (self, result);
#line 3413 "MediaDataRepresentation.c"
}


static void media_source_real_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file) {
#line 33 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 33 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 3422 "MediaDataRepresentation.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (n_param_values == 3);
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data1 = closure->data;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data2 = param_values->data[0].v_pointer;
#line 3441 "MediaDataRepresentation.c"
	} else {
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data1 = param_values->data[0].v_pointer;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data2 = closure->data;
#line 3447 "MediaDataRepresentation.c"
	}
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 3453 "MediaDataRepresentation.c"
}


static void media_source_class_init (MediaSourceClass * klass) {
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_type_class_add_private (klass, sizeof (MediaSourcePrivate));
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->notify_master_replaced = (void (*) (MediaSource *, GFile*, GFile*)) media_source_real_notify_master_replaced;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject *, Alteration*)) media_source_real_notify_altered;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject *, DataCollection*)) media_source_real_notify_membership_changed;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource *, EventID*)) media_source_real_set_event_id;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject *)) media_source_real_get_name;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_basename = (gchar* (*) (MediaSource *)) media_source_real_get_basename;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource *)) media_source_real_get_file;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource *)) media_source_real_get_master_file;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource *)) media_source_real_get_master_filesize;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource *)) media_source_real_get_filesize;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_timestamp = (time_t (*) (MediaSource *)) media_source_real_get_timestamp;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource *, int*)) media_source_real_get_backing_files_state;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource *)) media_source_real_get_title;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource *)) media_source_real_get_comment;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource *, const gchar*)) media_source_real_set_title;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource *, const gchar*)) media_source_real_set_comment;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_rating = (Rating (*) (MediaSource *)) media_source_real_get_rating;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->set_rating = (void (*) (MediaSource *, Rating)) media_source_real_set_rating;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->increase_rating = (void (*) (MediaSource *)) media_source_real_increase_rating;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->decrease_rating = (void (*) (MediaSource *)) media_source_real_decrease_rating;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource *, PhotoException, Dimensions*)) media_source_real_get_dimensions;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource *, Scaling*, GError**)) media_source_real_get_preview_pixbuf;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource *)) media_source_real_is_trashed;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource *)) media_source_real_trash;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource *)) media_source_real_untrash;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource *)) media_source_real_is_offline;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource *)) media_source_real_mark_offline;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource *)) media_source_real_mark_online;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource *)) media_source_real_get_master_md5;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource *, EventID*)) media_source_real_get_event_id;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_exposure_time = (time_t (*) (MediaSource *)) media_source_real_get_exposure_time;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource *, ImportID*)) media_source_real_get_import_id;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceClass *) klass)->master_replaced = media_source_real_master_replaced;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	G_OBJECT_CLASS (klass)->finalize = media_source_finalize;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_signals[MEDIA_SOURCE_MASTER_REPLACED_SIGNAL] = g_signal_new ("master-replaced", TYPE_MEDIA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceClass, master_replaced), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_get_type ());
#line 3532 "MediaDataRepresentation.c"
}


static void media_source_indexable_interface_init (IndexableIface * iface) {
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_indexable_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	iface->get_indexable_keywords = (const gchar* (*) (Indexable *)) media_source_real_get_indexable_keywords;
#line 3541 "MediaDataRepresentation.c"
}


static void media_source_instance_init (MediaSource * self) {
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv = MEDIA_SOURCE_GET_PRIVATE (self);
#line 36 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->event = NULL;
#line 37 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->indexable_keywords = NULL;
#line 3552 "MediaDataRepresentation.c"
}


static void media_source_finalize (GObject * obj) {
	MediaSource * self;
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE, MediaSource);
#line 36 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->event);
#line 37 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (self->priv->indexable_keywords);
#line 32 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	G_OBJECT_CLASS (media_source_parent_class)->finalize (obj);
#line 3566 "MediaDataRepresentation.c"
}


GType media_source_get_type (void) {
	static volatile gsize media_source_type_id__volatile = 0;
	if (g_once_init_enter (&media_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSource), 0, (GInstanceInitFunc) media_source_instance_init, NULL };
		static const GInterfaceInfo indexable_info = { (GInterfaceInitFunc) media_source_indexable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType media_source_type_id;
		media_source_type_id = g_type_register_static (TYPE_THUMBNAIL_SOURCE, "MediaSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (media_source_type_id, TYPE_INDEXABLE, &indexable_info);
		g_once_init_leave (&media_source_type_id__volatile, media_source_type_id);
	}
	return media_source_type_id__volatile;
}


static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = file_hash ((GFile*) v);
#line 271 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 3589 "MediaDataRepresentation.c"
}


static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
#line 271 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 3598 "MediaDataRepresentation.c"
}


MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type, MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target) {
	MediaSourceHoldingTank* self = NULL;
	MediaSourceCollection* _tmp0_;
	SourceHoldingTankCheckToKeep _tmp1_;
	void* _tmp1__target;
	GetSourceDatabaseKey _tmp2_;
	void* _tmp2__target;
#line 274 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (sources), NULL);
#line 276 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = sources;
#line 276 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = check_to_keep;
#line 276 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1__target = check_to_keep_target;
#line 276 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = get_key;
#line 276 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2__target = get_key_target;
#line 276 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = (MediaSourceHoldingTank*) database_source_holding_tank_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp1_, _tmp1__target, _tmp2_, _tmp2__target);
#line 274 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self;
#line 3625 "MediaDataRepresentation.c"
}


MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target) {
#line 274 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return media_source_holding_tank_construct (TYPE_MEDIA_SOURCE_HOLDING_TANK, sources, check_to_keep, check_to_keep_target, get_key, get_key_target);
#line 3632 "MediaDataRepresentation.c"
}


MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self, GFile* file) {
	MediaSource* result = NULL;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gpointer _tmp2_;
#line 279 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_HOLDING_TANK (self), NULL);
#line 279 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 280 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->master_file_map;
#line 280 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = file;
#line 280 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 280 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = (MediaSource*) _tmp2_;
#line 280 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 3655 "MediaDataRepresentation.c"
}


MediaSource* media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self, const gchar* md5) {
	MediaSource* result = NULL;
#line 283 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_HOLDING_TANK (self), NULL);
#line 283 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (md5 != NULL, NULL);
#line 3665 "MediaDataRepresentation.c"
	{
		GeeIterator* _source_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = self->priv->master_file_map;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = _tmp1_;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = _tmp4_;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp3_);
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_it = _tmp5_;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 3692 "MediaDataRepresentation.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			MediaSource* source = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			MediaSource* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			gboolean _tmp14_;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _source_it;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp7_) {
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 3711 "MediaDataRepresentation.c"
			}
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = _source_it;
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			source = (MediaSource*) _tmp9_;
#line 285 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = source;
#line 285 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp11_ = media_source_get_master_md5 (_tmp10_);
#line 285 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp12_ = _tmp11_;
#line 285 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp13_ = md5;
#line 285 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp14_ = g_strcmp0 (_tmp12_, _tmp13_) == 0;
#line 285 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_free0 (_tmp12_);
#line 285 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp14_) {
#line 286 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				result = source;
#line 286 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_source_it);
#line 286 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return result;
#line 3739 "MediaDataRepresentation.c"
			}
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (source);
#line 3743 "MediaDataRepresentation.c"
		}
#line 284 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_source_it);
#line 3747 "MediaDataRepresentation.c"
	}
#line 290 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = NULL;
#line 290 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 3753 "MediaDataRepresentation.c"
}


static void _media_source_holding_tank_on_master_source_replaced_media_source_master_replaced (MediaSource* _sender, GFile* old_file, GFile* new_file, gpointer self) {
#line 299 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_holding_tank_on_master_source_replaced ((MediaSourceHoldingTank*) self, _sender, old_file, new_file);
#line 3760 "MediaDataRepresentation.c"
}


static void media_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base, GeeCollection* added, GeeCollection* removed) {
	MediaSourceHoldingTank * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp15_;
	GeeCollection* _tmp33_;
	GeeCollection* _tmp34_;
#line 293 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank);
#line 293 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 293 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 295 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = added;
#line 295 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp0_ != NULL) {
#line 3780 "MediaDataRepresentation.c"
		{
			GeeIterator* _source_it = NULL;
			GeeCollection* _tmp1_;
			GeeIterator* _tmp2_;
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp1_ = added;
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_source_it = _tmp2_;
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			while (TRUE) {
#line 3793 "MediaDataRepresentation.c"
				GeeIterator* _tmp3_;
				gboolean _tmp4_;
				DataSource* source = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				MediaSource* media_source = NULL;
				DataSource* _tmp7_;
				MediaSource* _tmp8_;
				GeeHashMap* _tmp9_;
				MediaSource* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				MediaSource* _tmp13_;
				MediaSource* _tmp14_;
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp3_ = _source_it;
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (!_tmp4_) {
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					break;
#line 3816 "MediaDataRepresentation.c"
				}
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp5_ = _source_it;
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				source = (DataSource*) _tmp6_;
#line 297 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp7_ = source;
#line 297 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource));
#line 297 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				media_source = _tmp8_;
#line 298 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp9_ = self->priv->master_file_map;
#line 298 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp10_ = media_source;
#line 298 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp11_ = media_source_get_master_file (_tmp10_);
#line 298 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp12_ = _tmp11_;
#line 298 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp13_ = media_source;
#line 298 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp12_, _tmp13_);
#line 298 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_tmp12_);
#line 299 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp14_ = media_source;
#line 299 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_signal_connect (_tmp14_, "master-replaced", (GCallback) _media_source_holding_tank_on_master_source_replaced_media_source_master_replaced, self);
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (media_source);
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (source);
#line 3852 "MediaDataRepresentation.c"
			}
#line 296 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_source_it);
#line 3856 "MediaDataRepresentation.c"
		}
	}
#line 303 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp15_ = removed;
#line 303 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp15_ != NULL) {
#line 3863 "MediaDataRepresentation.c"
		{
			GeeIterator* _source_it = NULL;
			GeeCollection* _tmp16_;
			GeeIterator* _tmp17_;
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp16_ = removed;
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_source_it = _tmp17_;
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			while (TRUE) {
#line 3876 "MediaDataRepresentation.c"
				GeeIterator* _tmp18_;
				gboolean _tmp19_;
				DataSource* source = NULL;
				GeeIterator* _tmp20_;
				gpointer _tmp21_;
				MediaSource* media_source = NULL;
				DataSource* _tmp22_;
				MediaSource* _tmp23_;
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp24_;
				MediaSource* _tmp25_;
				GFile* _tmp26_;
				GFile* _tmp27_;
				gboolean _tmp28_;
				gboolean _tmp29_;
				gboolean _tmp30_;
				MediaSource* _tmp31_;
				guint _tmp32_;
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp18_ = _source_it;
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp19_ = gee_iterator_next (_tmp18_);
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (!_tmp19_) {
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					break;
#line 3903 "MediaDataRepresentation.c"
				}
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp20_ = _source_it;
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp21_ = gee_iterator_get (_tmp20_);
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				source = (DataSource*) _tmp21_;
#line 305 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp22_ = source;
#line 305 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_MEDIA_SOURCE, MediaSource));
#line 305 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				media_source = _tmp23_;
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp24_ = self->priv->master_file_map;
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp25_ = media_source;
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp26_ = media_source_get_master_file (_tmp25_);
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp27_ = _tmp26_;
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp28_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp27_, NULL);
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp29_ = _tmp28_;
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_tmp27_);
#line 306 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				is_removed = _tmp29_;
#line 307 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp30_ = is_removed;
#line 307 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_vala_assert (_tmp30_, "is_removed");
#line 308 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp31_ = media_source;
#line 308 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_signal_parse_name ("master-replaced", TYPE_MEDIA_SOURCE, &_tmp32_, NULL, FALSE);
#line 308 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_signal_handlers_disconnect_matched (_tmp31_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp32_, 0, NULL, (GCallback) _media_source_holding_tank_on_master_source_replaced_media_source_master_replaced, self);
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (media_source);
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (source);
#line 3947 "MediaDataRepresentation.c"
			}
#line 304 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_source_it);
#line 3951 "MediaDataRepresentation.c"
		}
	}
#line 312 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp33_ = added;
#line 312 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp34_ = removed;
#line 312 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	SOURCE_HOLDING_TANK_CLASS (media_source_holding_tank_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), _tmp33_, _tmp34_);
#line 3960 "MediaDataRepresentation.c"
}


static void media_source_holding_tank_on_master_source_replaced (MediaSourceHoldingTank* self, MediaSource* media_source, GFile* old_file, GFile* new_file) {
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GeeHashMap* _tmp3_;
	GFile* _tmp4_;
	MediaSource* _tmp5_;
#line 315 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_HOLDING_TANK (self));
#line 315 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (media_source));
#line 315 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 315 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 316 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->master_file_map;
#line 316 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = old_file;
#line 316 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
#line 316 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	removed = _tmp2_;
#line 317 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_vala_assert (removed, "removed");
#line 319 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = self->priv->master_file_map;
#line 319 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = new_file;
#line 319 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = media_source;
#line 319 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, _tmp5_);
#line 3998 "MediaDataRepresentation.c"
}


static void media_source_holding_tank_class_init (MediaSourceHoldingTankClass * klass) {
#line 270 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_holding_tank_parent_class = g_type_class_peek_parent (klass);
#line 270 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((SourceHoldingTankClass *) klass)->finalize = media_source_holding_tank_finalize;
#line 270 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_type_class_add_private (klass, sizeof (MediaSourceHoldingTankPrivate));
#line 270 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((SourceHoldingTankClass *) klass)->notify_contents_altered = (void (*) (SourceHoldingTank *, GeeCollection*, GeeCollection*)) media_source_holding_tank_real_notify_contents_altered;
#line 4011 "MediaDataRepresentation.c"
}


static void media_source_holding_tank_instance_init (MediaSourceHoldingTank * self) {
	GeeHashMap* _tmp0_;
#line 270 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv = MEDIA_SOURCE_HOLDING_TANK_GET_PRIVATE (self);
#line 271 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 271 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->master_file_map = _tmp0_;
#line 4023 "MediaDataRepresentation.c"
}


static void media_source_holding_tank_finalize (SourceHoldingTank * obj) {
	MediaSourceHoldingTank * self;
#line 270 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank);
#line 271 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->master_file_map);
#line 270 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	SOURCE_HOLDING_TANK_CLASS (media_source_holding_tank_parent_class)->finalize (obj);
#line 4035 "MediaDataRepresentation.c"
}


GType media_source_holding_tank_get_type (void) {
	static volatile gsize media_source_holding_tank_type_id__volatile = 0;
	if (g_once_init_enter (&media_source_holding_tank_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaSourceHoldingTankClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_holding_tank_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSourceHoldingTank), 0, (GInstanceInitFunc) media_source_holding_tank_instance_init, NULL };
		GType media_source_holding_tank_type_id;
		media_source_holding_tank_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_HOLDING_TANK, "MediaSourceHoldingTank", &g_define_type_info, 0);
		g_once_init_leave (&media_source_holding_tank_type_id__volatile, media_source_holding_tank_type_id);
	}
	return media_source_holding_tank_type_id__volatile;
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 329 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self ? data_collection_ref (self) : NULL;
#line 4054 "MediaDataRepresentation.c"
}


MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type, MediaSourceCollection* sources) {
	MediaSourceTransactionController* self = NULL;
	MediaSourceCollection* _tmp0_;
	MediaSourceCollection* _tmp1_;
#line 328 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (sources), NULL);
#line 328 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = (MediaSourceTransactionController*) transaction_controller_construct (object_type);
#line 329 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = sources;
#line 329 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 329 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_data_collection_unref0 (self->priv->sources);
#line 329 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->sources = _tmp1_;
#line 328 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self;
#line 4076 "MediaDataRepresentation.c"
}


MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources) {
#line 328 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return media_source_transaction_controller_construct (TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, sources);
#line 4083 "MediaDataRepresentation.c"
}


static void media_source_transaction_controller_real_begin_impl (TransactionController* base, GError** error) {
	MediaSourceTransactionController * self;
	MediaSourceCollection* _tmp0_;
#line 332 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController);
#line 333 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	database_table_begin_transaction ();
#line 334 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->sources;
#line 334 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 4098 "MediaDataRepresentation.c"
}


static void media_source_transaction_controller_real_commit_impl (TransactionController* base, GError** error) {
	MediaSourceTransactionController * self;
	MediaSourceCollection* _tmp0_;
	GError * _inner_error_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController);
#line 338 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->sources;
#line 338 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 339 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	database_table_commit_transaction (&_inner_error_);
#line 339 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 339 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_propagate_error (error, _inner_error_);
#line 339 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return;
#line 4120 "MediaDataRepresentation.c"
	}
}


static void media_source_transaction_controller_class_init (MediaSourceTransactionControllerClass * klass) {
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_transaction_controller_parent_class = g_type_class_peek_parent (klass);
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((TransactionControllerClass *) klass)->finalize = media_source_transaction_controller_finalize;
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_type_class_add_private (klass, sizeof (MediaSourceTransactionControllerPrivate));
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((TransactionControllerClass *) klass)->begin_impl = (void (*) (TransactionController *, GError**)) media_source_transaction_controller_real_begin_impl;
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((TransactionControllerClass *) klass)->commit_impl = (void (*) (TransactionController *, GError**)) media_source_transaction_controller_real_commit_impl;
#line 4136 "MediaDataRepresentation.c"
}


static void media_source_transaction_controller_instance_init (MediaSourceTransactionController * self) {
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv = MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_PRIVATE (self);
#line 4143 "MediaDataRepresentation.c"
}


static void media_source_transaction_controller_finalize (TransactionController * obj) {
	MediaSourceTransactionController * self;
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController);
#line 326 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_data_collection_unref0 (self->priv->sources);
#line 325 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	TRANSACTION_CONTROLLER_CLASS (media_source_transaction_controller_parent_class)->finalize (obj);
#line 4155 "MediaDataRepresentation.c"
}


GType media_source_transaction_controller_get_type (void) {
	static volatile gsize media_source_transaction_controller_type_id__volatile = 0;
	if (g_once_init_enter (&media_source_transaction_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaSourceTransactionControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_transaction_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSourceTransactionController), 0, (GInstanceInitFunc) media_source_transaction_controller_instance_init, NULL };
		GType media_source_transaction_controller_type_id;
		media_source_transaction_controller_type_id = g_type_register_static (TYPE_TRANSACTION_CONTROLLER, "MediaSourceTransactionController", &g_define_type_info, 0);
		g_once_init_leave (&media_source_transaction_controller_type_id__volatile, media_source_transaction_controller_type_id);
	}
	return media_source_transaction_controller_type_id__volatile;
}


static gint _import_id_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = import_id_compare_func ((ImportID*) a, (ImportID*) b);
#line 350 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 4176 "MediaDataRepresentation.c"
}


MediaSourceCollection* media_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target) {
	MediaSourceCollection* self = NULL;
	const gchar* _tmp0_;
	GetSourceDatabaseKey _tmp1_;
	void* _tmp1__target;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
#line 384 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 385 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = name;
#line 385 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = source_key_func;
#line 385 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1__target = source_key_func_target;
#line 385 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = (MediaSourceCollection*) database_source_collection_construct (object_type, _tmp0_, _tmp1_, _tmp1__target);
#line 387 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = media_source_collection_create_trashcan (self);
#line 387 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (self->priv->trashcan);
#line 387 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->trashcan = _tmp2_;
#line 388 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = media_source_collection_create_offline_bin (self);
#line 388 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (self->priv->offline_bin);
#line 388 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->offline_bin = _tmp3_;
#line 384 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self;
#line 4211 "MediaDataRepresentation.c"
}


void media_source_collection_filter_media (GeeCollection* media, GeeCollection* photos, GeeCollection* videos) {
#line 391 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 391 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((photos == NULL) || GEE_IS_COLLECTION (photos));
#line 391 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((videos == NULL) || GEE_IS_COLLECTION (videos));
#line 4222 "MediaDataRepresentation.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp0_;
		GeeIterator* _tmp1_;
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media;
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_it = _tmp1_;
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 4235 "MediaDataRepresentation.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			MediaSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeCollection* _tmp7_;
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp2_ = _source_it;
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp3_) {
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 4251 "MediaDataRepresentation.c"
			}
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _source_it;
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			source = (MediaSource*) _tmp5_;
#line 394 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = photos;
#line 394 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp7_ != NULL) {
#line 4263 "MediaDataRepresentation.c"
				MediaSource* _tmp8_;
#line 394 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp8_ = source;
#line 394 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_LIBRARY_PHOTO);
#line 4269 "MediaDataRepresentation.c"
			} else {
#line 394 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp6_ = FALSE;
#line 4273 "MediaDataRepresentation.c"
			}
#line 394 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp6_) {
#line 4277 "MediaDataRepresentation.c"
				GeeCollection* _tmp9_;
				MediaSource* _tmp10_;
#line 395 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp9_ = photos;
#line 395 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp10_ = source;
#line 395 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_collection_add (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 4286 "MediaDataRepresentation.c"
			} else {
				gboolean _tmp11_ = FALSE;
				GeeCollection* _tmp12_;
#line 396 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp12_ = videos;
#line 396 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp12_ != NULL) {
#line 4294 "MediaDataRepresentation.c"
					MediaSource* _tmp13_;
#line 396 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp13_ = source;
#line 396 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_VIDEO);
#line 4300 "MediaDataRepresentation.c"
				} else {
#line 396 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp11_ = FALSE;
#line 4304 "MediaDataRepresentation.c"
				}
#line 396 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp11_) {
#line 4308 "MediaDataRepresentation.c"
					GeeCollection* _tmp14_;
					MediaSource* _tmp15_;
#line 397 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp14_ = videos;
#line 397 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp15_ = source;
#line 397 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					gee_collection_add (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_VIDEO, Video));
#line 4317 "MediaDataRepresentation.c"
				} else {
					gboolean _tmp16_ = FALSE;
					GeeCollection* _tmp17_;
#line 398 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp17_ = photos;
#line 398 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (_tmp17_ != NULL) {
#line 398 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp16_ = TRUE;
#line 4327 "MediaDataRepresentation.c"
					} else {
						GeeCollection* _tmp18_;
#line 398 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp18_ = videos;
#line 398 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp16_ = _tmp18_ != NULL;
#line 4334 "MediaDataRepresentation.c"
					}
#line 398 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (_tmp16_) {
#line 4338 "MediaDataRepresentation.c"
						MediaSource* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
#line 399 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp19_ = source;
#line 399 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_OBJECT, DataObject));
#line 399 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp21_ = _tmp20_;
#line 399 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						g_warning ("MediaDataRepresentation.vala:399: Unrecognized media: %s", _tmp21_);
#line 399 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_g_free0 (_tmp21_);
#line 4352 "MediaDataRepresentation.c"
					}
				}
			}
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (source);
#line 4358 "MediaDataRepresentation.c"
		}
#line 393 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_source_it);
#line 4362 "MediaDataRepresentation.c"
	}
}


void media_source_collection_count_media (GeeCollection* media, gint* photo_count, gint* video_count) {
	gint _vala_photo_count = 0;
	gint _vala_video_count = 0;
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* videos = NULL;
	GeeArrayList* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 403 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 405 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 405 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	photos = _tmp0_;
#line 406 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 406 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	videos = _tmp1_;
#line 408 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = media;
#line 408 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_filter_media (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (videos, GEE_TYPE_COLLECTION, GeeCollection));
#line 410 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 410 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = _tmp3_;
#line 410 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_vala_photo_count = _tmp4_;
#line 411 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (videos, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 411 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = _tmp5_;
#line 411 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_vala_video_count = _tmp6_;
#line 403 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (videos);
#line 403 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (photos);
#line 403 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (photo_count) {
#line 403 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*photo_count = _vala_photo_count;
#line 4413 "MediaDataRepresentation.c"
	}
#line 403 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (video_count) {
#line 403 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*video_count = _vala_video_count;
#line 4419 "MediaDataRepresentation.c"
	}
}


gboolean media_source_collection_has_photo (GeeCollection* media) {
	gboolean result = FALSE;
#line 414 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (media), FALSE);
#line 4428 "MediaDataRepresentation.c"
	{
		GeeIterator* _current_media_it = NULL;
		GeeCollection* _tmp0_;
		GeeIterator* _tmp1_;
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media;
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_current_media_it = _tmp1_;
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 4441 "MediaDataRepresentation.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			MediaSource* current_media = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			MediaSource* _tmp6_;
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp2_ = _current_media_it;
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp3_) {
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 4456 "MediaDataRepresentation.c"
			}
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _current_media_it;
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			current_media = (MediaSource*) _tmp5_;
#line 416 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = current_media;
#line 416 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_PHOTO)) {
#line 417 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				result = TRUE;
#line 417 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (current_media);
#line 417 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_current_media_it);
#line 417 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return result;
#line 4476 "MediaDataRepresentation.c"
			}
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (current_media);
#line 4480 "MediaDataRepresentation.c"
		}
#line 415 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_current_media_it);
#line 4484 "MediaDataRepresentation.c"
	}
#line 421 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = FALSE;
#line 421 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 4490 "MediaDataRepresentation.c"
}


gboolean media_source_collection_has_video (GeeCollection* media) {
	gboolean result = FALSE;
#line 424 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (media), FALSE);
#line 4498 "MediaDataRepresentation.c"
	{
		GeeIterator* _current_media_it = NULL;
		GeeCollection* _tmp0_;
		GeeIterator* _tmp1_;
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media;
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_current_media_it = _tmp1_;
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 4511 "MediaDataRepresentation.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			MediaSource* current_media = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			MediaSource* _tmp6_;
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp2_ = _current_media_it;
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp3_) {
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 4526 "MediaDataRepresentation.c"
			}
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _current_media_it;
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			current_media = (MediaSource*) _tmp5_;
#line 426 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = current_media;
#line 426 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_VIDEO)) {
#line 427 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				result = TRUE;
#line 427 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (current_media);
#line 427 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_current_media_it);
#line 427 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return result;
#line 4546 "MediaDataRepresentation.c"
			}
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (current_media);
#line 4550 "MediaDataRepresentation.c"
		}
#line 425 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_current_media_it);
#line 4554 "MediaDataRepresentation.c"
	}
#line 431 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = FALSE;
#line 431 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 4560 "MediaDataRepresentation.c"
}


static MediaSourceHoldingTank* media_source_collection_real_create_trashcan (MediaSourceCollection* self) {
#line 434 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_create_trashcan'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 434 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 4569 "MediaDataRepresentation.c"
}


MediaSourceHoldingTank* media_source_collection_create_trashcan (MediaSourceCollection* self) {
#line 434 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 434 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->create_trashcan (self);
#line 4578 "MediaDataRepresentation.c"
}


static MediaSourceHoldingTank* media_source_collection_real_create_offline_bin (MediaSourceCollection* self) {
#line 436 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_create_offline_bin'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 436 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 4587 "MediaDataRepresentation.c"
}


MediaSourceHoldingTank* media_source_collection_create_offline_bin (MediaSourceCollection* self) {
#line 436 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 436 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->create_offline_bin (self);
#line 4596 "MediaDataRepresentation.c"
}


static MediaMonitor* media_source_collection_real_create_media_monitor (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable) {
#line 438 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_create_media_monitor'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 438 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 4605 "MediaDataRepresentation.c"
}


MediaMonitor* media_source_collection_create_media_monitor (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable) {
#line 438 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 438 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->create_media_monitor (self, workers, cancellable);
#line 4614 "MediaDataRepresentation.c"
}


static gchar* media_source_collection_real_get_typename (MediaSourceCollection* self) {
#line 440 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_get_typename'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 440 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 4623 "MediaDataRepresentation.c"
}


gchar* media_source_collection_get_typename (MediaSourceCollection* self) {
#line 440 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 440 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->get_typename (self);
#line 4632 "MediaDataRepresentation.c"
}


static gboolean media_source_collection_real_is_file_recognized (MediaSourceCollection* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
#line 442 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_is_file_recognized'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 442 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return _tmp0_;
#line 4642 "MediaDataRepresentation.c"
}


gboolean media_source_collection_is_file_recognized (MediaSourceCollection* self, GFile* file) {
#line 442 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), FALSE);
#line 442 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->is_file_recognized (self, file);
#line 4651 "MediaDataRepresentation.c"
}


static gpointer _source_holding_tank_ref0 (gpointer self) {
#line 445 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self ? source_holding_tank_ref (self) : NULL;
#line 4658 "MediaDataRepresentation.c"
}


MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self) {
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
#line 444 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 445 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->trashcan;
#line 445 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _source_holding_tank_ref0 (_tmp0_);
#line 445 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 445 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 4676 "MediaDataRepresentation.c"
}


MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self) {
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
#line 448 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 449 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->offline_bin;
#line 449 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _source_holding_tank_ref0 (_tmp0_);
#line 449 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 449 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 4694 "MediaDataRepresentation.c"
}


static MediaSource* media_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* self, gint64 numeric_id) {
#line 455 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_fetch_by_numeric_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 455 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 4703 "MediaDataRepresentation.c"
}


MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self, gint64 numeric_id) {
#line 455 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 455 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->fetch_by_numeric_id (self, numeric_id);
#line 4712 "MediaDataRepresentation.c"
}


static void media_source_collection_real_notify_import_roll_altered (MediaSourceCollection* self) {
#line 458 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_IMPORT_ROLL_ALTERED_SIGNAL], 0);
#line 4719 "MediaDataRepresentation.c"
}


void media_source_collection_notify_import_roll_altered (MediaSourceCollection* self) {
#line 457 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 457 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->notify_import_roll_altered (self);
#line 4728 "MediaDataRepresentation.c"
}


static void media_source_collection_real_notify_flagged_contents_altered (MediaSourceCollection* self) {
#line 462 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_FLAGGED_CONTENTS_ALTERED_SIGNAL], 0);
#line 4735 "MediaDataRepresentation.c"
}


void media_source_collection_notify_flagged_contents_altered (MediaSourceCollection* self) {
#line 461 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 461 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->notify_flagged_contents_altered (self);
#line 4744 "MediaDataRepresentation.c"
}


static void media_source_collection_real_notify_media_import_starting (MediaSourceCollection* self, GeeCollection* media) {
	GeeCollection* _tmp0_;
#line 465 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 466 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media;
#line 466 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_STARTING_SIGNAL], 0, _tmp0_);
#line 4756 "MediaDataRepresentation.c"
}


void media_source_collection_notify_media_import_starting (MediaSourceCollection* self, GeeCollection* media) {
#line 465 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 465 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->notify_media_import_starting (self, media);
#line 4765 "MediaDataRepresentation.c"
}


static void media_source_collection_real_notify_media_import_completed (MediaSourceCollection* self, GeeCollection* media) {
	GeeCollection* _tmp0_;
#line 469 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 470 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media;
#line 470 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_COMPLETED_SIGNAL], 0, _tmp0_);
#line 4777 "MediaDataRepresentation.c"
}


void media_source_collection_notify_media_import_completed (MediaSourceCollection* self, GeeCollection* media) {
#line 469 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 469 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->notify_media_import_completed (self, media);
#line 4786 "MediaDataRepresentation.c"
}


static void media_source_collection_real_items_altered (DataCollection* base, GeeMap* items) {
	MediaSourceCollection * self;
	GeeArrayList* to_trashcan = NULL;
	GeeArrayList* to_offline = NULL;
	gboolean flagged_altered = FALSE;
	GeeArrayList* _tmp54_;
	GeeArrayList* _tmp58_;
	gboolean _tmp62_;
	GeeMap* _tmp63_;
#line 473 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection);
#line 473 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_MAP (items));
#line 474 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	to_trashcan = NULL;
#line 475 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	to_offline = NULL;
#line 476 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	flagged_altered = FALSE;
#line 4809 "MediaDataRepresentation.c"
	{
		GeeIterator* _object_it = NULL;
		GeeMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = items;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = gee_map_get_keys (_tmp0_);
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = _tmp1_;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = _tmp4_;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp3_);
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_object_it = _tmp5_;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 4836 "MediaDataRepresentation.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			DataObject* object = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			Alteration* alteration = NULL;
			GeeMap* _tmp10_;
			DataObject* _tmp11_;
			gpointer _tmp12_;
			MediaSource* source = NULL;
			DataObject* _tmp13_;
			MediaSource* _tmp14_;
			Alteration* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_ = FALSE;
			MediaSource* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp28_ = FALSE;
			MediaSource* _tmp29_;
			gboolean _tmp30_;
			Flaggable* flaggable = NULL;
			MediaSource* _tmp39_;
			Flaggable* _tmp40_;
			Flaggable* _tmp41_;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _object_it;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp7_) {
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 4869 "MediaDataRepresentation.c"
			}
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = _object_it;
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			object = (DataObject*) _tmp9_;
#line 478 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = items;
#line 478 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp11_ = object;
#line 478 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
#line 478 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			alteration = (Alteration*) _tmp12_;
#line 479 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp13_ = object;
#line 479 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MEDIA_SOURCE, MediaSource));
#line 479 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			source = _tmp14_;
#line 481 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp15_ = alteration;
#line 481 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp16_ = alteration_has_subject (_tmp15_, "metadata");
#line 481 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp16_) {
#line 482 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (source);
#line 482 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_alteration_unref0 (alteration);
#line 482 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (object);
#line 482 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				continue;
#line 4905 "MediaDataRepresentation.c"
			}
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp18_ = source;
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp19_ = media_source_is_trashed (_tmp18_);
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp19_) {
#line 4913 "MediaDataRepresentation.c"
				MediaSourceHoldingTank* _tmp20_;
				MediaSourceHoldingTank* _tmp21_;
				MediaSource* _tmp22_;
				gboolean _tmp23_;
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp20_ = media_source_collection_get_trashcan (self);
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp21_ = _tmp20_;
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp22_ = source;
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp23_ = source_holding_tank_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_DATA_SOURCE, DataSource));
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp17_ = !_tmp23_;
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_source_holding_tank_unref0 (_tmp21_);
#line 4930 "MediaDataRepresentation.c"
			} else {
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp17_ = FALSE;
#line 4934 "MediaDataRepresentation.c"
			}
#line 484 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp17_) {
#line 4938 "MediaDataRepresentation.c"
				GeeArrayList* _tmp24_;
				GeeArrayList* _tmp26_;
				MediaSource* _tmp27_;
#line 485 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp24_ = to_trashcan;
#line 485 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp24_ == NULL) {
#line 4946 "MediaDataRepresentation.c"
					GeeArrayList* _tmp25_;
#line 486 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp25_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 486 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_g_object_unref0 (to_trashcan);
#line 486 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					to_trashcan = _tmp25_;
#line 4954 "MediaDataRepresentation.c"
				}
#line 488 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp26_ = to_trashcan;
#line 488 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp27_ = source;
#line 488 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp27_);
#line 491 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (source);
#line 491 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_alteration_unref0 (alteration);
#line 491 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (object);
#line 491 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				continue;
#line 4970 "MediaDataRepresentation.c"
			}
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp29_ = source;
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp30_ = media_source_is_offline (_tmp29_);
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp30_) {
#line 4978 "MediaDataRepresentation.c"
				MediaSourceHoldingTank* _tmp31_;
				MediaSourceHoldingTank* _tmp32_;
				MediaSource* _tmp33_;
				gboolean _tmp34_;
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp31_ = media_source_collection_get_offline_bin (self);
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp32_ = _tmp31_;
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp33_ = source;
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp34_ = source_holding_tank_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_DATA_SOURCE, DataSource));
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp28_ = !_tmp34_;
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_source_holding_tank_unref0 (_tmp32_);
#line 4995 "MediaDataRepresentation.c"
			} else {
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp28_ = FALSE;
#line 4999 "MediaDataRepresentation.c"
			}
#line 494 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp28_) {
#line 5003 "MediaDataRepresentation.c"
				GeeArrayList* _tmp35_;
				GeeArrayList* _tmp37_;
				MediaSource* _tmp38_;
#line 495 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp35_ = to_offline;
#line 495 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp35_ == NULL) {
#line 5011 "MediaDataRepresentation.c"
					GeeArrayList* _tmp36_;
#line 496 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp36_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 496 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_g_object_unref0 (to_offline);
#line 496 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					to_offline = _tmp36_;
#line 5019 "MediaDataRepresentation.c"
				}
#line 498 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp37_ = to_offline;
#line 498 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp38_ = source;
#line 498 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp38_);
#line 5027 "MediaDataRepresentation.c"
			}
#line 501 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp39_ = source;
#line 501 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp39_) : NULL);
#line 501 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			flaggable = _tmp40_;
#line 502 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp41_ = flaggable;
#line 502 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp41_ != NULL) {
#line 5039 "MediaDataRepresentation.c"
				Flaggable* _tmp42_;
				gboolean _tmp43_;
#line 503 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp42_ = flaggable;
#line 503 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp43_ = flaggable_is_flagged (_tmp42_);
#line 503 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp43_) {
#line 5048 "MediaDataRepresentation.c"
					gboolean _tmp44_ = FALSE;
					GeeSet* _tmp45_;
					MediaSource* _tmp46_;
					gboolean _tmp47_;
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp45_ = self->priv->flagged;
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp46_ = source;
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp47_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_COLLECTION, GeeCollection), _tmp46_);
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (_tmp47_) {
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp44_ = TRUE;
#line 5063 "MediaDataRepresentation.c"
					} else {
						gboolean _tmp48_;
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp48_ = flagged_altered;
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp44_ = _tmp48_;
#line 5070 "MediaDataRepresentation.c"
					}
#line 504 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					flagged_altered = _tmp44_;
#line 5074 "MediaDataRepresentation.c"
				} else {
					gboolean _tmp49_ = FALSE;
					GeeSet* _tmp50_;
					MediaSource* _tmp51_;
					gboolean _tmp52_;
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp50_ = self->priv->flagged;
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp51_ = source;
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp52_ = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_COLLECTION, GeeCollection), _tmp51_);
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (_tmp52_) {
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp49_ = TRUE;
#line 5090 "MediaDataRepresentation.c"
					} else {
						gboolean _tmp53_;
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp53_ = flagged_altered;
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp49_ = _tmp53_;
#line 5097 "MediaDataRepresentation.c"
					}
#line 506 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					flagged_altered = _tmp49_;
#line 5101 "MediaDataRepresentation.c"
				}
			}
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (flaggable);
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (source);
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_alteration_unref0 (alteration);
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (object);
#line 5112 "MediaDataRepresentation.c"
		}
#line 477 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_object_it);
#line 5116 "MediaDataRepresentation.c"
	}
#line 510 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp54_ = to_trashcan;
#line 510 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp54_ != NULL) {
#line 5122 "MediaDataRepresentation.c"
		MediaSourceHoldingTank* _tmp55_;
		MediaSourceHoldingTank* _tmp56_;
		GeeArrayList* _tmp57_;
#line 511 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp55_ = media_source_collection_get_trashcan (self);
#line 511 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp56_ = _tmp55_;
#line 511 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp57_ = to_trashcan;
#line 511 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		source_holding_tank_unlink_and_hold (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GEE_TYPE_COLLECTION, GeeCollection));
#line 511 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_holding_tank_unref0 (_tmp56_);
#line 5136 "MediaDataRepresentation.c"
	}
#line 513 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp58_ = to_offline;
#line 513 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp58_ != NULL) {
#line 5142 "MediaDataRepresentation.c"
		MediaSourceHoldingTank* _tmp59_;
		MediaSourceHoldingTank* _tmp60_;
		GeeArrayList* _tmp61_;
#line 514 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp59_ = media_source_collection_get_offline_bin (self);
#line 514 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp60_ = _tmp59_;
#line 514 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp61_ = to_offline;
#line 514 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		source_holding_tank_unlink_and_hold (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_COLLECTION, GeeCollection));
#line 514 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_holding_tank_unref0 (_tmp60_);
#line 5156 "MediaDataRepresentation.c"
	}
#line 516 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp62_ = flagged_altered;
#line 516 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp62_) {
#line 517 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_source_collection_notify_flagged_contents_altered (self);
#line 5164 "MediaDataRepresentation.c"
	}
#line 519 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp63_ = items;
#line 519 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	DATA_COLLECTION_CLASS (media_source_collection_parent_class)->items_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), _tmp63_);
#line 473 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (to_offline);
#line 473 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (to_trashcan);
#line 5174 "MediaDataRepresentation.c"
}


static void _media_source_collection_on_master_replaced_media_source_master_replaced (MediaSource* _sender, GFile* old_file, GFile* new_file, gpointer self) {
#line 531 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_on_master_replaced ((MediaSourceCollection*) self, _sender, old_file, new_file);
#line 5181 "MediaDataRepresentation.c"
}


static void media_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed) {
	MediaSourceCollection * self;
	gboolean import_roll_changed = FALSE;
	gboolean flagged_altered = FALSE;
	GeeIterable* _tmp0_;
	GeeIterable* _tmp38_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	GeeIterable* _tmp76_;
	GeeIterable* _tmp77_;
#line 522 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection);
#line 522 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 522 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 524 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	import_roll_changed = FALSE;
#line 525 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	flagged_altered = FALSE;
#line 526 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = added;
#line 526 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp0_ != NULL) {
#line 5209 "MediaDataRepresentation.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp1_;
			GeeIterator* _tmp2_;
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp1_ = added;
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_object_it = _tmp2_;
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			while (TRUE) {
#line 5222 "MediaDataRepresentation.c"
				GeeIterator* _tmp3_;
				gboolean _tmp4_;
				DataObject* object = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				MediaSource* media = NULL;
				DataObject* _tmp7_;
				MediaSource* _tmp8_;
				GeeHashMap* _tmp9_;
				MediaSource* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				MediaSource* _tmp13_;
				MediaSource* _tmp14_;
				ImportID import_id = {0};
				MediaSource* _tmp15_;
				ImportID _tmp16_ = {0};
				gboolean _tmp17_;
				Flaggable* flaggable = NULL;
				MediaSource* _tmp23_;
				Flaggable* _tmp24_;
				Flaggable* _tmp25_;
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp3_ = _object_it;
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (!_tmp4_) {
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					break;
#line 5253 "MediaDataRepresentation.c"
				}
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp5_ = _object_it;
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				object = (DataObject*) _tmp6_;
#line 528 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp7_ = object;
#line 528 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource));
#line 528 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				media = _tmp8_;
#line 530 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp9_ = self->priv->by_master_file;
#line 530 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp10_ = media;
#line 530 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp11_ = media_source_get_master_file (_tmp10_);
#line 530 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp12_ = _tmp11_;
#line 530 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp13_ = media;
#line 530 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp12_, _tmp13_);
#line 530 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_tmp12_);
#line 531 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp14_ = media;
#line 531 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_signal_connect (_tmp14_, "master-replaced", (GCallback) _media_source_collection_on_master_replaced_media_source_master_replaced, self);
#line 533 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp15_ = media;
#line 533 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				media_source_get_import_id (_tmp15_, &_tmp16_);
#line 533 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				import_id = _tmp16_;
#line 534 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp17_ = import_id_is_valid (&import_id);
#line 534 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp17_) {
#line 5295 "MediaDataRepresentation.c"
					GeeTreeSet* _tmp18_;
					ImportID _tmp19_;
					GeeMultiMap* _tmp20_;
					ImportID _tmp21_;
					MediaSource* _tmp22_;
#line 535 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp18_ = self->priv->sorted_import_ids;
#line 535 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp19_ = import_id;
#line 535 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp19_);
#line 536 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp20_ = self->priv->import_rolls;
#line 536 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp21_ = import_id;
#line 536 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp22_ = media;
#line 536 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					gee_multi_map_set (_tmp20_, &_tmp21_, _tmp22_);
#line 538 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					import_roll_changed = TRUE;
#line 5317 "MediaDataRepresentation.c"
				}
#line 541 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp23_ = media;
#line 541 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp23_) : NULL);
#line 541 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				flaggable = _tmp24_;
#line 542 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp25_ = flaggable;
#line 542 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp25_ != NULL) {
#line 5329 "MediaDataRepresentation.c"
					Flaggable* _tmp26_;
					gboolean _tmp27_;
#line 543 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp26_ = flaggable;
#line 543 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp27_ = flaggable_is_flagged (_tmp26_);
#line 543 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (_tmp27_) {
#line 5338 "MediaDataRepresentation.c"
						gboolean _tmp28_ = FALSE;
						GeeSet* _tmp29_;
						MediaSource* _tmp30_;
						gboolean _tmp31_;
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp29_ = self->priv->flagged;
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp30_ = media;
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp31_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection), _tmp30_);
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						if (_tmp31_) {
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
							_tmp28_ = TRUE;
#line 5353 "MediaDataRepresentation.c"
						} else {
							gboolean _tmp32_;
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
							_tmp32_ = flagged_altered;
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
							_tmp28_ = _tmp32_;
#line 5360 "MediaDataRepresentation.c"
						}
#line 544 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						flagged_altered = _tmp28_;
#line 5364 "MediaDataRepresentation.c"
					} else {
						gboolean _tmp33_ = FALSE;
						GeeSet* _tmp34_;
						MediaSource* _tmp35_;
						gboolean _tmp36_;
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp34_ = self->priv->flagged;
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp35_ = media;
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp36_ = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_COLLECTION, GeeCollection), _tmp35_);
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						if (_tmp36_) {
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
							_tmp33_ = TRUE;
#line 5380 "MediaDataRepresentation.c"
						} else {
							gboolean _tmp37_;
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
							_tmp37_ = flagged_altered;
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
							_tmp33_ = _tmp37_;
#line 5387 "MediaDataRepresentation.c"
						}
#line 546 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						flagged_altered = _tmp33_;
#line 5391 "MediaDataRepresentation.c"
					}
				}
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (flaggable);
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (media);
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (object);
#line 5400 "MediaDataRepresentation.c"
			}
#line 527 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_object_it);
#line 5404 "MediaDataRepresentation.c"
		}
	}
#line 551 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp38_ = removed;
#line 551 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp38_ != NULL) {
#line 5411 "MediaDataRepresentation.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp39_;
			GeeIterator* _tmp40_;
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp39_ = removed;
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp40_ = gee_iterable_iterator (_tmp39_);
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_object_it = _tmp40_;
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			while (TRUE) {
#line 5424 "MediaDataRepresentation.c"
				GeeIterator* _tmp41_;
				gboolean _tmp42_;
				DataObject* object = NULL;
				GeeIterator* _tmp43_;
				gpointer _tmp44_;
				MediaSource* media = NULL;
				DataObject* _tmp45_;
				MediaSource* _tmp46_;
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp47_;
				MediaSource* _tmp48_;
				GFile* _tmp49_;
				GFile* _tmp50_;
				gboolean _tmp51_;
				gboolean _tmp52_;
				gboolean _tmp53_;
				MediaSource* _tmp54_;
				guint _tmp55_;
				ImportID import_id = {0};
				MediaSource* _tmp56_;
				ImportID _tmp57_ = {0};
				gboolean _tmp58_;
				gboolean _tmp69_ = FALSE;
				GeeSet* _tmp70_;
				MediaSource* _tmp71_;
				gboolean _tmp72_;
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp41_ = _object_it;
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp42_ = gee_iterator_next (_tmp41_);
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (!_tmp42_) {
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					break;
#line 5459 "MediaDataRepresentation.c"
				}
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp43_ = _object_it;
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp44_ = gee_iterator_get (_tmp43_);
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				object = (DataObject*) _tmp44_;
#line 553 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp45_ = object;
#line 553 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_MEDIA_SOURCE, MediaSource));
#line 553 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				media = _tmp46_;
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp47_ = self->priv->by_master_file;
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp48_ = media;
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp49_ = media_source_get_master_file (_tmp48_);
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp50_ = _tmp49_;
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp51_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp50_, NULL);
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp52_ = _tmp51_;
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_tmp50_);
#line 555 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				is_removed = _tmp52_;
#line 556 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp53_ = is_removed;
#line 556 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_vala_assert (_tmp53_, "is_removed");
#line 557 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp54_ = media;
#line 557 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_signal_parse_name ("master-replaced", TYPE_MEDIA_SOURCE, &_tmp55_, NULL, FALSE);
#line 557 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_signal_handlers_disconnect_matched (_tmp54_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp55_, 0, NULL, (GCallback) _media_source_collection_on_master_replaced_media_source_master_replaced, self);
#line 559 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp56_ = media;
#line 559 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				media_source_get_import_id (_tmp56_, &_tmp57_);
#line 559 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				import_id = _tmp57_;
#line 560 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp58_ = import_id_is_valid (&import_id);
#line 560 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp58_) {
#line 5509 "MediaDataRepresentation.c"
					GeeMultiMap* _tmp59_;
					ImportID _tmp60_;
					MediaSource* _tmp61_;
					gboolean _tmp62_;
					gboolean _tmp63_;
					GeeMultiMap* _tmp64_;
					ImportID _tmp65_;
					gboolean _tmp66_;
#line 561 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp59_ = self->priv->import_rolls;
#line 561 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp60_ = import_id;
#line 561 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp61_ = media;
#line 561 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp62_ = gee_multi_map_remove (_tmp59_, &_tmp60_, _tmp61_);
#line 561 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					is_removed = _tmp62_;
#line 562 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp63_ = is_removed;
#line 562 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_vala_assert (_tmp63_, "is_removed");
#line 563 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp64_ = self->priv->import_rolls;
#line 563 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp65_ = import_id;
#line 563 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp66_ = gee_multi_map_contains (_tmp64_, &_tmp65_);
#line 563 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (!_tmp66_) {
#line 5540 "MediaDataRepresentation.c"
						GeeTreeSet* _tmp67_;
						ImportID _tmp68_;
#line 564 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp67_ = self->priv->sorted_import_ids;
#line 564 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp68_ = import_id;
#line 564 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp68_);
#line 5549 "MediaDataRepresentation.c"
					}
#line 566 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					import_roll_changed = TRUE;
#line 5553 "MediaDataRepresentation.c"
				}
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp70_ = self->priv->flagged;
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp71_ = media;
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp72_ = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, GEE_TYPE_COLLECTION, GeeCollection), _tmp71_);
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp72_) {
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp69_ = TRUE;
#line 5565 "MediaDataRepresentation.c"
				} else {
					gboolean _tmp73_;
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp73_ = flagged_altered;
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp69_ = _tmp73_;
#line 5572 "MediaDataRepresentation.c"
				}
#line 569 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				flagged_altered = _tmp69_;
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (media);
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (object);
#line 5580 "MediaDataRepresentation.c"
			}
#line 552 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_object_it);
#line 5584 "MediaDataRepresentation.c"
		}
	}
#line 573 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp74_ = import_roll_changed;
#line 573 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp74_) {
#line 574 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_source_collection_notify_import_roll_altered (self);
#line 5593 "MediaDataRepresentation.c"
	}
#line 576 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp75_ = flagged_altered;
#line 576 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp75_) {
#line 577 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_source_collection_notify_flagged_contents_altered (self);
#line 5601 "MediaDataRepresentation.c"
	}
#line 579 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp76_ = added;
#line 579 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp77_ = removed;
#line 579 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	DATA_COLLECTION_CLASS (media_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), _tmp76_, _tmp77_);
#line 5609 "MediaDataRepresentation.c"
}


static void media_source_collection_on_master_replaced (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file) {
	gboolean is_removed = FALSE;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GeeHashMap* _tmp3_;
	GFile* _tmp4_;
	MediaSource* _tmp5_;
	MediaSource* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
#line 582 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 582 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (media));
#line 582 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 582 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 583 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->by_master_file;
#line 583 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = old_file;
#line 583 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
#line 583 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	is_removed = _tmp2_;
#line 584 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_vala_assert (is_removed, "is_removed");
#line 586 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = self->priv->by_master_file;
#line 586 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = new_file;
#line 586 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = media;
#line 586 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, _tmp5_);
#line 588 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = media;
#line 588 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp7_ = old_file;
#line 588 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp8_ = new_file;
#line 588 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_emit (self, media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MASTER_FILE_REPLACED_SIGNAL], 0, _tmp6_, _tmp7_, _tmp8_);
#line 5658 "MediaDataRepresentation.c"
}


MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self, GFile* file) {
	MediaSource* result = NULL;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gpointer _tmp2_;
#line 591 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 591 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 592 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->by_master_file;
#line 592 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = file;
#line 592 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 592 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = (MediaSource*) _tmp2_;
#line 592 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5681 "MediaDataRepresentation.c"
}


static MediaSource* media_source_collection_real_fetch_by_source_id (MediaSourceCollection* self, const gchar* source_id) {
	MediaSource* result = NULL;
	gchar** components = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint components_length1;
	gint _components_size_;
	const gchar* _tmp3_;
	gint64 _tmp4_;
	MediaSource* _tmp5_;
#line 595 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (source_id != NULL, NULL);
#line 596 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = source_id;
#line 596 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "-", 0);
#line 596 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	components = _tmp2_;
#line 596 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	components_length1 = _vala_array_length (_tmp1_);
#line 596 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_components_size_ = components_length1;
#line 597 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_vala_assert (components_length1 == 2, "components.length == 2");
#line 599 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = components[1];
#line 599 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = parse_int64 (_tmp3_, 16);
#line 599 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = media_source_collection_fetch_by_numeric_id (self, _tmp4_);
#line 599 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp5_;
#line 599 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
#line 599 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5722 "MediaDataRepresentation.c"
}


MediaSource* media_source_collection_fetch_by_source_id (MediaSourceCollection* self, const gchar* source_id) {
#line 595 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 595 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->fetch_by_source_id (self, source_id);
#line 5731 "MediaDataRepresentation.c"
}


static GeeCollection* media_source_collection_real_get_event_source_ids (MediaSourceCollection* self, EventID* event_id) {
#line 602 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_critical ("Type `%s' does not implement abstract method `media_source_collection_get_event_source_ids'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 602 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 5740 "MediaDataRepresentation.c"
}


GeeCollection* media_source_collection_get_event_source_ids (MediaSourceCollection* self, EventID* event_id) {
#line 602 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 602 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->get_event_source_ids (self, event_id);
#line 5749 "MediaDataRepresentation.c"
}


GeeCollection* media_source_collection_get_trashcan_contents (MediaSourceCollection* self) {
	GeeCollection* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
#line 604 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 605 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_collection_get_trashcan (self);
#line 605 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 605 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = source_holding_tank_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
#line 605 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 605 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 605 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp3_;
#line 605 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5775 "MediaDataRepresentation.c"
}


GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self) {
	GeeCollection* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
#line 608 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 609 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_collection_get_offline_bin (self);
#line 609 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 609 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = source_holding_tank_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
#line 609 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 609 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 609 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp3_;
#line 609 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5801 "MediaDataRepresentation.c"
}


GeeCollection* media_source_collection_get_flagged (MediaSourceCollection* self) {
	GeeCollection* result = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
#line 612 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 613 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->flagged;
#line 613 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = gee_set_get_read_only_view (_tmp0_);
#line 613 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = _tmp1_;
#line 613 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 613 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5822 "MediaDataRepresentation.c"
}


GeeSortedSet* media_source_collection_get_import_roll_ids (MediaSourceCollection* self) {
	GeeSortedSet* result = NULL;
	GeeTreeSet* _tmp0_;
	GeeSortedSet* _tmp1_;
#line 617 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 618 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->sorted_import_ids;
#line 618 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SORTED_SET, GeeSortedSet));
#line 618 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 618 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5840 "MediaDataRepresentation.c"
}


ImportID* media_source_collection_get_last_import_id (MediaSourceCollection* self) {
	ImportID* result = NULL;
	ImportID* _tmp0_ = NULL;
	GeeTreeSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 621 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = self->priv->sorted_import_ids;
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = _tmp2_;
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp3_ != 0) {
#line 5860 "MediaDataRepresentation.c"
		GeeTreeSet* _tmp4_;
		gpointer _tmp5_;
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp4_ = self->priv->sorted_import_ids;
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = gee_abstract_sorted_set_last (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_SORTED_SET, GeeAbstractSortedSet));
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_import_id_free0 (_tmp0_);
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = (ImportID*) _tmp5_;
#line 5871 "MediaDataRepresentation.c"
	} else {
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_import_id_free0 (_tmp0_);
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = NULL;
#line 5877 "MediaDataRepresentation.c"
	}
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp0_;
#line 622 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5883 "MediaDataRepresentation.c"
}


GeeCollection* media_source_collection_get_import_roll (MediaSourceCollection* self, ImportID* import_id) {
	GeeCollection* result = NULL;
	GeeMultiMap* _tmp0_;
	ImportID _tmp1_;
	GeeCollection* _tmp2_;
#line 625 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 625 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 626 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->import_rolls;
#line 626 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = *import_id;
#line 626 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_multi_map_get (_tmp0_, &_tmp1_);
#line 626 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp2_;
#line 626 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5906 "MediaDataRepresentation.c"
}


void media_source_collection_add_many_to_trash (MediaSourceCollection* self, GeeCollection* sources) {
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	GeeCollection* _tmp2_;
#line 629 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 629 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 630 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_collection_get_trashcan (self);
#line 630 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 630 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = sources;
#line 630 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	source_holding_tank_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), _tmp2_);
#line 630 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 5928 "MediaDataRepresentation.c"
}


void media_source_collection_add_many_to_offline (MediaSourceCollection* self, GeeCollection* sources) {
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	GeeCollection* _tmp2_;
#line 633 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 633 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 634 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_collection_get_offline_bin (self);
#line 634 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 634 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = sources;
#line 634 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	source_holding_tank_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), _tmp2_);
#line 634 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 5950 "MediaDataRepresentation.c"
}


gint media_source_collection_get_trashcan_count (MediaSourceCollection* self) {
	gint result = 0;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 637 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), 0);
#line 638 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_source_collection_get_trashcan (self);
#line 638 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 638 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = source_holding_tank_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
#line 638 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = _tmp2_;
#line 638 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 638 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp3_;
#line 638 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 5976 "MediaDataRepresentation.c"
}


static void media_source_collection_real_import_many (MediaSourceCollection* self, GeeCollection* media) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
#line 644 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 645 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media;
#line 645 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_notify_media_import_starting (self, _tmp0_);
#line 647 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = media;
#line 647 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp1_, NULL, NULL);
#line 647 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = _tmp2_;
#line 647 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (_tmp3_);
#line 649 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = media;
#line 649 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_postprocess_imported_media (self, _tmp4_);
#line 651 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = media;
#line 651 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_notify_media_import_completed (self, _tmp5_);
#line 6009 "MediaDataRepresentation.c"
}


void media_source_collection_import_many (MediaSourceCollection* self, GeeCollection* media) {
#line 644 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 644 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->import_many (self, media);
#line 6018 "MediaDataRepresentation.c"
}


static void media_source_collection_real_postprocess_imported_media (MediaSourceCollection* self, GeeCollection* media) {
#line 656 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 6025 "MediaDataRepresentation.c"
}


void media_source_collection_postprocess_imported_media (MediaSourceCollection* self, GeeCollection* media) {
#line 656 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 656 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->postprocess_imported_media (self, media);
#line 6034 "MediaDataRepresentation.c"
}


static gboolean _aggregate_progress_monitor_monitor_progress_monitor (guint64 current, guint64 total, gboolean do_event_loop, gpointer self) {
	gboolean result;
	result = aggregate_progress_monitor_monitor ((AggregateProgressMonitor*) self, current, total);
#line 691 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 6043 "MediaDataRepresentation.c"
}


void media_source_collection_remove_from_app (MediaSourceCollection* self, GeeCollection* sources, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed) {
	GeeCollection* _tmp0_;
	GeeHashSet* _tmp1_ = NULL;
	gboolean _tmp2_;
	GeeHashSet* to_tombstone = NULL;
	GeeHashSet* _tmp4_;
	GeeArrayList* trashed = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* offlined = NULL;
	GeeArrayList* _tmp6_;
	GeeArrayList* not_trashed = NULL;
	GeeArrayList* _tmp7_;
	gint total_count = 0;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GeeArrayList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	AggregateProgressMonitor* agg_monitor = NULL;
	ProgressMonitor _tmp40_;
	void* _tmp40__target;
	GeeArrayList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GeeArrayList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	GeeArrayList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gboolean _tmp72_ = FALSE;
	GeeHashSet* _tmp73_;
	GError * _inner_error_ = NULL;
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((sources == NULL) || GEE_IS_COLLECTION (sources));
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((not_removed == NULL) || GEE_IS_LIST (not_removed));
#line 664 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = sources;
#line 664 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_vala_assert (_tmp0_ != NULL, "sources != null");
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = delete_backing;
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (!_tmp2_) {
#line 6102 "MediaDataRepresentation.c"
		GeeHashSet* _tmp3_;
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp3_;
#line 6110 "MediaDataRepresentation.c"
	} else {
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = NULL;
#line 6116 "MediaDataRepresentation.c"
	}
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = _g_object_ref0 (_tmp1_);
#line 666 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	to_tombstone = _tmp4_;
#line 669 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 669 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	trashed = _tmp5_;
#line 670 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 670 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	offlined = _tmp6_;
#line 671 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp7_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 671 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	not_trashed = _tmp7_;
#line 6134 "MediaDataRepresentation.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp8_;
		GeeIterator* _tmp9_;
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp8_ = sources;
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_it = _tmp9_;
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 6147 "MediaDataRepresentation.c"
			GeeIterator* _tmp10_;
			gboolean _tmp11_;
			MediaSource* source = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			MediaSource* _tmp14_;
			gboolean _tmp15_;
			GeeHashSet* _tmp24_;
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = _source_it;
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp11_ = gee_iterator_next (_tmp10_);
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp11_) {
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 6164 "MediaDataRepresentation.c"
			}
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp12_ = _source_it;
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp13_ = gee_iterator_get (_tmp12_);
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			source = (MediaSource*) _tmp13_;
#line 673 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp14_ = source;
#line 673 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp15_ = media_source_is_trashed (_tmp14_);
#line 673 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp15_) {
#line 6178 "MediaDataRepresentation.c"
				GeeArrayList* _tmp16_;
				MediaSource* _tmp17_;
#line 674 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp16_ = trashed;
#line 674 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp17_ = source;
#line 674 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 6187 "MediaDataRepresentation.c"
			} else {
				MediaSource* _tmp18_;
				gboolean _tmp19_;
#line 675 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp18_ = source;
#line 675 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp19_ = media_source_is_offline (_tmp18_);
#line 675 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_tmp19_) {
#line 6197 "MediaDataRepresentation.c"
					GeeArrayList* _tmp20_;
					MediaSource* _tmp21_;
#line 676 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp20_ = offlined;
#line 676 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp21_ = source;
#line 676 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
#line 6206 "MediaDataRepresentation.c"
				} else {
					GeeArrayList* _tmp22_;
					MediaSource* _tmp23_;
#line 678 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp22_ = not_trashed;
#line 678 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp23_ = source;
#line 678 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp23_);
#line 6216 "MediaDataRepresentation.c"
				}
			}
#line 680 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp24_ = to_tombstone;
#line 680 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp24_ != NULL) {
#line 6223 "MediaDataRepresentation.c"
				GeeHashSet* _tmp25_;
				MediaSource* _tmp26_;
#line 681 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp25_ = to_tombstone;
#line 681 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp26_ = source;
#line 681 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp26_);
#line 6232 "MediaDataRepresentation.c"
			}
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (source);
#line 6236 "MediaDataRepresentation.c"
		}
#line 672 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_source_it);
#line 6240 "MediaDataRepresentation.c"
	}
#line 684 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp27_ = sources;
#line 684 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp28_ = gee_collection_get_size (_tmp27_);
#line 684 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp29_ = _tmp28_;
#line 684 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	total_count = _tmp29_;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp30_ = total_count;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp31_ = trashed;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp32_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp33_ = _tmp32_;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp34_ = offlined;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp35_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp36_ = _tmp35_;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp37_ = not_trashed;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp38_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp39_ = _tmp38_;
#line 685 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_vala_assert (_tmp30_ == ((_tmp33_ + _tmp36_) + _tmp39_), "total_count == (trashed.size + offlined.size + not_trashed.size)");
#line 688 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	agg_monitor = NULL;
#line 689 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp40_ = monitor;
#line 689 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp40__target = monitor_target;
#line 689 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp40_ != NULL) {
#line 6280 "MediaDataRepresentation.c"
		gint _tmp41_;
		ProgressMonitor _tmp42_;
		void* _tmp42__target;
		AggregateProgressMonitor* _tmp43_;
		AggregateProgressMonitor* _tmp44_;
#line 690 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp41_ = total_count;
#line 690 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp42_ = monitor;
#line 690 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp42__target = monitor_target;
#line 690 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp43_ = aggregate_progress_monitor_new ((guint64) _tmp41_, _tmp42_, _tmp42__target);
#line 690 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_aggregate_progress_monitor_unref0 (agg_monitor);
#line 690 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		agg_monitor = _tmp43_;
#line 691 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp44_ = agg_monitor;
#line 691 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		monitor = _aggregate_progress_monitor_monitor_progress_monitor;
#line 691 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		monitor_target = _tmp44_;
#line 6304 "MediaDataRepresentation.c"
	}
#line 694 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp45_ = trashed;
#line 694 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp46_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 694 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp47_ = _tmp46_;
#line 694 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp47_ > 0) {
#line 6314 "MediaDataRepresentation.c"
		MediaSourceHoldingTank* _tmp48_;
		MediaSourceHoldingTank* _tmp49_;
		GeeArrayList* _tmp50_;
		gboolean _tmp51_;
		ProgressMonitor _tmp52_;
		void* _tmp52__target;
		GeeList* _tmp53_;
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp48_ = media_source_collection_get_trashcan (self);
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp49_ = _tmp48_;
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp50_ = trashed;
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp51_ = delete_backing;
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp52_ = monitor;
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp52__target = monitor_target;
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp53_ = not_removed;
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		source_holding_tank_destroy_orphans (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_LIST, GeeList), _tmp51_, _tmp52_, _tmp52__target, _tmp53_);
#line 695 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_holding_tank_unref0 (_tmp49_);
#line 6340 "MediaDataRepresentation.c"
	}
#line 697 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp54_ = offlined;
#line 697 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp55_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 697 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp56_ = _tmp55_;
#line 697 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp56_ > 0) {
#line 6350 "MediaDataRepresentation.c"
		MediaSourceHoldingTank* _tmp57_;
		MediaSourceHoldingTank* _tmp58_;
		GeeArrayList* _tmp59_;
		gboolean _tmp60_;
		ProgressMonitor _tmp61_;
		void* _tmp61__target;
		GeeList* _tmp62_;
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp57_ = media_source_collection_get_offline_bin (self);
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp58_ = _tmp57_;
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp59_ = offlined;
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp60_ = delete_backing;
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp61_ = monitor;
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp61__target = monitor_target;
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp62_ = not_removed;
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		source_holding_tank_destroy_orphans (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_LIST, GeeList), _tmp60_, _tmp61_, _tmp61__target, _tmp62_);
#line 698 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_holding_tank_unref0 (_tmp58_);
#line 6376 "MediaDataRepresentation.c"
	}
#line 701 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp63_ = not_trashed;
#line 701 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp64_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 701 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp65_ = _tmp64_;
#line 701 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp65_ > 0) {
#line 6386 "MediaDataRepresentation.c"
		GeeArrayList* _tmp66_;
		Marker* _tmp67_;
		Marker* _tmp68_;
		gboolean _tmp69_;
		ProgressMonitor _tmp70_;
		void* _tmp70__target;
		GeeList* _tmp71_;
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp66_ = not_trashed;
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp67_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, GEE_TYPE_COLLECTION, GeeCollection));
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp68_ = _tmp67_;
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp69_ = delete_backing;
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp70_ = monitor;
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp70__target = monitor_target;
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp71_ = not_removed;
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp68_, _tmp69_, _tmp70_, _tmp70__target, _tmp71_);
#line 702 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp68_);
#line 6412 "MediaDataRepresentation.c"
	}
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp73_ = to_tombstone;
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp73_ != NULL) {
#line 6418 "MediaDataRepresentation.c"
		GeeHashSet* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp74_ = to_tombstone;
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp75_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp76_ = _tmp75_;
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp72_ = _tmp76_ > 0;
#line 6430 "MediaDataRepresentation.c"
	} else {
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp72_ = FALSE;
#line 6434 "MediaDataRepresentation.c"
	}
#line 704 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp72_) {
#line 6438 "MediaDataRepresentation.c"
		{
			GeeHashSet* _tmp77_;
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp77_ = to_tombstone;
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			tombstone_entomb_many_sources (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, GEE_TYPE_COLLECTION, GeeCollection), TOMBSTONE_REASON_REMOVED_BY_USER, &_inner_error_);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 6449 "MediaDataRepresentation.c"
					goto __catch574_database_error;
				}
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_aggregate_progress_monitor_unref0 (agg_monitor);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (not_trashed);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (offlined);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (trashed);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (to_tombstone);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_tmp1_);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_clear_error (&_inner_error_);
#line 706 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return;
#line 6470 "MediaDataRepresentation.c"
			}
		}
		goto __finally574;
		__catch574_database_error:
		{
			GError* err = NULL;
			GError* _tmp78_;
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			err = _inner_error_;
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_inner_error_ = NULL;
#line 708 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp78_ = err;
#line 708 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			app_window_database_error (_tmp78_);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_error_free0 (err);
#line 6488 "MediaDataRepresentation.c"
		}
		__finally574:
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_aggregate_progress_monitor_unref0 (agg_monitor);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (not_trashed);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (offlined);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (trashed);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (to_tombstone);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_tmp1_);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			g_clear_error (&_inner_error_);
#line 705 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			return;
#line 6511 "MediaDataRepresentation.c"
		}
	}
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_aggregate_progress_monitor_unref0 (agg_monitor);
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (not_trashed);
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (offlined);
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (trashed);
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (to_tombstone);
#line 662 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (_tmp1_);
#line 6526 "MediaDataRepresentation.c"
}


void media_source_collection_delete_backing_files (MediaSourceCollection* self, GeeCollection* sources, ProgressMonitor monitor, void* monitor_target, GeeList* not_deleted) {
	gint total_count = 0;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint i = 0;
	GError * _inner_error_ = NULL;
#line 715 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (self));
#line 715 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 715 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((not_deleted == NULL) || GEE_IS_LIST (not_deleted));
#line 717 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = sources;
#line 717 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 717 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = _tmp1_;
#line 717 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	total_count = _tmp2_;
#line 718 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	i = 1;
#line 6553 "MediaDataRepresentation.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = sources;
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_source_it = _tmp4_;
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 6566 "MediaDataRepresentation.c"
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			MediaSource* source = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFile* file = NULL;
			MediaSource* _tmp9_;
			GFile* _tmp10_;
			GFile* masterfile = NULL;
			MediaSource* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			gboolean deleted = FALSE;
			GFile* _tmp27_;
			gboolean _tmp28_;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_;
			ProgressMonitor _tmp34_;
			void* _tmp34__target;
			gint _tmp38_;
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = _source_it;
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp6_) {
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 6595 "MediaDataRepresentation.c"
			}
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = _source_it;
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			source = (MediaSource*) _tmp8_;
#line 721 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = source;
#line 721 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = media_source_get_file (_tmp9_);
#line 721 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			file = _tmp10_;
#line 6609 "MediaDataRepresentation.c"
			{
				GFile* _tmp11_;
#line 723 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp11_ = file;
#line 723 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_file_delete (_tmp11_, NULL, &_inner_error_);
#line 723 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6618 "MediaDataRepresentation.c"
					goto __catch575_g_error;
				}
			}
			goto __finally575;
			__catch575_g_error:
			{
				GError* err = NULL;
				GFile* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GError* _tmp15_;
				const gchar* _tmp16_;
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				err = _inner_error_;
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_inner_error_ = NULL;
#line 726 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp12_ = file;
#line 726 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp13_ = g_file_get_path (_tmp12_);
#line 726 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp14_ = _tmp13_;
#line 726 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp15_ = err;
#line 726 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp16_ = _tmp15_->message;
#line 726 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_debug ("MediaDataRepresentation.vala:726: Exception deleting file %s: %s", _tmp14_, _tmp16_);
#line 726 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_free0 (_tmp14_);
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_error_free0 (err);
#line 6651 "MediaDataRepresentation.c"
			}
			__finally575:
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (file);
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (source);
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_source_it);
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				g_clear_error (&_inner_error_);
#line 722 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return;
#line 6668 "MediaDataRepresentation.c"
			}
#line 729 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp17_ = source;
#line 729 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp18_ = media_source_get_master_file (_tmp17_);
#line 729 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			masterfile = _tmp18_;
#line 730 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp19_ = masterfile;
#line 730 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp19_ != NULL) {
#line 6680 "MediaDataRepresentation.c"
				{
					GFile* _tmp20_;
#line 732 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp20_ = masterfile;
#line 732 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					g_file_delete (_tmp20_, NULL, &_inner_error_);
#line 732 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6689 "MediaDataRepresentation.c"
						goto __catch576_g_error;
					}
				}
				goto __finally576;
				__catch576_g_error:
				{
					GError* err = NULL;
					GError* _tmp21_;
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					err = _inner_error_;
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_inner_error_ = NULL;
#line 734 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_tmp21_ = err;
#line 734 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					if (!g_error_matches (_tmp21_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 6706 "MediaDataRepresentation.c"
						GFile* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						GError* _tmp25_;
						const gchar* _tmp26_;
#line 735 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp22_ = masterfile;
#line 735 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp23_ = g_file_get_path (_tmp22_);
#line 735 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp24_ = _tmp23_;
#line 735 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp25_ = err;
#line 735 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_tmp26_ = _tmp25_->message;
#line 735 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						g_debug ("MediaDataRepresentation.vala:735: Exception deleting master file %s: %" \
"s", _tmp24_, _tmp26_);
#line 735 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
						_g_free0 (_tmp24_);
#line 6726 "MediaDataRepresentation.c"
					}
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_g_error_free0 (err);
#line 6730 "MediaDataRepresentation.c"
				}
				__finally576:
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_g_object_unref0 (masterfile);
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_g_object_unref0 (file);
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_g_object_unref0 (source);
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					_g_object_unref0 (_source_it);
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					g_clear_error (&_inner_error_);
#line 731 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
					return;
#line 6749 "MediaDataRepresentation.c"
				}
			}
#line 740 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp27_ = file;
#line 740 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp28_ = g_file_query_exists (_tmp27_, NULL);
#line 740 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			deleted = !_tmp28_;
#line 741 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp30_ = deleted;
#line 741 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp30_) {
#line 6762 "MediaDataRepresentation.c"
				GeeList* _tmp31_;
#line 741 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp31_ = not_deleted;
#line 741 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp29_ = NULL != _tmp31_;
#line 6768 "MediaDataRepresentation.c"
			} else {
#line 741 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp29_ = FALSE;
#line 6772 "MediaDataRepresentation.c"
			}
#line 741 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp29_) {
#line 6776 "MediaDataRepresentation.c"
				GeeList* _tmp32_;
				MediaSource* _tmp33_;
#line 742 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp32_ = not_deleted;
#line 742 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp33_ = source;
#line 742 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), _tmp33_);
#line 6785 "MediaDataRepresentation.c"
			}
#line 745 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp34_ = monitor;
#line 745 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp34__target = monitor_target;
#line 745 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp34_ != NULL) {
#line 6793 "MediaDataRepresentation.c"
				ProgressMonitor _tmp35_;
				void* _tmp35__target;
				gint _tmp36_;
				gint _tmp37_;
#line 746 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp35_ = monitor;
#line 746 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp35__target = monitor_target;
#line 746 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp36_ = i;
#line 746 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp37_ = total_count;
#line 746 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp35_ ((guint64) _tmp36_, (guint64) _tmp37_, TRUE, _tmp35__target);
#line 6808 "MediaDataRepresentation.c"
			}
#line 748 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp38_ = i;
#line 748 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			i = _tmp38_ + 1;
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (masterfile);
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (file);
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (source);
#line 6820 "MediaDataRepresentation.c"
		}
#line 720 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_source_it);
#line 6824 "MediaDataRepresentation.c"
	}
}


TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self) {
#line 344 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (self), NULL);
#line 344 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return MEDIA_SOURCE_COLLECTION_GET_CLASS (self)->get_transaction_controller (self);
#line 6834 "MediaDataRepresentation.c"
}


static void media_source_collection_real_media_import_starting (MediaSourceCollection* self, GeeCollection* media) {
#line 357 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 6841 "MediaDataRepresentation.c"
}


static void media_source_collection_real_media_import_completed (MediaSourceCollection* self, GeeCollection* media) {
#line 364 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 6848 "MediaDataRepresentation.c"
}


static void media_source_collection_real_master_file_replaced (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file) {
#line 367 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (media));
#line 367 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 367 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 6859 "MediaDataRepresentation.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (n_param_values == 4);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data1 = closure->data;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data2 = param_values->data[0].v_pointer;
#line 6878 "MediaDataRepresentation.c"
	} else {
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data1 = param_values->data[0].v_pointer;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		data2 = closure->data;
#line 6884 "MediaDataRepresentation.c"
	}
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
#line 6890 "MediaDataRepresentation.c"
}


static void media_source_collection_real_trashcan_contents_altered (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed) {
#line 370 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 370 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 6899 "MediaDataRepresentation.c"
}


static void media_source_collection_real_import_roll_altered (MediaSourceCollection* self) {
}


static void media_source_collection_real_offline_contents_altered (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed) {
#line 377 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 377 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 6912 "MediaDataRepresentation.c"
}


static void media_source_collection_real_flagged_contents_altered (MediaSourceCollection* self) {
}


static void media_source_collection_class_init (MediaSourceCollectionClass * klass) {
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((DataCollectionClass *) klass)->finalize = media_source_collection_finalize;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_type_class_add_private (klass, sizeof (MediaSourceCollectionPrivate));
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection *)) media_source_collection_real_create_trashcan;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection *)) media_source_collection_real_create_offline_bin;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection *, Workers*, GCancellable*)) media_source_collection_real_create_media_monitor;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection *)) media_source_collection_real_get_typename;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection *, GFile*)) media_source_collection_real_is_file_recognized;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection *, gint64)) media_source_collection_real_fetch_by_numeric_id;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->notify_import_roll_altered = (void (*) (MediaSourceCollection *)) media_source_collection_real_notify_import_roll_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->notify_flagged_contents_altered = (void (*) (MediaSourceCollection *)) media_source_collection_real_notify_flagged_contents_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->notify_media_import_starting = (void (*) (MediaSourceCollection *, GeeCollection*)) media_source_collection_real_notify_media_import_starting;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->notify_media_import_completed = (void (*) (MediaSourceCollection *, GeeCollection*)) media_source_collection_real_notify_media_import_completed;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((DataCollectionClass *) klass)->items_altered = (void (*) (DataCollection *, GeeMap*)) media_source_collection_real_items_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection *, GeeIterable*, GeeIterable*)) media_source_collection_real_notify_contents_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->fetch_by_source_id = (MediaSource* (*) (MediaSourceCollection *, const gchar*)) media_source_collection_real_fetch_by_source_id;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection *, EventID*)) media_source_collection_real_get_event_source_ids;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->import_many = (void (*) (MediaSourceCollection *, GeeCollection*)) media_source_collection_real_import_many;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->postprocess_imported_media = (void (*) (MediaSourceCollection *, GeeCollection*)) media_source_collection_real_postprocess_imported_media;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->media_import_starting = media_source_collection_real_media_import_starting;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->media_import_completed = media_source_collection_real_media_import_completed;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->master_file_replaced = media_source_collection_real_master_file_replaced;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->trashcan_contents_altered = media_source_collection_real_trashcan_contents_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->import_roll_altered = media_source_collection_real_import_roll_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->offline_contents_altered = media_source_collection_real_offline_contents_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaSourceCollectionClass *) klass)->flagged_contents_altered = media_source_collection_real_flagged_contents_altered;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_STARTING_SIGNAL] = g_signal_new ("media-import-starting", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, media_import_starting), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MEDIA_IMPORT_COMPLETED_SIGNAL] = g_signal_new ("media-import-completed", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, media_import_completed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_MASTER_FILE_REPLACED_SIGNAL] = g_signal_new ("master-file-replaced", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, master_file_replaced), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, TYPE_MEDIA_SOURCE, g_file_get_type (), g_file_get_type ());
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_TRASHCAN_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("trashcan-contents-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, trashcan_contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEE_TYPE_COLLECTION);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_IMPORT_ROLL_ALTERED_SIGNAL] = g_signal_new ("import-roll-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, import_roll_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_OFFLINE_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("offline-contents-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, offline_contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEE_TYPE_COLLECTION);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_source_collection_signals[MEDIA_SOURCE_COLLECTION_FLAGGED_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("flagged-contents-altered", TYPE_MEDIA_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (MediaSourceCollectionClass, flagged_contents_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6987 "MediaDataRepresentation.c"
}


static void media_source_collection_instance_init (MediaSourceCollection * self) {
	GeeHashMap* _tmp0_;
	GeeTreeMultiMap* _tmp1_;
	GeeTreeSet* _tmp2_;
	GeeHashSet* _tmp3_;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv = MEDIA_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 346 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->trashcan = NULL;
#line 347 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->offline_bin = NULL;
#line 348 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 348 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->by_master_file = _tmp0_;
#line 350 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = gee_tree_multi_map_new (TYPE_IMPORT_ID, (GBoxedCopyFunc) import_id_dup, (GDestroyNotify) import_id_free, TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _import_id_compare_func_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
#line 350 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->import_rolls = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 352 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_tree_set_new (TYPE_IMPORT_ID, (GBoxedCopyFunc) import_id_dup, (GDestroyNotify) import_id_free, _import_id_compare_func_gcompare_data_func, NULL, NULL);
#line 352 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->sorted_import_ids = _tmp2_;
#line 353 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 353 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->flagged = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_SET, GeeSet);
#line 7018 "MediaDataRepresentation.c"
}


static void media_source_collection_finalize (DataCollection * obj) {
	MediaSourceCollection * self;
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection);
#line 346 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (self->priv->trashcan);
#line 347 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_source_holding_tank_unref0 (self->priv->offline_bin);
#line 348 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->by_master_file);
#line 350 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->import_rolls);
#line 352 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->sorted_import_ids);
#line 353 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->flagged);
#line 343 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	DATA_COLLECTION_CLASS (media_source_collection_parent_class)->finalize (obj);
#line 7040 "MediaDataRepresentation.c"
}


GType media_source_collection_get_type (void) {
	static volatile gsize media_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&media_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaSourceCollection), 0, (GInstanceInitFunc) media_source_collection_instance_init, NULL };
		GType media_source_collection_type_id;
		media_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "MediaSourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&media_source_collection_type_id__volatile, media_source_collection_type_id);
	}
	return media_source_collection_type_id__volatile;
}


static void _media_collection_registry_on_init_done_application_init_done (Application* _sender, gpointer self) {
#line 767 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_collection_registry_on_init_done ((MediaCollectionRegistry*) self);
#line 7059 "MediaDataRepresentation.c"
}


static MediaCollectionRegistry* media_collection_registry_construct (GType object_type) {
	MediaCollectionRegistry* self = NULL;
	Application* _tmp0_;
	Application* _tmp1_;
#line 762 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = (MediaCollectionRegistry*) g_type_create_instance (object_type);
#line 763 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = application_get_instance ();
#line 763 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 763 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_connect (_tmp1_, "init-done", (GCallback) _media_collection_registry_on_init_done_application_init_done, self);
#line 763 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_application_unref0 (_tmp1_);
#line 762 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self;
#line 7079 "MediaDataRepresentation.c"
}


static MediaCollectionRegistry* media_collection_registry_new (void) {
#line 762 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return media_collection_registry_construct (TYPE_MEDIA_COLLECTION_REGISTRY);
#line 7086 "MediaDataRepresentation.c"
}


static void media_collection_registry_on_init_done (MediaCollectionRegistry* self) {
	LibraryMonitor* library_monitor = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	LibraryMonitor* _tmp3_;
	LibraryMonitor* _tmp4_;
	LibraryMonitorPool* _tmp5_;
	LibraryMonitorPool* _tmp6_;
#line 770 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
#line 772 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = app_dirs_get_import_dir ();
#line 772 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 772 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = commandline_options_no_runtime_monitoring;
#line 772 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = library_monitor_new (_tmp1_, TRUE, !_tmp2_);
#line 772 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = _tmp3_;
#line 772 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (_tmp1_);
#line 772 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	library_monitor = _tmp4_;
#line 775 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = library_monitor_pool_get_instance ();
#line 775 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = _tmp5_;
#line 775 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	library_monitor_pool_replace (_tmp6_, library_monitor, MEDIA_COLLECTION_REGISTRY_LIBRARY_MONITOR_START_DELAY_MSEC);
#line 775 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_library_monitor_pool_unref0 (_tmp6_);
#line 770 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (library_monitor);
#line 7125 "MediaDataRepresentation.c"
}


static void _media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed (ConfigurationFacade* _sender, gpointer self) {
#line 780 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_collection_registry_on_import_directory_changed ();
#line 7132 "MediaDataRepresentation.c"
}


void media_collection_registry_init (void) {
	MediaCollectionRegistry* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
#line 779 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_collection_registry_new ();
#line 779 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_media_collection_registry_unref0 (media_collection_registry_instance);
#line 779 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_collection_registry_instance = _tmp0_;
#line 780 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = config_facade_get_instance ();
#line 780 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = _tmp1_;
#line 780 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "import-directory-changed", (GCallback) _media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed, NULL);
#line 780 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (_tmp2_);
#line 7154 "MediaDataRepresentation.c"
}


void media_collection_registry_terminate (void) {
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	guint _tmp2_;
#line 784 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = config_facade_get_instance ();
#line 784 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 784 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_parse_name ("import-directory-changed", TYPE_CONFIGURATION_FACADE, &_tmp2_, NULL, FALSE);
#line 784 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _media_collection_registry_on_import_directory_changed_configuration_facade_import_directory_changed, NULL);
#line 784 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (_tmp1_);
#line 7172 "MediaDataRepresentation.c"
}


static void media_collection_registry_on_import_directory_changed (void) {
	GFile* import_dir = NULL;
	GFile* _tmp0_;
	LibraryMonitor* current = NULL;
	LibraryMonitorPool* _tmp1_;
	LibraryMonitorPool* _tmp2_;
	LibraryMonitor* _tmp3_;
	LibraryMonitor* _tmp4_;
	gboolean _tmp5_ = FALSE;
	LibraryMonitor* _tmp6_;
	LibraryMonitor* replacement = NULL;
	GFile* _tmp12_;
	gboolean _tmp13_;
	LibraryMonitor* _tmp14_;
	LibraryMonitorPool* _tmp15_;
	LibraryMonitorPool* _tmp16_;
	LibraryMonitor* _tmp17_;
#line 788 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = app_dirs_get_import_dir ();
#line 788 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	import_dir = _tmp0_;
#line 790 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = library_monitor_pool_get_instance ();
#line 790 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = _tmp1_;
#line 790 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = library_monitor_pool_get_monitor (_tmp2_);
#line 790 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = _tmp3_;
#line 790 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_library_monitor_pool_unref0 (_tmp2_);
#line 790 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	current = _tmp4_;
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = current;
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp6_ != NULL) {
#line 7213 "MediaDataRepresentation.c"
		LibraryMonitor* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		gboolean _tmp11_;
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp7_ = current;
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp8_ = directory_monitor_get_root (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp9_ = _tmp8_;
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp10_ = import_dir;
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp11_ = g_file_equal (_tmp9_, _tmp10_);
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = _tmp11_;
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp9_);
#line 7233 "MediaDataRepresentation.c"
	} else {
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = FALSE;
#line 7237 "MediaDataRepresentation.c"
	}
#line 791 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp5_) {
#line 792 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (current);
#line 792 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (import_dir);
#line 792 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return;
#line 7247 "MediaDataRepresentation.c"
	}
#line 794 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp12_ = import_dir;
#line 794 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp13_ = commandline_options_no_runtime_monitoring;
#line 794 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp14_ = library_monitor_new (_tmp12_, TRUE, !_tmp13_);
#line 794 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	replacement = _tmp14_;
#line 796 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp15_ = library_monitor_pool_get_instance ();
#line 796 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp16_ = _tmp15_;
#line 796 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp17_ = replacement;
#line 796 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	library_monitor_pool_replace (_tmp16_, _tmp17_, MEDIA_COLLECTION_REGISTRY_LIBRARY_MONITOR_START_DELAY_MSEC);
#line 796 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_library_monitor_pool_unref0 (_tmp16_);
#line 797 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	library_files_select_copy_function ();
#line 787 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (replacement);
#line 787 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (current);
#line 787 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (import_dir);
#line 7275 "MediaDataRepresentation.c"
}


static gpointer _media_collection_registry_ref0 (gpointer self) {
#line 801 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self ? media_collection_registry_ref (self) : NULL;
#line 7282 "MediaDataRepresentation.c"
}


MediaCollectionRegistry* media_collection_registry_get_instance (void) {
	MediaCollectionRegistry* result = NULL;
	MediaCollectionRegistry* _tmp0_;
	MediaCollectionRegistry* _tmp1_;
#line 801 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = media_collection_registry_instance;
#line 801 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _media_collection_registry_ref0 (_tmp0_);
#line 801 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp1_;
#line 801 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 7298 "MediaDataRepresentation.c"
}


gchar* media_collection_registry_get_typename_from_source_id (const gchar* source_id) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
#line 804 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (source_id != NULL, NULL);
#line 807 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = source_id;
#line 807 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, PHOTO_TYPENAME);
#line 807 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp1_) {
#line 7314 "MediaDataRepresentation.c"
		gchar* _tmp2_;
#line 808 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = g_strdup (PHOTO_TYPENAME);
#line 808 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = _tmp2_;
#line 808 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 7322 "MediaDataRepresentation.c"
	} else {
		gchar** components = NULL;
		const gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint components_length1;
		gint _components_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 810 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = source_id;
#line 810 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "-", 0);
#line 810 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		components = _tmp5_;
#line 810 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		components_length1 = _vala_array_length (_tmp4_);
#line 810 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_components_size_ = components_length1;
#line 811 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6_ = components;
#line 811 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6__length1 = components_length1;
#line 811 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_vala_assert (_tmp6__length1 == 2, "components.length == 2");
#line 813 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp7_ = components;
#line 813 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp7__length1 = components_length1;
#line 813 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp8_ = _tmp7_[0];
#line 813 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 813 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = _tmp9_;
#line 813 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
#line 813 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 7366 "MediaDataRepresentation.c"
	}
}


void media_collection_registry_register_collection (MediaCollectionRegistry* self, MediaSourceCollection* collection) {
	GeeArrayList* _tmp0_;
	MediaSourceCollection* _tmp1_;
	GeeHashMap* _tmp2_;
	MediaSourceCollection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	MediaSourceCollection* _tmp6_;
#line 817 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
#line 817 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_SOURCE_COLLECTION (collection));
#line 818 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->all;
#line 818 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = collection;
#line 818 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 819 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = self->priv->by_typename;
#line 819 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = collection;
#line 819 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = media_source_collection_get_typename (_tmp3_);
#line 819 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp5_ = _tmp4_;
#line 819 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp6_ = collection;
#line 819 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_, _tmp6_);
#line 819 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (_tmp5_);
#line 7403 "MediaDataRepresentation.c"
}


MediaSourceCollection* media_collection_registry_get_collection (MediaCollectionRegistry* self, const gchar* typename) {
	MediaSourceCollection* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
#line 826 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
#line 826 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (typename != NULL, NULL);
#line 827 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->by_typename;
#line 827 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = typename;
#line 827 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 827 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = (MediaSourceCollection*) _tmp2_;
#line 827 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 7426 "MediaDataRepresentation.c"
}


GeeCollection* media_collection_registry_get_all (MediaCollectionRegistry* self) {
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
#line 830 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
#line 831 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = self->priv->all;
#line 831 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
#line 831 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = _tmp1_;
#line 831 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 831 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 7447 "MediaDataRepresentation.c"
}


void media_collection_registry_freeze_all (MediaCollectionRegistry* self) {
#line 834 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
#line 7454 "MediaDataRepresentation.c"
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media_collection_registry_get_all (self);
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp0_;
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_sources_it = _tmp3_;
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 7475 "MediaDataRepresentation.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			MediaSourceCollection* _tmp8_;
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _sources_it;
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp5_) {
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 7490 "MediaDataRepresentation.c"
			}
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _sources_it;
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			sources = (MediaSourceCollection*) _tmp7_;
#line 836 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = sources;
#line 836 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection));
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_data_collection_unref0 (sources);
#line 7504 "MediaDataRepresentation.c"
		}
#line 835 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_sources_it);
#line 7508 "MediaDataRepresentation.c"
	}
}


void media_collection_registry_thaw_all (MediaCollectionRegistry* self) {
#line 839 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
#line 7516 "MediaDataRepresentation.c"
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media_collection_registry_get_all (self);
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp0_;
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_sources_it = _tmp3_;
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 7537 "MediaDataRepresentation.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			MediaSourceCollection* _tmp8_;
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _sources_it;
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp5_) {
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 7552 "MediaDataRepresentation.c"
			}
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _sources_it;
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			sources = (MediaSourceCollection*) _tmp7_;
#line 841 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = sources;
#line 841 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection));
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_data_collection_unref0 (sources);
#line 7566 "MediaDataRepresentation.c"
		}
#line 840 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_sources_it);
#line 7570 "MediaDataRepresentation.c"
	}
}


void media_collection_registry_begin_transaction_on_all (MediaCollectionRegistry* self) {
#line 844 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
#line 7578 "MediaDataRepresentation.c"
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media_collection_registry_get_all (self);
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp0_;
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_sources_it = _tmp3_;
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 7599 "MediaDataRepresentation.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			MediaSourceCollection* _tmp8_;
			TransactionController* _tmp9_;
			TransactionController* _tmp10_;
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _sources_it;
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp5_) {
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 7616 "MediaDataRepresentation.c"
			}
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _sources_it;
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			sources = (MediaSourceCollection*) _tmp7_;
#line 846 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = sources;
#line 846 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = media_source_collection_get_transaction_controller (_tmp8_);
#line 846 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = _tmp9_;
#line 846 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			transaction_controller_begin (_tmp10_);
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_data_collection_unref0 (sources);
#line 7634 "MediaDataRepresentation.c"
		}
#line 845 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_sources_it);
#line 7638 "MediaDataRepresentation.c"
	}
}


void media_collection_registry_commit_transaction_on_all (MediaCollectionRegistry* self) {
#line 849 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self));
#line 7646 "MediaDataRepresentation.c"
	{
		GeeIterator* _sources_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media_collection_registry_get_all (self);
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp0_;
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_sources_it = _tmp3_;
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 7667 "MediaDataRepresentation.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			MediaSourceCollection* _tmp8_;
			TransactionController* _tmp9_;
			TransactionController* _tmp10_;
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _sources_it;
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp5_) {
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 7684 "MediaDataRepresentation.c"
			}
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _sources_it;
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			sources = (MediaSourceCollection*) _tmp7_;
#line 851 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = sources;
#line 851 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = media_source_collection_get_transaction_controller (_tmp8_);
#line 851 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = _tmp9_;
#line 851 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			transaction_controller_commit (_tmp10_);
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_data_collection_unref0 (sources);
#line 7702 "MediaDataRepresentation.c"
		}
#line 850 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_sources_it);
#line 7706 "MediaDataRepresentation.c"
	}
}


MediaSource* media_collection_registry_fetch_media (MediaCollectionRegistry* self, const gchar* source_id) {
	MediaSource* result = NULL;
	gchar* typename = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	MediaSourceCollection* collection = NULL;
	const gchar* _tmp2_;
	MediaSourceCollection* _tmp3_;
	MediaSourceCollection* _tmp4_;
	MediaSourceCollection* _tmp7_;
	const gchar* _tmp8_;
	MediaSource* _tmp9_;
#line 854 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
#line 854 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (source_id != NULL, NULL);
#line 855 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = source_id;
#line 855 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = media_collection_registry_get_typename_from_source_id (_tmp0_);
#line 855 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	typename = _tmp1_;
#line 857 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp2_ = typename;
#line 857 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = media_collection_registry_get_collection (self, _tmp2_);
#line 857 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	collection = _tmp3_;
#line 858 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = collection;
#line 858 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp4_ == NULL) {
#line 7743 "MediaDataRepresentation.c"
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 859 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = source_id;
#line 859 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6_ = typename;
#line 859 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_critical ("MediaDataRepresentation.vala:859: source id '%s' has unrecognized medi" \
"a type '%s'", _tmp5_, _tmp6_);
#line 860 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = NULL;
#line 860 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_data_collection_unref0 (collection);
#line 860 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_free0 (typename);
#line 860 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 7760 "MediaDataRepresentation.c"
	}
#line 863 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp7_ = collection;
#line 863 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp8_ = source_id;
#line 863 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp9_ = media_source_collection_fetch_by_source_id (_tmp7_, _tmp8_);
#line 863 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp9_;
#line 863 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_data_collection_unref0 (collection);
#line 863 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_free0 (typename);
#line 863 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 7776 "MediaDataRepresentation.c"
}


static gpointer _import_id_dup0 (gpointer self) {
#line 884 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return self ? import_id_dup (self) : NULL;
#line 7783 "MediaDataRepresentation.c"
}


ImportID* media_collection_registry_get_last_import_id (MediaCollectionRegistry* self) {
	ImportID* result = NULL;
	ImportID last_import_id = {0};
	ImportID _tmp16_;
	gint64 _tmp17_;
#line 866 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
#line 867 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	import_id_init (&last_import_id, IMPORT_ID_INVALID);
#line 7796 "MediaDataRepresentation.c"
	{
		GeeIterator* _current_collection_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media_collection_registry_get_all (self);
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp0_;
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_current_collection_it = _tmp3_;
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 7817 "MediaDataRepresentation.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			MediaSourceCollection* current_collection = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			ImportID* current_import_id = NULL;
			MediaSourceCollection* _tmp8_;
			ImportID* _tmp9_;
			ImportID* _tmp10_;
			ImportID* _tmp11_;
			gint64 _tmp12_;
			ImportID _tmp13_;
			gint64 _tmp14_;
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _current_collection_it;
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp5_) {
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 7839 "MediaDataRepresentation.c"
			}
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _current_collection_it;
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			current_collection = (MediaSourceCollection*) _tmp7_;
#line 870 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = current_collection;
#line 870 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = media_source_collection_get_last_import_id (_tmp8_);
#line 870 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			current_import_id = _tmp9_;
#line 872 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = current_import_id;
#line 872 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp10_ == NULL) {
#line 873 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_import_id_free0 (current_import_id);
#line 873 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_data_collection_unref0 (current_collection);
#line 873 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				continue;
#line 7863 "MediaDataRepresentation.c"
			}
#line 875 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp11_ = current_import_id;
#line 875 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp12_ = (*_tmp11_).id;
#line 875 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp13_ = last_import_id;
#line 875 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp14_ = _tmp13_.id;
#line 875 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp12_ > _tmp14_) {
#line 7875 "MediaDataRepresentation.c"
				ImportID* _tmp15_;
#line 876 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_tmp15_ = current_import_id;
#line 876 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				last_import_id = *_tmp15_;
#line 7881 "MediaDataRepresentation.c"
			}
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_import_id_free0 (current_import_id);
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_data_collection_unref0 (current_collection);
#line 7887 "MediaDataRepresentation.c"
		}
#line 869 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_current_collection_it);
#line 7891 "MediaDataRepresentation.c"
	}
#line 881 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp16_ = last_import_id;
#line 881 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp17_ = _tmp16_.id;
#line 881 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp17_ == IMPORT_ID_INVALID) {
#line 882 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = NULL;
#line 882 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 7903 "MediaDataRepresentation.c"
	} else {
		ImportID* _tmp18_;
#line 884 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp18_ = _import_id_dup0 (&last_import_id);
#line 884 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = _tmp18_;
#line 884 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 7912 "MediaDataRepresentation.c"
	}
}


GeeCollection* media_collection_registry_get_source_ids_for_event_id (MediaCollectionRegistry* self, EventID* event_id) {
	GeeCollection* result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
#line 887 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
#line 887 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 888 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 888 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_result_ = _tmp0_;
#line 7929 "MediaDataRepresentation.c"
	{
		GeeIterator* _current_collection_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = media_collection_registry_get_all (self);
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = _tmp1_;
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp4_ = _tmp3_;
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp2_);
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_current_collection_it = _tmp4_;
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 7950 "MediaDataRepresentation.c"
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			MediaSourceCollection* current_collection = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeArrayList* _tmp9_;
			MediaSourceCollection* _tmp10_;
			EventID _tmp11_;
			GeeCollection* _tmp12_;
			GeeCollection* _tmp13_;
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = _current_collection_it;
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp6_) {
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 7969 "MediaDataRepresentation.c"
			}
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = _current_collection_it;
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			current_collection = (MediaSourceCollection*) _tmp8_;
#line 891 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = _result_;
#line 891 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = current_collection;
#line 891 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp11_ = *event_id;
#line 891 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp12_ = media_source_collection_get_event_source_ids (_tmp10_, &_tmp11_);
#line 891 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp13_ = _tmp12_;
#line 891 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			gee_array_list_add_all (_tmp9_, _tmp13_);
#line 891 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_g_object_unref0 (_tmp13_);
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_data_collection_unref0 (current_collection);
#line 7993 "MediaDataRepresentation.c"
		}
#line 890 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_current_collection_it);
#line 7997 "MediaDataRepresentation.c"
	}
#line 894 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_COLLECTION, GeeCollection);
#line 894 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 8003 "MediaDataRepresentation.c"
}


MediaSourceCollection* media_collection_registry_get_collection_for_file (MediaCollectionRegistry* self, GFile* file) {
	MediaSourceCollection* result = NULL;
#line 897 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), NULL);
#line 897 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 8013 "MediaDataRepresentation.c"
	{
		GeeIterator* _collection_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp0_ = media_collection_registry_get_all (self);
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp1_ = _tmp0_;
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp3_ = _tmp2_;
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_tmp1_);
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_collection_it = _tmp3_;
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		while (TRUE) {
#line 8034 "MediaDataRepresentation.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			MediaSourceCollection* collection = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			MediaSourceCollection* _tmp8_;
			GFile* _tmp9_;
			gboolean _tmp10_;
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp4_ = _collection_it;
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (!_tmp5_) {
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				break;
#line 8051 "MediaDataRepresentation.c"
			}
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp6_ = _collection_it;
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			collection = (MediaSourceCollection*) _tmp7_;
#line 899 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp8_ = collection;
#line 899 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp9_ = file;
#line 899 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_tmp10_ = media_source_collection_is_file_recognized (_tmp8_, _tmp9_);
#line 899 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			if (_tmp10_) {
#line 900 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				result = collection;
#line 900 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				_g_object_unref0 (_collection_it);
#line 900 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
				return result;
#line 8073 "MediaDataRepresentation.c"
			}
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			_data_collection_unref0 (collection);
#line 8077 "MediaDataRepresentation.c"
		}
#line 898 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_g_object_unref0 (_collection_it);
#line 8081 "MediaDataRepresentation.c"
	}
#line 903 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = NULL;
#line 903 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 8087 "MediaDataRepresentation.c"
}


gboolean media_collection_registry_is_valid_source_id (MediaCollectionRegistry* self, const gchar* source_id) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_;
#line 906 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (IS_MEDIA_COLLECTION_REGISTRY (self), FALSE);
#line 907 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = source_id;
#line 907 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 907 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp1_) {
#line 908 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		result = FALSE;
#line 908 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return result;
#line 8110 "MediaDataRepresentation.c"
	}
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp3_ = source_id;
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp4_ = g_str_has_prefix (_tmp3_, PHOTO_TYPENAME);
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (_tmp4_) {
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = TRUE;
#line 8120 "MediaDataRepresentation.c"
	} else {
		const gchar* _tmp5_;
		gboolean _tmp6_;
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp5_ = source_id;
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp6_ = g_str_has_prefix (_tmp5_, VIDEO_TYPENAME "-");
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		_tmp2_ = _tmp6_;
#line 8130 "MediaDataRepresentation.c"
	}
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	result = _tmp2_;
#line 910 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return result;
#line 8136 "MediaDataRepresentation.c"
}


static void value_media_collection_registry_init (GValue* value) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	value->data[0].v_pointer = NULL;
#line 8143 "MediaDataRepresentation.c"
}


static void value_media_collection_registry_free_value (GValue* value) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (value->data[0].v_pointer) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_collection_registry_unref (value->data[0].v_pointer);
#line 8152 "MediaDataRepresentation.c"
	}
}


static void value_media_collection_registry_copy_value (const GValue* src_value, GValue* dest_value) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (src_value->data[0].v_pointer) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		dest_value->data[0].v_pointer = media_collection_registry_ref (src_value->data[0].v_pointer);
#line 8162 "MediaDataRepresentation.c"
	} else {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8166 "MediaDataRepresentation.c"
	}
}


static gpointer value_media_collection_registry_peek_pointer (const GValue* value) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return value->data[0].v_pointer;
#line 8174 "MediaDataRepresentation.c"
}


static gchar* value_media_collection_registry_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (collect_values[0].v_pointer) {
#line 8181 "MediaDataRepresentation.c"
		MediaCollectionRegistry * object;
		object = collect_values[0].v_pointer;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8188 "MediaDataRepresentation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8192 "MediaDataRepresentation.c"
		}
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = media_collection_registry_ref (object);
#line 8196 "MediaDataRepresentation.c"
	} else {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = NULL;
#line 8200 "MediaDataRepresentation.c"
	}
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 8204 "MediaDataRepresentation.c"
}


static gchar* value_media_collection_registry_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MediaCollectionRegistry ** object_p;
	object_p = collect_values[0].v_pointer;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (!object_p) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8215 "MediaDataRepresentation.c"
	}
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (!value->data[0].v_pointer) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*object_p = NULL;
#line 8221 "MediaDataRepresentation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*object_p = value->data[0].v_pointer;
#line 8225 "MediaDataRepresentation.c"
	} else {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		*object_p = media_collection_registry_ref (value->data[0].v_pointer);
#line 8229 "MediaDataRepresentation.c"
	}
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return NULL;
#line 8233 "MediaDataRepresentation.c"
}


GParamSpec* param_spec_media_collection_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMediaCollectionRegistry* spec;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MEDIA_COLLECTION_REGISTRY), NULL);
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return G_PARAM_SPEC (spec);
#line 8247 "MediaDataRepresentation.c"
}


gpointer value_get_media_collection_registry (const GValue* value) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_COLLECTION_REGISTRY), NULL);
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return value->data[0].v_pointer;
#line 8256 "MediaDataRepresentation.c"
}


void value_set_media_collection_registry (GValue* value, gpointer v_object) {
	MediaCollectionRegistry * old;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_COLLECTION_REGISTRY));
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	old = value->data[0].v_pointer;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (v_object) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_COLLECTION_REGISTRY));
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = v_object;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_collection_registry_ref (value->data[0].v_pointer);
#line 8276 "MediaDataRepresentation.c"
	} else {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = NULL;
#line 8280 "MediaDataRepresentation.c"
	}
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (old) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_collection_registry_unref (old);
#line 8286 "MediaDataRepresentation.c"
	}
}


void value_take_media_collection_registry (GValue* value, gpointer v_object) {
	MediaCollectionRegistry * old;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_COLLECTION_REGISTRY));
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	old = value->data[0].v_pointer;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (v_object) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_COLLECTION_REGISTRY));
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = v_object;
#line 8305 "MediaDataRepresentation.c"
	} else {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		value->data[0].v_pointer = NULL;
#line 8309 "MediaDataRepresentation.c"
	}
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (old) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		media_collection_registry_unref (old);
#line 8315 "MediaDataRepresentation.c"
	}
}


static void media_collection_registry_class_init (MediaCollectionRegistryClass * klass) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	media_collection_registry_parent_class = g_type_class_peek_parent (klass);
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	((MediaCollectionRegistryClass *) klass)->finalize = media_collection_registry_finalize;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_type_class_add_private (klass, sizeof (MediaCollectionRegistryPrivate));
#line 8327 "MediaDataRepresentation.c"
}


static void media_collection_registry_instance_init (MediaCollectionRegistry * self) {
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv = MEDIA_COLLECTION_REGISTRY_GET_PRIVATE (self);
#line 758 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL);
#line 758 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->all = _tmp0_;
#line 759 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_MEDIA_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 759 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->priv->by_typename = _tmp1_;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self->ref_count = 1;
#line 8346 "MediaDataRepresentation.c"
}


static void media_collection_registry_finalize (MediaCollectionRegistry * obj) {
	MediaCollectionRegistry * self;
	Application* _tmp0_;
	Application* _tmp1_;
	guint _tmp2_;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry);
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_handlers_destroy (self);
#line 767 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp0_ = application_get_instance ();
#line 767 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_tmp1_ = _tmp0_;
#line 767 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_parse_name ("init-done", TYPE_APPLICATION, &_tmp2_, NULL, FALSE);
#line 767 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _media_collection_registry_on_init_done_application_init_done, self);
#line 767 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_application_unref0 (_tmp1_);
#line 758 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->all);
#line 759 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	_g_object_unref0 (self->priv->by_typename);
#line 8373 "MediaDataRepresentation.c"
}


GType media_collection_registry_get_type (void) {
	static volatile gsize media_collection_registry_type_id__volatile = 0;
	if (g_once_init_enter (&media_collection_registry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_media_collection_registry_init, value_media_collection_registry_free_value, value_media_collection_registry_copy_value, value_media_collection_registry_peek_pointer, "p", value_media_collection_registry_collect_value, "p", value_media_collection_registry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MediaCollectionRegistryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_collection_registry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaCollectionRegistry), 0, (GInstanceInitFunc) media_collection_registry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType media_collection_registry_type_id;
		media_collection_registry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MediaCollectionRegistry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&media_collection_registry_type_id__volatile, media_collection_registry_type_id);
	}
	return media_collection_registry_type_id__volatile;
}


gpointer media_collection_registry_ref (gpointer instance) {
	MediaCollectionRegistry * self;
	self = instance;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	return instance;
#line 8398 "MediaDataRepresentation.c"
}


void media_collection_registry_unref (gpointer instance) {
	MediaCollectionRegistry * self;
	self = instance;
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		MEDIA_COLLECTION_REGISTRY_GET_CLASS (self)->finalize (self);
#line 753 "/home/jens/Source/shotwell/src/MediaDataRepresentation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8411 "MediaDataRepresentation.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



