(*^

::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "NeXT Mathematica Notebook Front End Version 2.2";

	NeXTStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e8,  24, "Times"; ;
	fontset = subtitle, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e6,  18, "Times"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, L1, e6,  14, "Times"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, L1, a20,  18, "Times"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, L1, a15,  14, "Times"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, L1, a12,  12, "Times"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  10, "Times"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L1,  12, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L1,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L1,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L1,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287, L1,  12, "Courier"; ;
	fontset = name, inactive, noPageBreakInGroup, nohscroll, preserveAspect, M7, italic, B65535, L1,  10, "Times"; ;
	fontset = header, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, L1,  12, "Times"; ;
	fontset = leftheader,  12;
	fontset = footer, inactive, nohscroll, noKeepOnOnePage, preserveAspect, center, M7, italic, L1,  12, "Times"; ;
	fontset = leftfooter,  12;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Courier"; ;
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12;
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; preserveAspect; startGroup]
Three-dimensional Geometry
:[font = text; inactive; preserveAspect]
This notebook demonstrates some computations in three-dimensional geometry. 
The topic is described in more detail in the book:

	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.
:[font = section; inactive; preserveAspect; startGroup]
Initialize
:[font = subsection; inactive; preserveAspect; startGroup]
Set $Path
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
For Unix
:[font = input; preserveAspect; endGroup]
AppendTo[ $Path, "/usr/local/TWJ_Packages"];
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
For MS Windows
:[font = input; preserveAspect]
AppendTo[ $Path, "c:\\twjpacks"];
:[font = input; preserveAspect; endGroup]
Get[ "dosgraph.m"]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
For Macintosh
:[font = input; preserveAspect; endGroup; endGroup]
AppendTo[ $Path, "Macintosh HD:TWJ_Packages"];
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Load Packages
:[font = input; preserveAspect; endGroup]
Needs[ "ExtendGraphics`Geometry3D`"]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Turn off spelling checker
:[font = input; preserveAspect; endGroup; endGroup]
Off[ General::spell];
Off[ General::spell1];

:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Slicing up a Surface
:[font = text; inactive; preserveAspect]
A surface is made.
:[font = input; preserveAspect]
surf = 
  Graphics3D[Plot3D[Sin[x y],{x,-Pi,Pi},{y,-Pi,Pi},
                    PlotPoints -> 20]];
:[font = text; inactive; preserveAspect]
The surface is clipped by two horizontal planes.
:[font = input; preserveAspect]
Fold[Clip3D[#1, #2]&, surf, 
    {Plane[{0,0,0.5}, {0,0,-1}], 
     Plane[{0,0,-0.5},{0,0,1}]}];
:[font = text; inactive; preserveAspect]
The result is plotted.
:[font = input; preserveAspect; endGroup]
Show[%];
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Non-Convex Triangulation
:[font = text; inactive; preserveAspect]
These points for a non-convex set.
:[font = input; preserveAspect]
pts2d = 
  {{0,0},{1,-2},{1.5,-2},{4,4},{2.5,4},
  {1,0},{.5,1},{-.5,1},{-1,0},{-2.5,4},
  {-4,4},{-1.5,-2},{-1,-2}};
:[font = text; inactive; preserveAspect]
The two-dimensional plot.
:[font = input; preserveAspect]
Show[
  Graphics[Polygon[pts2d]], 
  AspectRatio -> Automatic]
:[font = text; inactive; preserveAspect]
The points are embedded in three-dimensional space.
:[font = input; preserveAspect]
pts =
  EmbedIn3D[pts2d, Plane[{0,0,0}, {1,-2,.2}], {0,1}];
:[font = text; inactive; preserveAspect]
The points can be plotted on a line.
:[font = input; preserveAspect]
Show[
  Graphics3D[Line[pts /. {a_, b__} -> {a,b,a}]]]
:[font = text; inactive; preserveAspect]
When a ploygon is made the result is strange.
:[font = input; preserveAspect]
Show[
  Graphics3D[Polygon[pts]]]
:[font = text; inactive; preserveAspect]
The non-convex outline can be generated.
:[font = input; preserveAspect]
NonConvexTriangulate[pts2d]
:[font = text; inactive; preserveAspect]
This can be plotted.
:[font = input; preserveAspect]
Show[
  Graphics[
    Map[Line[Part[pts2d, #] /. 
            {a_,b__} -> {a,b,a}]&, %]]]
:[font = text; inactive; preserveAspect]
The function, NonConvexPolygon, does everything, at once.
:[font = input; preserveAspect; endGroup]
Show[
  Graphics3D[NonConvexPolygon[Polygon[pts]]]]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Extrusion
:[font = text; inactive; preserveAspect]
A function to generate two-dimensional cog wheels.
:[font = input; preserveAspect]
Cog[r_, num_] :=
  Module[{ang, angi, ang1, ang2, 
          rf = 1.15, id = 0.4, od = 0.4},
    ang = N[2Pi/num] ;
    angi = ang*id ;
    ang1 = ang*(1+id-od)/2. ;
    ang2 = ang*(1+id+od)/2. ;
    pts =
      Table[{r { Cos[t], Sin[t]}, 
             r {Cos[t+angi],Sin[t+angi]},
             r rf { Cos[t+ang1], Sin[t+ang1]}, 
             r rf {Cos[t+ang2],Sin[t+ang2]}
             }, {t,0,2Pi-ang,ang}] ;
    Polygon[Flatten[pts, 1]]
    ]
:[font = text; inactive; preserveAspect]
An example cog.
:[font = input; preserveAspect]
cog = Cog[3, 15];

Show[
  Graphics[{GrayLevel[0.5], cog}],
  AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect]
The cog is put in three-dimensions.
:[font = input; preserveAspect]
cog3d = 
  cog /. 
    Polygon[pts_] :> 
        Polygon[Map[Append[#,0]&, pts]];
:[font = text; inactive; preserveAspect]
The three-dimensional outline is plotted.
:[font = input; preserveAspect]
Show[
  Graphics3D[NonConvexPolygon[cog3d]]]
:[font = text; inactive; preserveAspect]
The cog is extruded to form a solid object.
:[font = input; preserveAspect; endGroup; endGroup]
Show[
  Graphics3D[{EdgeForm[], Extrude[cog3d, 0.2]}]]
^*)
