#ifndef STACK_H__
#define STACK_H__

template<typename T>
class Stack
{
public:
  Stack() {
    m_data = new T[1000];
    m_size = 1000;
    m_top = 0;
  }
 
 Stack(int iSize) {
    m_data = new T[iSize];
    m_size = iSize;
    m_top = 0;
 }

  ~Stack() {delete[] m_data;}

  T pop() {
    return m_data[--m_top];
  }
  void push(T d)
  {
    m_data[m_top++] = d;
    if(m_top < m_size) return;
    expand();
  }
  int size() {return m_top;}
  int capacity() {return m_size;}
  

private:
  T* m_data;
  int m_top;
  int m_size;

  void expand() {
    T* newdata = new T[2*m_size];
    memcpy(newdata,m_data,sizeof(T)*m_size);
    delete[] m_data;
    m_data = newdata;
    m_size*=2;
  }
};




#endif
