//
// C++ Implementation: TransferListItemDelegate
//
// Description: 
//
//
// Author: Arsenij Vodjanov <arsenij@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "transferlistmodel.h"
#include "transferlistitemdelegate.h"
#include <QPainter>
#include <QFont>
#include <QRect>
#include <QStyleOptionViewItem>
#include <QModelIndex>
#include "log.h"

TransferListItemDelegate::TransferListItemDelegate( QObject *parent )
 : QItemDelegate( parent )
{
}


TransferListItemDelegate::~TransferListItemDelegate()
{
}


/*! Reimplemented from QItemDelegate */
QSize TransferListItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
{
	if ( index.column() != TransferListModel::COL_PROGRESS_BAR )
		return QItemDelegate::sizeHint(option, index);
	
	const QAbstractItemModel *model = index.model();
	if (model==0) {
		logger->warn("Warning: model==0 in TransferListItemDelegate::sizeHint()");
		return QSize(0,0);
	}
	QString text = "BLA 00:00:00 BLA"; // just some string for a size hint
	QVariant value = model->data(index, Qt::FontRole);
	QFont fnt = value.isValid() ? qvariant_cast<QFont>(value) : option.font;
	QFontMetrics fontMetrics(fnt);
	return QSize( fontMetrics.width(text), fontMetrics.lineSpacing()+2 ); // extra pixel at top and bottom
}



/*! Reimplemented from QItemDelegate */
void TransferListItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
	if ( index.column() != TransferListModel::COL_PROGRESS_BAR )
		return QItemDelegate::paint(painter, option, index);
	
	const QAbstractItemModel *model = index.model();
	if (model==0) {
		logger->warn("Warning: model==0 in TransferListItemDelegate::paint()");
		return;
	}

	// This is stupid.  Probably should have reimplemented some item view class instead.
	QList<QVariant> pdata = model->data(index, Qt::DisplayRole).toList();
	int secs = pdata.at( TransferListModel::PDATA_SECONDS_LEFT ).toInt();
	bool isDownload = pdata.at(TransferListModel::PDATA_IS_DOWNLOAD).toBool();
	qlonglong startPos = pdata.at( TransferListModel::PDATA_START_POS ).toLongLong();
	qlonglong pos = pdata.at( TransferListModel::PDATA_POS ).toLongLong();
	qlonglong actual = pdata.at( TransferListModel::PDATA_ACTUAL ).toLongLong();
	qlonglong fsize = pdata.at( TransferListModel::PDATA_SIZE ).toLongLong();
	
	QString text = QString("%1%  %2:%3:%4").arg((qlonglong)(pos*100/fsize)).arg( (qlonglong)(secs / (60*60))).arg( (qlonglong)(secs / 60)).arg( (qlonglong)(secs % 60));

	// Draw progressbar and text

	QStyleOptionViewItem opt = option;
	QRect rect = option.rect;
	QFont font = painter->font();
	QPen pen = painter->pen();
	QBrush brush = painter->brush();
	
    // set font
	QVariant value = model->data(index, Qt::FontRole);
	if (value.isValid())
		opt.font = qvariant_cast<QFont>(value);

    // set text alignment
	opt.displayAlignment = Qt::AlignCenter;

    // set text color
	value = model->data(index, Qt::TextColorRole);
	if (value.isValid() && qvariant_cast<QColor>(value).isValid())
		opt.palette.setColor(QPalette::Text, qvariant_cast<QColor>(value));

    // draw the background color
	QPalette::ColorGroup cg = opt.state & QStyle::State_Enabled ? QPalette::Normal : QPalette::Disabled;
	if (opt.showDecorationSelected && (option.state & QStyle::State_Selected)) {
		painter->fillRect(rect, opt.palette.brush(cg, QPalette::Highlight));
	} else {
		value = model->data(index, Qt::BackgroundColorRole);
		if (value.isValid() && qvariant_cast<QColor>(value).isValid())
			painter->fillRect(rect, qvariant_cast<QColor>(value));
	}

	// draw bar borders
	painter->setPen( opt.palette.color(cg, QPalette::Mid) );
	painter->drawRoundRect(rect.adjusted(2,2,-3,-3), 5,5);
	QRect barRect = rect.adjusted(4,4,-4,-4);
	// figure out rectangle positions for progress bar
	int x = barRect.x(), y = barRect.y(), height = barRect.height();
	qlonglong width = barRect.width();
	int x1 = x + startPos*width/fsize;
	int x2 = x + (pos-actual)*width/fsize;
	int x3 = x + pos*width/fsize;
	// draw progress bar in different color for upload and download... ugly if-statement.
	if (isDownload) {
		painter->fillRect( x, y, x1-x, height, QColor( 16,140,16 ) );
		painter->fillRect( x1, y, x2-x1, height, QColor( 16,180,16 ) );
		painter->fillRect( x2, y, x3-x2, height, QColor( 20,220,20 ) );
	} else {
		painter->fillRect( x, y, x1-x, height, QColor( 160,0,0 ) );
		painter->fillRect( x1, y, x2-x1, height, QColor( 190,10,10 ) );
		painter->fillRect( x2, y, x3-x2, height, QColor( 255,20,20 ) );
	}
	painter->fillRect( x3, y, (width-x3)+x+1, height, QColor( 220,220,245 ) );

	// draw text
	QRect textRect = rect.adjusted(1, 0, -1, -1); // remove width padding ( const int textMargin = 1 in qitemdelegate.cpp )
	QRect textShadowRect = textRect.adjusted(1,1,1,1);
	QColor textColor = QColor(220,220,220);
	painter->setFont(opt.font);
	painter->setPen( QColor( 255-textColor.red(), 255-textColor.green(), 255-textColor.blue() ) );
	if ((painter->fontMetrics().width(text)+1) > textRect.width()) {
		// inverted text color for shadow
		painter->drawText(textShadowRect, opt.displayAlignment,
						  elidedText(painter->fontMetrics(), textShadowRect.width(), // QAbstractItemDelegate::elidedText()
									 opt.textElideMode, text));
		painter->setPen(textColor);
		painter->drawText(textRect, opt.displayAlignment,
						  elidedText(painter->fontMetrics(), textRect.width(), // QAbstractItemDelegate::elidedText()
									 opt.textElideMode, text));
	} else {
		painter->drawText(textShadowRect, opt.displayAlignment, text);
		painter->setPen(textColor);
		painter->drawText(textRect, opt.displayAlignment, text);
	}
	
	painter->setFont(font);
	painter->setPen(pen);
	painter->setBrush(brush);
	
	drawFocus(painter, opt, textRect);
}

