//
// C++ Interface: UserListModel
//
// Description:
// Defines the UserList data model
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005.2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef USER_LIST_H__
#define USER_LIST_H__

#include <QAbstractTableModel>
#include <QHash>
#include <QIcon>
#include "user.h"

class UserListModel : public QAbstractTableModel
{
    Q_OBJECT
public:
    UserListModel() : QAbstractTableModel()
    {
        iconNormal = QIcon(":/images/user-normal.png");
        iconOp= QIcon(":/images/user-normal-op.png");
        iconDcpp= QIcon(":/images/user-dcpp.png");
        iconDcppOp= QIcon(":/images/user-dcpp-op.png");
        iconDcppPassive= QIcon(":/images/user-dcpp-passive.png");
        iconPassive= QIcon(":/images/user-passive.png");
        iconPassiveOp= QIcon(":/images/user-passive-op.png");
        iconDcppPassiveOp= QIcon(":/images/user-dcpp-passive-op.png");
        updateSignals = true;
    }
    ~UserListModel()
    {}

    // QAbstractTableModel methods...
    int rowCount ( const QModelIndex& ) const
    {
        //return userIndexMap.size();
        return users.size();
    }
    int columnCount ( const QModelIndex& ) const
    {
        return 3;        // Nick, share, description
    }
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
    QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

    User* getUser(const QModelIndex& i)
    {
        return users[i.row()];
    }

    void setUser(User*);
    User* getUser(int userId)
    {
        return userIdMap.value(userId);
    }
    void removeUser(int userId);
    void sort(int col,Qt::SortOrder order = Qt::AscendingOrder);

    //! Used to turn of emission of the layoutchanhed signal, default true.
    void enableUpdateSignals(bool yes)
    {
        updateSignals=yes;
    }

    void signalLayoutChanged()
    {
        emit layoutChanged();
    }

protected:
    bool updateSignals;
    QHash<int,User*> userIdMap;
    QList<User*> users;
    QIcon iconNormal,iconOp,iconDcpp,iconDcppOp,iconDcppPassive,iconPassive,iconPassiveOp,iconDcppPassiveOp;
};



#endif
