Contributing to JDT UI - Java development tools UI
============================================

Thanks for your interest in this project.

Project description:
--------------------

The JDT UI implements the user interface for the Java IDE. This includes views like Package Explorer and JUnit, the Java and properties files editors, Java search, and refactorings.
Website: <http://www.eclipse.org/jdt/ui/>

- <https://projects.eclipse.org/projects/eclipse.jdt.ui>

How to contribute:
--------------------
Contributions to JDT UI are most welcome. There are many ways to contribute, 
from entering high quality bug reports, to contributing code or documentation changes. 
For a complete guide, see the [How to Contribute] [1] page on the team wiki.

Developer resources:
--------------------

Information regarding source code management, builds, coding standards, and more.

- <https://projects.eclipse.org/projects/eclipse.jdt.ui/developer>

Contributor License Agreement:
------------------------------

Before your contribution can be accepted by the project, you need to create and electronically sign the Eclipse Foundation Contributor License Agreement (CLA).

- <http://www.eclipse.org/legal/CLA.php>

Forum:
------

Public forum for Eclipse JDT users.

- <http://www.eclipse.org/forums/eclipse.tools.jdt>

Search for bugs/issues:
----------------

This project uses Github issues to track ongoing development and issues.

- [https://github.com/eclipse-jdt/eclipse.jdt.ui/issues](https://github.com/eclipse-jdt/eclipse.jdt.ui/issues)

Create a new bug/issue:
-----------------

Be sure to search for existing issue before you create another one. Remember that contributions are always welcome!

- [https://github.com/eclipse-jdt/eclipse.jdt.ui/issues](https://github.com/eclipse-jdt/eclipse.jdt.ui/issues)

Contact:
--------

Contact the project developers via the project's "dev" list.

- <https://dev.eclipse.org/mailman/listinfo/jdt-dev>

License
-------

[Eclipse Public License (EPL) v2.0][2]

[1]: https://wiki.eclipse.org/JDT_UI/How_to_Contribute
[2]: http://wiki.eclipse.org/EPL
