/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.security;

import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.codehaus.xfire.util.Base64;

public class CryptoProxy
implements Crypto {
    private String keyFile;
    private String certFile;
    private X509Certificate cert;
    private PrivateKey privkey;

    public CryptoProxy(String key, String cert) {
        this.keyFile = key;
        this.certFile = cert;
    }

    public String[] getAliasesForDN(String arg0) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public String getAliasForX509Cert(byte[] arg0) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public String getAliasForX509Cert(Certificate arg0) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public String getAliasForX509Cert(String arg0, BigInteger arg1) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public String getAliasForX509Cert(String arg0) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public byte[] getCertificateData(boolean arg0, X509Certificate[] arg1) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public X509Certificate[] getCertificates(String arg0) throws WSSecurityException {
        X509Certificate cert = this.getCertByName();
        return new X509Certificate[]{cert};
    }

    public String getDefaultX509Alias() {
        throw new RuntimeException("Unimplemented");
    }

    public KeyStore getKeyStore() {
        throw new RuntimeException("Unimplemented");
    }

    public PrivateKey getPrivateKey(String alias, String password) {
        return this.getPrivateKeyByName();
    }

    public byte[] getSKIBytesFromCert(X509Certificate arg0) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public X509Certificate[] getX509Certificates(byte[] arg0, boolean arg1) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public X509Certificate loadCertificate(InputStream arg0) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public boolean validateCertPath(X509Certificate[] arg0) throws WSSecurityException {
        throw new WSSecurityException(0);
    }

    public String getAliasForX509CertThumb(byte[] bytes) throws WSSecurityException {
        throw new IllegalStateException("Not implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate getCertByName() {
        CertificateFactory factory;
        if (this.cert != null) throw new BadInputException(ErrorMessages.ErrorCode.NO_CREDENTIALS_PROVIDED, new String[0]);
        FileInputStream is = null;
        String certificateType = "X.509";
        try {
            factory = CertificateFactory.getInstance(certificateType);
        }
        catch (CertificateException e) {
            throw new InternalErrorException("Bad certificate definition: " + certificateType, e);
        }
        try {
            try {
                is = new FileInputStream(this.certFile);
                this.cert = (X509Certificate)factory.generateCertificate(is);
            }
            catch (FileNotFoundException e) {
                throw new BadInputException(ErrorMessages.ErrorCode.FILE_NOT_FOUND, this.certFile);
            }
            catch (CertificateException e) {
                throw new BadInputException(ErrorMessages.ErrorCode.BAD_X509_CERT_IN_FILE, this.certFile);
            }
            Object var6_7 = null;
            if (is == null) return this.cert;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        ((InputStream)is).close();
        return this.cert;
    }

    private PrivateKey getPrivateKeyByName() {
        if (this.privkey == null) {
            String algorithm = "RSA";
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.keyFile));
                StringBuffer keyBuf = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("-----BEGIN") || line.startsWith("-----END")) continue;
                    keyBuf.append(line);
                    keyBuf.append("\n");
                }
                br.close();
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)keyBuf.toString()));
                KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                this.privkey = keyFactory.generatePrivate(privKeySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new BadInputException(ErrorMessages.ErrorCode.BAD_PRIVATE_KEY_IN_FILE, this.keyFile);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalErrorException("Bad algorithm: " + algorithm, e);
            }
            catch (FileNotFoundException e) {
                throw new BadInputException(ErrorMessages.ErrorCode.FILE_NOT_FOUND, this.keyFile);
            }
            catch (IOException e) {
                throw new BadInputException(ErrorMessages.ErrorCode.BAD_PRIVATE_KEY_IN_FILE, this.keyFile);
            }
        } else {
            throw new BadInputException(ErrorMessages.ErrorCode.NO_CREDENTIALS_PROVIDED, new String[0]);
        }
        return this.privkey;
    }
}

