!{\src2tex{textfont=tt}}
!!****h* group_level/etsf_io
!! NAME
!!  etsf_io
!!
!! FUNCTION
!!  This module contains all information required by the ETSF/Nanoquanta
!!  file format specifications. See http://www.etsf.eu/fileformats for
!!  details.
!!
!!  It contains definitions of:
!!  * #ETSF_IO_CONSTANTS some constants defined by the specifications ;
!!  * #FLAGS_GROUPS & #FLAGS_MAIN, public flags to identify specific
!!    structures ;
!!  * the list of all dimensions declared in the specifications, see
!!    #etsf_dimensions.
!!  * several structures to store variable used in a same context, such as
!!    geometry informations, k points data...
!!  * a container (see #etsf_groups) to agregate all previous structures.
!!  * a container to store the main data (see #etsf_main).
!!
!! COPYRIGHT
!!  Copyright (C) 2006, 2007 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! NOTES
!!  This file has been automatically generated by the autogen_module
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!***
module etsf_io

  use etsf_io_low_level

  implicit none

  !!****d* etsf_io_basics_group/ETSF_IO_CONSTANTS
  !! NAME
  !!  ETSF_IO_CONSTANTS
  !!
  !! FUNCTION
  !!  These values are fixed by the specifications or are static values.
  !!   * etsf_spec_dimension = to be used in a count argument (see
  !!                           etsf_io_low_read_var() for instance) when
  !!                           one wants to read all the values of one
  !!                           dimension. For example count = (/ 1, etsf_spec_dimension /)
  !!                           will read one element from the first dimension and
  !!                           all for the second.
  !!   * etsf_no_sub_access = some variable can be accessed only for one index in a
  !!                          specific dimension (usually spin or k points). This
  !!                          value is used to tell the library to access all the values
  !!                          of that dimension.
  !!   * etsf_no_dimension = this value is given to a dimension. It means that
  !!                         the file does not contain that dimension.
  !!
  !! SOURCE
  ! Constants for internal dimensions
  integer, parameter :: etsf_charlen = 80
  integer, parameter :: etsf_histlen = 1024
  integer, parameter :: etsf_chemlen = 2
  integer, parameter :: etsf_2dimlen = 2
  integer, parameter :: etsf_3dimlen = 3
  integer, parameter :: etsf_spec_dimension = 0
  integer, parameter :: etsf_no_sub_access = 0
  integer, parameter :: etsf_no_dimension = 0

 ! Global attributes
 character(len=etsf_charlen),parameter :: etsf_file_format = &
  & "ETSF Nanoquanta"
 character(len=etsf_charlen),parameter :: etsf_conventions = &
  & "http://www.etsf.eu/fileformats"
 real,parameter :: etsf_file_format_version = 3.3
  !!***

  !!****s* etsf_io_basics_group/etsf_vars
  !! NAME
  !!  etsf_vars
  !!
  !! FUNCTION
  !!  This structure contains informations about a list of variables. It inherits
  !!  from etsf_io_low_var_infos type, but it adds new fields, specific to
  !!  the ETSF norm. These fields are:
  !!  * @group which is a value in FLAGS_GROUPS ;
  !!  * @varid which is a value in FLAGS_MAIN ;
  !!  * @split which defines if the variable is a split definition array.
  !!  This structure is intrinsectly an array for performance reasons since
  !!  variables are usually handled together. Use etsf_io_vars_free() to 
  !!  deallocate it.
  !!
  !! SOURCE
  type etsf_vars
    integer                              :: n_vars    =  0
    type(etsf_io_low_var_infos), pointer :: parent(:) => null()
    integer, pointer                     :: group(:)  => null()
    integer, pointer                     :: varid(:)  => null()
    logical, pointer                     :: split(:)  => null()
  end type etsf_vars
  !!***

  !!****d* etsf_io_basics_group/FLAGS_GROUPS
  !! NAME
  !!  FLAGS_GROUPS
  !!
  !! FUNCTION
  !!  These flags are used when indicating which groups must be used.
  !!  If several groups must be accessed, then, simply add the corresponding
  !!  flags. See etsf_io_data_write() or etsf_io_data_read() for usage.
  !!
  !! SOURCE


 ! Constants for groups of variables
 integer, parameter :: etsf_grp_none             = 0
 integer, parameter :: etsf_grp_geometry         = 1
 integer, parameter :: etsf_grp_electrons        = 2
 integer, parameter :: etsf_grp_kpoints          = 4
 integer, parameter :: etsf_grp_basisdata        = 8
 integer, parameter :: etsf_grp_gwdata           = 16
 integer, parameter :: etsf_grp_dielectric       = 32
 integer, parameter :: etsf_grp_main             = 64
 integer, parameter :: etsf_ngroups              = 7
  !!***

  !!****d* etsf_io_basics_group/FLAGS_VARIABLES
  !! NAME
  !!  FLAGS_VARIABLES
  !!
  !! FUNCTION
  !!  These flags are used on data definition (see etsf_io_data_init()) to specify
  !!  which variables should be defined in the NetCDF file. They are not exclusive.
  !!
  !! SOURCE


 ! 'geometry' variables
 integer, parameter :: etsf_geometry_none                 = 0
 integer, parameter :: etsf_geometry_space_group          = 1
 integer, parameter :: etsf_geometry_primitive_vectors    = 2
 integer, parameter :: etsf_geometry_red_sym_matrices     = 4
 integer, parameter :: etsf_geometry_red_sym_trans        = 8
 integer, parameter :: etsf_geometry_atom_species         = 16
 integer, parameter :: etsf_geometry_red_at_pos           = 32
 integer, parameter :: etsf_geometry_valence_charges      = 64
 integer, parameter :: etsf_geometry_atomic_numbers       = 128
 integer, parameter :: etsf_geometry_atom_species_names   = 256
 integer, parameter :: etsf_geometry_chemical_symbols     = 512
 integer, parameter :: etsf_geometry_pseudo_types         = 1024
 integer, parameter :: etsf_geometry_all                  = 2047
 integer, parameter :: etsf_geometry_nvars                = 11

 ! 'electrons' variables
 integer, parameter :: etsf_electrons_none                 = 0
 integer, parameter :: etsf_electrons_number_of_electrons  = 1
 integer, parameter :: etsf_electrons_x_functional         = 2
 integer, parameter :: etsf_electrons_c_functional         = 4
 integer, parameter :: etsf_electrons_fermi_energy         = 8
 integer, parameter :: etsf_electrons_smearing_scheme      = 16
 integer, parameter :: etsf_electrons_smearing_width       = 32
 integer, parameter :: etsf_electrons_number_of_states     = 64
 integer, parameter :: etsf_electrons_eigenvalues          = 128
 integer, parameter :: etsf_electrons_occupations          = 256
 integer, parameter :: etsf_electrons_all                  = 511
 integer, parameter :: etsf_electrons_nvars                = 9

 ! 'kpoints' variables
 integer, parameter :: etsf_kpoints_none                 = 0
 integer, parameter :: etsf_kpoints_kpoint_grid_shift    = 1
 integer, parameter :: etsf_kpoints_kpoint_grid_vectors  = 2
 integer, parameter :: etsf_kpoints_mp_folding           = 4
 integer, parameter :: etsf_kpoints_red_coord_kpt        = 8
 integer, parameter :: etsf_kpoints_kpoint_weights       = 16
 integer, parameter :: etsf_kpoints_all                  = 31
 integer, parameter :: etsf_kpoints_nvars                = 5

 ! 'basisdata' variables
 integer, parameter :: etsf_basisdata_none                 = 0
 integer, parameter :: etsf_basisdata_basis_set            = 1
 integer, parameter :: etsf_basisdata_kin_cutoff           = 2
 integer, parameter :: etsf_basisdata_n_coeff              = 4
 integer, parameter :: etsf_basisdata_red_coord_pw         = 8
 integer, parameter :: etsf_basisdata_coord_grid           = 16
 integer, parameter :: etsf_basisdata_n_coeff_grid         = 32
 integer, parameter :: etsf_basisdata_all                  = 63
 integer, parameter :: etsf_basisdata_nvars                = 6

 ! 'gwdata' variables
 integer, parameter :: etsf_gwdata_none                 = 0
 integer, parameter :: etsf_gwdata_gw_corrections       = 1
 integer, parameter :: etsf_gwdata_kb_coeff_sig         = 2
 integer, parameter :: etsf_gwdata_kb_coeff             = 4
 integer, parameter :: etsf_gwdata_kb_coeff_der         = 8
 integer, parameter :: etsf_gwdata_all                  = 15
 integer, parameter :: etsf_gwdata_nvars                = 4

 ! 'dielectric' variables
 integer, parameter :: etsf_dielectric_none                 = 0
 integer, parameter :: etsf_dielectric_frequencies          = 1
 integer, parameter :: etsf_dielectric_qpt                  = 2
 integer, parameter :: etsf_dielectric_qpt_g_lim            = 4
 integer, parameter :: etsf_dielectric_function             = 8
 integer, parameter :: etsf_dielectric_function_head        = 16
 integer, parameter :: etsf_dielectric_function_lower       = 32
 integer, parameter :: etsf_dielectric_function_upper       = 64
 integer, parameter :: etsf_dielectric_function_inv         = 128
 integer, parameter :: etsf_dielectric_function_inv_head    = 256
 integer, parameter :: etsf_dielectric_function_inv_lower   = 512
 integer, parameter :: etsf_dielectric_function_inv_upper   = 1024
 integer, parameter :: etsf_dielectric_polarizability       = 2048
 integer, parameter :: etsf_dielectric_pol_head             = 4096
 integer, parameter :: etsf_dielectric_pol_lower            = 8192
 integer, parameter :: etsf_dielectric_pol_upper            = 16384
 integer, parameter :: etsf_dielectric_polarizability_inv   = 32768
 integer, parameter :: etsf_dielectric_pol_inv_head         = 65536
 integer, parameter :: etsf_dielectric_pol_inv_lower        = 131072
 integer, parameter :: etsf_dielectric_pol_inv_upper        = 262144
 integer, parameter :: etsf_dielectric_all                  = 524287
 integer, parameter :: etsf_dielectric_nvars                = 19

 ! 'main' variables
 integer, parameter :: etsf_main_none                 = 0
 integer, parameter :: etsf_main_density              = 1
 integer, parameter :: etsf_main_pot_x_only           = 2
 integer, parameter :: etsf_main_pot_c_only           = 4
 integer, parameter :: etsf_main_pot_xc               = 8
 integer, parameter :: etsf_main_wfs_coeff            = 16
 integer, parameter :: etsf_main_wfs_rsp              = 32
 integer, parameter :: etsf_main_all                  = 63
 integer, parameter :: etsf_main_nvars                = 6
  !!***

  !!****d* etsf_io_basics_group/ETSF_IO_VALIDITY_FLAGS
  !! NAME
  !!  ETSF_IO_VALIDITY_FLAGS
  !!
  !! FUNCTION
  !!  These flags are used to identify a valid file as defined
  !!  in the specifications. These valid files contains physical informations such as
  !!  a potential or crystalographic data. Flags are not exclusive.
  !!
  !! SOURCE
  integer, parameter :: etsf_specs_none                     = 0
  integer, parameter :: etsf_dielectric_function_data       = 1
  integer, parameter :: etsf_wavefunctions_data             = 2
  integer, parameter :: etsf_scalar_field_data              = 4
  integer, parameter :: etsf_crystallographic_data          = 8
  integer, parameter :: etsf_nspecs_data                    = 4
  character(len = *), parameter :: etsf_specs_names(4) = (/ &
    & "dielectric_function_data ", &
    & "wavefunctions_data       ", &
    & "scalar_field_data        ", &
    & "crystallographic_data    " /)

  !!***

  !!****s* etsf_io_basics_group/etsf_dims
  !! NAME
  !!  etsf_dimensions
  !!
  !! FUNCTION
  !!  This structure is a container that stores all dimensions defined in the
  !!  specifications. An instance of this structure is required when a new
  !!  ETSF file is created.
  !!
  !! SOURCE


 ! Data type for dimensions
 type etsf_dims
  integer :: character_string_length = etsf_charlen
  integer :: complex = etsf_2dimlen
  integer :: max_number_of_angular_momenta = 1
  integer :: max_number_of_basis_grid_points = 1
  integer :: max_number_of_coefficients = 1
  integer :: max_number_of_projectors = 1
  integer :: max_number_of_states = 1
  integer :: number_of_atoms = 1
  integer :: number_of_atom_species = 1
  integer :: number_of_cartesian_directions = etsf_3dimlen
  integer :: number_of_coefficients_dielectric_function = 1
  integer :: number_of_components = 1
  integer :: number_of_frequencies_dielectric_function = 1
  integer :: number_of_grid_points_vector1 = 1
  integer :: number_of_grid_points_vector2 = 1
  integer :: number_of_grid_points_vector3 = 1
  integer :: number_of_kpoints = 1
  integer :: number_of_localization_regions = 1
  integer :: number_of_qpoints_dielectric_function = 1
  integer :: number_of_qpoints_gamma_limit = 1
  integer :: number_of_reduced_dimensions = etsf_3dimlen
  integer :: number_of_spinor_components = 1
  integer :: number_of_spins = 1
  integer :: number_of_symmetry_operations = 1
  integer :: number_of_vectors = etsf_3dimlen
  integer :: real_or_complex_coefficients = 1
  integer :: real_or_complex_density = 1
  integer :: real_or_complex_gw_corrections = 1
  integer :: real_or_complex_potential = 1
  integer :: real_or_complex_wavefunctions = 1
  integer :: symbol_length = etsf_chemlen

  !Dimensions for variables that can be splitted.
  integer :: my_max_number_of_coefficients = etsf_no_dimension
  integer :: my_max_number_of_states = etsf_no_dimension
  integer :: my_number_of_components = etsf_no_dimension
  integer :: my_number_of_grid_points_vect1 = etsf_no_dimension
  integer :: my_number_of_grid_points_vect2 = etsf_no_dimension
  integer :: my_number_of_grid_points_vect3 = etsf_no_dimension
  integer :: my_number_of_kpoints = etsf_no_dimension
  integer :: my_number_of_spins = etsf_no_dimension
 end type etsf_dims
  !!***


 !!****s* etsf_groups/etsf_geometry
 !! NAME
 !!  etsf_geometry
 !!
 !! FUNCTION
 !!  All variables from the specifications have been gathered into types called
 !!  groups. These groups can be gathered into a container called #etsf_groups.
 !!  This container is the main argument of the routines etsf_io_data_read()
 !!  and etsf_io_data_write().
 !!
 !! SOURCE


 ! Data type for geometry
 type etsf_geometry
  integer, pointer :: space_group => null()
  double precision, pointer :: primitive_vectors(:,:) => null()
  integer, pointer :: reduced_symmetry_matrices(:,:,:) => null()
  double precision, pointer :: reduced_symmetry_translations(:,:) => null()
  integer, pointer :: atom_species(:) => null()
  double precision, pointer :: reduced_atom_positions(:,:) => null()
  double precision, pointer :: valence_charges(:) => null()
  double precision, pointer :: atomic_numbers(:) => null()
  character(len=etsf_charlen), pointer :: atom_species_names(:) => null()
  character(len=etsf_chemlen), pointer :: chemical_symbols(:) => null()
  character(len=etsf_charlen), pointer :: pseudopotential_types(:) => null()
 end type etsf_geometry
 !!***
 !!****s* etsf_groups/etsf_electrons
 !! NAME
 !!  etsf_electrons
 !!
 !! FUNCTION
 !!  All variables from the specifications have been gathered into types called
 !!  groups. These groups can be gathered into a container called #etsf_groups.
 !!  This container is the main argument of the routines etsf_io_data_read()
 !!  and etsf_io_data_write().
 !!
 !! SOURCE


 ! Data type for electrons
 type etsf_electrons
  integer, pointer :: number_of_electrons => null()
  character(len=etsf_charlen), pointer :: exchange_functional => null()
  character(len=etsf_charlen), pointer :: correlation_functional => null()
  double precision, pointer :: fermi_energy => null()
  character(len=etsf_charlen), pointer :: smearing_scheme => null()
  double precision, pointer :: smearing_width => null()
  type(etsf_io_low_var_integer) :: number_of_states
  type(etsf_io_low_var_double) :: eigenvalues
  type(etsf_io_low_var_double) :: occupations

  ! Attributes
  ! Units attributes for variable fermi_energy
  character(len=etsf_charlen) :: fermi_energy__units = "atomic units"
  double precision :: fermi_energy__scale_to_atomic_units = 1.0d0
  ! Units attributes for variable smearing_width
  character(len=etsf_charlen) :: smearing_width__units = "atomic units"
  double precision :: smearing_width__scale_to_atomic_units = 1.0d0
  ! Units attributes for variable eigenvalues
  character(len=etsf_charlen) :: eigenvalues__units = "atomic units"
  double precision :: eigenvalues__scale_to_atomic_units = 1.0d0

  ! Specific dimensions (etsf_spec_dimension get the value
  !  of the max_number_of_something when the variable is get
  !  or put, change it to a lower value if less values are to
  !  be accessed).
  integer :: eigenvalues__number_of_states = etsf_spec_dimension
  integer :: eigenvalues__spin_access = etsf_no_sub_access
  integer :: eigenvalues__kpoint_access = etsf_no_sub_access
  integer :: eigenvalues__state_access = etsf_no_sub_access
  integer :: occupations__number_of_states = etsf_spec_dimension
  integer :: occupations__spin_access = etsf_no_sub_access
  integer :: occupations__kpoint_access = etsf_no_sub_access
  integer :: occupations__state_access = etsf_no_sub_access
 end type etsf_electrons
 !!***
 !!****s* etsf_groups/etsf_kpoints
 !! NAME
 !!  etsf_kpoints
 !!
 !! FUNCTION
 !!  All variables from the specifications have been gathered into types called
 !!  groups. These groups can be gathered into a container called #etsf_groups.
 !!  This container is the main argument of the routines etsf_io_data_read()
 !!  and etsf_io_data_write().
 !!
 !! SOURCE


 ! Data type for kpoints
 type etsf_kpoints
  double precision, pointer :: kpoint_grid_shift(:) => null()
  double precision, pointer :: kpoint_grid_vectors(:,:) => null()
  integer, pointer :: monkhorst_pack_folding(:) => null()
  double precision, pointer :: reduced_coordinates_of_kpoints(:,:) => null()
  double precision, pointer :: kpoint_weights(:) => null()
 end type etsf_kpoints
 !!***
 !!****s* etsf_groups/etsf_basisdata
 !! NAME
 !!  etsf_basisdata
 !!
 !! FUNCTION
 !!  All variables from the specifications have been gathered into types called
 !!  groups. These groups can be gathered into a container called #etsf_groups.
 !!  This container is the main argument of the routines etsf_io_data_read()
 !!  and etsf_io_data_write().
 !!
 !! SOURCE


 ! Data type for basisdata
 type etsf_basisdata
  character(len=etsf_charlen), pointer :: basis_set => null()
  double precision, pointer :: kinetic_energy_cutoff => null()
  integer, pointer :: number_of_coefficients(:) => null()
  type(etsf_io_low_var_integer) :: reduced_coordinates_of_plane_waves
  type(etsf_io_low_var_integer) :: coordinates_of_basis_grid_points
  type(etsf_io_low_var_integer) :: number_of_coefficients_per_grid_point

  ! Attributes
  ! Units attributes for variable kinetic_energy_cutoff
  character(len=etsf_charlen) :: kin_cutoff__units = "atomic units"
  double precision :: kin_cutoff__scale_to_atomic_units = 1.0d0

  ! Specific dimensions (etsf_spec_dimension get the value
  !  of the max_number_of_something when the variable is get
  !  or put, change it to a lower value if less values are to
  !  be accessed).
  integer :: red_coord_pw__number_of_coefficients = etsf_spec_dimension
  integer :: red_coord_pw__kpoint_access = etsf_no_sub_access
  integer :: coord_grid__number_of_basis_grid_points = etsf_spec_dimension
  integer :: n_coeff_grid__number_of_basis_grid_points = etsf_spec_dimension
 end type etsf_basisdata
 !!***
 !!****s* etsf_groups/etsf_gwdata
 !! NAME
 !!  etsf_gwdata
 !!
 !! FUNCTION
 !!  All variables from the specifications have been gathered into types called
 !!  groups. These groups can be gathered into a container called #etsf_groups.
 !!  This container is the main argument of the routines etsf_io_data_read()
 !!  and etsf_io_data_write().
 !!
 !! SOURCE


 ! Data type for gwdata
 type etsf_gwdata
  type(etsf_io_low_var_double) :: gw_corrections
  type(etsf_io_low_var_integer) :: kb_formfactor_sign
  type(etsf_io_low_var_double) :: kb_formfactors
  type(etsf_io_low_var_double) :: kb_formfactor_derivative

  ! Specific dimensions (etsf_spec_dimension get the value
  !  of the max_number_of_something when the variable is get
  !  or put, change it to a lower value if less values are to
  !  be accessed).
  integer :: gw_corrections__number_of_states = etsf_spec_dimension
  integer :: gw_corrections__spin_access = etsf_no_sub_access
  integer :: gw_corrections__kpoint_access = etsf_no_sub_access
  integer :: gw_corrections__state_access = etsf_no_sub_access
  integer :: kb_coeff_sig__number_of_angular_momenta = etsf_spec_dimension
  integer :: kb_coeff_sig__number_of_projectors = etsf_spec_dimension
  integer :: kb_coeff__number_of_angular_momenta = etsf_spec_dimension
  integer :: kb_coeff__number_of_projectors = etsf_spec_dimension
  integer :: kb_coeff__number_of_coefficients = etsf_spec_dimension
  integer :: kb_coeff__kpoint_access = etsf_no_sub_access
  integer :: kb_coeff_der__number_of_angular_momenta = etsf_spec_dimension
  integer :: kb_coeff_der__number_of_projectors = etsf_spec_dimension
  integer :: kb_coeff_der__number_of_coefficients = etsf_spec_dimension
  integer :: kb_coeff_der__kpoint_access = etsf_no_sub_access
 end type etsf_gwdata
 !!***
 !!****s* etsf_groups/etsf_dielectric
 !! NAME
 !!  etsf_dielectric
 !!
 !! FUNCTION
 !!  All variables from the specifications have been gathered into types called
 !!  groups. These groups can be gathered into a container called #etsf_groups.
 !!  This container is the main argument of the routines etsf_io_data_read()
 !!  and etsf_io_data_write().
 !!
 !! SOURCE


 ! Data type for dielectric
 type etsf_dielectric
  double precision, pointer :: frequencies_dielectric_function(:,:) => null()
  double precision, pointer :: qpoints_dielectric_function(:,:) => null()
  double precision, pointer :: qpoints_gamma_limit(:,:) => null()
  type(etsf_io_low_var_double) :: dielectric_function
  type(etsf_io_low_var_double) :: dielectric_function_head
  type(etsf_io_low_var_double) :: dielectric_function_lower_wing
  type(etsf_io_low_var_double) :: dielectric_function_upper_wing
  type(etsf_io_low_var_double) :: inverse_dielectric_function
  type(etsf_io_low_var_double) :: inverse_dielectric_function_head
  type(etsf_io_low_var_double) :: inverse_dielectric_function_lower_wing
  type(etsf_io_low_var_double) :: inverse_dielectric_function_upper_wing
  type(etsf_io_low_var_double) :: polarizability
  type(etsf_io_low_var_double) :: polarizability_head
  type(etsf_io_low_var_double) :: polarizability_lower_wing
  type(etsf_io_low_var_double) :: polarizability_upper_wing
  type(etsf_io_low_var_double) :: inverse_polarizability
  type(etsf_io_low_var_double) :: inverse_polarizability_head
  type(etsf_io_low_var_double) :: inverse_polarizability_lower_wing
  type(etsf_io_low_var_double) :: inverse_polarizability_upper_wing
 end type etsf_dielectric
 !!***
 !!****s* etsf_groups/etsf_main
 !! NAME
 !!  etsf_main
 !!
 !! FUNCTION
 !!  All variables from the specifications have been gathered into types called
 !!  groups. These groups can be gathered into a container called #etsf_groups.
 !!  This container is the main argument of the routines etsf_io_data_read()
 !!  and etsf_io_data_write().
 !!
 !! SOURCE


 ! Data type for main
 type etsf_main
  type(etsf_io_low_var_double) :: density
  type(etsf_io_low_var_double) :: exchange_potential
  type(etsf_io_low_var_double) :: correlation_potential
  type(etsf_io_low_var_double) :: exchange_correlation_potential
  type(etsf_io_low_var_double) :: coefficients_of_wavefunctions
  type(etsf_io_low_var_double) :: real_space_wavefunctions

  ! Attributes
  ! Units attributes for variable density
  character(len=etsf_charlen) :: density__units = "atomic units"
  double precision :: density__scale_to_atomic_units = 1.0d0
  ! Units attributes for variable exchange_potential
  character(len=etsf_charlen) :: pot_x_only__units = "atomic units"
  double precision :: pot_x_only__scale_to_atomic_units = 1.0d0
  ! Units attributes for variable correlation_potential
  character(len=etsf_charlen) :: pot_c_only__units = "atomic units"
  double precision :: pot_c_only__scale_to_atomic_units = 1.0d0
  ! Units attributes for variable exchange_correlation_potential
  character(len=etsf_charlen) :: pot_xc__units = "atomic units"
  double precision :: pot_xc__scale_to_atomic_units = 1.0d0

  ! Specific dimensions (etsf_spec_dimension get the value
  !  of the max_number_of_something when the variable is get
  !  or put, change it to a lower value if less values are to
  !  be accessed).
  integer :: wfs_coeff__number_of_states = etsf_spec_dimension
  integer :: wfs_coeff__number_of_coefficients = etsf_spec_dimension
  integer :: wfs_coeff__spin_access = etsf_no_sub_access
  integer :: wfs_coeff__kpoint_access = etsf_no_sub_access
  integer :: wfs_coeff__state_access = etsf_no_sub_access
  integer :: wfs_rsp__number_of_states = etsf_spec_dimension
  integer :: wfs_rsp__spin_access = etsf_no_sub_access
  integer :: wfs_rsp__kpoint_access = etsf_no_sub_access
  integer :: wfs_rsp__state_access = etsf_no_sub_access
 end type etsf_main
 !!***

  !!****s* etsf_io_basics_group/etsf_groups_flags
  !! NAME
  !!  etsf_groups_flags
  !!
  !! FUNCTION
  !!  This structure is a container for each group to specify which variables
  !!  are required (see etsf_io_data_init()).
  !!
  !! SOURCE


 ! Folder for the variable ids in each group
 type etsf_groups_flags
 integer :: geometry         = etsf_geometry_none
 integer :: electrons        = etsf_electrons_none
 integer :: kpoints          = etsf_kpoints_none
 integer :: basisdata        = etsf_basisdata_none
 integer :: gwdata           = etsf_gwdata_none
 integer :: dielectric       = etsf_dielectric_none
 integer :: main             = etsf_main_none
 end type etsf_groups_flags
  !!***

  !!****s* etsf_io/etsf_groups
  !! NAME
  !!  etsf_groups
  !!
  !! FUNCTION
  !!  This structure is a container for all available groups defined in the specifications.
  !!  To use this structure, create a group (instanciating a #etsf_basisdata or a
  !!  #etsf_geometry), and associate this group to its pointer:
  !!   type(etsf_geometry) :: geometry_data
  !!   type(etsf_groups)   :: my_groups
  !!   ... do something with geometry_data ...
  !!   my_groups%geometry => geometry_data
  !!   ... do something with my_groups ...
  !!  Several groups can be associated at a time in #etsf_groups.
  !!
  !! SOURCE


 ! Folder for the groups of variables
 type etsf_groups
  type(etsf_geometry), pointer :: geometry => null()
  type(etsf_electrons), pointer :: electrons => null()
  type(etsf_kpoints), pointer :: kpoints => null()
  type(etsf_basisdata), pointer :: basisdata => null()
  type(etsf_gwdata), pointer :: gwdata => null()
  type(etsf_dielectric), pointer :: dielectric => null()
  type(etsf_main), pointer :: main => null()
 end type etsf_groups
  !!***

  !!****s* etsf_io_basics_group/etsf_split
  !! FUNCTION
  !!  This group is used to store description array in the case of a splitted file.
  !!
  !! SOURCE
 type etsf_split
  integer, pointer :: my_kpoints(:) => null()
  integer, pointer :: my_grid_points_vector3(:) => null()
  integer, pointer :: my_spins(:) => null()
  integer, pointer :: my_grid_points_vector1(:) => null()
  integer, pointer :: my_grid_points_vector2(:) => null()
  integer, pointer :: my_coefficients(:) => null()
  integer, pointer :: my_components(:) => null()
  integer, pointer :: my_states(:) => null()
 end type etsf_split

  !!***

  ! Private group, use internally to get the name of dimensions
  ! that can be splitted.
 type split_dim_names
  character(len = 256) :: number_of_kpoints = "number_of_kpoints"
  character(len = 256) :: number_of_grid_points_vector3 = "number_of_grid_points_vector3"
  character(len = 256) :: number_of_spins = "number_of_spins"
  character(len = 256) :: number_of_grid_points_vector1 = "number_of_grid_points_vector1"
  character(len = 256) :: number_of_grid_points_vector2 = "number_of_grid_points_vector2"
  character(len = 256) :: max_number_of_coefficients = "max_number_of_coefficients"
  character(len = 256) :: number_of_components = "number_of_components"
  character(len = 256) :: max_number_of_states = "max_number_of_states"
 end type split_dim_names

  private :: split_dim_names

  !!****g* etsf_io/etsf_io_data_group
  !! FUNCTION
  !!  These are the most usefull routines of the library etsf_io. They are used
  !!  to read/write all or some selected variables of the ETSF specifications.
  !!
  !! SOURCE
  public :: etsf_groups
  public :: etsf_io_data_init
  public :: etsf_io_data_read
  public :: etsf_io_data_write
  !!***

  !!****g* etsf_io/etsf_io_basics_group
  !! FUNCTION
  !!  These are public parameters or types defined in the ETSF library.
  !!
  !! SOURCE
  public :: etsf_dims
  !!***

contains

  include "etsf_io_dims_def.f90"
  include "etsf_io_dims_get.f90"
  include "etsf_io_dims_merge.f90"
  include "etsf_io_dims_trace.f90"
  include "etsf_io_geometry_def.f90"
  include "etsf_io_electrons_def.f90"
  include "etsf_io_kpoints_def.f90"
  include "etsf_io_basisdata_def.f90"
  include "etsf_io_gwdata_def.f90"
  include "etsf_io_dielectric_def.f90"
  include "etsf_io_main_def.f90"
  include "etsf_io_geometry_get.f90"
  include "etsf_io_electrons_get.f90"
  include "etsf_io_kpoints_get.f90"
  include "etsf_io_basisdata_get.f90"
  include "etsf_io_gwdata_get.f90"
  include "etsf_io_dielectric_get.f90"
  include "etsf_io_main_get.f90"
  include "etsf_io_geometry_put.f90"
  include "etsf_io_electrons_put.f90"
  include "etsf_io_kpoints_put.f90"
  include "etsf_io_basisdata_put.f90"
  include "etsf_io_gwdata_put.f90"
  include "etsf_io_dielectric_put.f90"
  include "etsf_io_main_put.f90"
  include "etsf_io_geometry_copy.f90"
  include "etsf_io_electrons_copy.f90"
  include "etsf_io_kpoints_copy.f90"
  include "etsf_io_basisdata_copy.f90"
  include "etsf_io_gwdata_copy.f90"
  include "etsf_io_dielectric_copy.f90"
  include "etsf_io_main_copy.f90"
  include "etsf_io_split_init.f90"
  include "etsf_io_split_allocate.f90"
  include "etsf_io_split_free.f90"
  include "etsf_io_split_def.f90"
  include "etsf_io_split_get.f90"
  include "etsf_io_split_put.f90"
  include "etsf_io_split_copy.f90"
  include "etsf_io_split_merge.f90"
  include "etsf_io_vars_free.f90"
  include "etsf_io_data_init.f90"
  include "etsf_io_data_read.f90"
  include "etsf_io_data_write.f90"
  include "etsf_io_data_contents.f90"
  include "etsf_io_data_get.f90"
  include "etsf_io_data_copy.f90"


end module etsf_io
