// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file structuresTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "structuresTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "structures.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructShort_type_identifier(
        TypeIdentifierPair& type_ids_StructShort)
{

    ReturnCode_t return_code_StructShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructShort", type_ids_StructShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructShort)
    {
        StructTypeFlag struct_flags_StructShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructShort = "StructShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructShort;
        CompleteTypeDetail detail_StructShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructShort, ann_custom_StructShort, type_name_StructShort.to_string());
        CompleteStructHeader header_StructShort;
        header_StructShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructShort);
        CompleteStructMemberSeq member_seq_StructShort;
        {
            TypeIdentifierPair type_ids_var_short;
            ReturnCode_t return_code_var_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_short = 0x00000000;
            bool common_var_short_ec {false};
            CommonStructMember common_var_short {TypeObjectUtils::build_common_struct_member(member_id_var_short, member_flags_var_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_short, common_var_short_ec))};
            if (!common_var_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_short = "var_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_short;
            ann_custom_StructShort.reset();
            CompleteMemberDetail detail_var_short = TypeObjectUtils::build_complete_member_detail(name_var_short, member_ann_builtin_var_short, ann_custom_StructShort);
            CompleteStructMember member_var_short = TypeObjectUtils::build_complete_struct_member(common_var_short, detail_var_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructShort, member_var_short);
        }
        CompleteStructType struct_type_StructShort = TypeObjectUtils::build_complete_struct_type(struct_flags_StructShort, header_StructShort, member_seq_StructShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructShort, type_name_StructShort.to_string(), type_ids_StructShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructUnsignedShort_type_identifier(
        TypeIdentifierPair& type_ids_StructUnsignedShort)
{

    ReturnCode_t return_code_StructUnsignedShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructUnsignedShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructUnsignedShort", type_ids_StructUnsignedShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructUnsignedShort)
    {
        StructTypeFlag struct_flags_StructUnsignedShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructUnsignedShort = "StructUnsignedShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructUnsignedShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructUnsignedShort;
        CompleteTypeDetail detail_StructUnsignedShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructUnsignedShort, ann_custom_StructUnsignedShort, type_name_StructUnsignedShort.to_string());
        CompleteStructHeader header_StructUnsignedShort;
        header_StructUnsignedShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructUnsignedShort);
        CompleteStructMemberSeq member_seq_StructUnsignedShort;
        {
            TypeIdentifierPair type_ids_var_ushort;
            ReturnCode_t return_code_var_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ushort = 0x00000000;
            bool common_var_ushort_ec {false};
            CommonStructMember common_var_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_ushort, member_flags_var_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ushort, common_var_ushort_ec))};
            if (!common_var_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ushort = "var_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ushort;
            ann_custom_StructUnsignedShort.reset();
            CompleteMemberDetail detail_var_ushort = TypeObjectUtils::build_complete_member_detail(name_var_ushort, member_ann_builtin_var_ushort, ann_custom_StructUnsignedShort);
            CompleteStructMember member_var_ushort = TypeObjectUtils::build_complete_struct_member(common_var_ushort, detail_var_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructUnsignedShort, member_var_ushort);
        }
        CompleteStructType struct_type_StructUnsignedShort = TypeObjectUtils::build_complete_struct_type(struct_flags_StructUnsignedShort, header_StructUnsignedShort, member_seq_StructUnsignedShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructUnsignedShort, type_name_StructUnsignedShort.to_string(), type_ids_StructUnsignedShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructUnsignedShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructLong_type_identifier(
        TypeIdentifierPair& type_ids_StructLong)
{

    ReturnCode_t return_code_StructLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructLong", type_ids_StructLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructLong)
    {
        StructTypeFlag struct_flags_StructLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructLong = "StructLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructLong;
        CompleteTypeDetail detail_StructLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructLong, ann_custom_StructLong, type_name_StructLong.to_string());
        CompleteStructHeader header_StructLong;
        header_StructLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructLong);
        CompleteStructMemberSeq member_seq_StructLong;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000000;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_StructLong.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_StructLong);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructLong, member_var_long);
        }
        CompleteStructType struct_type_StructLong = TypeObjectUtils::build_complete_struct_type(struct_flags_StructLong, header_StructLong, member_seq_StructLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructLong, type_name_StructLong.to_string(), type_ids_StructLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructUnsignedLong_type_identifier(
        TypeIdentifierPair& type_ids_StructUnsignedLong)
{

    ReturnCode_t return_code_StructUnsignedLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructUnsignedLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructUnsignedLong", type_ids_StructUnsignedLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructUnsignedLong)
    {
        StructTypeFlag struct_flags_StructUnsignedLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructUnsignedLong = "StructUnsignedLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructUnsignedLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructUnsignedLong;
        CompleteTypeDetail detail_StructUnsignedLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructUnsignedLong, ann_custom_StructUnsignedLong, type_name_StructUnsignedLong.to_string());
        CompleteStructHeader header_StructUnsignedLong;
        header_StructUnsignedLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructUnsignedLong);
        CompleteStructMemberSeq member_seq_StructUnsignedLong;
        {
            TypeIdentifierPair type_ids_var_ulong;
            ReturnCode_t return_code_var_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulong = 0x00000000;
            bool common_var_ulong_ec {false};
            CommonStructMember common_var_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_ulong, member_flags_var_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulong, common_var_ulong_ec))};
            if (!common_var_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulong = "var_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulong;
            ann_custom_StructUnsignedLong.reset();
            CompleteMemberDetail detail_var_ulong = TypeObjectUtils::build_complete_member_detail(name_var_ulong, member_ann_builtin_var_ulong, ann_custom_StructUnsignedLong);
            CompleteStructMember member_var_ulong = TypeObjectUtils::build_complete_struct_member(common_var_ulong, detail_var_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructUnsignedLong, member_var_ulong);
        }
        CompleteStructType struct_type_StructUnsignedLong = TypeObjectUtils::build_complete_struct_type(struct_flags_StructUnsignedLong, header_StructUnsignedLong, member_seq_StructUnsignedLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructUnsignedLong, type_name_StructUnsignedLong.to_string(), type_ids_StructUnsignedLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructUnsignedLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructLongLong_type_identifier(
        TypeIdentifierPair& type_ids_StructLongLong)
{

    ReturnCode_t return_code_StructLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructLongLong", type_ids_StructLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructLongLong)
    {
        StructTypeFlag struct_flags_StructLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructLongLong = "StructLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructLongLong;
        CompleteTypeDetail detail_StructLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructLongLong, ann_custom_StructLongLong, type_name_StructLongLong.to_string());
        CompleteStructHeader header_StructLongLong;
        header_StructLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructLongLong);
        CompleteStructMemberSeq member_seq_StructLongLong;
        {
            TypeIdentifierPair type_ids_var_longlong;
            ReturnCode_t return_code_var_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longlong = 0x00000000;
            bool common_var_longlong_ec {false};
            CommonStructMember common_var_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_longlong, member_flags_var_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longlong, common_var_longlong_ec))};
            if (!common_var_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longlong = "var_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longlong;
            ann_custom_StructLongLong.reset();
            CompleteMemberDetail detail_var_longlong = TypeObjectUtils::build_complete_member_detail(name_var_longlong, member_ann_builtin_var_longlong, ann_custom_StructLongLong);
            CompleteStructMember member_var_longlong = TypeObjectUtils::build_complete_struct_member(common_var_longlong, detail_var_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructLongLong, member_var_longlong);
        }
        CompleteStructType struct_type_StructLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_StructLongLong, header_StructLongLong, member_seq_StructLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructLongLong, type_name_StructLongLong.to_string(), type_ids_StructLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructUnsignedLongLong_type_identifier(
        TypeIdentifierPair& type_ids_StructUnsignedLongLong)
{

    ReturnCode_t return_code_StructUnsignedLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructUnsignedLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructUnsignedLongLong", type_ids_StructUnsignedLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructUnsignedLongLong)
    {
        StructTypeFlag struct_flags_StructUnsignedLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructUnsignedLongLong = "StructUnsignedLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructUnsignedLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructUnsignedLongLong;
        CompleteTypeDetail detail_StructUnsignedLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructUnsignedLongLong, ann_custom_StructUnsignedLongLong, type_name_StructUnsignedLongLong.to_string());
        CompleteStructHeader header_StructUnsignedLongLong;
        header_StructUnsignedLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructUnsignedLongLong);
        CompleteStructMemberSeq member_seq_StructUnsignedLongLong;
        {
            TypeIdentifierPair type_ids_var_ulonglong;
            ReturnCode_t return_code_var_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulonglong = 0x00000000;
            bool common_var_ulonglong_ec {false};
            CommonStructMember common_var_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_ulonglong, member_flags_var_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulonglong, common_var_ulonglong_ec))};
            if (!common_var_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulonglong = "var_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulonglong;
            ann_custom_StructUnsignedLongLong.reset();
            CompleteMemberDetail detail_var_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_ulonglong, member_ann_builtin_var_ulonglong, ann_custom_StructUnsignedLongLong);
            CompleteStructMember member_var_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_ulonglong, detail_var_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructUnsignedLongLong, member_var_ulonglong);
        }
        CompleteStructType struct_type_StructUnsignedLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_StructUnsignedLongLong, header_StructUnsignedLongLong, member_seq_StructUnsignedLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructUnsignedLongLong, type_name_StructUnsignedLongLong.to_string(), type_ids_StructUnsignedLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructUnsignedLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructFloat_type_identifier(
        TypeIdentifierPair& type_ids_StructFloat)
{

    ReturnCode_t return_code_StructFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructFloat", type_ids_StructFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructFloat)
    {
        StructTypeFlag struct_flags_StructFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructFloat = "StructFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructFloat;
        CompleteTypeDetail detail_StructFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructFloat, ann_custom_StructFloat, type_name_StructFloat.to_string());
        CompleteStructHeader header_StructFloat;
        header_StructFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructFloat);
        CompleteStructMemberSeq member_seq_StructFloat;
        {
            TypeIdentifierPair type_ids_var_float;
            ReturnCode_t return_code_var_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_var_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_float = 0x00000000;
            bool common_var_float_ec {false};
            CommonStructMember common_var_float {TypeObjectUtils::build_common_struct_member(member_id_var_float, member_flags_var_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_float, common_var_float_ec))};
            if (!common_var_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_float = "var_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_float;
            ann_custom_StructFloat.reset();
            CompleteMemberDetail detail_var_float = TypeObjectUtils::build_complete_member_detail(name_var_float, member_ann_builtin_var_float, ann_custom_StructFloat);
            CompleteStructMember member_var_float = TypeObjectUtils::build_complete_struct_member(common_var_float, detail_var_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructFloat, member_var_float);
        }
        CompleteStructType struct_type_StructFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_StructFloat, header_StructFloat, member_seq_StructFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructFloat, type_name_StructFloat.to_string(), type_ids_StructFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructDouble_type_identifier(
        TypeIdentifierPair& type_ids_StructDouble)
{

    ReturnCode_t return_code_StructDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructDouble", type_ids_StructDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructDouble)
    {
        StructTypeFlag struct_flags_StructDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructDouble = "StructDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructDouble;
        CompleteTypeDetail detail_StructDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructDouble, ann_custom_StructDouble, type_name_StructDouble.to_string());
        CompleteStructHeader header_StructDouble;
        header_StructDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructDouble);
        CompleteStructMemberSeq member_seq_StructDouble;
        {
            TypeIdentifierPair type_ids_var_double;
            ReturnCode_t return_code_var_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_var_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_double = 0x00000000;
            bool common_var_double_ec {false};
            CommonStructMember common_var_double {TypeObjectUtils::build_common_struct_member(member_id_var_double, member_flags_var_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_double, common_var_double_ec))};
            if (!common_var_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_double = "var_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_double;
            ann_custom_StructDouble.reset();
            CompleteMemberDetail detail_var_double = TypeObjectUtils::build_complete_member_detail(name_var_double, member_ann_builtin_var_double, ann_custom_StructDouble);
            CompleteStructMember member_var_double = TypeObjectUtils::build_complete_struct_member(common_var_double, detail_var_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructDouble, member_var_double);
        }
        CompleteStructType struct_type_StructDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_StructDouble, header_StructDouble, member_seq_StructDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructDouble, type_name_StructDouble.to_string(), type_ids_StructDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_StructLongDouble)
{

    ReturnCode_t return_code_StructLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructLongDouble", type_ids_StructLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructLongDouble)
    {
        StructTypeFlag struct_flags_StructLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructLongDouble = "StructLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructLongDouble;
        CompleteTypeDetail detail_StructLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructLongDouble, ann_custom_StructLongDouble, type_name_StructLongDouble.to_string());
        CompleteStructHeader header_StructLongDouble;
        header_StructLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructLongDouble);
        CompleteStructMemberSeq member_seq_StructLongDouble;
        {
            TypeIdentifierPair type_ids_var_longdouble;
            ReturnCode_t return_code_var_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_var_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longdouble = 0x00000000;
            bool common_var_longdouble_ec {false};
            CommonStructMember common_var_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_longdouble, member_flags_var_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longdouble, common_var_longdouble_ec))};
            if (!common_var_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longdouble = "var_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longdouble;
            ann_custom_StructLongDouble.reset();
            CompleteMemberDetail detail_var_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_longdouble, member_ann_builtin_var_longdouble, ann_custom_StructLongDouble);
            CompleteStructMember member_var_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_longdouble, detail_var_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructLongDouble, member_var_longdouble);
        }
        CompleteStructType struct_type_StructLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_StructLongDouble, header_StructLongDouble, member_seq_StructLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructLongDouble, type_name_StructLongDouble.to_string(), type_ids_StructLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructBoolean_type_identifier(
        TypeIdentifierPair& type_ids_StructBoolean)
{

    ReturnCode_t return_code_StructBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructBoolean", type_ids_StructBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructBoolean)
    {
        StructTypeFlag struct_flags_StructBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructBoolean = "StructBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructBoolean;
        CompleteTypeDetail detail_StructBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructBoolean, ann_custom_StructBoolean, type_name_StructBoolean.to_string());
        CompleteStructHeader header_StructBoolean;
        header_StructBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructBoolean);
        CompleteStructMemberSeq member_seq_StructBoolean;
        {
            TypeIdentifierPair type_ids_var_boolean;
            ReturnCode_t return_code_var_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_var_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_boolean = 0x00000000;
            bool common_var_boolean_ec {false};
            CommonStructMember common_var_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_boolean, member_flags_var_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_boolean, common_var_boolean_ec))};
            if (!common_var_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_boolean = "var_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_boolean;
            ann_custom_StructBoolean.reset();
            CompleteMemberDetail detail_var_boolean = TypeObjectUtils::build_complete_member_detail(name_var_boolean, member_ann_builtin_var_boolean, ann_custom_StructBoolean);
            CompleteStructMember member_var_boolean = TypeObjectUtils::build_complete_struct_member(common_var_boolean, detail_var_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructBoolean, member_var_boolean);
        }
        CompleteStructType struct_type_StructBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_StructBoolean, header_StructBoolean, member_seq_StructBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructBoolean, type_name_StructBoolean.to_string(), type_ids_StructBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructOctet_type_identifier(
        TypeIdentifierPair& type_ids_StructOctet)
{

    ReturnCode_t return_code_StructOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructOctet", type_ids_StructOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructOctet)
    {
        StructTypeFlag struct_flags_StructOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructOctet = "StructOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructOctet;
        CompleteTypeDetail detail_StructOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructOctet, ann_custom_StructOctet, type_name_StructOctet.to_string());
        CompleteStructHeader header_StructOctet;
        header_StructOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructOctet);
        CompleteStructMemberSeq member_seq_StructOctet;
        {
            TypeIdentifierPair type_ids_var_octet;
            ReturnCode_t return_code_var_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_var_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_octet = 0x00000000;
            bool common_var_octet_ec {false};
            CommonStructMember common_var_octet {TypeObjectUtils::build_common_struct_member(member_id_var_octet, member_flags_var_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_octet, common_var_octet_ec))};
            if (!common_var_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_octet = "var_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_octet;
            ann_custom_StructOctet.reset();
            CompleteMemberDetail detail_var_octet = TypeObjectUtils::build_complete_member_detail(name_var_octet, member_ann_builtin_var_octet, ann_custom_StructOctet);
            CompleteStructMember member_var_octet = TypeObjectUtils::build_complete_struct_member(common_var_octet, detail_var_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructOctet, member_var_octet);
        }
        CompleteStructType struct_type_StructOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_StructOctet, header_StructOctet, member_seq_StructOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructOctet, type_name_StructOctet.to_string(), type_ids_StructOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructChar8_type_identifier(
        TypeIdentifierPair& type_ids_StructChar8)
{

    ReturnCode_t return_code_StructChar8 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructChar8 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructChar8", type_ids_StructChar8);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructChar8)
    {
        StructTypeFlag struct_flags_StructChar8 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructChar8 = "StructChar8";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructChar8;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructChar8;
        CompleteTypeDetail detail_StructChar8 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructChar8, ann_custom_StructChar8, type_name_StructChar8.to_string());
        CompleteStructHeader header_StructChar8;
        header_StructChar8 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructChar8);
        CompleteStructMemberSeq member_seq_StructChar8;
        {
            TypeIdentifierPair type_ids_var_char8;
            ReturnCode_t return_code_var_char8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char8 = 0x00000000;
            bool common_var_char8_ec {false};
            CommonStructMember common_var_char8 {TypeObjectUtils::build_common_struct_member(member_id_var_char8, member_flags_var_char8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char8, common_var_char8_ec))};
            if (!common_var_char8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char8 = "var_char8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char8;
            ann_custom_StructChar8.reset();
            CompleteMemberDetail detail_var_char8 = TypeObjectUtils::build_complete_member_detail(name_var_char8, member_ann_builtin_var_char8, ann_custom_StructChar8);
            CompleteStructMember member_var_char8 = TypeObjectUtils::build_complete_struct_member(common_var_char8, detail_var_char8);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructChar8, member_var_char8);
        }
        CompleteStructType struct_type_StructChar8 = TypeObjectUtils::build_complete_struct_type(struct_flags_StructChar8, header_StructChar8, member_seq_StructChar8);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructChar8, type_name_StructChar8.to_string(), type_ids_StructChar8))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructChar8 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructChar16_type_identifier(
        TypeIdentifierPair& type_ids_StructChar16)
{

    ReturnCode_t return_code_StructChar16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructChar16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructChar16", type_ids_StructChar16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructChar16)
    {
        StructTypeFlag struct_flags_StructChar16 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructChar16 = "StructChar16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructChar16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructChar16;
        CompleteTypeDetail detail_StructChar16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructChar16, ann_custom_StructChar16, type_name_StructChar16.to_string());
        CompleteStructHeader header_StructChar16;
        header_StructChar16 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructChar16);
        CompleteStructMemberSeq member_seq_StructChar16;
        {
            TypeIdentifierPair type_ids_var_char16;
            ReturnCode_t return_code_var_char16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_var_char16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char16 = 0x00000000;
            bool common_var_char16_ec {false};
            CommonStructMember common_var_char16 {TypeObjectUtils::build_common_struct_member(member_id_var_char16, member_flags_var_char16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char16, common_var_char16_ec))};
            if (!common_var_char16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char16 = "var_char16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char16;
            ann_custom_StructChar16.reset();
            CompleteMemberDetail detail_var_char16 = TypeObjectUtils::build_complete_member_detail(name_var_char16, member_ann_builtin_var_char16, ann_custom_StructChar16);
            CompleteStructMember member_var_char16 = TypeObjectUtils::build_complete_struct_member(common_var_char16, detail_var_char16);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructChar16, member_var_char16);
        }
        CompleteStructType struct_type_StructChar16 = TypeObjectUtils::build_complete_struct_type(struct_flags_StructChar16, header_StructChar16, member_seq_StructChar16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructChar16, type_name_StructChar16.to_string(), type_ids_StructChar16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructChar16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructString_type_identifier(
        TypeIdentifierPair& type_ids_StructString)
{

    ReturnCode_t return_code_StructString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructString", type_ids_StructString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructString)
    {
        StructTypeFlag struct_flags_StructString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructString = "StructString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructString;
        CompleteTypeDetail detail_StructString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructString, ann_custom_StructString, type_name_StructString.to_string());
        CompleteStructHeader header_StructString;
        header_StructString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructString);
        CompleteStructMemberSeq member_seq_StructString;
        {
            TypeIdentifierPair type_ids_var_string;
            ReturnCode_t return_code_var_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_string = 0x00000000;
            bool common_var_string_ec {false};
            CommonStructMember common_var_string {TypeObjectUtils::build_common_struct_member(member_id_var_string, member_flags_var_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_string, common_var_string_ec))};
            if (!common_var_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_string = "var_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_string;
            ann_custom_StructString.reset();
            CompleteMemberDetail detail_var_string = TypeObjectUtils::build_complete_member_detail(name_var_string, member_ann_builtin_var_string, ann_custom_StructString);
            CompleteStructMember member_var_string = TypeObjectUtils::build_complete_struct_member(common_var_string, detail_var_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructString, member_var_string);
        }
        CompleteStructType struct_type_StructString = TypeObjectUtils::build_complete_struct_type(struct_flags_StructString, header_StructString, member_seq_StructString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructString, type_name_StructString.to_string(), type_ids_StructString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructString already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructWString_type_identifier(
        TypeIdentifierPair& type_ids_StructWString)
{

    ReturnCode_t return_code_StructWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructWString", type_ids_StructWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructWString)
    {
        StructTypeFlag struct_flags_StructWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructWString = "StructWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructWString;
        CompleteTypeDetail detail_StructWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructWString, ann_custom_StructWString, type_name_StructWString.to_string());
        CompleteStructHeader header_StructWString;
        header_StructWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructWString);
        CompleteStructMemberSeq member_seq_StructWString;
        {
            TypeIdentifierPair type_ids_var_wstring;
            ReturnCode_t return_code_var_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_unbounded", type_ids_var_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_wstring)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_wstring_unbounded", type_ids_var_wstring, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_wstring = 0x00000000;
            bool common_var_wstring_ec {false};
            CommonStructMember common_var_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_wstring, member_flags_var_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_wstring, common_var_wstring_ec))};
            if (!common_var_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_wstring = "var_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_wstring;
            ann_custom_StructWString.reset();
            CompleteMemberDetail detail_var_wstring = TypeObjectUtils::build_complete_member_detail(name_var_wstring, member_ann_builtin_var_wstring, ann_custom_StructWString);
            CompleteStructMember member_var_wstring = TypeObjectUtils::build_complete_struct_member(common_var_wstring, detail_var_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructWString, member_var_wstring);
        }
        CompleteStructType struct_type_StructWString = TypeObjectUtils::build_complete_struct_type(struct_flags_StructWString, header_StructWString, member_seq_StructWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructWString, type_name_StructWString.to_string(), type_ids_StructWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructBoundedString_type_identifier(
        TypeIdentifierPair& type_ids_StructBoundedString)
{

    ReturnCode_t return_code_StructBoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructBoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructBoundedString", type_ids_StructBoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructBoundedString)
    {
        StructTypeFlag struct_flags_StructBoundedString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructBoundedString = "StructBoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructBoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructBoundedString;
        CompleteTypeDetail detail_StructBoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructBoundedString, ann_custom_StructBoundedString, type_name_StructBoundedString.to_string());
        CompleteStructHeader header_StructBoundedString;
        header_StructBoundedString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructBoundedString);
        CompleteStructMemberSeq member_seq_StructBoundedString;
        {
            TypeIdentifierPair type_ids_var_bounded_string;
            ReturnCode_t return_code_var_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_bounded_string_helper", type_ids_var_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_bounded_string)
            {
            ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_bounded_string);
            }
            StructMemberFlag member_flags_var_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_bounded_string = 0x00000000;
            bool common_var_bounded_string_ec {false};
            CommonStructMember common_var_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_var_bounded_string, member_flags_var_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_bounded_string, common_var_bounded_string_ec))};
            if (!common_var_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_bounded_string = "var_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_bounded_string;
            ann_custom_StructBoundedString.reset();
            CompleteMemberDetail detail_var_bounded_string = TypeObjectUtils::build_complete_member_detail(name_var_bounded_string, member_ann_builtin_var_bounded_string, ann_custom_StructBoundedString);
            CompleteStructMember member_var_bounded_string = TypeObjectUtils::build_complete_struct_member(common_var_bounded_string, detail_var_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructBoundedString, member_var_bounded_string);
        }
        CompleteStructType struct_type_StructBoundedString = TypeObjectUtils::build_complete_struct_type(struct_flags_StructBoundedString, header_StructBoundedString, member_seq_StructBoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructBoundedString, type_name_StructBoundedString.to_string(), type_ids_StructBoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructBoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructBoundedWString_type_identifier(
        TypeIdentifierPair& type_ids_StructBoundedWString)
{

    ReturnCode_t return_code_StructBoundedWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructBoundedWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructBoundedWString", type_ids_StructBoundedWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructBoundedWString)
    {
        StructTypeFlag struct_flags_StructBoundedWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructBoundedWString = "StructBoundedWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructBoundedWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructBoundedWString;
        CompleteTypeDetail detail_StructBoundedWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructBoundedWString, ann_custom_StructBoundedWString, type_name_StructBoundedWString.to_string());
        CompleteStructHeader header_StructBoundedWString;
        header_StructBoundedWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructBoundedWString);
        CompleteStructMemberSeq member_seq_StructBoundedWString;
        {
            TypeIdentifierPair type_ids_var_bounded_wstring;
            ReturnCode_t return_code_var_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_bounded_wstring_helper", type_ids_var_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_bounded_wstring)
            {
            ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_bounded_wstring);
            }
            StructMemberFlag member_flags_var_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_bounded_wstring = 0x00000000;
            bool common_var_bounded_wstring_ec {false};
            CommonStructMember common_var_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_bounded_wstring, member_flags_var_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_bounded_wstring, common_var_bounded_wstring_ec))};
            if (!common_var_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_bounded_wstring = "var_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_bounded_wstring;
            ann_custom_StructBoundedWString.reset();
            CompleteMemberDetail detail_var_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_var_bounded_wstring, member_ann_builtin_var_bounded_wstring, ann_custom_StructBoundedWString);
            CompleteStructMember member_var_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_var_bounded_wstring, detail_var_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructBoundedWString, member_var_bounded_wstring);
        }
        CompleteStructType struct_type_StructBoundedWString = TypeObjectUtils::build_complete_struct_type(struct_flags_StructBoundedWString, header_StructBoundedWString, member_seq_StructBoundedWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructBoundedWString, type_name_StructBoundedWString.to_string(), type_ids_StructBoundedWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructBoundedWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructEnum_type_identifier(
        TypeIdentifierPair& type_ids_StructEnum)
{

    ReturnCode_t return_code_StructEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructEnum", type_ids_StructEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructEnum)
    {
        StructTypeFlag struct_flags_StructEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructEnum = "StructEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructEnum;
        CompleteTypeDetail detail_StructEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructEnum, ann_custom_StructEnum, type_name_StructEnum.to_string());
        CompleteStructHeader header_StructEnum;
        header_StructEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructEnum);
        CompleteStructMemberSeq member_seq_StructEnum;
        {
            TypeIdentifierPair type_ids_var_enum;
            ReturnCode_t return_code_var_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerEnumHelper", type_ids_var_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_enum)
            {
            ::register_InnerEnumHelper_type_identifier(type_ids_var_enum);
            }
            StructMemberFlag member_flags_var_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_enum = 0x00000000;
            bool common_var_enum_ec {false};
            CommonStructMember common_var_enum {TypeObjectUtils::build_common_struct_member(member_id_var_enum, member_flags_var_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_enum, common_var_enum_ec))};
            if (!common_var_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_enum = "var_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_enum;
            ann_custom_StructEnum.reset();
            CompleteMemberDetail detail_var_enum = TypeObjectUtils::build_complete_member_detail(name_var_enum, member_ann_builtin_var_enum, ann_custom_StructEnum);
            CompleteStructMember member_var_enum = TypeObjectUtils::build_complete_struct_member(common_var_enum, detail_var_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructEnum, member_var_enum);
        }
        CompleteStructType struct_type_StructEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_StructEnum, header_StructEnum, member_seq_StructEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructEnum, type_name_StructEnum.to_string(), type_ids_StructEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructBitMask_type_identifier(
        TypeIdentifierPair& type_ids_StructBitMask)
{

    ReturnCode_t return_code_StructBitMask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructBitMask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructBitMask", type_ids_StructBitMask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructBitMask)
    {
        StructTypeFlag struct_flags_StructBitMask = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructBitMask = "StructBitMask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructBitMask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructBitMask;
        CompleteTypeDetail detail_StructBitMask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructBitMask, ann_custom_StructBitMask, type_name_StructBitMask.to_string());
        CompleteStructHeader header_StructBitMask;
        header_StructBitMask = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructBitMask);
        CompleteStructMemberSeq member_seq_StructBitMask;
        {
            TypeIdentifierPair type_ids_var_bitmask;
            ReturnCode_t return_code_var_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerBitMaskHelper", type_ids_var_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_bitmask)
            {
            ::register_InnerBitMaskHelper_type_identifier(type_ids_var_bitmask);
            }
            StructMemberFlag member_flags_var_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_bitmask = 0x00000000;
            bool common_var_bitmask_ec {false};
            CommonStructMember common_var_bitmask {TypeObjectUtils::build_common_struct_member(member_id_var_bitmask, member_flags_var_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_bitmask, common_var_bitmask_ec))};
            if (!common_var_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_bitmask = "var_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_bitmask;
            ann_custom_StructBitMask.reset();
            CompleteMemberDetail detail_var_bitmask = TypeObjectUtils::build_complete_member_detail(name_var_bitmask, member_ann_builtin_var_bitmask, ann_custom_StructBitMask);
            CompleteStructMember member_var_bitmask = TypeObjectUtils::build_complete_struct_member(common_var_bitmask, detail_var_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructBitMask, member_var_bitmask);
        }
        CompleteStructType struct_type_StructBitMask = TypeObjectUtils::build_complete_struct_type(struct_flags_StructBitMask, header_StructBitMask, member_seq_StructBitMask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructBitMask, type_name_StructBitMask.to_string(), type_ids_StructBitMask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructBitMask already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructAlias_type_identifier(
        TypeIdentifierPair& type_ids_StructAlias)
{

    ReturnCode_t return_code_StructAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructAlias", type_ids_StructAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructAlias)
    {
        StructTypeFlag struct_flags_StructAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructAlias = "StructAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructAlias;
        CompleteTypeDetail detail_StructAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructAlias, ann_custom_StructAlias, type_name_StructAlias.to_string());
        CompleteStructHeader header_StructAlias;
        header_StructAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructAlias);
        CompleteStructMemberSeq member_seq_StructAlias;
        {
            TypeIdentifierPair type_ids_var_alias;
            ReturnCode_t return_code_var_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerAliasHelper", type_ids_var_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_alias)
            {
            ::register_InnerAliasHelper_type_identifier(type_ids_var_alias);
            }
            StructMemberFlag member_flags_var_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_alias = 0x00000000;
            bool common_var_alias_ec {false};
            CommonStructMember common_var_alias {TypeObjectUtils::build_common_struct_member(member_id_var_alias, member_flags_var_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_alias, common_var_alias_ec))};
            if (!common_var_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_alias = "var_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_alias;
            ann_custom_StructAlias.reset();
            CompleteMemberDetail detail_var_alias = TypeObjectUtils::build_complete_member_detail(name_var_alias, member_ann_builtin_var_alias, ann_custom_StructAlias);
            CompleteStructMember member_var_alias = TypeObjectUtils::build_complete_struct_member(common_var_alias, detail_var_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructAlias, member_var_alias);
        }
        CompleteStructType struct_type_StructAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_StructAlias, header_StructAlias, member_seq_StructAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructAlias, type_name_StructAlias.to_string(), type_ids_StructAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructShortArray_type_identifier(
        TypeIdentifierPair& type_ids_StructShortArray)
{

    ReturnCode_t return_code_StructShortArray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructShortArray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructShortArray", type_ids_StructShortArray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructShortArray)
    {
        StructTypeFlag struct_flags_StructShortArray = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructShortArray = "StructShortArray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructShortArray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructShortArray;
        CompleteTypeDetail detail_StructShortArray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructShortArray, ann_custom_StructShortArray, type_name_StructShortArray.to_string());
        CompleteStructHeader header_StructShortArray;
        header_StructShortArray = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructShortArray);
        CompleteStructMemberSeq member_seq_StructShortArray;
        {
            TypeIdentifierPair type_ids_var_array_short;
            ReturnCode_t return_code_var_array_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_var_array_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
            {
                return_code_var_array_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_short.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_var_array_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_short = 0x00000000;
            bool common_var_array_short_ec {false};
            CommonStructMember common_var_array_short {TypeObjectUtils::build_common_struct_member(member_id_var_array_short, member_flags_var_array_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, common_var_array_short_ec))};
            if (!common_var_array_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_short = "var_array_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_short;
            ann_custom_StructShortArray.reset();
            CompleteMemberDetail detail_var_array_short = TypeObjectUtils::build_complete_member_detail(name_var_array_short, member_ann_builtin_var_array_short, ann_custom_StructShortArray);
            CompleteStructMember member_var_array_short = TypeObjectUtils::build_complete_struct_member(common_var_array_short, detail_var_array_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructShortArray, member_var_array_short);
        }
        CompleteStructType struct_type_StructShortArray = TypeObjectUtils::build_complete_struct_type(struct_flags_StructShortArray, header_StructShortArray, member_seq_StructShortArray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructShortArray, type_name_StructShortArray.to_string(), type_ids_StructShortArray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructShortArray already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructSequence_type_identifier(
        TypeIdentifierPair& type_ids_StructSequence)
{

    ReturnCode_t return_code_StructSequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructSequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructSequence", type_ids_StructSequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructSequence)
    {
        StructTypeFlag struct_flags_StructSequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructSequence = "StructSequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructSequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructSequence;
        CompleteTypeDetail detail_StructSequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructSequence, ann_custom_StructSequence, type_name_StructSequence.to_string());
        CompleteStructHeader header_StructSequence;
        header_StructSequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructSequence);
        CompleteStructMemberSeq member_seq_StructSequence;
        {
            TypeIdentifierPair type_ids_var_sequence;
            ReturnCode_t return_code_var_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int32_t_unbounded", type_ids_var_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence)
            {
                return_code_var_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_sequence)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence, element_identifier_anonymous_sequence_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int32_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_var_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int32_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_unbounded, element_flags_anonymous_sequence_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_unbounded", type_ids_var_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_sequence = 0x00000000;
            bool common_var_sequence_ec {false};
            CommonStructMember common_var_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_sequence, member_flags_var_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_sequence, common_var_sequence_ec))};
            if (!common_var_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_sequence = "var_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_sequence;
            ann_custom_StructSequence.reset();
            CompleteMemberDetail detail_var_sequence = TypeObjectUtils::build_complete_member_detail(name_var_sequence, member_ann_builtin_var_sequence, ann_custom_StructSequence);
            CompleteStructMember member_var_sequence = TypeObjectUtils::build_complete_struct_member(common_var_sequence, detail_var_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructSequence, member_var_sequence);
        }
        CompleteStructType struct_type_StructSequence = TypeObjectUtils::build_complete_struct_type(struct_flags_StructSequence, header_StructSequence, member_seq_StructSequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructSequence, type_name_StructSequence.to_string(), type_ids_StructSequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructSequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructMap_type_identifier(
        TypeIdentifierPair& type_ids_StructMap)
{

    ReturnCode_t return_code_StructMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructMap", type_ids_StructMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructMap)
    {
        StructTypeFlag struct_flags_StructMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructMap = "StructMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructMap;
        CompleteTypeDetail detail_StructMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructMap, ann_custom_StructMap, type_name_StructMap.to_string());
        CompleteStructHeader header_StructMap;
        header_StructMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructMap);
        CompleteStructMemberSeq member_seq_StructMap;
        {
            TypeIdentifierPair type_ids_var_map;
            ReturnCode_t return_code_var_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map)
            {
                return_code_var_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map, element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map, key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int32_t_unbounded, element_flags_anonymous_map_int32_t_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int32_t_unbounded), key_flags_anonymous_map_int32_t_int32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map = 0x00000000;
            bool common_var_map_ec {false};
            CommonStructMember common_var_map {TypeObjectUtils::build_common_struct_member(member_id_var_map, member_flags_var_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map, common_var_map_ec))};
            if (!common_var_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map = "var_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map;
            ann_custom_StructMap.reset();
            CompleteMemberDetail detail_var_map = TypeObjectUtils::build_complete_member_detail(name_var_map, member_ann_builtin_var_map, ann_custom_StructMap);
            CompleteStructMember member_var_map = TypeObjectUtils::build_complete_struct_member(common_var_map, detail_var_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructMap, member_var_map);
        }
        CompleteStructType struct_type_StructMap = TypeObjectUtils::build_complete_struct_type(struct_flags_StructMap, header_StructMap, member_seq_StructMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructMap, type_name_StructMap.to_string(), type_ids_StructMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructUnion_type_identifier(
        TypeIdentifierPair& type_ids_StructUnion)
{

    ReturnCode_t return_code_StructUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructUnion", type_ids_StructUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructUnion)
    {
        StructTypeFlag struct_flags_StructUnion = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructUnion = "StructUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructUnion;
        CompleteTypeDetail detail_StructUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructUnion, ann_custom_StructUnion, type_name_StructUnion.to_string());
        CompleteStructHeader header_StructUnion;
        header_StructUnion = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructUnion);
        CompleteStructMemberSeq member_seq_StructUnion;
        {
            TypeIdentifierPair type_ids_var_union;
            ReturnCode_t return_code_var_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerUnionHelper", type_ids_var_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union)
            {
            ::register_InnerUnionHelper_type_identifier(type_ids_var_union);
            }
            StructMemberFlag member_flags_var_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union = 0x00000000;
            bool common_var_union_ec {false};
            CommonStructMember common_var_union {TypeObjectUtils::build_common_struct_member(member_id_var_union, member_flags_var_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union, common_var_union_ec))};
            if (!common_var_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union = "var_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union;
            ann_custom_StructUnion.reset();
            CompleteMemberDetail detail_var_union = TypeObjectUtils::build_complete_member_detail(name_var_union, member_ann_builtin_var_union, ann_custom_StructUnion);
            CompleteStructMember member_var_union = TypeObjectUtils::build_complete_struct_member(common_var_union, detail_var_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructUnion, member_var_union);
        }
        CompleteStructType struct_type_StructUnion = TypeObjectUtils::build_complete_struct_type(struct_flags_StructUnion, header_StructUnion, member_seq_StructUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructUnion, type_name_StructUnion.to_string(), type_ids_StructUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructStructure_type_identifier(
        TypeIdentifierPair& type_ids_StructStructure)
{

    ReturnCode_t return_code_StructStructure {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructStructure =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructStructure", type_ids_StructStructure);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructStructure)
    {
        StructTypeFlag struct_flags_StructStructure = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructStructure = "StructStructure";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructStructure;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructStructure;
        CompleteTypeDetail detail_StructStructure = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructStructure, ann_custom_StructStructure, type_name_StructStructure.to_string());
        CompleteStructHeader header_StructStructure;
        header_StructStructure = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructStructure);
        CompleteStructMemberSeq member_seq_StructStructure;
        {
            TypeIdentifierPair type_ids_var_structure;
            ReturnCode_t return_code_var_structure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_structure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_var_structure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_structure)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_var_structure);
            }
            StructMemberFlag member_flags_var_structure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_structure = 0x00000000;
            bool common_var_structure_ec {false};
            CommonStructMember common_var_structure {TypeObjectUtils::build_common_struct_member(member_id_var_structure, member_flags_var_structure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_structure, common_var_structure_ec))};
            if (!common_var_structure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_structure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_structure = "var_structure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_structure;
            ann_custom_StructStructure.reset();
            CompleteMemberDetail detail_var_structure = TypeObjectUtils::build_complete_member_detail(name_var_structure, member_ann_builtin_var_structure, ann_custom_StructStructure);
            CompleteStructMember member_var_structure = TypeObjectUtils::build_complete_struct_member(common_var_structure, detail_var_structure);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructStructure, member_var_structure);
        }
        CompleteStructType struct_type_StructStructure = TypeObjectUtils::build_complete_struct_type(struct_flags_StructStructure, header_StructStructure, member_seq_StructStructure);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructStructure, type_name_StructStructure.to_string(), type_ids_StructStructure))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructStructure already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructBitset_type_identifier(
        TypeIdentifierPair& type_ids_StructBitset)
{

    ReturnCode_t return_code_StructBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructBitset", type_ids_StructBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructBitset)
    {
        StructTypeFlag struct_flags_StructBitset = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructBitset = "StructBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructBitset;
        CompleteTypeDetail detail_StructBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructBitset, ann_custom_StructBitset, type_name_StructBitset.to_string());
        CompleteStructHeader header_StructBitset;
        header_StructBitset = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructBitset);
        CompleteStructMemberSeq member_seq_StructBitset;
        {
            TypeIdentifierPair type_ids_var_bitset;
            ReturnCode_t return_code_var_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerBitsetHelper", type_ids_var_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_bitset)
            {
            ::register_InnerBitsetHelper_type_identifier(type_ids_var_bitset);
            }
            StructMemberFlag member_flags_var_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_bitset = 0x00000000;
            bool common_var_bitset_ec {false};
            CommonStructMember common_var_bitset {TypeObjectUtils::build_common_struct_member(member_id_var_bitset, member_flags_var_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_bitset, common_var_bitset_ec))};
            if (!common_var_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_bitset = "var_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_bitset;
            ann_custom_StructBitset.reset();
            CompleteMemberDetail detail_var_bitset = TypeObjectUtils::build_complete_member_detail(name_var_bitset, member_ann_builtin_var_bitset, ann_custom_StructBitset);
            CompleteStructMember member_var_bitset = TypeObjectUtils::build_complete_struct_member(common_var_bitset, detail_var_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructBitset, member_var_bitset);
        }
        CompleteStructType struct_type_StructBitset = TypeObjectUtils::build_complete_struct_type(struct_flags_StructBitset, header_StructBitset, member_seq_StructBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructBitset, type_name_StructBitset.to_string(), type_ids_StructBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructEmpty_type_identifier(
        TypeIdentifierPair& type_ids_StructEmpty)
{

    ReturnCode_t return_code_StructEmpty {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructEmpty =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructEmpty", type_ids_StructEmpty);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructEmpty)
    {
        StructTypeFlag struct_flags_StructEmpty = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructEmpty = "StructEmpty";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructEmpty;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructEmpty;
        CompleteTypeDetail detail_StructEmpty = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructEmpty, ann_custom_StructEmpty, type_name_StructEmpty.to_string());
        CompleteStructHeader header_StructEmpty;
        header_StructEmpty = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructEmpty);
        CompleteStructMemberSeq member_seq_StructEmpty;
        CompleteStructType struct_type_StructEmpty = TypeObjectUtils::build_complete_struct_type(struct_flags_StructEmpty, header_StructEmpty, member_seq_StructEmpty);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructEmpty, type_name_StructEmpty.to_string(), type_ids_StructEmpty))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructEmpty already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Structures_type_identifier(
        TypeIdentifierPair& type_ids_Structures)
{

    ReturnCode_t return_code_Structures {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Structures =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Structures", type_ids_Structures);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Structures)
    {
        StructTypeFlag struct_flags_Structures = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Structures = "Structures";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Structures;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Structures;
        CompleteTypeDetail detail_Structures = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Structures, ann_custom_Structures, type_name_Structures.to_string());
        CompleteStructHeader header_Structures;
        header_Structures = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Structures);
        CompleteStructMemberSeq member_seq_Structures;
        {
            TypeIdentifierPair type_ids_var_StructShort;
            ReturnCode_t return_code_var_StructShort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructShort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructShort", type_ids_var_StructShort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructShort)
            {
            ::register_StructShort_type_identifier(type_ids_var_StructShort);
            }
            StructMemberFlag member_flags_var_StructShort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructShort = 0x00000000;
            bool common_var_StructShort_ec {false};
            CommonStructMember common_var_StructShort {TypeObjectUtils::build_common_struct_member(member_id_var_StructShort, member_flags_var_StructShort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructShort, common_var_StructShort_ec))};
            if (!common_var_StructShort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructShort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructShort = "var_StructShort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructShort;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructShort = TypeObjectUtils::build_complete_member_detail(name_var_StructShort, member_ann_builtin_var_StructShort, ann_custom_Structures);
            CompleteStructMember member_var_StructShort = TypeObjectUtils::build_complete_struct_member(common_var_StructShort, detail_var_StructShort);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructShort);
        }
        {
            TypeIdentifierPair type_ids_var_StructUnsignedShort;
            ReturnCode_t return_code_var_StructUnsignedShort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructUnsignedShort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructUnsignedShort", type_ids_var_StructUnsignedShort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructUnsignedShort)
            {
            ::register_StructUnsignedShort_type_identifier(type_ids_var_StructUnsignedShort);
            }
            StructMemberFlag member_flags_var_StructUnsignedShort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructUnsignedShort = 0x00000001;
            bool common_var_StructUnsignedShort_ec {false};
            CommonStructMember common_var_StructUnsignedShort {TypeObjectUtils::build_common_struct_member(member_id_var_StructUnsignedShort, member_flags_var_StructUnsignedShort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructUnsignedShort, common_var_StructUnsignedShort_ec))};
            if (!common_var_StructUnsignedShort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructUnsignedShort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructUnsignedShort = "var_StructUnsignedShort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructUnsignedShort;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructUnsignedShort = TypeObjectUtils::build_complete_member_detail(name_var_StructUnsignedShort, member_ann_builtin_var_StructUnsignedShort, ann_custom_Structures);
            CompleteStructMember member_var_StructUnsignedShort = TypeObjectUtils::build_complete_struct_member(common_var_StructUnsignedShort, detail_var_StructUnsignedShort);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructUnsignedShort);
        }
        {
            TypeIdentifierPair type_ids_var_StructLong;
            ReturnCode_t return_code_var_StructLong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructLong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructLong", type_ids_var_StructLong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructLong)
            {
            ::register_StructLong_type_identifier(type_ids_var_StructLong);
            }
            StructMemberFlag member_flags_var_StructLong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructLong = 0x00000002;
            bool common_var_StructLong_ec {false};
            CommonStructMember common_var_StructLong {TypeObjectUtils::build_common_struct_member(member_id_var_StructLong, member_flags_var_StructLong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructLong, common_var_StructLong_ec))};
            if (!common_var_StructLong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructLong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructLong = "var_StructLong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructLong;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructLong = TypeObjectUtils::build_complete_member_detail(name_var_StructLong, member_ann_builtin_var_StructLong, ann_custom_Structures);
            CompleteStructMember member_var_StructLong = TypeObjectUtils::build_complete_struct_member(common_var_StructLong, detail_var_StructLong);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructLong);
        }
        {
            TypeIdentifierPair type_ids_var_StructUnsignedLong;
            ReturnCode_t return_code_var_StructUnsignedLong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructUnsignedLong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructUnsignedLong", type_ids_var_StructUnsignedLong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructUnsignedLong)
            {
            ::register_StructUnsignedLong_type_identifier(type_ids_var_StructUnsignedLong);
            }
            StructMemberFlag member_flags_var_StructUnsignedLong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructUnsignedLong = 0x00000003;
            bool common_var_StructUnsignedLong_ec {false};
            CommonStructMember common_var_StructUnsignedLong {TypeObjectUtils::build_common_struct_member(member_id_var_StructUnsignedLong, member_flags_var_StructUnsignedLong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructUnsignedLong, common_var_StructUnsignedLong_ec))};
            if (!common_var_StructUnsignedLong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructUnsignedLong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructUnsignedLong = "var_StructUnsignedLong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructUnsignedLong;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructUnsignedLong = TypeObjectUtils::build_complete_member_detail(name_var_StructUnsignedLong, member_ann_builtin_var_StructUnsignedLong, ann_custom_Structures);
            CompleteStructMember member_var_StructUnsignedLong = TypeObjectUtils::build_complete_struct_member(common_var_StructUnsignedLong, detail_var_StructUnsignedLong);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructUnsignedLong);
        }
        {
            TypeIdentifierPair type_ids_var_StructLongLong;
            ReturnCode_t return_code_var_StructLongLong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructLongLong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructLongLong", type_ids_var_StructLongLong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructLongLong)
            {
            ::register_StructLongLong_type_identifier(type_ids_var_StructLongLong);
            }
            StructMemberFlag member_flags_var_StructLongLong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructLongLong = 0x00000004;
            bool common_var_StructLongLong_ec {false};
            CommonStructMember common_var_StructLongLong {TypeObjectUtils::build_common_struct_member(member_id_var_StructLongLong, member_flags_var_StructLongLong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructLongLong, common_var_StructLongLong_ec))};
            if (!common_var_StructLongLong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructLongLong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructLongLong = "var_StructLongLong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructLongLong;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructLongLong = TypeObjectUtils::build_complete_member_detail(name_var_StructLongLong, member_ann_builtin_var_StructLongLong, ann_custom_Structures);
            CompleteStructMember member_var_StructLongLong = TypeObjectUtils::build_complete_struct_member(common_var_StructLongLong, detail_var_StructLongLong);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructLongLong);
        }
        {
            TypeIdentifierPair type_ids_var_StructUnsignedLongLong;
            ReturnCode_t return_code_var_StructUnsignedLongLong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructUnsignedLongLong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructUnsignedLongLong", type_ids_var_StructUnsignedLongLong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructUnsignedLongLong)
            {
            ::register_StructUnsignedLongLong_type_identifier(type_ids_var_StructUnsignedLongLong);
            }
            StructMemberFlag member_flags_var_StructUnsignedLongLong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructUnsignedLongLong = 0x00000005;
            bool common_var_StructUnsignedLongLong_ec {false};
            CommonStructMember common_var_StructUnsignedLongLong {TypeObjectUtils::build_common_struct_member(member_id_var_StructUnsignedLongLong, member_flags_var_StructUnsignedLongLong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructUnsignedLongLong, common_var_StructUnsignedLongLong_ec))};
            if (!common_var_StructUnsignedLongLong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructUnsignedLongLong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructUnsignedLongLong = "var_StructUnsignedLongLong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructUnsignedLongLong;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructUnsignedLongLong = TypeObjectUtils::build_complete_member_detail(name_var_StructUnsignedLongLong, member_ann_builtin_var_StructUnsignedLongLong, ann_custom_Structures);
            CompleteStructMember member_var_StructUnsignedLongLong = TypeObjectUtils::build_complete_struct_member(common_var_StructUnsignedLongLong, detail_var_StructUnsignedLongLong);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructUnsignedLongLong);
        }
        {
            TypeIdentifierPair type_ids_var_StructFloat;
            ReturnCode_t return_code_var_StructFloat {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructFloat =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructFloat", type_ids_var_StructFloat);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructFloat)
            {
            ::register_StructFloat_type_identifier(type_ids_var_StructFloat);
            }
            StructMemberFlag member_flags_var_StructFloat = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructFloat = 0x00000006;
            bool common_var_StructFloat_ec {false};
            CommonStructMember common_var_StructFloat {TypeObjectUtils::build_common_struct_member(member_id_var_StructFloat, member_flags_var_StructFloat, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructFloat, common_var_StructFloat_ec))};
            if (!common_var_StructFloat_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructFloat member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructFloat = "var_StructFloat";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructFloat;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructFloat = TypeObjectUtils::build_complete_member_detail(name_var_StructFloat, member_ann_builtin_var_StructFloat, ann_custom_Structures);
            CompleteStructMember member_var_StructFloat = TypeObjectUtils::build_complete_struct_member(common_var_StructFloat, detail_var_StructFloat);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructFloat);
        }
        {
            TypeIdentifierPair type_ids_var_StructDouble;
            ReturnCode_t return_code_var_StructDouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructDouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructDouble", type_ids_var_StructDouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructDouble)
            {
            ::register_StructDouble_type_identifier(type_ids_var_StructDouble);
            }
            StructMemberFlag member_flags_var_StructDouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructDouble = 0x00000007;
            bool common_var_StructDouble_ec {false};
            CommonStructMember common_var_StructDouble {TypeObjectUtils::build_common_struct_member(member_id_var_StructDouble, member_flags_var_StructDouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructDouble, common_var_StructDouble_ec))};
            if (!common_var_StructDouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructDouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructDouble = "var_StructDouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructDouble;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructDouble = TypeObjectUtils::build_complete_member_detail(name_var_StructDouble, member_ann_builtin_var_StructDouble, ann_custom_Structures);
            CompleteStructMember member_var_StructDouble = TypeObjectUtils::build_complete_struct_member(common_var_StructDouble, detail_var_StructDouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructDouble);
        }
        {
            TypeIdentifierPair type_ids_var_StructLongDouble;
            ReturnCode_t return_code_var_StructLongDouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructLongDouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructLongDouble", type_ids_var_StructLongDouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructLongDouble)
            {
            ::register_StructLongDouble_type_identifier(type_ids_var_StructLongDouble);
            }
            StructMemberFlag member_flags_var_StructLongDouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructLongDouble = 0x00000008;
            bool common_var_StructLongDouble_ec {false};
            CommonStructMember common_var_StructLongDouble {TypeObjectUtils::build_common_struct_member(member_id_var_StructLongDouble, member_flags_var_StructLongDouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructLongDouble, common_var_StructLongDouble_ec))};
            if (!common_var_StructLongDouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructLongDouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructLongDouble = "var_StructLongDouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructLongDouble;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructLongDouble = TypeObjectUtils::build_complete_member_detail(name_var_StructLongDouble, member_ann_builtin_var_StructLongDouble, ann_custom_Structures);
            CompleteStructMember member_var_StructLongDouble = TypeObjectUtils::build_complete_struct_member(common_var_StructLongDouble, detail_var_StructLongDouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructLongDouble);
        }
        {
            TypeIdentifierPair type_ids_var_StructBoolean;
            ReturnCode_t return_code_var_StructBoolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructBoolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructBoolean", type_ids_var_StructBoolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructBoolean)
            {
            ::register_StructBoolean_type_identifier(type_ids_var_StructBoolean);
            }
            StructMemberFlag member_flags_var_StructBoolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructBoolean = 0x00000009;
            bool common_var_StructBoolean_ec {false};
            CommonStructMember common_var_StructBoolean {TypeObjectUtils::build_common_struct_member(member_id_var_StructBoolean, member_flags_var_StructBoolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructBoolean, common_var_StructBoolean_ec))};
            if (!common_var_StructBoolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructBoolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructBoolean = "var_StructBoolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructBoolean;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructBoolean = TypeObjectUtils::build_complete_member_detail(name_var_StructBoolean, member_ann_builtin_var_StructBoolean, ann_custom_Structures);
            CompleteStructMember member_var_StructBoolean = TypeObjectUtils::build_complete_struct_member(common_var_StructBoolean, detail_var_StructBoolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructBoolean);
        }
        {
            TypeIdentifierPair type_ids_var_StructOctet;
            ReturnCode_t return_code_var_StructOctet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructOctet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructOctet", type_ids_var_StructOctet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructOctet)
            {
            ::register_StructOctet_type_identifier(type_ids_var_StructOctet);
            }
            StructMemberFlag member_flags_var_StructOctet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructOctet = 0x0000000a;
            bool common_var_StructOctet_ec {false};
            CommonStructMember common_var_StructOctet {TypeObjectUtils::build_common_struct_member(member_id_var_StructOctet, member_flags_var_StructOctet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructOctet, common_var_StructOctet_ec))};
            if (!common_var_StructOctet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructOctet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructOctet = "var_StructOctet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructOctet;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructOctet = TypeObjectUtils::build_complete_member_detail(name_var_StructOctet, member_ann_builtin_var_StructOctet, ann_custom_Structures);
            CompleteStructMember member_var_StructOctet = TypeObjectUtils::build_complete_struct_member(common_var_StructOctet, detail_var_StructOctet);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructOctet);
        }
        {
            TypeIdentifierPair type_ids_var_StructChar8;
            ReturnCode_t return_code_var_StructChar8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructChar8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructChar8", type_ids_var_StructChar8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructChar8)
            {
            ::register_StructChar8_type_identifier(type_ids_var_StructChar8);
            }
            StructMemberFlag member_flags_var_StructChar8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructChar8 = 0x0000000b;
            bool common_var_StructChar8_ec {false};
            CommonStructMember common_var_StructChar8 {TypeObjectUtils::build_common_struct_member(member_id_var_StructChar8, member_flags_var_StructChar8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructChar8, common_var_StructChar8_ec))};
            if (!common_var_StructChar8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructChar8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructChar8 = "var_StructChar8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructChar8;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructChar8 = TypeObjectUtils::build_complete_member_detail(name_var_StructChar8, member_ann_builtin_var_StructChar8, ann_custom_Structures);
            CompleteStructMember member_var_StructChar8 = TypeObjectUtils::build_complete_struct_member(common_var_StructChar8, detail_var_StructChar8);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructChar8);
        }
        {
            TypeIdentifierPair type_ids_var_StructChar16;
            ReturnCode_t return_code_var_StructChar16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructChar16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructChar16", type_ids_var_StructChar16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructChar16)
            {
            ::register_StructChar16_type_identifier(type_ids_var_StructChar16);
            }
            StructMemberFlag member_flags_var_StructChar16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructChar16 = 0x0000000c;
            bool common_var_StructChar16_ec {false};
            CommonStructMember common_var_StructChar16 {TypeObjectUtils::build_common_struct_member(member_id_var_StructChar16, member_flags_var_StructChar16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructChar16, common_var_StructChar16_ec))};
            if (!common_var_StructChar16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructChar16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructChar16 = "var_StructChar16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructChar16;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructChar16 = TypeObjectUtils::build_complete_member_detail(name_var_StructChar16, member_ann_builtin_var_StructChar16, ann_custom_Structures);
            CompleteStructMember member_var_StructChar16 = TypeObjectUtils::build_complete_struct_member(common_var_StructChar16, detail_var_StructChar16);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructChar16);
        }
        {
            TypeIdentifierPair type_ids_var_StructString;
            ReturnCode_t return_code_var_StructString {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructString =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructString", type_ids_var_StructString);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructString)
            {
            ::register_StructString_type_identifier(type_ids_var_StructString);
            }
            StructMemberFlag member_flags_var_StructString = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructString = 0x0000000d;
            bool common_var_StructString_ec {false};
            CommonStructMember common_var_StructString {TypeObjectUtils::build_common_struct_member(member_id_var_StructString, member_flags_var_StructString, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructString, common_var_StructString_ec))};
            if (!common_var_StructString_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructString member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructString = "var_StructString";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructString;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructString = TypeObjectUtils::build_complete_member_detail(name_var_StructString, member_ann_builtin_var_StructString, ann_custom_Structures);
            CompleteStructMember member_var_StructString = TypeObjectUtils::build_complete_struct_member(common_var_StructString, detail_var_StructString);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructString);
        }
        {
            TypeIdentifierPair type_ids_var_StructWString;
            ReturnCode_t return_code_var_StructWString {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructWString =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructWString", type_ids_var_StructWString);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructWString)
            {
            ::register_StructWString_type_identifier(type_ids_var_StructWString);
            }
            StructMemberFlag member_flags_var_StructWString = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructWString = 0x0000000e;
            bool common_var_StructWString_ec {false};
            CommonStructMember common_var_StructWString {TypeObjectUtils::build_common_struct_member(member_id_var_StructWString, member_flags_var_StructWString, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructWString, common_var_StructWString_ec))};
            if (!common_var_StructWString_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructWString member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructWString = "var_StructWString";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructWString;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructWString = TypeObjectUtils::build_complete_member_detail(name_var_StructWString, member_ann_builtin_var_StructWString, ann_custom_Structures);
            CompleteStructMember member_var_StructWString = TypeObjectUtils::build_complete_struct_member(common_var_StructWString, detail_var_StructWString);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructWString);
        }
        {
            TypeIdentifierPair type_ids_var_StructBoundedString;
            ReturnCode_t return_code_var_StructBoundedString {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructBoundedString =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructBoundedString", type_ids_var_StructBoundedString);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructBoundedString)
            {
            ::register_StructBoundedString_type_identifier(type_ids_var_StructBoundedString);
            }
            StructMemberFlag member_flags_var_StructBoundedString = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructBoundedString = 0x0000000f;
            bool common_var_StructBoundedString_ec {false};
            CommonStructMember common_var_StructBoundedString {TypeObjectUtils::build_common_struct_member(member_id_var_StructBoundedString, member_flags_var_StructBoundedString, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructBoundedString, common_var_StructBoundedString_ec))};
            if (!common_var_StructBoundedString_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructBoundedString member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructBoundedString = "var_StructBoundedString";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructBoundedString;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructBoundedString = TypeObjectUtils::build_complete_member_detail(name_var_StructBoundedString, member_ann_builtin_var_StructBoundedString, ann_custom_Structures);
            CompleteStructMember member_var_StructBoundedString = TypeObjectUtils::build_complete_struct_member(common_var_StructBoundedString, detail_var_StructBoundedString);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructBoundedString);
        }
        {
            TypeIdentifierPair type_ids_var_StructBoundedWString;
            ReturnCode_t return_code_var_StructBoundedWString {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructBoundedWString =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructBoundedWString", type_ids_var_StructBoundedWString);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructBoundedWString)
            {
            ::register_StructBoundedWString_type_identifier(type_ids_var_StructBoundedWString);
            }
            StructMemberFlag member_flags_var_StructBoundedWString = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructBoundedWString = 0x00000010;
            bool common_var_StructBoundedWString_ec {false};
            CommonStructMember common_var_StructBoundedWString {TypeObjectUtils::build_common_struct_member(member_id_var_StructBoundedWString, member_flags_var_StructBoundedWString, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructBoundedWString, common_var_StructBoundedWString_ec))};
            if (!common_var_StructBoundedWString_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructBoundedWString member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructBoundedWString = "var_StructBoundedWString";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructBoundedWString;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructBoundedWString = TypeObjectUtils::build_complete_member_detail(name_var_StructBoundedWString, member_ann_builtin_var_StructBoundedWString, ann_custom_Structures);
            CompleteStructMember member_var_StructBoundedWString = TypeObjectUtils::build_complete_struct_member(common_var_StructBoundedWString, detail_var_StructBoundedWString);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructBoundedWString);
        }
        {
            TypeIdentifierPair type_ids_var_StructEnum;
            ReturnCode_t return_code_var_StructEnum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructEnum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructEnum", type_ids_var_StructEnum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructEnum)
            {
            ::register_StructEnum_type_identifier(type_ids_var_StructEnum);
            }
            StructMemberFlag member_flags_var_StructEnum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructEnum = 0x00000011;
            bool common_var_StructEnum_ec {false};
            CommonStructMember common_var_StructEnum {TypeObjectUtils::build_common_struct_member(member_id_var_StructEnum, member_flags_var_StructEnum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructEnum, common_var_StructEnum_ec))};
            if (!common_var_StructEnum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructEnum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructEnum = "var_StructEnum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructEnum;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructEnum = TypeObjectUtils::build_complete_member_detail(name_var_StructEnum, member_ann_builtin_var_StructEnum, ann_custom_Structures);
            CompleteStructMember member_var_StructEnum = TypeObjectUtils::build_complete_struct_member(common_var_StructEnum, detail_var_StructEnum);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructEnum);
        }
        {
            TypeIdentifierPair type_ids_var_StructBitMask;
            ReturnCode_t return_code_var_StructBitMask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructBitMask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructBitMask", type_ids_var_StructBitMask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructBitMask)
            {
            ::register_StructBitMask_type_identifier(type_ids_var_StructBitMask);
            }
            StructMemberFlag member_flags_var_StructBitMask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructBitMask = 0x00000012;
            bool common_var_StructBitMask_ec {false};
            CommonStructMember common_var_StructBitMask {TypeObjectUtils::build_common_struct_member(member_id_var_StructBitMask, member_flags_var_StructBitMask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructBitMask, common_var_StructBitMask_ec))};
            if (!common_var_StructBitMask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructBitMask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructBitMask = "var_StructBitMask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructBitMask;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructBitMask = TypeObjectUtils::build_complete_member_detail(name_var_StructBitMask, member_ann_builtin_var_StructBitMask, ann_custom_Structures);
            CompleteStructMember member_var_StructBitMask = TypeObjectUtils::build_complete_struct_member(common_var_StructBitMask, detail_var_StructBitMask);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructBitMask);
        }
        {
            TypeIdentifierPair type_ids_var_StructAlias;
            ReturnCode_t return_code_var_StructAlias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructAlias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructAlias", type_ids_var_StructAlias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructAlias)
            {
            ::register_StructAlias_type_identifier(type_ids_var_StructAlias);
            }
            StructMemberFlag member_flags_var_StructAlias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructAlias = 0x00000013;
            bool common_var_StructAlias_ec {false};
            CommonStructMember common_var_StructAlias {TypeObjectUtils::build_common_struct_member(member_id_var_StructAlias, member_flags_var_StructAlias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructAlias, common_var_StructAlias_ec))};
            if (!common_var_StructAlias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructAlias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructAlias = "var_StructAlias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructAlias;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructAlias = TypeObjectUtils::build_complete_member_detail(name_var_StructAlias, member_ann_builtin_var_StructAlias, ann_custom_Structures);
            CompleteStructMember member_var_StructAlias = TypeObjectUtils::build_complete_struct_member(common_var_StructAlias, detail_var_StructAlias);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructAlias);
        }
        {
            TypeIdentifierPair type_ids_var_StructShortArray;
            ReturnCode_t return_code_var_StructShortArray {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructShortArray =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructShortArray", type_ids_var_StructShortArray);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructShortArray)
            {
            ::register_StructShortArray_type_identifier(type_ids_var_StructShortArray);
            }
            StructMemberFlag member_flags_var_StructShortArray = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructShortArray = 0x00000014;
            bool common_var_StructShortArray_ec {false};
            CommonStructMember common_var_StructShortArray {TypeObjectUtils::build_common_struct_member(member_id_var_StructShortArray, member_flags_var_StructShortArray, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructShortArray, common_var_StructShortArray_ec))};
            if (!common_var_StructShortArray_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructShortArray member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructShortArray = "var_StructShortArray";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructShortArray;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructShortArray = TypeObjectUtils::build_complete_member_detail(name_var_StructShortArray, member_ann_builtin_var_StructShortArray, ann_custom_Structures);
            CompleteStructMember member_var_StructShortArray = TypeObjectUtils::build_complete_struct_member(common_var_StructShortArray, detail_var_StructShortArray);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructShortArray);
        }
        {
            TypeIdentifierPair type_ids_var_StructSequence;
            ReturnCode_t return_code_var_StructSequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructSequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructSequence", type_ids_var_StructSequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructSequence)
            {
            ::register_StructSequence_type_identifier(type_ids_var_StructSequence);
            }
            StructMemberFlag member_flags_var_StructSequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructSequence = 0x00000015;
            bool common_var_StructSequence_ec {false};
            CommonStructMember common_var_StructSequence {TypeObjectUtils::build_common_struct_member(member_id_var_StructSequence, member_flags_var_StructSequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructSequence, common_var_StructSequence_ec))};
            if (!common_var_StructSequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructSequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructSequence = "var_StructSequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructSequence;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructSequence = TypeObjectUtils::build_complete_member_detail(name_var_StructSequence, member_ann_builtin_var_StructSequence, ann_custom_Structures);
            CompleteStructMember member_var_StructSequence = TypeObjectUtils::build_complete_struct_member(common_var_StructSequence, detail_var_StructSequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructSequence);
        }
        {
            TypeIdentifierPair type_ids_var_StructMap;
            ReturnCode_t return_code_var_StructMap {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructMap =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructMap", type_ids_var_StructMap);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructMap)
            {
            ::register_StructMap_type_identifier(type_ids_var_StructMap);
            }
            StructMemberFlag member_flags_var_StructMap = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructMap = 0x00000016;
            bool common_var_StructMap_ec {false};
            CommonStructMember common_var_StructMap {TypeObjectUtils::build_common_struct_member(member_id_var_StructMap, member_flags_var_StructMap, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructMap, common_var_StructMap_ec))};
            if (!common_var_StructMap_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructMap member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructMap = "var_StructMap";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructMap;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructMap = TypeObjectUtils::build_complete_member_detail(name_var_StructMap, member_ann_builtin_var_StructMap, ann_custom_Structures);
            CompleteStructMember member_var_StructMap = TypeObjectUtils::build_complete_struct_member(common_var_StructMap, detail_var_StructMap);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructMap);
        }
        {
            TypeIdentifierPair type_ids_var_StructUnion;
            ReturnCode_t return_code_var_StructUnion {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructUnion =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructUnion", type_ids_var_StructUnion);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructUnion)
            {
            ::register_StructUnion_type_identifier(type_ids_var_StructUnion);
            }
            StructMemberFlag member_flags_var_StructUnion = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructUnion = 0x00000017;
            bool common_var_StructUnion_ec {false};
            CommonStructMember common_var_StructUnion {TypeObjectUtils::build_common_struct_member(member_id_var_StructUnion, member_flags_var_StructUnion, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructUnion, common_var_StructUnion_ec))};
            if (!common_var_StructUnion_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructUnion member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructUnion = "var_StructUnion";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructUnion;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructUnion = TypeObjectUtils::build_complete_member_detail(name_var_StructUnion, member_ann_builtin_var_StructUnion, ann_custom_Structures);
            CompleteStructMember member_var_StructUnion = TypeObjectUtils::build_complete_struct_member(common_var_StructUnion, detail_var_StructUnion);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructUnion);
        }
        {
            TypeIdentifierPair type_ids_var_StructStructure;
            ReturnCode_t return_code_var_StructStructure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructStructure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructStructure", type_ids_var_StructStructure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructStructure)
            {
            ::register_StructStructure_type_identifier(type_ids_var_StructStructure);
            }
            StructMemberFlag member_flags_var_StructStructure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructStructure = 0x00000018;
            bool common_var_StructStructure_ec {false};
            CommonStructMember common_var_StructStructure {TypeObjectUtils::build_common_struct_member(member_id_var_StructStructure, member_flags_var_StructStructure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructStructure, common_var_StructStructure_ec))};
            if (!common_var_StructStructure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructStructure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructStructure = "var_StructStructure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructStructure;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructStructure = TypeObjectUtils::build_complete_member_detail(name_var_StructStructure, member_ann_builtin_var_StructStructure, ann_custom_Structures);
            CompleteStructMember member_var_StructStructure = TypeObjectUtils::build_complete_struct_member(common_var_StructStructure, detail_var_StructStructure);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructStructure);
        }
        {
            TypeIdentifierPair type_ids_var_StructBitset;
            ReturnCode_t return_code_var_StructBitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructBitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructBitset", type_ids_var_StructBitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructBitset)
            {
            ::register_StructBitset_type_identifier(type_ids_var_StructBitset);
            }
            StructMemberFlag member_flags_var_StructBitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructBitset = 0x00000019;
            bool common_var_StructBitset_ec {false};
            CommonStructMember common_var_StructBitset {TypeObjectUtils::build_common_struct_member(member_id_var_StructBitset, member_flags_var_StructBitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructBitset, common_var_StructBitset_ec))};
            if (!common_var_StructBitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructBitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructBitset = "var_StructBitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructBitset;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructBitset = TypeObjectUtils::build_complete_member_detail(name_var_StructBitset, member_ann_builtin_var_StructBitset, ann_custom_Structures);
            CompleteStructMember member_var_StructBitset = TypeObjectUtils::build_complete_struct_member(common_var_StructBitset, detail_var_StructBitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructBitset);
        }
        {
            TypeIdentifierPair type_ids_var_StructEmpty;
            ReturnCode_t return_code_var_StructEmpty {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructEmpty =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructEmpty", type_ids_var_StructEmpty);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructEmpty)
            {
            ::register_StructEmpty_type_identifier(type_ids_var_StructEmpty);
            }
            StructMemberFlag member_flags_var_StructEmpty = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructEmpty = 0x0000001a;
            bool common_var_StructEmpty_ec {false};
            CommonStructMember common_var_StructEmpty {TypeObjectUtils::build_common_struct_member(member_id_var_StructEmpty, member_flags_var_StructEmpty, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructEmpty, common_var_StructEmpty_ec))};
            if (!common_var_StructEmpty_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructEmpty member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructEmpty = "var_StructEmpty";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructEmpty;
            ann_custom_Structures.reset();
            CompleteMemberDetail detail_var_StructEmpty = TypeObjectUtils::build_complete_member_detail(name_var_StructEmpty, member_ann_builtin_var_StructEmpty, ann_custom_Structures);
            CompleteStructMember member_var_StructEmpty = TypeObjectUtils::build_complete_struct_member(common_var_StructEmpty, detail_var_StructEmpty);
            TypeObjectUtils::add_complete_struct_member(member_seq_Structures, member_var_StructEmpty);
        }
        CompleteStructType struct_type_Structures = TypeObjectUtils::build_complete_struct_type(struct_flags_Structures, header_Structures, member_seq_Structures);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Structures, type_name_Structures.to_string(), type_ids_Structures))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Structures already registered in TypeObjectRegistry for a different type.");
        }
    }
}namespace testing_1 {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_foo_type_identifier(
        TypeIdentifierPair& type_ids_foo)
{

    ReturnCode_t return_code_foo {eprosima::fastdds::dds::RETCODE_OK};
    return_code_foo =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "testing_1::foo", type_ids_foo);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_foo)
    {
        StructTypeFlag struct_flags_foo = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_foo = "testing_1::foo";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_foo;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_foo;
        CompleteTypeDetail detail_foo = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_foo, ann_custom_foo, type_name_foo.to_string());
        CompleteStructHeader header_foo;
        header_foo = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_foo);
        CompleteStructMemberSeq member_seq_foo;
        {
            TypeIdentifierPair type_ids_a;
            ReturnCode_t return_code_a {eprosima::fastdds::dds::RETCODE_OK};
            return_code_a =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_a);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_a)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "a Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_a = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_a = 0x00000000;
            bool common_a_ec {false};
            CommonStructMember common_a {TypeObjectUtils::build_common_struct_member(member_id_a, member_flags_a, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_a, common_a_ec))};
            if (!common_a_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure a member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_a = "a";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_foo.reset();
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_foo);
            CompleteStructMember member_a = TypeObjectUtils::build_complete_struct_member(common_a, detail_a);
            TypeObjectUtils::add_complete_struct_member(member_seq_foo, member_a);
        }
        {
            TypeIdentifierPair type_ids_b;
            ReturnCode_t return_code_b {eprosima::fastdds::dds::RETCODE_OK};
            return_code_b =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_b);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_b)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "b Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_b = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_b = 0x00000001;
            bool common_b_ec {false};
            CommonStructMember common_b {TypeObjectUtils::build_common_struct_member(member_id_b, member_flags_b, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_b, common_b_ec))};
            if (!common_b_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure b member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_b = "b";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_foo.reset();
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_foo);
            CompleteStructMember member_b = TypeObjectUtils::build_complete_struct_member(common_b, detail_b);
            TypeObjectUtils::add_complete_struct_member(member_seq_foo, member_b);
        }
        CompleteStructType struct_type_foo = TypeObjectUtils::build_complete_struct_type(struct_flags_foo, header_foo, member_seq_foo);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_foo, type_name_foo.to_string(), type_ids_foo))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "testing_1::foo already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace testing_1
namespace testing_2 {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_foo_type_identifier(
        TypeIdentifierPair& type_ids_foo)
{

    ReturnCode_t return_code_foo {eprosima::fastdds::dds::RETCODE_OK};
    return_code_foo =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "testing_2::foo", type_ids_foo);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_foo)
    {
        StructTypeFlag struct_flags_foo = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_foo = "testing_2::foo";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_foo;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_foo;
        CompleteTypeDetail detail_foo = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_foo, ann_custom_foo, type_name_foo.to_string());
        CompleteStructHeader header_foo;
        header_foo = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_foo);
        CompleteStructMemberSeq member_seq_foo;
        {
            TypeIdentifierPair type_ids_d;
            ReturnCode_t return_code_d {eprosima::fastdds::dds::RETCODE_OK};
            return_code_d =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_d);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_d)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "d Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_d = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_d = 0x00000000;
            bool common_d_ec {false};
            CommonStructMember common_d {TypeObjectUtils::build_common_struct_member(member_id_d, member_flags_d, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_d, common_d_ec))};
            if (!common_d_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure d member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_d = "d";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_foo.reset();
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_foo);
            CompleteStructMember member_d = TypeObjectUtils::build_complete_struct_member(common_d, detail_d);
            TypeObjectUtils::add_complete_struct_member(member_seq_foo, member_d);
        }
        CompleteStructType struct_type_foo = TypeObjectUtils::build_complete_struct_type(struct_flags_foo, header_foo, member_seq_foo);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_foo, type_name_foo.to_string(), type_ids_foo))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "testing_2::foo already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace testing_2
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_bar_type_identifier(
        TypeIdentifierPair& type_ids_bar)
{

    ReturnCode_t return_code_bar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_bar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "bar", type_ids_bar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_bar)
    {
        StructTypeFlag struct_flags_bar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_bar = "bar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_bar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_bar;
        CompleteTypeDetail detail_bar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_bar, ann_custom_bar, type_name_bar.to_string());
        CompleteStructHeader header_bar;
        header_bar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_bar);
        CompleteStructMemberSeq member_seq_bar;
        {
            TypeIdentifierPair type_ids_e;
            ReturnCode_t return_code_e {eprosima::fastdds::dds::RETCODE_OK};
            return_code_e =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_e);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_e)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "e Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_e = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_e = 0x00000000;
            bool common_e_ec {false};
            CommonStructMember common_e {TypeObjectUtils::build_common_struct_member(member_id_e, member_flags_e, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_e, common_e_ec))};
            if (!common_e_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure e member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_e = "e";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_e;
            ann_custom_bar.reset();
            CompleteMemberDetail detail_e = TypeObjectUtils::build_complete_member_detail(name_e, member_ann_builtin_e, ann_custom_bar);
            CompleteStructMember member_e = TypeObjectUtils::build_complete_struct_member(common_e, detail_e);
            TypeObjectUtils::add_complete_struct_member(member_seq_bar, member_e);
        }
        CompleteStructType struct_type_bar = TypeObjectUtils::build_complete_struct_type(struct_flags_bar, header_bar, member_seq_bar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_bar, type_name_bar.to_string(), type_ids_bar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "bar already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_root1_type_identifier(
        TypeIdentifierPair& type_ids_root1)
{

    ReturnCode_t return_code_root1 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_root1 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "root1", type_ids_root1);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_root1)
    {
        StructTypeFlag struct_flags_root1 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_root1 = "root1";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_root1;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_root1;
        CompleteTypeDetail detail_root1 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_root1, ann_custom_root1, type_name_root1.to_string());
        CompleteStructHeader header_root1;
        header_root1 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_root1);
        CompleteStructMemberSeq member_seq_root1;
        {
            TypeIdentifierPair type_ids_foo_struct;
            ReturnCode_t return_code_foo_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_foo_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "testing_1::foo", type_ids_foo_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_foo_struct)
            {
                ::testing_1::register_foo_type_identifier(type_ids_foo_struct);
            }
            StructMemberFlag member_flags_foo_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_foo_struct = 0x00000000;
            bool common_foo_struct_ec {false};
            CommonStructMember common_foo_struct {TypeObjectUtils::build_common_struct_member(member_id_foo_struct, member_flags_foo_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_foo_struct, common_foo_struct_ec))};
            if (!common_foo_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure foo_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_foo_struct = "foo_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_foo_struct;
            ann_custom_root1.reset();
            CompleteMemberDetail detail_foo_struct = TypeObjectUtils::build_complete_member_detail(name_foo_struct, member_ann_builtin_foo_struct, ann_custom_root1);
            CompleteStructMember member_foo_struct = TypeObjectUtils::build_complete_struct_member(common_foo_struct, detail_foo_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_root1, member_foo_struct);
        }
        {
            TypeIdentifierPair type_ids_c;
            ReturnCode_t return_code_c {eprosima::fastdds::dds::RETCODE_OK};
            return_code_c =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_c);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_c)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "c Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_c = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_c = 0x00000001;
            bool common_c_ec {false};
            CommonStructMember common_c {TypeObjectUtils::build_common_struct_member(member_id_c, member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_c, common_c_ec))};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_root1.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_root1);
            CompleteStructMember member_c = TypeObjectUtils::build_complete_struct_member(common_c, detail_c);
            TypeObjectUtils::add_complete_struct_member(member_seq_root1, member_c);
        }
        CompleteStructType struct_type_root1 = TypeObjectUtils::build_complete_struct_type(struct_flags_root1, header_root1, member_seq_root1);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_root1, type_name_root1.to_string(), type_ids_root1))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "root1 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_root2_type_identifier(
        TypeIdentifierPair& type_ids_root2)
{

    ReturnCode_t return_code_root2 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_root2 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "root2", type_ids_root2);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_root2)
    {
        StructTypeFlag struct_flags_root2 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_root2 = "root2";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_root2;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_root2;
        CompleteTypeDetail detail_root2 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_root2, ann_custom_root2, type_name_root2.to_string());
        CompleteStructHeader header_root2;
        header_root2 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_root2);
        CompleteStructMemberSeq member_seq_root2;
        {
            TypeIdentifierPair type_ids_foo_struct;
            ReturnCode_t return_code_foo_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_foo_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "testing_2::foo", type_ids_foo_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_foo_struct)
            {
                ::testing_2::register_foo_type_identifier(type_ids_foo_struct);
            }
            StructMemberFlag member_flags_foo_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_foo_struct = 0x00000000;
            bool common_foo_struct_ec {false};
            CommonStructMember common_foo_struct {TypeObjectUtils::build_common_struct_member(member_id_foo_struct, member_flags_foo_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_foo_struct, common_foo_struct_ec))};
            if (!common_foo_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure foo_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_foo_struct = "foo_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_foo_struct;
            ann_custom_root2.reset();
            CompleteMemberDetail detail_foo_struct = TypeObjectUtils::build_complete_member_detail(name_foo_struct, member_ann_builtin_foo_struct, ann_custom_root2);
            CompleteStructMember member_foo_struct = TypeObjectUtils::build_complete_struct_member(common_foo_struct, detail_foo_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_root2, member_foo_struct);
        }
        {
            TypeIdentifierPair type_ids_bar_struct;
            ReturnCode_t return_code_bar_struct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bar_struct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "bar", type_ids_bar_struct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bar_struct)
            {
            ::register_bar_type_identifier(type_ids_bar_struct);
            }
            StructMemberFlag member_flags_bar_struct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bar_struct = 0x00000001;
            bool common_bar_struct_ec {false};
            CommonStructMember common_bar_struct {TypeObjectUtils::build_common_struct_member(member_id_bar_struct, member_flags_bar_struct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bar_struct, common_bar_struct_ec))};
            if (!common_bar_struct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bar_struct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bar_struct = "bar_struct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bar_struct;
            ann_custom_root2.reset();
            CompleteMemberDetail detail_bar_struct = TypeObjectUtils::build_complete_member_detail(name_bar_struct, member_ann_builtin_bar_struct, ann_custom_root2);
            CompleteStructMember member_bar_struct = TypeObjectUtils::build_complete_struct_member(common_bar_struct, detail_bar_struct);
            TypeObjectUtils::add_complete_struct_member(member_seq_root2, member_bar_struct);
        }
        CompleteStructType struct_type_root2 = TypeObjectUtils::build_complete_struct_type(struct_flags_root2, header_root2, member_seq_root2);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_root2, type_name_root2.to_string(), type_ids_root2))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "root2 already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_root_type_identifier(
        TypeIdentifierPair& type_ids_root)
{

    ReturnCode_t return_code_root {eprosima::fastdds::dds::RETCODE_OK};
    return_code_root =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "root", type_ids_root);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_root)
    {
        StructTypeFlag struct_flags_root = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_root = "root";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_root;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_root;
        CompleteTypeDetail detail_root = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_root, ann_custom_root, type_name_root.to_string());
        CompleteStructHeader header_root;
        header_root = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_root);
        CompleteStructMemberSeq member_seq_root;
        {
            TypeIdentifierPair type_ids_var_root1;
            ReturnCode_t return_code_var_root1 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_root1 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "root1", type_ids_var_root1);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_root1)
            {
            ::register_root1_type_identifier(type_ids_var_root1);
            }
            StructMemberFlag member_flags_var_root1 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_root1 = 0x00000000;
            bool common_var_root1_ec {false};
            CommonStructMember common_var_root1 {TypeObjectUtils::build_common_struct_member(member_id_var_root1, member_flags_var_root1, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_root1, common_var_root1_ec))};
            if (!common_var_root1_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_root1 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_root1 = "var_root1";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_root1;
            ann_custom_root.reset();
            CompleteMemberDetail detail_var_root1 = TypeObjectUtils::build_complete_member_detail(name_var_root1, member_ann_builtin_var_root1, ann_custom_root);
            CompleteStructMember member_var_root1 = TypeObjectUtils::build_complete_struct_member(common_var_root1, detail_var_root1);
            TypeObjectUtils::add_complete_struct_member(member_seq_root, member_var_root1);
        }
        {
            TypeIdentifierPair type_ids_var_root2;
            ReturnCode_t return_code_var_root2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_root2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "root2", type_ids_var_root2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_root2)
            {
            ::register_root2_type_identifier(type_ids_var_root2);
            }
            StructMemberFlag member_flags_var_root2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_root2 = 0x00000001;
            bool common_var_root2_ec {false};
            CommonStructMember common_var_root2 {TypeObjectUtils::build_common_struct_member(member_id_var_root2, member_flags_var_root2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_root2, common_var_root2_ec))};
            if (!common_var_root2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_root2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_root2 = "var_root2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_root2;
            ann_custom_root.reset();
            CompleteMemberDetail detail_var_root2 = TypeObjectUtils::build_complete_member_detail(name_var_root2, member_ann_builtin_var_root2, ann_custom_root);
            CompleteStructMember member_var_root2 = TypeObjectUtils::build_complete_struct_member(common_var_root2, detail_var_root2);
            TypeObjectUtils::add_complete_struct_member(member_seq_root, member_var_root2);
        }
        CompleteStructType struct_type_root = TypeObjectUtils::build_complete_struct_type(struct_flags_root, header_root, member_seq_root);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_root, type_name_root.to_string(), type_ids_root))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "root already registered in TypeObjectRegistry for a different type.");
        }
    }
}
