package FusionInventory::Agent::Task::Inventory::Win32::USB;

use strict;
use warnings;

use parent 'FusionInventory::Agent::Task::Inventory::Module';

use FusionInventory::Agent::Tools::Generic;
use FusionInventory::Agent::Tools::Win32;

sub isEnabled {
    my (%params) = @_;
    return 0 if $params{no_category}->{usb};
    return 1;
}

sub isEnabledForRemote {
    my (%params) = @_;
    return 0 if $params{no_category}->{usb};
    return 1;
}

sub doInventory {
    my (%params) = @_;

    my $inventory = $params{inventory};

    foreach my $device (_getDevices(logger => $params{logger}, datadir => $params{datadir})) {
        $inventory->addEntry(
            section => 'USBDEVICES',
            entry   => $device
        );
    }
}

sub _getDevices {
    my @devices;
    my $seen;

    foreach my $device (_getDevicesFromWMI(@_)) {
        next if $device->{VENDORID} =~ /^0+$/;

        # avoid duplicates
        next if $seen->{$device->{SERIAL}}++;

        # pseudo serial generated by windows
        delete $device->{SERIAL} if $device->{SERIAL} =~ /&/;

        my $vendor = getUSBDeviceVendor(id => lc($device->{VENDORID}), @_);
        if ($vendor) {
            $device->{MANUFACTURER} = $vendor->{name};

            my $entry = $vendor->{devices}->{lc($device->{PRODUCTID})};
            if ($entry) {
                $device->{CAPTION} = $entry->{name};
                $device->{NAME} = $entry->{name};
            }
        }

        push @devices, $device;
    }

    return @devices;
}

sub _getDevicesFromWMI {
    my @devices;

    foreach my $object (getWMIObjects(
        class      => 'CIM_LogicalDevice',
        properties => [ qw/Caption DeviceID Name/ ]
    )) {
        next unless $object->{DeviceID} =~ /^USB\\VID_(\w+)&PID_(\w+)\\(.*)/;

        push @devices, {
            CAPTION   => $object->{Caption},
            NAME      => $object->{Name},
            VENDORID  => $1,
            PRODUCTID => $2,
            SERIAL    => $3
        };
    }

    return @devices;
}

1;
