package reservations

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ReturnClient is the client for the Return methods of the Reservations service.
type ReturnClient struct {
	BaseClient
}

// NewReturnClient creates an instance of the ReturnClient client.
func NewReturnClient() ReturnClient {
	return NewReturnClientWithBaseURI(DefaultBaseURI)
}

// NewReturnClientWithBaseURI creates an instance of the ReturnClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewReturnClientWithBaseURI(baseURI string) ReturnClient {
	return ReturnClient{NewWithBaseURI(baseURI)}
}

// Post return a reservation.
// Parameters:
// reservationOrderID - order Id of the reservation
// body - information needed for returning reservation.
func (client ReturnClient) Post(ctx context.Context, reservationOrderID string, body RefundRequest) (result RefundResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReturnClient.Post")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PostPreparer(ctx, reservationOrderID, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ReturnClient", "Post", nil, "Failure preparing request")
		return
	}

	resp, err := client.PostSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "reservations.ReturnClient", "Post", resp, "Failure sending request")
		return
	}

	result, err = client.PostResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ReturnClient", "Post", resp, "Failure responding to request")
		return
	}

	return
}

// PostPreparer prepares the Post request.
func (client ReturnClient) PostPreparer(ctx context.Context, reservationOrderID string, body RefundRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reservationOrderId": autorest.Encode("path", reservationOrderID),
	}

	const APIVersion = "2022-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/return", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PostSender sends the Post request. The method will close the
// http.Response Body if it receives an error.
func (client ReturnClient) PostSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// PostResponder handles the response to the Post request. The method always
// closes the http.Response Body.
func (client ReturnClient) PostResponder(resp *http.Response) (result RefundResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
