// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKDATABOXMM_DATABOX_H
#define _GTKDATABOXMM_DATABOX_H

#include <gtkdataboxmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2012  iCub Facility, Istituto Italiano di Tecnologia
 *   @author Daniele E. Domenichelli <daniele.domenichelli@iit.it>
 *
 * This file is part of gtkdataboxmm.
 *
 * gtkdataboxmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gtkdataboxmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <gtkmm/widget.h>
#include <gtkmm/adjustment.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkDatabox GtkDatabox;
typedef struct _GtkDataboxClass GtkDataboxClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GDatabox
{ class Databox_Class; } // namespace GDatabox
namespace Gtk
{
class Table;
}

namespace GDatabox
{
class Graph;
class Ruler;


class Databox : public Gtk::Widget
{
    public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Databox CppObjectType;
  typedef Databox_Class CppClassType;
  typedef GtkDatabox BaseObjectType;
  typedef GtkDataboxClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Databox();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Databox_Class;
  static CppClassType databox_class_;

  // noncopyable
  Databox(const Databox&);
  Databox& operator=(const Databox&);

protected:
  explicit Databox(const Glib::ConstructParams& construct_params);
  explicit Databox(GtkDatabox* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkDatabox*       gobj()       { return reinterpret_cast<GtkDatabox*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkDatabox* gobj() const { return reinterpret_cast<GtkDatabox*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_zoomed().
  virtual void on_zoomed();
  /// This is a default handler for the signal signal_selection_canceled().
  virtual void on_selection_canceled();


private:


public:
    Databox();
    explicit Databox(Gtk::Table **table, bool scrollbar_x = false, bool scrollbar_y = false, bool ruler_x = false, bool ruler_y = false);

    
  /** Adds the @a graph to the @a box. The next time the @a box is re-drawn, the graph will be shown.
   * 
   * It might be becessary to modify the total_limits in order for the graph to be displayed properly (see set_total_limits()).
   * @param graph A graph, e.g. a Gtk::DataboxPoints or a Gtk::DataboxGrid object.
   * @return 0 on success, -1 otherwise.
   */
  int graph_add(const Glib::RefPtr<Graph> & graph);
    
  /** Removes the @a graph from the @a box once. The next time the @a box is re-drawn, the graph will not be shown (unless it was added more 
   * than once).
   * @param graph A graph, e.g. a Gtk::DataboxPoints or a Gtk::DataboxGrid object.
   * @return 0 on success, -1 otherwise.
   */
  int graph_remove(const Glib::RefPtr<Graph> & graph);
    
  /** Removes all graphs from the @a box. The next time the @a box is re-drawn, no graphs will be shown.
   * @return 0 on success, -1 otherwise.
   */
  int graph_remove_all();

    
  /** This function is similar to set_total_limits(). It sets the total limits 
   * to match the data extrema (see calculate_extrema()). If you do not like data pixels exactly at the 
   * widget's border, you can add modify the limits using the border parameter: The limits are extended by  
   *  @a border*(max-min) if max!=min. If max==min, they are extended by @a border*max (otherwise the data could not be 
   * scaled to the pixel realm).
   * 
   * After calling this function, x values grow from left to right, y values grow from bottom to top.
   * @param border Relative border width (e.g. 0.1 means that the border on each side is 10% of the data area).
   * @return 0 on success,
   * -1 if @a box is no GtkDatabox widget,
   * -2 if no datasets are available.
   */
  int auto_rescale(float border);
    
  /** Determines the minimum and maximum x and y values of all 
   * Gtk::DataboxGraph objects which have been added to the Gtk::Databox widget via graph_add().
   * @param min_x Will be filled with the lowest x value of all datasets.
   * @param max_x Will be filled with the highest x value of all datasets.
   * @param min_y Will be filled with the lowest y value of all datasets.
   * @param max_y Will be filled with the highest y value of all datasets.
   * @return 0 on success,
   * -1 if @a box is no GtkDatabox widget,
   * -2 if no datasets are available.
   */
  int calculate_extrema(float & min_x, float & max_x, float & min_y, float & max_y);

    
  /** This function is used to set the limits of the total 
   * display area of @a box.
   * This function can be used to invert the orientation of the displayed graphs, 
   * e.g. @a top=-1000 and  @a bottom=0.
   * 
   * Side effect: The @a box also internally calls set_visible_limits() with the same values.
   * @param left Left total limit.
   * @param right Right total limit.
   * @param top Top total limit.
   * @param bottom Bottom total limit.
   */
  void set_total_limits(float left, float right, float top, float bottom);
    
  /** This function is used to set the limits of the visible 
   * display area of @a box. The visible display area can be section of the total 
   * area, i.e. the @a box zooms in, showing only a part of the complete picture.
   * 
   * The orientation of the values have to be the same as in set_total_limits() and 
   * the visible limits have to be within the total limits. The 
   * values will not be used otherwise.
   * 
   * Side effect: The @a box emits Gtk::Databox::signal_zoomed().
   * @param left Left visible limit.
   * @param right Right visible limit.
   * @param top Top visible limit.
   * @param bottom Bottom visible limit.
   */
  void set_visible_limits(float left, float right, float top, float bottom);
    
  /** Gives the total limits (as set by auto_rescale() or set_total_limits()).
   * @param left Space for total left value or #<tt>0</tt>.
   * @param right Space for total right value or #<tt>0</tt>.
   * @param top Space for total top value or #<tt>0</tt>.
   * @param bottom Space for total bottom value or #<tt>0</tt>.
   */
  void get_total_limits(float & left, float & right, float & top, float & bottom) const;
    
  /** Gives the current visible limits. These differ from those given by get_total_limits() if 
   * you zoomed into the data for instance by zoom_to_selection() or set_visible_limits() (these values
   * can be changed by scrolling, of course).
   * @param left Space for visible left value or #<tt>0</tt>.
   * @param right Space for visible right value or #<tt>0</tt>.
   * @param top Space for visible top value or #<tt>0</tt>.
   * @param bottom Space for visible bottom value or #<tt>0</tt>.
   */
  void get_visible_limits(float & left, float & right, float & top, float & bottom) const;

    
  /** Setter function for the Gtk::Databox::property_adjustment_x() property. Normally, it should not be 
   * required to use this function, see property documentation.
   * @param adj A Gtk::Adjustment object.
   */
  void set_adjustment_x(Gtk::Adjustment & adj);
    
  /** Setter function for the Gtk::Databox::property_adjustment_y() property. Normally, it should not be 
   * required to use this function, see property documentation.
   * @param adj A Gtk::Adjustment object.
   */
  void set_adjustment_y(Gtk::Adjustment & adj);
    
  /** Getter function for the Gtk::Databox::property_adjustment_x() property.
   * @return The Gtk::Databox::property_adjustment_x() property value.
   */
  Gtk::Adjustment* get_adjustment_x();
    
  /** Getter function for the Gtk::Databox::property_adjustment_x() property.
   * @return The Gtk::Databox::property_adjustment_x() property value.
   */
  const Gtk::Adjustment* get_adjustment_x() const;
    
  /** Getter function for the Gtk::Databox::property_adjustment_y() property.
   * @return The Gtk::Databox::property_adjustment_y() property value.
   */
  Gtk::Adjustment* get_adjustment_y();
    
  /** Getter function for the Gtk::Databox::property_adjustment_y() property.
   * @return The Gtk::Databox::property_adjustment_y() property value.
   */
  const Gtk::Adjustment* get_adjustment_y() const;

    
  /** Setter function for the Gtk::Databox::property_ruler_x() property.
   * @param ruler A Gtk::DataboxRuler object.
   */
  void set_ruler_x(const Ruler& ruler);
    
  /** Setter function for the Gtk::Databox::property_ruler_y() property.
   * @param ruler An Gtk::DataboxRuler object.
   */
  void set_ruler_y(const Ruler& ruler);
    
  /** Getter function for the Gtk::Databox::property_ruler_x() property.
   * @return The Gtk::Databox::property_ruler_x() property value.
   */
  const Ruler* get_ruler_x() const;
    
  /** Getter function for the Gtk::Databox::property_ruler_y() property.
   * @return The Gtk::Databox::property_ruler_y() property value.
   */
  const Ruler* get_ruler_y() const;

// void gtk_databox_set_scale_type_x (GtkDatabox * box, GtkDataboxScaleType scale_type);
//    _WRAP_METHOD(void set_scale_type_x(ScaleType scale_type), gtk_databox_set_scale_type_x)
// void gtk_databox_set_scale_type_y (GtkDatabox * box, GtkDataboxScaleType scale_type);
//    _WRAP_METHOD(void set_scale_type_y(ScaleType scale_type), gtk_databox_set_scale_type_y)
// GtkDataboxScaleType gtk_databox_get_scale_type_x (GtkDatabox * box);
//    _WRAP_METHOD(GtkDatabox::ScaleType get_scale_type_x() const, gtk_databox_get_scale_type_x)
// GtkDataboxScaleType gtk_databox_get_scale_type_y (GtkDatabox * box);
//    _WRAP_METHOD(GtkDatabox::ScaleType get_scale_type_y() const, gtk_databox_get_scale_type_y)

    
  /** Setter function for the Gtk::Databox::property_enable_selection() property.
   * @param enable Whether selection via mouse is enabled or not.
   */
  void set_enable_selection(bool enable);
    
  /** Setter function for the Gtk::Databox::property_enable_zoom() property.
   * @param enable Whether zoom via mouse is enabled or not.
   */
  void set_enable_zoom(bool enable);

    
  /** Getter function for the Gtk::Databox::property_enable_selection() property.
   * @return The Gtk::Databox::property_enable_selection() property value.
   */
  bool get_enable_selection() const;
    
  /** Getter function for the Gtk::Databox::property_enable_selection() property.
   * @return The Gtk::Databox::property_enable_selection() property value.
   */
  bool get_enable_zoom() const;

    
  /** This is equivalent to left-clicking into the selected area.
   * 
   * This function works, if the attribute #enable-zoom is set to #<tt>true</tt>. Calling the function 
   * then zooms to the area selected with the mouse. 
   * 
   * Side effect: The @a box emits Gtk::Databox::signal_zoomed().
   */
  void zoom_to_selection();
    
  /** This is equivalent to right-clicking into the @a box.
   * 
   * This function works, if the attribute #enable-zoom is set to #<tt>true</tt>. Calling the function 
   * then zooms out by a factor of 2 in both dimensions (the maximum is defined by the total 
   * limits, see set_total_limits()).
   * 
   * Side effect: The @a box emits Gtk::Databox::signal_zoomed().
   */
  void zoom_out();
    
  /** This is equivalent to shift right-clicking into the @a box.
   * 
   * This function works, if the attribute #enable-zoom is set to #<tt>true</tt>. It is equivalent to 
   * calling the set_visible_limits() with the total limits.
   */
  void zoom_home();

    
  /** Calculates the horizontal pixel coordinate which represents the x @a value.
   * Pixel coordinates are relative to the top-left corner of the @a box which is equivalent to (0,0).
   * @param value An x value.
   * @return Pixel coordinate.
   */
  short value_to_pixel_x(float value);
    
  /** Calculates the horizontal pixel coordinate which represents the x @a value.
   * Pixel coordinates are relative to the top-left corner of the @a box which is equivalent to (0,0).
   * @param value An x value.
   * @return Pixel coordinate.
   */
  short value_to_pixel_y(float value);
    
  /** Calculates the x value which is represented by the horizontal @a pixel coordinate.
   * Pixel coordinates are relative to the top-left corner of the @a box which is equivalent to (0,0).
   * @param pixel A horizontal pixel coordinate.
   * @return X value.
   */
  float pixel_to_value_x(short pixel);
    
  /** Calculates the y value which is represented by the vertical @a pixel coordinate.
   * Pixel coordinates are relative to the top-left corner of the @a box which is equivalent to (0,0).
   * @param pixel A vertical pixel coordinate.
   * @return Y value.
   */
  float pixel_to_value_y(short pixel);
// void gtk_databox_values_to_pixels (GtkDatabox * box, unsigned int len, const gfloat * values_x, const gfloat * values_y, GdkPoint * pixels);
//    _WRAP_METHOD(void values_to_pixels(unsigned int len, const float* values_x, const float* values_y, Gdk::Point *pixels), gtk_databox_values_to_pixels)

// GdkPixmap* gtk_databox_get_backing_pixmap(GtkDatabox * box);
    
  /** This function returns the pixmap which is used by @a box and its Gtk::DataboxGraph objects 
   * for drawing operations before copying the result to the screen.
   * 
   * The function is typically called by the Gtk::DataboxGraph objects.
   * @return Backing pixmap.
   */
  Glib::RefPtr<Gdk::Pixmap> get_backing_pixmap() const;

    
/**
   * @par Slot Prototype:
   * <tt>void on_my_%zoomed()</tt>
   *
   * This signal is emitted each time the zoom of the widget is changed, see for example 
   * Gtk::Databox::zoom_to_selection(), Gtk::Databox::set_visible_limits().
   */

  Glib::SignalProxy0< void > signal_zoomed();

// void (*selection_started) (GtkDatabox * box, GtkDataboxValueRectangle * selectionValues);
//    _WRAP_SIGNAL(void selection_started(ValueRectangle *selectionValues), "selection_started")
// void (*selection_changed) (GtkDatabox * box, GtkDataboxValueRectangle * selectionValues);
//    _WRAP_SIGNAL(void selection_changed(ValueRectangle *selectionValues), "selection_changed")
// void (*selection_finalized) (GtkDatabox * box, GtkDataboxValueRectangle * selectionValues);
//    _WRAP_SIGNAL(void selection_finalized(ValueRectangle *selectionValues), "selection_finalized")

    
/**
   * @par Slot Prototype:
   * <tt>void on_my_%selection_canceled()</tt>
   *
   * This signal is emitted after a right click outside 
   * a selection rectangle.
   */

  Glib::SignalProxy0< void > signal_selection_canceled();


    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Enable selection of areas via mouse (TRUE/FALSE).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_enable_selection() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Enable selection of areas via mouse (TRUE/FALSE).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_enable_selection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Enable zooming in or out via mouse click (TRUE/FALSE).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_enable_zoom() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Enable zooming in or out via mouse click (TRUE/FALSE).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_enable_zoom() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkAdjustment for horizontal scrolling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Adjustment* > property_adjustment_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkAdjustment for horizontal scrolling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* > property_adjustment_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkAdjustment for vertical scrolling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Adjustment* > property_adjustment_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkAdjustment for vertical scrolling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* > property_adjustment_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** A horizontal GtkDataboxRuler or NULL.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Ruler > property_ruler_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A horizontal GtkDataboxRuler or NULL.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Ruler > property_ruler_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** A vertical GtkDataboxRuler or NULL.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Ruler > property_ruler_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A vertical GtkDataboxRuler or NULL.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Ruler > property_ruler_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

//    _WRAP_PROPERTY("scale_type_x", ScaleType)
//    _WRAP_PROPERTY("scale_type_y", ScaleType)


};

} // namespace GDatabox


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GDatabox::Databox
   */
  GDatabox::Databox* wrap(GtkDatabox* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKDATABOXMM_DATABOX_H */

