#include "gcrypt_glue.h"
#include <stdio.h>

extern char* kaya_secret;
extern char* kaya_ivec;

int ciphermode(KayaValue c)
{
    switch(KayaUnionGetTag(c)) {
    case 0:
	return GCRY_CIPHER_MODE_ECB;
	break;
    case 1:
	return GCRY_CIPHER_MODE_CFB;
	break;
    case 2:
	return GCRY_CIPHER_MODE_CBC;
	break;
    case 3:
	return GCRY_CIPHER_MODE_STREAM;
	break;
    case 4:
	return GCRY_CIPHER_MODE_OFB;
	break;
    case 5:
//	return GCRY_CIPHER_MODE_CTR;
	return GCRY_CIPHER_MODE_NONE;
	break;
    }
}

int cipheralgo(KayaValue c)
{
    switch(KayaUnionGetTag(c)) {
    case 0:
	return GCRY_CIPHER_IDEA;
	break;
    case 1:
	return GCRY_CIPHER_3DES;
	break;
    case 2:
	return GCRY_CIPHER_CAST5;
	break;
    case 3:
	return GCRY_CIPHER_BLOWFISH;
	break;
    case 4:
	return GCRY_CIPHER_AES128;
	break;
    case 5:
	return GCRY_CIPHER_AES192;
	break;
    case 6:
	return GCRY_CIPHER_AES256;
	break;
    case 7:
	return GCRY_CIPHER_TWOFISH;
	break;
    case 8:
	return GCRY_CIPHER_ARCFOUR;
	break;
    case 9:
	return GCRY_CIPHER_DES;
	break;
    default:
	return GCRY_CIPHER_NONE; // Can't happen
	break;
    }
}

int hashalgo(KayaValue c)
{
    switch(KayaUnionGetTag(c)) {
    case 0:
	return GCRY_MD_SHA1;
	break;
    case 1:
	return GCRY_MD_RMD160;
	break;
    case 2:
	return GCRY_MD_MD5;
	break;
    case 3:
	return GCRY_MD_MD4;
	break;
    case 4:
	return GCRY_MD_TIGER;
	break;
    case 5:
	return GCRY_MD_SHA256;
	break;
    case 6:
//	return GCRY_MD_CRC32;
	return GCRY_MD_NONE;
	break;
    default:
	return GCRY_MD_NONE; // Can't happen
	break;
    }
}

int cipherKeySize(int c)
{
    size_t len = 4;
    gcry_cipher_algo_info(c, GCRYCTL_GET_KEYLEN, 
			  0, &len);
    return len;
}

int cipherBlockLength(int c)
{
    size_t len = 4;
    gcry_cipher_algo_info(c, GCRYCTL_GET_BLKLEN, 
			  0, &len);
    return len;
}


void* cipherOpen(KayaValue algo, KayaValue mode, int flags)
{
  int cflags = 0;
  if (flags & 1) cflags += GCRY_CIPHER_SECURE;
  if (flags & 2) cflags += GCRY_CIPHER_ENABLE_SYNC;
  if (flags & 4) cflags += GCRY_CIPHER_CBC_CTS;
  if (flags & 8) cflags += GCRY_CIPHER_CBC_MAC;
    GcryptData* d = new GcryptData();
    gcry_cipher_open(&(d->handle), cipheralgo(algo), ciphermode(mode), cflags);
    d->algo = cipheralgo(algo);
    return (void*)d;
}

void cipherClose(void* ptr)
{
    GcryptData* d = (GcryptData*)ptr;
    gcry_cipher_close(d->handle);
}

void do_setkey(void* ptr, KayaArray key)
{
    GcryptData* d = (GcryptData*)ptr;
    int size = KayaArraySize(key);
    char* keydata = (char*)KayaAlloc(size);
    for(int i=0;i<size;++i) {
	keydata[i]=KayaGetChar(KayaArrayLookup(key,i));
    }

    gcry_cipher_setkey(d->handle, keydata, size);
}

void do_setivec(void* ptr, KayaArray vec)
{
    GcryptData* d = (GcryptData*)ptr;
    int size = KayaArraySize(vec);
    char* keydata = (char*)KayaAlloc(size);
    for(int i=0;i<size;++i) {
	keydata[i]=KayaGetChar(KayaArrayLookup(vec,i));
    }

    gcry_cipher_setiv(d->handle, keydata, size);
}


void* do_encrypt(void* h, void* data, int size, KayaValue outsize)
{
    GcryptData* d = (GcryptData*)h;
    int blklen = cipherBlockLength(d->algo);
    int newsize;
    void* newblock, *outbuf;

    // If size isn't a multiple of blklen, copy the data to a block which
    // is a multiple of blklen.
    newsize= size+blklen+(blklen-(size%blklen));
    newblock = KayaAlloc(newsize);
    memcpy(newblock,data,size);
    data = newblock;
    size = newsize;

    // Create an output buffer of the right length.
    outbuf = KayaAlloc(size);
    gcry_cipher_encrypt(d->handle, (unsigned char*)outbuf, size, 
			(unsigned char*)data, size);

//    printf("Size %d", size);

    KayaSetInt(outsize,size);
    return outbuf;
}

void* do_decrypt(void* h, void* data, int size, KayaValue outsize)
{
    GcryptData* d = (GcryptData*)h;
    int blklen = cipherBlockLength(d->algo);
    int newsize;
    void* newblock, *outbuf;

    // If size isn't a multiple of blklen, copy the data to a block which
    // is a multiple of blklen.
    newsize= size+blklen+(blklen-(size%blklen));
    newblock = KayaAlloc(newsize);
    //    cout<<"decrypt:"<<size<<":"<<newsize<<":"<<newblock<<":"<<data<<endl;
    memcpy(newblock,data,size);
    //    cout<<"copied"<<endl;
    data = newblock;
    size = newsize;

    // Create an output buffer of the right length.
    outbuf = KayaAlloc(size);
    gcry_cipher_decrypt(d->handle, (unsigned char*)outbuf, size, 
			(unsigned char*)data, size);

    KayaSetInt(outsize,size);
    return outbuf;
}

void* hashOpen(KayaValue algo, int flags)
{
    int hflags = 0;
    if (flags & 1) hflags += GCRY_MD_FLAG_SECURE;
    if (flags & 2) hflags += GCRY_MD_FLAG_HMAC;

    GcryptHash* d = new GcryptHash();
    gcry_md_open(&(d->handle), hashalgo(algo),hflags);
    d->size = gcry_md_get_algo_dlen(hashalgo(algo));
    d->algo = hashalgo(algo);

    return (void*)d;
}

void hashClose(void* ptr)
{
    GcryptHash* d = (GcryptHash*)ptr;
    gcry_md_close(d->handle);
}

void hashReset(void* ptr)
{
    GcryptHash* d = (GcryptHash*)ptr;
    gcry_md_reset(d->handle);
}

void hashWrite(void* ptr, void* data, int size)
{
    GcryptHash* d = (GcryptHash*)ptr;
    gcry_md_write(d->handle, data, size);
}

void hashFinal(void* ptr)
{
    GcryptHash* d = (GcryptHash*)ptr;
    gcry_md_final(d->handle);
}

void* hashGet(void* ptr, KayaValue size)
{
    GcryptHash* d = (GcryptHash*)ptr;
    KayaSetInt(size,d->size);
    void* block = KayaAlloc(d->size);
    block = (unsigned char*)(gcry_md_read(d->handle,d->algo));
    return block;
}

KayaArray appKey()
{
    KayaArray key = newKayaArray(32);
    for(int i=3;i<35;++i)
    {
	KayaArrayPush(key,KayaChar(kaya_secret[i]));
    }
    return key;
}

KayaArray appIVec()
{
    KayaArray key = newKayaArray(16);
    for(int i=3;i<19;++i)
    {
	KayaArrayPush(key,KayaChar(kaya_ivec[i]));
    }
    return key;
}
