<?php

class highlight {
	/**
	 * Perform a simple text replace
	 * This should be used when the string does not contain HTML
	 * (off by default)
	 */
	var $STR_HIGHLIGHT_SIMPLE = 1;

	/**
	 * Only match whole words in the string
	 * (off by default)
	 */
	var $STR_HIGHLIGHT_WHOLEWD = 2;

	/**
	 * Case sensitive matching
	 * (off by default)
	 */
	var $STR_HIGHLIGHT_CASESENS = 4;

	/**
	 * Overwrite links if matched
	 * This should be used when the replacement string is a link
	 * (off by default)
	 */
	var $STR_HIGHLIGHT_STRIPLINKS = 8;

	/**
	 * Highlight a string in text without corrupting HTML tags
	 *
	 * @param       string          $text           Haystack - The text to search
	 * @param       array|string    $needle         Needle - The string to highlight
	 * @param       bool            $options        Bitwise set of options
	 * @param       array           $highlight      Replacement string
	 * @return      Text with needle highlighted
	 */
	function str_highlight($text, $needle, $options = null, $highlight = null) {
		// Default highlighting
		if ($highlight === null) {
			$highlight = '<strong>\1</strong>';
		}

		// Select pattern to use
		if ($options & $this->STR_HIGHLIGHT_SIMPLE) {
			$pattern = '#(%s)#';
			$sl_pattern = '#(%s)#';
		} else {
			$pattern = '#(?!<.*?)(%s)(?![^<>]*?>)#';
			$sl_pattern = '#<a\s(?:.*?)>(%s)</a>#';
	    	}

		// Case sensitivity
		if (!($options & $this->STR_HIGHLIGHT_CASESENS)) {
			$pattern .= 'i';
			$sl_pattern .= 'i';
	    	}

		$needle = (array) $needle;
		foreach ($needle as $needle_s) {
			$needle_s = preg_quote($needle_s);

			// Escape needle with optional whole word check
			if ($options & $this->STR_HIGHLIGHT_WHOLEWD) {
				$needle_s = '\b' . $needle_s . '\b';
			}

			// Strip links
			if ($options & $this->STR_HIGHLIGHT_STRIPLINKS) {
				$sl_regex = sprintf($sl_pattern, $needle_s);
				$text = preg_replace($sl_regex, '\1', $text);
			}

			$regex = sprintf($pattern, $needle_s);
			$text = preg_replace($regex, $highlight, $text);
		}

		return $text;
	}
}

?>
