/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_ENTRY_INDEXER_HEADER
#define LIFEOGRAPH_ENTRY_INDEXER_HEADER


#include "lifeograph.hpp"
#include "diary.hpp"
#include "parser_text.hpp"


namespace LIFEO
{


class ParserPara : public ParserText
{
    public:
        void                    parse( Paragraph* );

        Wchar                   get_char_at( int i ) override
        {
            return m_p2para_cur->get_text().at( i );
        }

        Ustring                 get_substr( UstringSize begin, UstringSize end )
        {
            return m_p2para_cur->get_text().substr( begin, end - begin );
        }

        //void                    process_paragraph() override;
        void                    apply_heading() override;
        void                    apply_subheading() override;
        void                    apply_subsubheading() override;
        void                    apply_link() override;
        void                    apply_check_ccl() override;
        void                    apply_check_unf() override;
        void                    apply_check_prg() override;
        void                    apply_check_fin() override;
        void                    apply_inline_tag() override;

    protected:

};

}  // end of namespace LIFEO

#endif
