/**
 * SECTION:installer
 * @short_description: Performs the installation of an IPK package
 * 
 * <para>This class handles all stuff required to install an application. All methods are syncronous right now.</para>
 */
/**
 * LISTALLER_TYPE_SETUP:
 * 
 * The type for <link linkend="ListallerSetup"><type>ListallerSetup</type></link>.
 */
/**
 * listaller_setup_supported_install_modes:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 */
/**
 * listaller_setup_set_install_mode:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 * @mode: &nbsp;
 */
/**
 * listaller_setup_get_install_mode:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 */
/**
 * listaller_setup_initialize:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 */
/**
 * listaller_setup_get_current_application:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 */
/**
 * listaller_setup_kill_installation_process:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 * 
 * Forcibly kills a running installation process. You should never use this method, it might only be useful in command-line applications, where you can catch an interrupt signal and tell the running setup about it. It might be used on mobile devices if a setup is running and the device is running out of power. (but best way in that case would be to prevent an installation in the first place, if there is not enough energy left) This function does some emergency cleanup and tries to make sure that nothing gets corrupted.
 */
/**
 * listaller_setup_get_replaced_native_packs:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 * 
 * Check if there are native packages providing the same functionality
 * 
 * <para>Software packages can declare a &quot;replaces&quot; element, showing which native componants become obsolete if their 3rd-party app gets installed. E.g. Firefox could declare a replacement of &quot;/usr/bin/firefox&quot;, so the user gets hinted to maybe remove the native package. This feature is optional, and Listaller won&apos;t perform any removal actions! This function will fail if the user did not request a shared installation.</para>
 * 
 * Returns: List of replaces package-ids, separated by newlines or NULL if no replacement was declared. 
 */
/**
 * listaller_setup_run_installation:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 * 
 * Execute software installation
 * 
 * Returns: Success of the operation (if FALSE, an error was emitted) 
 */
/**
 * listaller_setup_get_security_info:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance
 */
/**
 * listaller_setup_new:
 * @ipkfilename: &nbsp;
 */
/**
 * ListallerSetup:fname:
 */
/**
 * listaller_setup_get_fname:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetup--fname"><type>"fname"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetup--fname"><type>"fname"</type></link> property
 */
/**
 * ListallerSetup:settings:
 */
/**
 * listaller_setup_get_settings:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetup--settings"><type>"settings"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetup--settings"><type>"settings"</type></link> property
 */
/**
 * ListallerSetup:control:
 */
/**
 * listaller_setup_get_control:
 * @self: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerSetup--control"><type>"control"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerSetup--control"><type>"control"</type></link> property
 */
/**
 * ListallerSetup::status-changed:
 * @setup: the <link linkend="ListallerSetup"><type>ListallerSetup</type></link> instance that received the signal
 * @status: &nbsp;
 */
/**
 * ListallerSetup:
 * 
 * Performs the installation of an IPK package
 * 
 * <para>This class handles all stuff required to install an application. All methods are syncronous right now.</para>
 */
/**
 * ListallerSetupClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-TYPE-SETUP:CAPS"><literal>LISTALLER_TYPE_SETUP</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
