#include <stdlib.h>
#include <iostream>
#include <stdio.h>
#include <string>
#include <string.h>
#include <map>

// before including helper.h, pretend to be Windows to enable the drive (c:\) handling routines ...
#define _WIN32
// ... but at the same time force forward slash as our path separator for our tests
#define NATIVE_PATH_SEPARATOR '/'

#include "../helper.h"

#if !NO_MAIN || !defined(TEST_ASSERT)
static int iErrors = 0;
static int iTests = 0;
#endif

#ifndef TEST_ASSERT
# define TEST_ASSERT(...) iTests++; if (!(__VA_ARGS__)) ++iErrors
#endif

// test cases for function strip2ndFromEndOf1st()
static void test_strip2ndFromEndOf1st() {
    {
        // (a) input string, (b) expected result string
        std::pair<std::string, std::string> examples[] = {
            { "", "" },
            { "/", "" },
            { "//", "" },
            { "///", "" },
            { "/foo/bla", "/foo/bla" },
            { "/foo/bla/", "/foo/bla" },
            { "/foo/bla//", "/foo/bla" },
            { "/foo/bla///", "/foo/bla" },
            { "/foo", "/foo" },
            { "/foo/", "/foo" },
            { "/foo//", "/foo" },
            { "/foo///", "/foo" },
            { "/foo/asdf.gig", "/foo/asdf.gig" },
            { "foo", "foo" },
            { "asdf.gig", "asdf.gig" },
            { "C:/", "C:" },
            { "C://", "C:" },
            { "C:", "C:" },
            { "C:/asdf", "C:/asdf" },
            { "C:/asdf/", "C:/asdf"},
            { "C:/asdf//", "C:/asdf"},
            { "C:/asdf///", "C:/asdf"},
        };
        for (auto ex : examples) {
            const std::string in  = ex.first;
            const std::string out = strip2ndFromEndOf1st(in, '/');
            const std::string expected = ex.second;
            printf("strip2ndFromEndOf1st('%s', '/')  =>  '%s' %s\n",
                   in.c_str(), out.c_str(),
                   ((out == expected) ? "[ok]" : "[WRONG] <---")
            );
            TEST_ASSERT(out == expected);
        }
    }
}

// test cases for function parentPath()
static void test_parentPath() {
    {
        // (a) input string, (b) expected result string
        std::pair<std::string, std::string> examples[] = {
            { "", "" },
            { "/", "/" },
            { "//", "/" },
            { "///", "/" },
            { "/foo/bla", "/foo" },
            { "/foo/bla/", "/foo" },
            { "/foo/bla//", "/foo" },
            { "/foo/bla///", "/foo" },
            { "/foo", "/" },
            { "/foo/", "/" },
            { "/foo//", "/" },
            { "/foo///", "/" },
            { "/foo/asdf.gig", "/foo" },
            { "foo", "" },
            { "asdf.gig", "" },
            { "C:", "C:" },
            { "C:/", "C:" },
            { "C://", "C:" },
            { "C:///", "C:" },
            { "C:/asdf", "C:" },
            { "C:/asdf/", "C:"},
            { "C:/asdf//", "C:"},
            { "C:/asdf///", "C:"},
            { "C:/foo.gig", "C:"},
        };
        for (auto ex : examples) {
            const std::string in  = ex.first;
            const std::string out = parentPath(in);
            const std::string expected = ex.second;
            printf("parentPath('%s')  =>  '%s' %s\n",
                   in.c_str(), out.c_str(),
                   ((out == expected) ? "[ok]" : "[WRONG] <---")
            );
            TEST_ASSERT(out == expected);
        }
    }
}

// test cases for function lastPathComponent()
static void test_lastPathComponent() {
    {
        // (a) input string, (b) expected result string
        std::pair<std::string, std::string> examples[] = {
            { "", "" },
            { "/", "" },
            { "//", "" },
            { "///", "" },
            { "/foo/bla", "bla" },
            { "/foo/bla/", "" },
            { "/foo/bla//", "" },
            { "/foo/bla///", "" },
            { "/foo", "foo" },
            { "/foo/", "" },
            { "/foo//", "" },
            { "/foo///", "" },
            { "/foo/asdf.gig", "asdf.gig" },
            { "foo", "foo" },
            { "asdf.gig", "asdf.gig" },
            { "C:", "" },
            { "C:/", "" },
            { "C://", "" },
            { "C:///", "" },
            { "C:/asdf", "asdf" },
            { "C:/asdf/", ""},
            { "C:/asdf//", ""},
            { "C:/asdf///", ""},
            { "C:/foo.gig", "foo.gig"},
        };
        for (auto ex : examples) {
            const std::string in  = ex.first;
            const std::string out = lastPathComponent(in);
            const std::string expected = ex.second;
            printf("lastPathComponent('%s')  =>  '%s' %s\n",
                   in.c_str(), out.c_str(),
                   ((out == expected) ? "[ok]" : "[WRONG] <---")
            );
            TEST_ASSERT(out == expected);
        }
    }
}

// test cases for function pathWithoutExtension()
static void test_pathWithoutExtension() {
    {
        // (a) input string, (b) expected result string
        std::pair<std::string, std::string> examples[] = {
            { "", "" },
            { "/foo/bla", "/foo/bla" },
            { "/foo", "/foo" },
            { "/foo/asdf.gig", "/foo/asdf" },
            { "/foo/asdf.gigx", "/foo/asdf" },
            { "foo", "foo" },
            { "asdf.gig", "asdf" },
            { "asdf.blabla", "asdf" },
            { "C:/foo.gig", "C:/foo"},
            { "C:/foo.blabla", "C:/foo"},
        };
        for (auto ex : examples) {
            const std::string in  = ex.first;
            const std::string out = pathWithoutExtension(in);
            const std::string expected = ex.second;
            printf("pathWithoutExtension('%s')  =>  '%s' %s\n",
                   in.c_str(), out.c_str(),
                   ((out == expected) ? "[ok]" : "[WRONG] <---")
            );
            TEST_ASSERT(out == expected);
        }
    }
}

// test cases for function extensionOfPath()
static void test_extensionOfPath() {
    {
        // (a) input string, (b) expected result string
        std::pair<std::string, std::string> examples[] = {
            { "", "" },
            { "/foo/bla", "" },
            { "/foo", "" },
            { "/foo/asdf.gig", "gig" },
            { "/foo/asdf.gigx", "gigx" },
            { "foo", "" },
            { "asdf.gig", "gig" },
            { "asdf.blabla", "blabla" },
            { "C:/foo.gig", "gig"},
            { "C:/foo.blabla", "blabla"},
        };
        for (auto ex : examples) {
            const std::string in  = ex.first;
            const std::string out = extensionOfPath(in);
            const std::string expected = ex.second;
            printf("extensionOfPath('%s')  =>  '%s' %s\n",
                   in.c_str(), out.c_str(),
                   ((out == expected) ? "[ok]" : "[WRONG] <---")
            );
            TEST_ASSERT(out == expected);
        }
    }
}

#if !NO_MAIN

int main() {
    printf("\n");

    test_strip2ndFromEndOf1st();
    test_parentPath();
    test_lastPathComponent();
    test_pathWithoutExtension();
    test_extensionOfPath();

    if (iErrors)
        printf("\n!!! FAILED !!!  [ There were %d errors ]\n\n", iErrors);
    else
        printf("\nOK (%d tests)\n\n", iTests);

    return iErrors;
}

#endif // !NO_MAIN
