/* ***************************************************************************
 *
 * Pico Technology USB TC08 Device Driver
 *
 *//**
 * \file      lookupdata.h 
 * \brief     Thermocouple range limits for TC08
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: lookupdata.h,v 1.2 2007/05/14 14:36:28 douglas Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef LOOKUPDATA_H
#define LOOKUPDATA_H

/* CJC Thermistor */
/** First temperature in CJC Thermistor lookup table, in Celsius*/
#define LIMITS_THERMISTOR_MIN -5.0f
/** Last temperature in CJC Thermistor lookup table, in Celsius */
#define LIMITS_THERMISTOR_MAX 70.0f
/** Increment of temperatures in CJC Thermistor lookup table, in Celsius */
#define LIMITS_THERMISTOR_INT 1.0f

// Thermocouples (as above)
/** First temperature in Type B thermocouple lookup table, in Celsius*/
#define LIMITS_TYPEB_MIN  20.0f
/** Last temperature in Type B thermocouple lookup table, in Celsius */
#define LIMITS_TYPEB_MAX  1820.0f
/** Increment of temperatures in Type B thermocouple lookup table, in Celsius */
#define LIMITS_TYPEB_INT  10.0f

/** First temperature in Type E thermocouple lookup table, in Celsius*/
#define LIMITS_TYPEE_MIN  -270.0f
/** Last temperature in Type E thermocouple lookup table, in Celsius */
#define LIMITS_TYPEE_MAX  1000.0f
/** Increment of temperatures in Type E thermocouple lookup table, in Celsius */
#define LIMITS_TYPEE_INT  10.0f

/** First temperature in Type J thermocouple lookup table, in Celsius*/
#define LIMITS_TYPEJ_MIN  -210.0f
/** Last temperature in Type J thermocouple lookup table, in Celsius */
#define LIMITS_TYPEJ_MAX  1200.0f
/** Increment of temperatures in Type J thermocouple lookup table, in Celsius */
#define LIMITS_TYPEJ_INT  10.0f

/** First temperature in Type K thermocouple lookup table, in Celsius*/
#define LIMITS_TYPEK_MIN  -270.0f
/** Last temperature in Type K thermocouple lookup table, in Celsius */
#define LIMITS_TYPEK_MAX  1370.0f
/** Increment of temperatures in Type K thermocouple lookup table, in Celsius */
#define LIMITS_TYPEK_INT  10.0f

/** First temperature in Type N thermocouple lookup table, in Celsius*/
#define LIMITS_TYPEN_MIN  -270.0f
/** Last temperature in Type N thermocouple lookup table, in Celsius */
#define LIMITS_TYPEN_MAX  1300.0f
/** Increment of temperatures in Type N thermocouple lookup table, in Celsius */
#define LIMITS_TYPEN_INT  10.0f

/** First temperature in Type R thermocouple lookup table, in Celsius*/
#define LIMITS_TYPER_MIN  -50.0f
/** Last temperature in Type R thermocouple lookup table, in Celsius */
#define LIMITS_TYPER_MAX  1760.0f
/** Increment of temperatures in Type R thermocouple lookup table, in Celsius */
#define LIMITS_TYPER_INT  10.0f

/** First temperature in Type S thermocouple lookup table, in Celsius*/
#define LIMITS_TYPES_MIN  -50.0f
/** Last temperature in Type S thermocouple lookup table, in Celsius */
#define LIMITS_TYPES_MAX  1760.0f
/** Increment of temperatures in Type S thermocouple lookup table, in Celsius */
#define LIMITS_TYPES_INT  10.0f

/** First temperature in Type T thermocouple lookup table, in Celsius*/
#define LIMITS_TYPET_MIN  -270.0f
/** Last temperature in Type T thermocouple lookup table, in Celsius */
#define LIMITS_TYPET_MAX  400.0f
/** Increment of temperatures in Type T thermocouple lookup table, in Celsius */
#define LIMITS_TYPET_INT  10.0f

#endif /* not defined LOOKUPDATA_H */
